/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.shrssc.impl;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.query.IQueryExecutor;
import com.kingdee.bos.dao.query.QueryExecutorFactory;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.data.SortType;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.sql.ParserException;
import com.kingdee.eas.base.shrssc.ShrTaskOperation;
import com.kingdee.eas.base.ssc.shr.bean.GridDataEntity;
import com.kingdee.eas.base.ssc.shr.bean.RealDataFetcher;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ShrTaskOperation_SHRGETF7ITEM
implements ShrTaskOperation {
    private static final Logger logger = LoggerFactory.getLogger(ShrTaskOperation_SHRGETF7ITEM.class);

    @Override
    public Object operation(Context ctx, Map<String, Object> query) throws BOSException {
        String selector;
        GridDataEntity gridDataEntity = new GridDataEntity();
        boolean includePager = true;
        String includePagerParam = (String)query.get("includePager");
        if (includePagerParam != null) {
            includePager = Boolean.parseBoolean(includePagerParam);
        }
        int rows = 10;
        String rowsParam = (String)query.get("rows");
        if (rowsParam != null) {
            rows = Integer.parseInt(rowsParam);
        }
        int page = 1;
        String pageParam = (String)query.get("page");
        if (pageParam != null) {
            page = Integer.parseInt(pageParam);
        }
        String columns = (String)query.get("columnModel");
        boolean isDemandQuery = true;
        String isDemandQueryParam = (String)query.get("isDemandQuery");
        if (isDemandQueryParam != null) {
            isDemandQuery = Boolean.parseBoolean(isDemandQueryParam);
        }
        if ((selector = (String)query.get("selector")) == null || selector.equals("")) {
            selector = isDemandQuery ? columns : null;
        }
        String queryPK = (String)query.get("queryPK");
        String filterItems = (String)query.get("filterItems");
        String sorterItems = (String)query.get("sorterItems");
        if (sorterItems != null && (sorterItems.equals("") || sorterItems.equals("null"))) {
            sorterItems = null;
        }
        if (sorterItems == null && query.get("sidx") != null && !query.get("sidx").equals("")) {
            StringBuilder sb = new StringBuilder();
            String sidx = (String)query.get("sidx");
            sb.append(sidx);
            if (!sidx.endsWith("asc") && !sidx.endsWith("desc")) {
                sb.append(" ").append(query.get("sord"));
            }
            sorterItems = sb.toString();
        }
        IQueryExecutor exec = null;
        logger.debug("****queryPK****:" + queryPK);
        if (queryPK == null || "".equals(queryPK)) {
            throw new BOSException("queryPK\u4e3a\u7a7a");
        }
        exec = QueryExecutorFactory.getLocalInstance((Context)ctx, (IMetaDataPK)new MetaDataPK(queryPK));
        EntityViewInfo entityViewInfo = new EntityViewInfo();
        if (selector != null && selector.length() > 0) {
            SelectorItemCollection coll = new SelectorItemCollection();
            String[] column = selector.split(",");
            for (int i = 0; i < column.length; ++i) {
                SelectorItemInfo selectorInfo = new SelectorItemInfo(column[i]);
                coll.add(selectorInfo);
            }
            entityViewInfo.setSelector(coll);
        }
        FilterInfo filterInfo = new FilterInfo();
        if (filterItems != null && filterItems.length() > 0) {
            try {
                filterInfo.mergeFilter(new FilterInfo(filterItems), "AND");
            }
            catch (ParserException e) {
                e.printStackTrace();
            }
        }
        entityViewInfo.setFilter(filterInfo);
        if (sorterItems != null && sorterItems.length() > 0) {
            String[] sorterList;
            if ((sorterItems = sorterItems.toLowerCase().trim()).toLowerCase().indexOf("order by") > -1) {
                sorterItems = sorterItems.substring("order by".length()).trim();
            }
            for (String sort : sorterList = sorterItems.split(",")) {
                String[] sortContent = sort.trim().split(" ");
                SorterItemInfo sorterItemInfo = new SorterItemInfo(sortContent[0]);
                if (sortContent.length == 2) {
                    sorterItemInfo.setSortType(sortContent[1].equals("asc") ? SortType.ASCEND : SortType.DESCEND);
                }
                entityViewInfo.getSorter().add(sorterItemInfo);
            }
        }
        exec.setObjectView(entityViewInfo);
        exec.option().isIgnoreOrder = true;
        exec.option().isAutoIgnoreDuplicatedRow = true;
        exec.option().isAutoTranslateBoolean = true;
        exec.option().isAutoTranslateEnum = true;
        exec.option().isIgnorePermissionCheck = false;
        exec.option().pageCount = rows;
        ArrayList records = new ArrayList();
        String[] columnModel = columns.split(",");
        List listModel = null;
        long pageSize = this.calcTotalCount(exec);
        if (!includePager) {
            rows = (int)pageSize;
        }
        if (rows == 0) {
            gridDataEntity.setTotal(0L);
        } else if (pageSize % (long)rows == 0L) {
            gridDataEntity.setTotal(pageSize / (long)rows);
        } else {
            gridDataEntity.setTotal(pageSize / (long)rows + 1L);
        }
        RealDataFetcher vdf = null;
        vdf = (long)page <= gridDataEntity.getTotal() || rows == 0 ? RealDataFetcher.createInstance((IQueryExecutor)exec, (int)((page - 1) * rows), (int)rows) : RealDataFetcher.createInstance((IQueryExecutor)exec, (int)((page - 1) * rows), (int)((int)(pageSize % (long)rows)));
        listModel = vdf.getData();
        for (int nIndex = 0; nIndex < listModel.size(); ++nIndex) {
            Map info = (Map)listModel.get(nIndex);
            HashMap<String, Object> row = new HashMap<String, Object>();
            for (String column : columnModel) {
                Object value = null;
                if (info.get(column) != null) {
                    value = info.get(column);
                }
                row.put(column, value);
            }
            records.add(row);
        }
        gridDataEntity.setRecords(pageSize);
        gridDataEntity.setRows(records);
        gridDataEntity.setPage(page);
        return gridDataEntity;
    }

    private long calcTotalCount(IQueryExecutor queryExecutor) {
        long totalCount = 0L;
        try {
            totalCount = queryExecutor.getRowCount();
        }
        catch (Throwable e) {
            logger.error("get total record count error!", e);
            totalCount = 0L;
        }
        return totalCount;
    }
}

