/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.uiframe.client;

import com.kingdee.bos.json.JSONException;
import com.kingdee.bos.json.JSONObject;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.base.license.ILicenseSrvAgent;
import com.kingdee.eas.base.license.LicenseException;
import com.kingdee.eas.base.license.client.LicenseSrvAgentFactory;
import com.kingdee.eas.base.license.file.LicenseCloudRequestInfo;
import com.kingdee.eas.base.uiframe.client.AbstractActiveCodeUI;
import com.kingdee.eas.base.uiframe.client.LicenseHelper;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.framework.FrameWorkUtils;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.Base64Encoder;
import com.kingdee.util.StringUtils;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.event.ActionEvent;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStreamWriter;
import org.apache.log4j.Logger;

public class ActiveCodeUI
extends AbstractActiveCodeUI {
    private static final Logger logger = CoreUIObject.getLogger(ActiveCodeUI.class);
    private static final String GENUINE_VALIDITY = "GenuineValidity.dat";
    private static final String DEFAULT_PATH = "w:\\eas\\deploy\\client";
    private boolean status = false;
    private String activeSerialNum = null;
    private boolean needProvideAssistFile = true;

    public void onLoad() throws Exception {
        super.onLoad();
        this.activeSerialNum = LicenseHelper.generateActiveCode();
        this.txtActiveSerial.setText(this.activeSerialNum);
        this.txtActiveSerial.setEditable(false);
        this.validateNet.setForeground(Color.BLUE);
        this.kDLabel15.setForeground(Color.BLUE);
        this.kDLabel17.setForeground(Color.BLUE);
        this.disableToolTips();
        this.addListener();
    }

    private void disableToolTips() {
        this.validateNet.setToolTipText("http://www.kingdee.com");
        this.kDLabel2.setAutoToolTipText(false);
        this.kDLabel10.setAutoToolTipText(false);
        this.kDLabel3.setAutoToolTipText(false);
        this.kDLabel7.setAutoToolTipText(false);
        this.kDLabel8.setAutoToolTipText(false);
        this.kDLabel4.setAutoToolTipText(false);
        this.kDLabel13.setAutoToolTipText(false);
        this.kDLabel9.setAutoToolTipText(false);
        this.kDLabel6.setAutoToolTipText(false);
        this.kDLabel1.setAutoToolTipText(false);
        this.kDLabel17.setAutoToolTipText(false);
    }

    private void addListener() {
        this.txtActiveCode.addFocusListener(new FocusListener(){
            String initText;
            {
                this.initText = ActiveCodeUI.this.resHelper.getString("txtActiveCode.text");
            }

            @Override
            public void focusGained(FocusEvent e) {
                if (ActiveCodeUI.this.txtActiveCode.getText().equals(this.initText)) {
                    ActiveCodeUI.this.txtActiveCode.setText("");
                } else {
                    ActiveCodeUI.this.txtActiveCode.setSelectAllOnFocus(true);
                }
            }

            @Override
            public void focusLost(FocusEvent e) {
                if (StringUtils.isEmpty((String)ActiveCodeUI.this.txtActiveCode.getText())) {
                    ActiveCodeUI.this.txtActiveCode.setText(this.initText);
                }
            }
        });
        this.validateNet.addMouseListener((MouseListener)new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent e) {
                ActiveCodeUI.this.setCursor(new Cursor(12));
            }

            @Override
            public void mouseExited(MouseEvent e) {
                ActiveCodeUI.this.setCursor(new Cursor(0));
            }

            @Override
            public void mouseClicked(MouseEvent e) {
                FrameWorkUtils.openByDefaultBrowser((String)"http://www.kingdee.com/genuine/activation.jsp");
            }
        });
        this.kDLabel15.addMouseListener((MouseListener)new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent e) {
                ActiveCodeUI.this.setCursor(new Cursor(12));
            }

            @Override
            public void mouseExited(MouseEvent e) {
                ActiveCodeUI.this.setCursor(new Cursor(0));
            }

            @Override
            public void mouseClicked(MouseEvent e) {
                ActiveCodeUI.this.setCursor(new Cursor(3));
                String filePath = null;
                try {
                    filePath = ActiveCodeUI.this.generateGenuineValidity();
                }
                catch (LicenseException e1) {
                    logger.error((Object)e1.getMessage(), (Throwable)e1);
                }
                ActiveCodeUI.this.setCursor(new Cursor(0));
                if (!StringUtils.isEmpty((String)filePath)) {
                    System.out.println("\u6587\u4ef6\u751f\u6210\u6210\u529f\uff01\n\n\u8bf7\u5728\u4ee5\u4e0b\u8def\u5f84\u83b7\u53d6\u8be5\u6587\u4ef6\uff1a\n\n" + filePath);
                    filePath = filePath.replaceAll("/", "\\\\");
                    String begin = filePath.substring(0, filePath.indexOf("eas\\client\\deploy"));
                    String end = filePath.substring(filePath.indexOf("eas\\client\\deploy"), filePath.length());
                    String temPath = begin + "\n\n" + end;
                    MsgBox.showInfo((Component)((Object)ActiveCodeUI.this), (String)("\u6587\u4ef6\u751f\u6210\u6210\u529f\uff01\n\n\u8bf7\u5728\u4ee5\u4e0b\u8def\u5f84\u83b7\u53d6\u8be5\u6587\u4ef6\uff1a\n\n" + temPath));
                } else {
                    MsgBox.showInfo((Component)((Object)ActiveCodeUI.this), (String)"\u6587\u4ef6\u751f\u6210\u5931\u8d25\uff01");
                }
            }
        });
    }

    @Override
    protected void btnActive_actionPerformed(ActionEvent e) {
        try {
            String activeCode = this.txtActiveCode.getText();
            if (StringUtils.isEmpty((String)activeCode) || StringUtils.equals((String)activeCode, (String)this.resHelper.getString("txtActiveCode.text"))) {
                MsgBox.showWarning((String)"\u8bf7\u8f93\u5165\u6fc0\u6d3b\u9a8c\u8bc1\u7801\uff01");
                return;
            }
            if (activeCode.length() <= 4) {
                MsgBox.showWarning((String)"\u9a8c\u8bc1\u5931\u8d25\uff01");
                this.status = false;
                return;
            }
            String randomCode = (activeCode = LicenseHelper.decodeBASE64(activeCode)).substring(0, 4);
            if (!randomCode.equals(this.activeSerialNum.substring(this.activeSerialNum.length() - 4, this.activeSerialNum.length()))) {
                MsgBox.showWarning((String)"\u9a8c\u8bc1\u5931\u8d25\uff01");
                this.status = false;
                return;
            }
            int key = this.calculateRomdom(randomCode);
            String latestCheckDate = activeCode.substring(4);
            String realValue = this.calculateRealValue(key, latestCheckDate);
            ILicenseSrvAgent agent = LicenseSrvAgentFactory.getRemoteInstance();
            if (!agent.updateLatestCheckDate(realValue)) {
                MsgBox.showWarning((String)"\u9a8c\u8bc1\u5931\u8d25\uff01");
                this.status = false;
                return;
            }
            this.status = true;
            MsgBox.showWarning((String)"\u9a8c\u8bc1\u6210\u529f\uff01");
            this.disposeUIWindow();
        }
        catch (Throwable e1) {
            logger.error((Object)e1.getMessage(), e1);
            MsgBox.showWarning((String)"\u9a8c\u8bc1\u5931\u8d25\uff01");
            this.status = false;
        }
    }

    private String calculateRealValue(int key, String latestCheckDate) {
        StringBuffer result = new StringBuffer();
        for (int i = 0; i < latestCheckDate.length(); ++i) {
            int temp = latestCheckDate.charAt(i) - key;
            char c = (char)temp;
            result.append(c);
        }
        return result.toString();
    }

    private int calculateRomdom(String randomCode) {
        int sum = 0;
        for (int i = 0; i < randomCode.length(); ++i) {
            sum += Integer.parseInt(String.valueOf(randomCode.charAt(i)));
        }
        return sum;
    }

    public boolean getReturnValue() {
        return this.status;
    }

    private String generateGenuineValidity() throws LicenseException {
        ILicenseSrvAgent agent = LicenseSrvAgentFactory.getRemoteInstance();
        LicenseCloudRequestInfo requestInfo = agent.generateRequestInfo(new String[]{SysContext.getSysContext().getDcName()});
        JSONObject json = null;
        try {
            json = LicenseHelper.generateJSONObject(requestInfo);
        }
        catch (JSONException e) {
            throw new LicenseException((Throwable)e);
        }
        String base64String = Base64Encoder.byteArrayToBase64((byte[])json.toString().getBytes());
        String filePath = this.generateFilePath();
        File file = new File(filePath);
        OutputStreamWriter fileWriter = null;
        try {
            if (!file.exists()) {
                file.createNewFile();
            }
            fileWriter = new FileWriter(file);
            fileWriter.write("");
            fileWriter.flush();
            fileWriter.write(base64String);
            fileWriter.flush();
        }
        catch (IOException e) {
            throw new LicenseException((Throwable)e);
        }
        finally {
            if (fileWriter != null) {
                try {
                    fileWriter.close();
                }
                catch (Exception ex) {
                    logger.error((Object)"stream close error!");
                }
            }
        }
        return filePath;
    }

    private String generateFilePath() {
        String filePath = null;
        filePath = System.getProperty("easclient.root") != null ? System.getProperty("easclient.root") + File.separator + GENUINE_VALIDITY : "w:\\eas\\deploy\\clientGenuineValidity.dat";
        return filePath;
    }
}

