/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.uiframe.client;

import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIException;
import com.kingdee.eas.base.permission.UserException;
import com.kingdee.eas.base.uiframe.EASLoginException;
import com.kingdee.eas.base.uiframe.OpenMethod;
import com.kingdee.eas.base.uiframe.client.ILoginInitStrategy;
import com.kingdee.eas.base.uiframe.client.LoginInitWEBStrategy;
import com.kingdee.eas.base.uiframe.client.MainMenuTree;
import com.kingdee.eas.base.uiframe.client.SystemEntry;
import com.kingdee.eas.base.uiframe.utils.UIFrameUtils;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.cp.eip.sso.UserCountLimitedException;
import com.kingdee.eas.cp.eip.sso.client.service.IUserLoginHelper;
import com.kingdee.eas.cp.eip.sso.client.service.UserLoginHelperFactroy;
import com.kingdee.eas.util.AbortException;
import com.kingdee.eas.util.client.ExceptionHandler;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.StringUtils;
import java.awt.Component;
import java.awt.Frame;
import java.util.Locale;
import javax.swing.JApplet;
import javax.swing.JOptionPane;
import org.apache.log4j.Logger;

public class AppletManagerProxy {
    private static Logger logger = Logger.getLogger(AppletManagerProxy.class);
    private static JApplet applet = null;

    public void init(JApplet applet, String appServerUrl) {
        AppletManagerProxy.applet = applet;
        SystemEntry.instance.setApplet(applet);
        String embed = applet.getParameter("openModel");
        if (embed != null && "embed".equals(embed)) {
            SystemEntry.instance.setStartMode(2);
        } else {
            SystemEntry.instance.setStartMode(1);
        }
        try {
            ILoginInitStrategy loginInitStrategy = LoginInitWEBStrategy.getInstance();
            loginInitStrategy.init(appServerUrl);
            UIFrameUtils.marked();
        }
        catch (Exception e) {
            ExceptionHandler.handle((Component)this.getOwnerFrame(), (Throwable)e);
        }
    }

    public String login(String userName, String password, String slnName, String dcName, String locale, int dbType) {
        return this.login(userName, password, slnName, dcName, locale, dbType, "");
    }

    public String login(String userName, String password, String slnName, String dcName, String locale, int dbType, String authPattern) {
        String session = null;
        try {
            if (authPattern != null && authPattern.length() != 0 && authPattern.equals("ReginAutoLogin")) {
                IUserLoginHelper iUserLogin = UserLoginHelperFactroy.getUserLoginHelp();
                userName = iUserLogin.getUserName();
            }
            session = SystemEntry.instance.login(userName, password, slnName, dcName, new Locale(locale), dbType, authPattern);
        }
        catch (Exception e) {
            UserCountLimitedException ucle = this.getUserCountLimitedException(e);
            if (ucle != null) {
                MsgBox.showError((Component)this.getOwnerFrame(), (String)ucle.getMessage());
            } else if (e instanceof UserException) {
                String code = ((UserException)e).getCode();
                session = code.equals("02-016") ? "-2" : (code.equals("02-007") ? "-1" : "-2");
                ExceptionHandler.handle((Component)this.getOwnerFrame(), (Throwable)e);
            } else {
                ExceptionHandler.handle((Component)this.getOwnerFrame(), (Throwable)e);
            }
            logger.debug((Object)("End login : " + System.currentTimeMillis()));
            return session;
        }
        return session + ";" + userName;
    }

    public void initAfterLogin() {
        logger.debug((Object)("Begin init after login : " + System.currentTimeMillis()));
        SystemEntry.instance.initAfterLogin();
        logger.debug((Object)("End init after login : " + System.currentTimeMillis()));
    }

    public String logout() {
        try {
            SystemEntry.instance.closeApplication(false);
        }
        catch (AbortException e) {
            return "0";
        }
        catch (EASLoginException e0) {
            logger.info((Object)"loutout error", (Throwable)((Object)e0));
            ExceptionHandler.handle((Component)this.getOwnerFrame(), (Throwable)((Object)e0));
        }
        catch (Exception e1) {
            logger.info((Object)"loutout error", (Throwable)e1);
            return "-1";
        }
        return "1";
    }

    public void destory() {
        try {
            if (!StringUtils.isEmpty((String)SysContext.getSysContext().getSessionID())) {
                SystemEntry.instance.closeApplication(false);
            }
        }
        catch (Exception e0) {
            logger.info((Object)"", (Throwable)e0);
        }
    }

    public void openMainMenuFunction() {
        this.webEntryStart(null);
    }

    public void invokeFunction(String uiClass, String uiClassParam, String uiOprt, int openMethod) {
        try {
            Frame frame = null;
            IUIWindow uiWindow = null;
            frame = JOptionPane.getFrameForComponent(applet);
            OpenMethod opeMethod = this.parseOpenMethod(openMethod);
            uiWindow = MainMenuTree.passCreateUI(frame, uiClass, uiClassParam, opeMethod, uiOprt, null);
            uiWindow.show();
        }
        catch (UIException e) {
            ExceptionHandler.handle((Component)this.getOwnerFrame(), (Throwable)e);
        }
    }

    private OpenMethod parseOpenMethod(int op) {
        if (op == 20) {
            return OpenMethod.NEWTAB;
        }
        if (op == 30) {
            return OpenMethod.NEWWIN;
        }
        if (op == 50) {
            return OpenMethod.MODEL;
        }
        return OpenMethod.FIXTAB;
    }

    public void webEntryStart(IUIObject uiObject) {
        try {
            SystemEntry.instance.startApplication(uiObject);
        }
        catch (UIException e) {
            ExceptionHandler.handle((Component)this.getOwnerFrame(), (Throwable)e);
        }
    }

    public void switchOrg() {
        SystemEntry.instance.switchOrg(this.getOwnerFrame());
    }

    private Frame getOwnerFrame() {
        return JOptionPane.getFrameForComponent(applet);
    }

    private UserCountLimitedException getUserCountLimitedException(Exception e) {
        Throwable ex = null;
        for (ex = e; ex != null && ex.getCause() != ex; ex = ex.getCause()) {
            if (!(ex instanceof UserCountLimitedException)) continue;
            return (UserCountLimitedException)ex;
        }
        return null;
    }
}

