/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.uiframe.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.swing.KDInfoTip;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.base.myeas.MyEasResource;
import com.kingdee.eas.base.permission.IUser;
import com.kingdee.eas.base.permission.SecurityFactory;
import com.kingdee.eas.base.permission.SecurityInfo;
import com.kingdee.eas.base.permission.UserException;
import com.kingdee.eas.base.permission.UserFactory;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.base.permission.util.SecurityValidator;
import com.kingdee.eas.base.uiframe.UIFrameResource;
import com.kingdee.eas.base.uiframe.client.AbstractChangePassword2UI;
import com.kingdee.eas.base.uiframe.client.ChangePasswordUI;
import com.kingdee.eas.base.uiframe.client.SystemEntry;
import com.kingdee.eas.base.uiframe.utils.UIFrameUtils;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.util.CryptoTean;
import com.kingdee.eas.util.client.ExceptionHandler;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.StringUtils;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.JComponent;
import org.apache.log4j.Logger;

public class ChangePassword2UI
extends AbstractChangePassword2UI {
    private static final Logger logger = CoreUIObject.getLogger(ChangePasswordUI.class);
    public boolean isCancel = true;
    private static final String resource = "com.kingdee.eas.base.uiframe.UIFrameResource";
    KDInfoTip pdTip = null;

    public void onLoad() throws Exception {
        this.loadFields();
        this.newPassword.addFocusListener((FocusListener)new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e) {
                try {
                    ChangePassword2UI.this.pwdPassword_focusLost(e);
                }
                catch (Exception exc) {
                    ChangePassword2UI.this.handUIException(exc);
                }
            }

            @Override
            public void focusGained(FocusEvent e) {
                try {
                    ChangePassword2UI.this.pwdPassword_focusGained(e);
                }
                catch (Exception exc) {
                    ChangePassword2UI.this.handUIException(exc);
                }
            }
        });
    }

    private void pwdPassword_focusLost(FocusEvent e) {
        if (this.pdTip != null) {
            this.pdTip.setShowing(false);
        }
    }

    private void pwdPassword_focusGained(FocusEvent e) throws EASBizException, BOSException {
        if (this.pdTip != null && !StringUtils.isEmpty((String)this.pdTip.getTipText())) {
            this.pdTip.setShowing(true);
            return;
        }
        UserInfo userInfo = SysContext.getSysContext().getCurrentUserInfo();
        SecurityInfo security = SecurityFactory.getRemoteInstance().getSecurityInfo("where id='" + userInfo.getSecurity().getId().toString() + "'");
        userInfo.setSecurity(security);
        SecurityValidator securityValidator = new SecurityValidator(userInfo);
        String securityPolicy = securityValidator.getSecurityPolicy();
        if (!StringUtils.isEmpty((String)securityPolicy)) {
            this.pdTip = new KDInfoTip((JComponent)this.newPassword, securityPolicy);
            this.pdTip.setMaxRenderWidth(250.0f);
            this.pdTip.setShowing(true);
        }
    }

    @Override
    public void loadFields() {
        UserInfo userInfo = SysContext.getSysContext().getCurrentUserInfo();
        this.userName.setText(userInfo.getNumber());
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    protected boolean verifyInput() {
        char[] newPwd = this.newPassword.getPassword();
        char[] newPwdAgain = this.confirmPassword.getPassword();
        String strNewPwd = new String(newPwd);
        String strNewPwdAgain = new String(newPwdAgain);
        Pattern p = Pattern.compile("[\u4e00-\u9fa5]|[\ufe30-\uffa0]");
        Matcher m = p.matcher(strNewPwd);
        if (m.find() || this.checkIllChar(strNewPwd)) {
            MsgBox.showInfo((String)UIFrameResource.getString("new_pwd_incorrect"));
            this.newPassword.requestFocus();
            this.newPassword.selectAll();
            return false;
        }
        if (!StringUtils.equals((String)strNewPwd, (String)strNewPwdAgain)) {
            MsgBox.showInfo((Component)((Object)this), (String)this.getString("PasswordSetUI.verifyPwd"));
            this.newPassword.requestFocus();
            this.newPassword.selectAll();
            return false;
        }
        return true;
    }

    private boolean checkIllChar(String str) {
        return str.indexOf("'") > -1 || str.indexOf("(") > -1 || str.indexOf("%27") > -1 || str.indexOf("<") > -1 || str.indexOf("%3c") > -1;
    }

    private String getString(String strKey) {
        return MyEasResource.getString((String)strKey);
    }

    @Override
    protected void confirm_actionPerformed(ActionEvent e) throws Exception {
        block3: {
            super.confirm_actionPerformed(e);
            if (this.verifyInput()) {
                UserInfo userInfo = SysContext.getSysContext().getCurrentUserInfo();
                char[] newPwd = this.newPassword.getPassword();
                String strOldPwd = this.oldPwd.getText();
                String strNewPwd = new String(newPwd);
                try {
                    strOldPwd = CryptoTean.encrypt((String)userInfo.getNumber(), (String)strOldPwd);
                    strNewPwd = CryptoTean.encrypt((String)userInfo.getNumber(), (String)strNewPwd);
                    ObjectUuidPK iObjectPK = new ObjectUuidPK(userInfo.getId());
                    IUser iUser = UserFactory.getRemoteInstance();
                    iUser.updatePass((IObjectPK)iObjectPK, strOldPwd, strNewPwd);
                    this.isCancel = false;
                    MsgBox.showInfo((Component)((Object)this), (String)MyEasResource.getCommonString((String)"saveSuccessed"));
                    SysContext.getSysContext().setProperty((Object)"needPasswordWhenUpdatePw", (Object)true);
                    this.uiWindow.close();
                }
                catch (Exception ex) {
                    logger.error((Object)(UIFrameUtils.getRes("res_36") + ex.getMessage()));
                    ExceptionHandler.handle((Component)((Object)this), (Throwable)ex);
                    if (!(ex instanceof UserException) || !UserException.USER_IS_LOCKED_BY_UPDATEPW.getCode().equals(((UserException)ex).getSubCode()) && !UserException.USER_IS_LOCKED.getCode().equals(((UserException)ex).getSubCode())) break block3;
                    SystemEntry.instance.relogin();
                }
            }
        }
    }

    @Override
    protected void cancel_actionPerformed(ActionEvent e) throws Exception {
        this.isCancel = true;
        this.getUIWindow().close();
    }

    @Override
    public void actionPageSetup_actionPerformed(ActionEvent e) throws Exception {
        super.actionPageSetup_actionPerformed(e);
    }

    @Override
    public void actionExitCurrent_actionPerformed(ActionEvent e) throws Exception {
        super.actionExitCurrent_actionPerformed(e);
    }

    @Override
    public void actionHelp_actionPerformed(ActionEvent e) throws Exception {
        super.actionHelp_actionPerformed(e);
    }

    @Override
    public void actionAbout_actionPerformed(ActionEvent e) throws Exception {
        super.actionAbout_actionPerformed(e);
    }

    @Override
    public void actionOnLoad_actionPerformed(ActionEvent e) throws Exception {
        super.actionOnLoad_actionPerformed(e);
    }
}

