/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.uiframe.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.swing.KDInfoTip;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.base.myeas.MyEasResource;
import com.kingdee.eas.base.permission.IUser;
import com.kingdee.eas.base.permission.SecurityFactory;
import com.kingdee.eas.base.permission.SecurityInfo;
import com.kingdee.eas.base.permission.UserFactory;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.base.permission.util.SecurityValidator;
import com.kingdee.eas.base.uiframe.UIFrameResource;
import com.kingdee.eas.base.uiframe.client.AbstractChangePasswordUI;
import com.kingdee.eas.base.uiframe.utils.UIFrameUtils;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.util.CryptoTean;
import com.kingdee.eas.util.client.ExceptionHandler;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.StringUtils;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.JComponent;
import org.apache.log4j.Logger;

public class ChangePasswordUI
extends AbstractChangePasswordUI {
    private static final Logger logger = CoreUIObject.getLogger(ChangePasswordUI.class);
    public boolean isCancel = true;
    KDInfoTip pdTip = null;

    public void onLoad() throws Exception {
        this.loadFields();
        String info = (String)this.getUIContext().get("info");
        if (!StringUtils.isEmpty((String)info)) {
            this.kDLabel2.setText(info);
        }
        this.newPassword.addFocusListener((FocusListener)new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e) {
                try {
                    ChangePasswordUI.this.pwdPassword_focusLost(e);
                }
                catch (Exception exc) {
                    ChangePasswordUI.this.handUIException(exc);
                }
            }

            @Override
            public void focusGained(FocusEvent e) {
                try {
                    ChangePasswordUI.this.pwdPassword_focusGained(e);
                }
                catch (Exception exc) {
                    ChangePasswordUI.this.handUIException(exc);
                }
            }
        });
    }

    private void pwdPassword_focusLost(FocusEvent e) {
        if (this.pdTip != null) {
            this.pdTip.setShowing(false);
        }
    }

    private void pwdPassword_focusGained(FocusEvent e) throws EASBizException, BOSException {
        if (this.pdTip != null && !StringUtils.isEmpty((String)this.pdTip.getTipText())) {
            this.pdTip.setShowing(true);
            return;
        }
        UserInfo userInfo = SysContext.getSysContext().getCurrentUserInfo();
        SecurityInfo security = SecurityFactory.getRemoteInstance().getSecurityInfo("where id='" + userInfo.getSecurity().getId().toString() + "'");
        userInfo.setSecurity(security);
        SecurityValidator securityValidator = new SecurityValidator(userInfo);
        String securityPolicy = securityValidator.getSecurityPolicy();
        if (!StringUtils.isEmpty((String)securityPolicy)) {
            this.pdTip = new KDInfoTip((JComponent)this.newPassword, securityPolicy);
            this.pdTip.setMaxRenderWidth(300.0f);
            this.pdTip.setShowing(true);
        }
    }

    @Override
    public void loadFields() {
        UserInfo userInfo = SysContext.getSysContext().getCurrentUserInfo();
        this.userName.setText(userInfo.getNumber());
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    protected boolean verifyInput() {
        char[] newPwd = this.newPassword.getPassword();
        char[] newPwdAgain = this.confirmPassword.getPassword();
        String strNewPwd = new String(newPwd);
        String strNewPwdAgain = new String(newPwdAgain);
        Pattern p = Pattern.compile("[\u4e00-\u9fa5]|[\ufe30-\uffa0]");
        Matcher m = p.matcher(strNewPwd);
        if (m.find() || this.checkIllChar(strNewPwd)) {
            MsgBox.showInfo((String)UIFrameResource.getString("new_pwd_incorrect"));
            this.newPassword.requestFocus();
            this.newPassword.selectAll();
            return false;
        }
        if (!StringUtils.equals((String)strNewPwd, (String)strNewPwdAgain)) {
            MsgBox.showInfo((Component)((Object)this), (String)this.getString("PasswordSetUI.verifyPwd"));
            this.newPassword.requestFocus();
            this.newPassword.selectAll();
            return false;
        }
        return true;
    }

    private boolean checkIllChar(String str) {
        return str.indexOf("'") > -1 || str.indexOf("(") > -1 || str.indexOf("%27") > -1 || str.indexOf("<") > -1 || str.indexOf("%3c") > -1;
    }

    private String getString(String strKey) {
        return MyEasResource.getString((String)strKey);
    }

    @Override
    protected void confirm_actionPerformed(ActionEvent e) throws Exception {
        super.confirm_actionPerformed(e);
        if (this.verifyInput()) {
            SysContext sysContext = SysContext.getSysContext();
            UserInfo userInfo = sysContext.getSysContext().getCurrentUserInfo();
            char[] newPwd = this.newPassword.getPassword();
            String strOldPwd = this.oldPassword.getText();
            String strNewPwd = new String(newPwd);
            try {
                strOldPwd = CryptoTean.encrypt((String)userInfo.getNumber(), (String)strOldPwd);
                strNewPwd = CryptoTean.encrypt((String)userInfo.getNumber(), (String)strNewPwd);
                ObjectUuidPK iObjectPK = new ObjectUuidPK(userInfo.getId());
                IUser iUser = UserFactory.getRemoteInstance();
                iUser.updatePass((IObjectPK)iObjectPK, strOldPwd, strNewPwd);
                sysContext.setProperty((Object)"Password", (Object)strNewPwd);
                this.isCancel = false;
                this.uiWindow.close();
            }
            catch (Exception ex) {
                logger.error((Object)(UIFrameUtils.getRes("res_36") + ex.getMessage()));
                ExceptionHandler.handle((Component)((Object)this), (Throwable)ex);
            }
        }
    }

    @Override
    protected void cancel_actionPerformed(ActionEvent e) throws Exception {
        this.isCancel = true;
        this.getUIWindow().close();
    }

    @Override
    public void actionPageSetup_actionPerformed(ActionEvent e) throws Exception {
        super.actionPageSetup_actionPerformed(e);
    }

    @Override
    public void actionExitCurrent_actionPerformed(ActionEvent e) throws Exception {
        super.actionExitCurrent_actionPerformed(e);
    }

    @Override
    public void actionHelp_actionPerformed(ActionEvent e) throws Exception {
        super.actionHelp_actionPerformed(e);
    }

    @Override
    public void actionAbout_actionPerformed(ActionEvent e) throws Exception {
        super.actionAbout_actionPerformed(e);
    }

    @Override
    public void actionOnLoad_actionPerformed(ActionEvent e) throws Exception {
        super.actionOnLoad_actionPerformed(e);
    }
}

