/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.uiframe.client;

import com.kingdee.bos.ui.face.CoreUIObject;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.net.URL;
import org.apache.log4j.Logger;

public class EASClientDownLoadHelperFile {
    private static final Logger logger = CoreUIObject.getLogger(EASClientDownLoadHelperFile.class);
    private static final String EAS_CLIENT_HELPER_PREFIX = "jar:file:/";
    private static final String EAS_ClIENT_HELPER_FILE_URL = "C:/kingdee/eas/client/lib/client/eas/eas_help.jar!/";
    private static EASClientDownLoadHelperFile instance;
    private File clientHelperFile;
    private String isNotDefaultClientPath;
    private long conreateSize = 10240L;

    private EASClientDownLoadHelperFile(String clientFilePath) {
        if (clientFilePath == null || clientFilePath.equals("")) {
            this.clientHelperFile = new File(EAS_ClIENT_HELPER_FILE_URL);
        } else {
            this.isNotDefaultClientPath = clientFilePath + "/lib/client/eas/eas_help.jar";
            this.clientHelperFile = new File(this.isNotDefaultClientPath);
        }
    }

    public static EASClientDownLoadHelperFile getInstance(String clientFilePath) {
        if (clientFilePath == null) {
            throw new IllegalArgumentException("args for clientFilePath can not be null !");
        }
        if (instance == null && !clientFilePath.equals("")) {
            instance = new EASClientDownLoadHelperFile(clientFilePath);
        }
        return instance;
    }

    public URL downloadClientHelperFileFromServer(URL srvResURL) throws IOException {
        if (this.clientHelperFile.exists()) {
            this.clientHelperFile.delete();
        }
        this.downLoadServerHelperFile(srvResURL);
        return new URL(this.getEasClientHelperFilePath());
    }

    private void downLoadServerHelperFile(URL srvResURL) throws IOException {
        DataInputStream inputStream = null;
        FileOutputStream fileOutputStream = null;
        FilterOutputStream outputStream = null;
        try {
            inputStream = new DataInputStream(srvResURL.openStream());
            fileOutputStream = new FileOutputStream(this.clientHelperFile);
            outputStream = new DataOutputStream(fileOutputStream);
            byte[] tempArray = new byte[new Long(this.conreateSize).intValue()];
            long size = 0L;
            while ((size = (long)inputStream.read(tempArray)) != -1L) {
                ((DataOutputStream)outputStream).write(tempArray, 0, new Long(size).intValue());
            }
            ((DataOutputStream)outputStream).flush();
        }
        catch (IOException ie) {
            throw new IOException(ie);
        }
        finally {
            if (outputStream != null) {
                try {
                    outputStream.close();
                }
                catch (Exception ex) {
                    logger.error((Object)"stream close error!");
                }
            }
            if (fileOutputStream != null) {
                try {
                    fileOutputStream.close();
                }
                catch (Exception ex) {
                    logger.error((Object)"stream close error!");
                }
            }
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (Exception ex) {
                    logger.error((Object)"stream close error!");
                }
            }
        }
    }

    String getEasClientHelperFilePath() {
        if (this.isNotDefaultClientPath != null) {
            return EAS_CLIENT_HELPER_PREFIX + this.isNotDefaultClientPath + "!/";
        }
        return "jar:file:/C:/kingdee/eas/client/lib/client/eas/eas_help.jar!/";
    }

    public boolean isExists() {
        return this.clientHelperFile.exists();
    }
}

