/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.uiframe.client;

import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.swing.KDFileChooser;
import com.kingdee.bos.dao.query.ISQLExecutor;
import com.kingdee.bos.dao.query.SQLExecutorFactory;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.ItemAction;
import com.kingdee.eas.base.uiframe.client.AbstractExportMenuSqlUI;
import com.kingdee.eas.base.uiframe.client.ExportSqlServerData;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.jdbc.rowset.IRowSet;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.BorderFactory;
import javax.swing.InputMap;
import javax.swing.KeyStroke;
import org.apache.log4j.Logger;

public class ExportMenuSqlUI
extends AbstractExportMenuSqlUI {
    private static final Logger logger = CoreUIObject.getLogger(ExportMenuSqlUI.class);
    private ActionQuery actionQuery = null;
    private static final String resource = "com.kingdee.eas.base.uiframe.UIFrameResource";

    public ExportMenuSqlUI() throws Exception {
        this.jbinit();
    }

    private void jbinit() {
        this.queryText.setBorder(BorderFactory.createLineBorder(Color.BLACK));
        this.initQueryKey();
        this.queryText.setText("select * from T_PM_MAINMENUITEM;");
        this.tableComboBox.addItem((Object)"T_PM_MainMenuItem");
        this.tableComboBox.addItem((Object)"T_BAS_SysMenuItem");
        this.tableComboBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                ExportMenuSqlUI.this.changeTable();
            }
        });
    }

    private void changeTable() {
        String selectTable = this.tableComboBox.getSelectedItem().toString();
        String sqlText = this.queryText.getText();
        this.queryText.setText("select * from " + selectTable + ";");
    }

    private void initQueryKey() {
        InputMap imEntry = this.getInputMap(2);
        KeyStroke ctrl_shift_f = KeyStroke.getKeyStroke(81, 3);
        imEntry.put(ctrl_shift_f, "modifyKey");
        ActionMap entryActionMap = this.getActionMap();
        entryActionMap.put("modifyKey", (Action)((Object)this.actionQuery));
        this.actionQuery = new ActionQuery();
        this.getActionManager().registerAction("modifyKey", (ItemAction)this.actionQuery);
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    @Override
    protected void CloseBtn_actionPerformed(ActionEvent e) throws Exception {
        super.CloseBtn_actionPerformed(e);
        this.disposeUIWindow();
    }

    @Override
    protected void exportSqlBtn_actionPerformed(ActionEvent e) throws Exception {
        super.exportSqlBtn_actionPerformed(e);
        this.exportSql();
    }

    @Override
    protected void queryBtn_actionPerformed(ActionEvent e) throws Exception {
        super.queryBtn_actionPerformed(e);
        this.query();
    }

    private boolean isCorrectSql(String sql) {
        String temSql = sql.toLowerCase();
        if (temSql.indexOf("t_pm_mainmenuitem") < 0 && temSql.indexOf("t_bas_sysmenuitem") < 0) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)resource, (String)"tableError"));
            return false;
        }
        if (!sql.startsWith("select")) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)resource, (String)"SqlError"));
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void exportSql() {
        StringBuffer sqlstr = new StringBuffer();
        IRowSet resut = null;
        ResultSetMetaData restmd = null;
        String sql = this.queryText.getText();
        if (!this.isCorrectSql(sql)) {
            return;
        }
        String tableName = sql.toLowerCase().indexOf("T_PM_MainMenuItem".toLowerCase()) > 0 ? "T_PM_MainMenuItem" : "T_BAS_SysMenuItem";
        KDFileChooser chooser = new KDFileChooser();
        FileOutputStream fileOutputStream = null;
        OutputStreamWriter outputStreamWriter = null;
        BufferedWriter out = null;
        try {
            File tempFile;
            int result = chooser.showSaveDialog((Component)((Object)this));
            if (result == 0) {
                tempFile = chooser.getSelectedFile();
                if (tempFile.exists()) {
                    tempFile.delete();
                }
            } else {
                return;
            }
            fileOutputStream = new FileOutputStream(tempFile, true);
            outputStreamWriter = new OutputStreamWriter((OutputStream)fileOutputStream, "utf-8");
            out = new BufferedWriter(outputStreamWriter);
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        ISQLExecutor sqlExe = SQLExecutorFactory.getRemoteInstance((String)sql);
        try {
            resut = sqlExe.executeSQL();
            restmd = resut.getMetaData();
            int numberOfColumns = restmd.getColumnCount();
            int iRowGo = 0;
            int iAllRow = 0;
            while (resut.next()) {
                int k;
                ++iRowGo;
                ++iAllRow;
                sqlstr.append("insert into " + tableName + " (");
                for (int i = k = 1; i <= numberOfColumns; ++i) {
                    if (i > 1) {
                        sqlstr.append(" , " + restmd.getColumnName(i));
                        continue;
                    }
                    sqlstr.append(restmd.getColumnName(i));
                }
                sqlstr.append(")  values( ");
                ExportSqlServerData.dealData((ResultSet)resut, restmd, sqlstr, numberOfColumns, k);
                sqlstr.append(");");
                sqlstr.append("\n");
            }
            if (out != null) {
                out.write(sqlstr.toString());
                out.flush();
            }
            logger.debug((Object)("this is the sql to export:" + sqlstr));
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)resource, (String)"sqlSuccess"));
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            MsgBox.showInfo((Component)((Object)this), (String)(EASResource.getString((String)resource, (String)"SqlExportError") + e.toString()));
        }
        finally {
            if (out != null) {
                try {
                    out.close();
                }
                catch (Exception ex) {
                    logger.error((Object)"stream close error!");
                }
            }
            if (outputStreamWriter != null) {
                try {
                    outputStreamWriter.close();
                }
                catch (Exception ex) {
                    logger.error((Object)"stream close error!");
                }
            }
            if (fileOutputStream != null) {
                try {
                    fileOutputStream.close();
                }
                catch (Exception ex) {
                    logger.error((Object)"stream close error!");
                }
            }
        }
    }

    private void query() {
        String sql = this.queryText.getText();
        if (!this.isCorrectSql(sql)) {
            return;
        }
        this.queryTable.removeColumns();
        ISQLExecutor sqlExe = SQLExecutorFactory.getRemoteInstance((String)sql);
        try {
            IRowSet rs = sqlExe.executeSQL();
            this.fillData(this.queryTable, rs);
        }
        catch (Exception e) {
            MsgBox.showError((Component)((Object)this), (String)(EASResource.getString((String)resource, (String)"adjustSql") + e.toString()));
        }
    }

    private void quickQuery() {
        String sql = this.queryText.getText();
        this.queryTable.removeColumns();
        ISQLExecutor sqlExe = SQLExecutorFactory.getRemoteInstance((String)sql);
        try {
            IRowSet rs = sqlExe.executeSQL();
            this.fillData(this.queryTable, rs);
        }
        catch (Exception e) {
            MsgBox.showError((Component)((Object)this), (String)(EASResource.getString((String)resource, (String)"adjustSql") + e.toString()));
        }
    }

    public void fillData(KDTable tblMain, IRowSet rs) throws SQLException {
        ResultSetMetaData meta = rs.getMetaData();
        this.fillHeader(tblMain, meta);
        this.fillBody(tblMain, rs);
    }

    public void fillBody(KDTable tblMain, IRowSet rs) throws SQLException {
        int c = rs.getMetaData().getColumnCount();
        while (rs.next()) {
            IRow row = tblMain.addRow();
            for (int i = 0; i < c; ++i) {
                Object object = rs.getObject(i + 1);
                row.getCell(i).setValue(object);
            }
        }
    }

    public void fillHeader(KDTable tblMain, ResultSetMetaData meta) throws SQLException {
        int c = meta.getColumnCount();
        IRow row = tblMain.addHeadRow();
        for (int i = 0; i < c; ++i) {
            tblMain.addColumn();
            row.getCell(i).setValue((Object)meta.getColumnName(i + 1));
        }
    }

    public void actionPageSetup_actionPerformed(ActionEvent e) throws Exception {
        super.actionPageSetup_actionPerformed(e);
    }

    public void actionExitCurrent_actionPerformed(ActionEvent e) throws Exception {
        super.actionExitCurrent_actionPerformed(e);
    }

    public void actionHelp_actionPerformed(ActionEvent e) throws Exception {
        super.actionHelp_actionPerformed(e);
    }

    public void actionAbout_actionPerformed(ActionEvent e) throws Exception {
        super.actionAbout_actionPerformed(e);
    }

    public void actionOnLoad_actionPerformed(ActionEvent e) throws Exception {
        super.actionOnLoad_actionPerformed(e);
    }

    public void actionSendMessage_actionPerformed(ActionEvent e) throws Exception {
        super.actionSendMessage_actionPerformed(e);
    }

    public void actionCalculator_actionPerformed(ActionEvent e) throws Exception {
        super.actionCalculator_actionPerformed(e);
    }

    public void actionExport_actionPerformed(ActionEvent e) throws Exception {
        super.actionExport_actionPerformed(e);
    }

    public void actionExportSelected_actionPerformed(ActionEvent e) throws Exception {
        super.actionExportSelected_actionPerformed(e);
    }

    public void actionRegProduct_actionPerformed(ActionEvent e) throws Exception {
        super.actionRegProduct_actionPerformed(e);
    }

    public void actionPersonalSite_actionPerformed(ActionEvent e) throws Exception {
        super.actionPersonalSite_actionPerformed(e);
    }

    protected class ActionQuery
    extends ItemAction {
        public void actionPerformed(ActionEvent e) {
            ExportMenuSqlUI.this.quickQuery();
        }
    }
}

