/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.uiframe.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.swing.KDLabel;
import com.kingdee.eas.base.permission.MainMenuItemInfo;
import com.kingdee.eas.util.client.ExceptionHandler;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.ImageIcon;

public abstract class FolderMenuLabel
extends KDLabel {
    private MainMenuItemInfo info = null;
    private ImageIcon icon = null;
    private Point textPX = new Point(50, 20);
    private Point iconPX = new Point(30, 7);
    private boolean _isHover = false;

    public FolderMenuLabel(MainMenuItemInfo info, ImageIcon icon) {
        this(info, icon, 31);
    }

    public FolderMenuLabel(MainMenuItemInfo info, ImageIcon icon, int labelHeight) {
        this.info = info;
        this.icon = icon;
        this.addMouseListener(new FolderMenuMouseAdapter());
        this.setPreferredSize(new Dimension(this.getWidth(), labelHeight));
        this.setUserObject(info);
    }

    protected void setTextDrawPoint(Point textPX) {
        if (textPX != null) {
            this.textPX = textPX;
        }
    }

    protected void setIconDrawPoint(Point iconPX) {
        if (iconPX != null) {
            this.iconPX = iconPX;
        }
    }

    protected void setHover(boolean isHover) {
        this._isHover = isHover;
    }

    protected void paintComponent(Graphics g) {
        int width = this.getWidth();
        int height = this.getHeight();
        Graphics2D g2d = (Graphics2D)g;
        if (this._isHover) {
            g2d.setColor(new Color(144, 182, 231));
            g2d.fillRect(0, 0, width, height);
        }
        Font font = new Font(null, 0, 12);
        g2d.setFont(font);
        g2d.setColor(Color.BLACK);
        g2d.drawString(this.info.getName(), this.textPX.x, this.textPX.y);
        if (this.icon != null) {
            g2d.drawImage(this.icon.getImage(), this.iconPX.x, this.iconPX.y, this.icon.getIconWidth(), this.icon.getIconHeight(), null);
        }
        super.paintComponent(g);
    }

    public abstract void folderMenuLabelClicked(MouseEvent var1) throws BOSException;

    private class FolderMenuMouseAdapter
    extends MouseAdapter {
        private FolderMenuMouseAdapter() {
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            try {
                FolderMenuLabel.this.folderMenuLabelClicked(e);
            }
            catch (BOSException e1) {
                ExceptionHandler.handle((Throwable)e1);
            }
        }

        @Override
        public void mouseEntered(MouseEvent e) {
            FolderMenuLabel.this._isHover = true;
            FolderMenuLabel.this.revalidate();
            FolderMenuLabel.this.repaint();
        }

        @Override
        public void mouseExited(MouseEvent e) {
            FolderMenuLabel.this._isHover = false;
            FolderMenuLabel.this.revalidate();
            FolderMenuLabel.this.repaint();
        }
    }
}

