/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.uiframe.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.swing.KDList;
import com.kingdee.bos.ctrl.swing.KDPanel;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.permission.MainMenuItemInfo;
import com.kingdee.eas.base.uiframe.BizTypeEnum;
import com.kingdee.eas.base.uiframe.IndustryEnum;
import com.kingdee.eas.base.uiframe.client.MainMenuConstants;
import com.kingdee.eas.base.uiframe.client.MainMenuList;
import com.kingdee.eas.base.uiframe.client.MainMenuListCellRenderer;
import com.kingdee.eas.base.uiframe.client.NewMainFunctionMenuUI;
import com.kingdee.eas.base.uiframe.client.NewMenuVisitorHelper;
import com.kingdee.eas.base.uiframe.client.SubMenuPanel;
import com.kingdee.eas.base.uiframe.client.util.ImageIconUtil;
import com.kingdee.eas.util.client.EASResource;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.ListCellRenderer;
import javax.swing.event.ListSelectionEvent;
import org.apache.log4j.Logger;

public abstract class GroupPanel
extends KDPanel {
    private static final Logger logger = Logger.getLogger(GroupPanel.class);
    private MainMenuList northList;
    private SubMenuPanel centerSubMenuPanel;
    private MainMenuList southList;
    private MainMenuItemInfo myCommonFunc = this.createMyCommonFunc();
    private MainMenuItemInfo preSelectedMenuInfo = null;
    private MainMenuItemInfo currentSelectedInfo = null;
    private List<MainMenuItemInfo> topMenuColls = new ArrayList<MainMenuItemInfo>();
    private NewMainFunctionMenuUI mainUI = null;
    private int prePaneHeight = 0;
    private boolean isAllCollapse = false;

    public GroupPanel(NewMainFunctionMenuUI mainUI) throws BOSException {
        this.setCustomInsets(new Insets(1, 0, 0, 0));
        this.mainUI = mainUI;
        this.topMenuColls.addAll(NewMenuVisitorHelper.buildSubNodesByParentId("topMenu"));
        this.topMenuColls.add(0, this.myCommonFunc);
        this.setBackground(MainMenuConstants.BACKGROUND_COLOR);
        this.initComponents(this.topMenuColls);
        this.initLayout();
        this.addComponentListener(new PanelAdapter());
    }

    private MainMenuItemInfo createMyCommonFunc() {
        MainMenuItemInfo menuInfo = new MainMenuItemInfo();
        menuInfo.setId(BOSUuid.read((String)"lODiaMIzSUGnCej39gl6WRdCz6U="));
        menuInfo.setName(EASResource.getString((String)"com.kingdee.eas.base.uiframe.client.WorkBenchResource", (String)"favorites"));
        menuInfo.setNumber("00000000");
        menuInfo.setLongNumber("00000000");
        menuInfo.setIsLeaf(true);
        menuInfo.setLevel(1);
        menuInfo.setOrder("255");
        menuInfo.setImagePath("imgMenumodule_icon_knowledge");
        menuInfo.setVisible(true);
        menuInfo.setEnabled(true);
        menuInfo.setMenutype(BizTypeEnum.guimenu);
        menuInfo.setIndustry(IndustryEnum.standard);
        return menuInfo;
    }

    private void initLayout() {
        this.setLayout(new BorderLayout());
        this.setBorder(BorderFactory.createEmptyBorder());
        this.add((Component)((Object)this.northList), "North");
        this.add((Component)((Object)this.centerSubMenuPanel), "Center");
        this.add((Component)((Object)this.southList), "South");
    }

    private void initComponents(List<MainMenuItemInfo> topMenuCols) {
        this.northList = new MainMenuList(){

            @Override
            protected void listSelectionChanged(ListSelectionEvent e) throws BOSException {
                GroupPanel.this.topMenuSelectionChanged(e);
            }
        };
        this.northList.addMouseMotionListener();
        this.northList.addMouseListener();
        this.northList.setCellRenderer((ListCellRenderer)((Object)new MainMenuListCellRenderer()));
        this.southList = new MainMenuList(){

            @Override
            protected void listSelectionChanged(ListSelectionEvent e) throws BOSException {
                GroupPanel.this.topMenuSelectionChanged(e);
            }
        };
        this.southList.addMouseMotionListener();
        this.southList.addMouseListener();
        this.southList.setCellRenderer((ListCellRenderer)((Object)new MainMenuListCellRenderer()));
        this.centerSubMenuPanel = new SubMenuPanel(){

            @Override
            protected void level2MenuSelectionChanged(ListSelectionEvent e) throws BOSException {
                GroupPanel.this.level2SelectionChanged(e);
            }
        };
        this.buildListByTopMenuColls(topMenuCols);
    }

    private void buildListByTopMenuColls(List<MainMenuItemInfo> topMenuCols) {
        if (topMenuCols == null || topMenuCols.size() == 0) {
            return;
        }
        this.clearList(this.northList);
        int j = topMenuCols.size();
        for (int i = 0; i < j; ++i) {
            MainMenuItemInfo info = topMenuCols.get(i);
            this.northList.addElement(info);
            info.put("IMAGEICON", (Object)ImageIconUtil.getTopMenuIconByImagePath(info.getImagePath()));
        }
        this.northList.addListSelectionListener();
        this.northList.setSelectedIndex(0);
    }

    protected void topMenuSelectionChanged(ListSelectionEvent e) throws BOSException {
        KDList list = (KDList)e.getSource();
        int index = list.getSelectedIndex();
        if (index < 0 || list.getElementCount() <= index) {
            return;
        }
        this.currentSelectedInfo = (MainMenuItemInfo)list.getElement(index);
        if (this.currentSelectedInfo == this.myCommonFunc) {
            this.showWorkBenchPanel();
            this.setDisplayMark(this.currentSelectedInfo);
            this.clearList(this.northList);
            this.clearList(this.southList);
            int j = this.topMenuColls.size();
            for (int i = 0; i < j; ++i) {
                MainMenuItemInfo info = this.topMenuColls.get(i);
                this.northList.addElement(info);
                info.put("IMAGEICON", (Object)ImageIconUtil.getTopMenuIconByImagePath(info.getImagePath()));
            }
            this.centerSubMenuPanel.setVisible(false);
            this.northList.addListSelectionListener();
            this.southList.addListSelectionListener();
            return;
        }
        if (this.currentSelectedInfo == this.preSelectedMenuInfo) {
            this.preSelectedMenuInfo.setBoolean("ISSELECTED", false);
            this.preSelectedMenuInfo.setBoolean("ISHOVER", false);
            this.buildListByTopMenuColls(this.topMenuColls);
            this.centerSubMenuPanel.setVisible(false);
            this.isAllCollapse = false;
            return;
        }
        this.showMainMenuPanel();
        if (this.isAllCollapse) {
            this.setDisplayMark(this.currentSelectedInfo);
            this.buildListByTopMenuColls(this.topMenuColls);
            this.centerSubMenuPanel.setVisible(false);
            this.isAllCollapse = false;
            return;
        }
        this.centerSubMenuPanel.setVisible(true);
        List<MainMenuItemInfo> level2MenuColls = NewMenuVisitorHelper.buildSubNodesByParentId(this.currentSelectedInfo.getId().toString());
        boolean needAllExpand = this.isNeedAllCollapse(this.topMenuColls.size(), level2MenuColls.size());
        this.setDisplayMark(this.currentSelectedInfo);
        this.clearList(this.northList);
        this.clearList(this.southList);
        if (needAllExpand) {
            this.isAllCollapse = true;
            this.northList.addElement(this.currentSelectedInfo);
            this.currentSelectedInfo.put("IMAGEICON", (Object)ImageIconUtil.getTopMenuIconByImagePath(this.currentSelectedInfo.getImagePath()));
            boolean needAddArrow = this.isNeedAllCollapse(1, level2MenuColls.size());
            if (needAddArrow) {
                this.centerSubMenuPanel.displayArrow();
            }
        } else {
            this.centerSubMenuPanel.hideArrow();
            this.rebuildList();
        }
        this.centerSubMenuPanel.replaceAllElements(level2MenuColls);
        if (level2MenuColls == null || level2MenuColls.isEmpty()) {
            this.mainUI.cleanLeve3AndLeve4List();
        }
        this.northList.addListSelectionListener();
        this.southList.addListSelectionListener();
    }

    private void rebuildList() {
        boolean hasInitSubPanel = false;
        if (this.currentSelectedInfo == this.myCommonFunc) {
            this.northList.addElement(this.myCommonFunc);
            this.myCommonFunc.put("IMAGEICON", (Object)ImageIconUtil.getTopMenuIconByImagePath(this.myCommonFunc.getImagePath()));
            hasInitSubPanel = true;
        } else {
            int j = this.topMenuColls.size();
            for (int i = 0; i < j; ++i) {
                MainMenuItemInfo info = this.topMenuColls.get(i);
                if (hasInitSubPanel) {
                    this.southList.addElement(info);
                    info.put("IMAGEICON", (Object)ImageIconUtil.getTopMenuIconByImagePath(info.getImagePath()));
                    continue;
                }
                if (info.equals((Object)this.currentSelectedInfo)) {
                    this.northList.addElement(info);
                    info.put("IMAGEICON", (Object)ImageIconUtil.getTopMenuIconByImagePath(info.getImagePath()));
                    hasInitSubPanel = true;
                    continue;
                }
                this.northList.addElement(info);
                info.put("IMAGEICON", (Object)ImageIconUtil.getTopMenuIconByImagePath(info.getImagePath()));
            }
        }
    }

    private void showMainMenuPanel() {
        this.mainUI.splitPanel.setDividerLocation(250);
        this.mainUI.splitPanel.remove((Component)((Object)this.mainUI.workBenchPanel));
        this.mainUI.splitPanel.add((Component)((Object)this.mainUI.subSplitPanel), (Object)"right");
    }

    private void showWorkBenchPanel() {
        this.mainUI.splitPanel.setDividerLocation(250);
        this.mainUI.splitPanel.remove((Component)((Object)this.mainUI.subSplitPanel));
        this.mainUI.splitPanel.add((Component)((Object)this.mainUI.workBenchPanel), (Object)"right");
        this.mainUI.workBenchPanel.refreshFunction();
    }

    private void setDisplayMark(MainMenuItemInfo currentSelectedInfo) {
        if (this.preSelectedMenuInfo != null) {
            this.preSelectedMenuInfo.setBoolean("ISSELECTED", false);
        }
        currentSelectedInfo.setBoolean("ISSELECTED", true);
        currentSelectedInfo.setBoolean("ISHOVER", false);
        this.preSelectedMenuInfo = currentSelectedInfo;
    }

    private void clearList(MainMenuList list) {
        list.removeListSelectionListener();
        list.removeAllElements();
        list.clearAdapterLocalVar();
    }

    private boolean isNeedAllCollapse(int topMenuSize, int level2Size) {
        int topPane = this.getHeight();
        if (topPane == 0) {
            return false;
        }
        return topPane < (topMenuSize + 1) * 31 + level2Size * 27;
    }

    public abstract void level2SelectionChanged(ListSelectionEvent var1) throws BOSException;

    protected void paintComponent(Graphics g) {
        super.paintComponent(g);
        Graphics2D g2d = (Graphics2D)g;
        int northHeight = this.northList.getHeight();
        int southHeight = this.southList.getHeight();
        int subPaneHeight = this.centerSubMenuPanel.getHeight();
        int parentHeight = this.getHeight();
        g2d.setColor(Color.LIGHT_GRAY);
        g2d.drawLine(0, 0, this.getWidth(), 0);
        if (northHeight + southHeight + subPaneHeight < parentHeight - 1) {
            g2d.drawLine(0, northHeight + southHeight + subPaneHeight, 0, parentHeight);
            g2d.drawLine(this.getWidth() - 1, northHeight + southHeight + subPaneHeight, this.getWidth() - 1, parentHeight);
            g2d.drawLine(0, parentHeight - 1, this.getWidth() - 1, parentHeight - 1);
        } else if (!this.centerSubMenuPanel.isVisible()) {
            g2d.drawLine(0, northHeight + southHeight, 0, parentHeight);
            g2d.drawLine(this.getWidth() - 1, northHeight + southHeight, this.getWidth() - 1, parentHeight);
            g2d.drawLine(0, parentHeight - 1, this.getWidth() - 1, parentHeight - 1);
        }
    }

    public KDList getNorthList() {
        return this.northList;
    }

    private class PanelAdapter
    extends ComponentAdapter {
        private PanelAdapter() {
        }

        @Override
        public void componentResized(ComponentEvent e) {
            int currentPaneHeight = e.getComponent().getHeight();
            if (GroupPanel.this.prePaneHeight < currentPaneHeight) {
                ((GroupPanel)GroupPanel.this).mainUI.splitPanel.setDividerLocation(250);
            }
            GroupPanel.this.prePaneHeight = currentPaneHeight;
        }
    }
}

