/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.uiframe.client;

import com.kingdee.bos.ctrl.swing.KDLabel;
import com.kingdee.bos.ctrl.swing.KDPanel;
import com.kingdee.bos.framework.cache.UIActionMonitor;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.eas.base.myeas.ComMenuFunctionCollection;
import com.kingdee.eas.base.myeas.ComMenuFunctionFactory;
import com.kingdee.eas.base.myeas.IComMenuFunction;
import com.kingdee.eas.base.permission.MainMenuItemInfo;
import com.kingdee.eas.base.uiframe.IMainFunctionMenu;
import com.kingdee.eas.base.uiframe.MainFunctionMenuFactory;
import com.kingdee.eas.base.uiframe.client.LeafMenuLabelContainer;
import com.kingdee.eas.base.uiframe.client.MainMenuConstants;
import com.kingdee.eas.base.uiframe.client.NewMainFunctionMenuUI;
import com.kingdee.eas.base.uiframe.client.NewMenuVisitorHelper;
import com.kingdee.eas.base.uiframe.client.SystemEntry;
import com.kingdee.eas.base.uiframe.client.UIShowHelper;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.framework.client.CoreUI;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.ExceptionHandler;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.StringUtils;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager2;
import java.awt.Point;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.io.Serializable;
import java.util.Collection;
import javax.swing.JComponent;
import org.apache.log4j.Logger;

public class LeafMenuCellPane
extends KDPanel {
    private static final Logger logger = Logger.getLogger(LeafMenuCellPane.class);
    private LeafMenuLabelContainer bottomLeafContainer = null;
    private KDLabel topLabel = null;
    private MainMenuItemInfo info = null;
    private NewMainFunctionMenuUI mainUI = null;

    private void setStatusMessage(String text) {
        IUIObject o = SystemEntry.instance.getMainUIObject().getSelectedUIObject();
        if (o instanceof CoreUI) {
            CoreUI ui = (CoreUI)o;
            ui.setMessageText(text);
            ui.showMessage();
        }
    }

    public LeafMenuCellPane(NewMainFunctionMenuUI mainUI, MainMenuItemInfo info) {
        this.info = info;
        this.mainUI = mainUI;
        this.bottomLeafContainer = new LeafMenuLabelContainer(this.isComFunction(info.getId().toString()), info.getName(), mainUI.level4BgColor);
        this.topLabel = new KDLabel();
        this.topLabel.setAutoToolTipText(false);
        this.setLayout(new LeafMenuCellPaneLayout());
        this.setBackground(MainMenuConstants.BACKGROUND_COLOR);
        TopLabelMouseAdapter adapter = new TopLabelMouseAdapter();
        this.topLabel.addMouseListener((MouseListener)adapter);
        this.topLabel.addMouseMotionListener((MouseMotionListener)adapter);
        this.add((Component)this.topLabel);
        this.add((Component)((Object)this.bottomLeafContainer));
    }

    private boolean isComFunction(String menuId) {
        Collection<ComMenuFunctionCollection> collection = NewMenuVisitorHelper.getComMenuCache().values();
        if (collection == null) {
            return false;
        }
        String id = null;
        for (ComMenuFunctionCollection colls : collection) {
            for (int i = 0; i < colls.size(); ++i) {
                id = colls.get(i).getMenuFunction().getId().toString();
                if (!StringUtils.equals((String)id, (String)menuId)) continue;
                return true;
            }
        }
        return false;
    }

    private void removeComMenu() {
        try {
            String userId = SysContext.getSysContext().getCurrentUserInfo().getId().toString();
            StringBuffer oql = new StringBuffer("where user.id = '").append(userId).append("' and menuFunction.id = '").append(this.info.getId().toString()).append("'");
            IComMenuFunction iComMenuFunction = ComMenuFunctionFactory.getRemoteInstance();
            iComMenuFunction.delete(oql.toString());
            NewMenuVisitorHelper.clearComMenuCache();
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            ExceptionHandler.handle((Throwable)e);
        }
    }

    private void addComMenu() {
        try {
            IMainFunctionMenu ifunction = MainFunctionMenuFactory.getRemoteInstance();
            ifunction.saveMenuToComFunction(this.info);
            NewMenuVisitorHelper.clearComMenuCache();
        }
        catch (Exception e1) {
            logger.error((Object)e1.getMessage(), (Throwable)e1);
            ExceptionHandler.handle((Throwable)e1);
        }
    }

    private void performDblclick() {
        this.setCursor(new Cursor(3));
        long start = System.currentTimeMillis();
        UIActionMonitor.startAction((String)"", (String)"");
        UIShowHelper.showUI((Component)((Object)this), this.info);
        UIActionMonitor.endAction((String)this.info.getUiClassName(), (String)"clickMenuItem", (long)(System.currentTimeMillis() - start));
        this.setCursor(new Cursor(0));
    }

    public Insets getInsets() {
        return new Insets(0, 0, 0, 0);
    }

    protected LeafMenuLabelContainer getLeafMenuLabelContainer() {
        return this.bottomLeafContainer;
    }

    private class LeafMenuCellPaneLayout
    implements LayoutManager2,
    Serializable {
        private LeafMenuCellPaneLayout() {
        }

        @Override
        public Dimension maximumLayoutSize(Container target) {
            return this.preferredLayoutSize(target);
        }

        @Override
        public void addLayoutComponent(String name, Component comp) {
        }

        @Override
        public void layoutContainer(Container parent) {
            Insets insets = parent.getInsets();
            int componentCount = parent.getComponentCount();
            if (componentCount == 0) {
                return;
            }
            int componentWidth = parent.getWidth() - insets.left - insets.right;
            int height = 0;
            for (int i = 0; i < componentCount; ++i) {
                JComponent childComponent = (JComponent)parent.getComponent(i);
                childComponent.setBounds(insets.left, insets.top, componentWidth, height + 31);
            }
        }

        @Override
        public Dimension minimumLayoutSize(Container parent) {
            return this.preferredLayoutSize(parent);
        }

        @Override
        public Dimension preferredLayoutSize(Container parent) {
            Container ancestor = parent.getParent();
            int width = ancestor.getWidth() - ancestor.getInsets().left - ancestor.getInsets().right;
            int height = 31;
            return new Dimension(width, height);
        }

        @Override
        public void removeLayoutComponent(Component comp) {
        }

        @Override
        public void addLayoutComponent(Component comp, Object constraints) {
        }

        @Override
        public float getLayoutAlignmentX(Container target) {
            return 0.0f;
        }

        @Override
        public float getLayoutAlignmentY(Container target) {
            return 0.0f;
        }

        @Override
        public void invalidateLayout(Container target) {
        }
    }

    class TopLabelMouseAdapter
    extends MouseAdapter
    implements MouseMotionListener {
        TopLabelMouseAdapter() {
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            Point p = e.getPoint();
            LeafMenuLabelContainer labelContainer = LeafMenuCellPane.this.getLeafMenuLabelContainer();
            int labelWidth = labelContainer.getBoundLabel().getWidth();
            int buttonWidth = labelContainer.getBoundButton().getWidth();
            if (labelWidth - 10 <= p.x && labelWidth + buttonWidth + 10 >= p.x) {
                if (!labelContainer.isComFunction()) {
                    String uiClassName = LeafMenuCellPane.this.info.getUiClassName();
                    if (StringUtils.isEmpty((String)uiClassName)) {
                        return;
                    }
                    LeafMenuCellPane.this.setCursor(new Cursor(3));
                    LeafMenuCellPane.this.addComMenu();
                    ((LeafMenuCellPane)LeafMenuCellPane.this).mainUI.workBenchPanel.setAddComFunction(true);
                    labelContainer.setComFunction(true);
                    labelContainer.setButtonIcon(MainMenuConstants.BLUE_STAR_IMAGE);
                    labelContainer.revalidate();
                    labelContainer.repaint();
                    LeafMenuCellPane.this.setCursor(new Cursor(0));
                    LeafMenuCellPane.this.setStatusMessage(EASResource.getString((String)"com.kingdee.eas.base.uiframe.UIFRAMEAutoGenerateResource", (String)"71_LeafMenuCellPane"));
                } else {
                    String uiClassName = LeafMenuCellPane.this.info.getUiClassName();
                    if (StringUtils.isEmpty((String)uiClassName)) {
                        MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.base.uiframe.UIFRAMEAutoGenerateResource", (String)"72_LeafMenuCellPane"));
                        return;
                    }
                    LeafMenuCellPane.this.setCursor(new Cursor(3));
                    LeafMenuCellPane.this.removeComMenu();
                    ((LeafMenuCellPane)LeafMenuCellPane.this).mainUI.workBenchPanel.setAddComFunction(true);
                    labelContainer.setComFunction(false);
                    labelContainer.setButtonIcon(MainMenuConstants.GRAY_STAR_IMAGE);
                    labelContainer.revalidate();
                    labelContainer.repaint();
                    LeafMenuCellPane.this.setCursor(new Cursor(0));
                    LeafMenuCellPane.this.setStatusMessage(EASResource.getString((String)"com.kingdee.eas.base.uiframe.UIFRAMEAutoGenerateResource", (String)"73_LeafMenuCellPane"));
                }
            } else if (e.getButton() == 1 && e.getClickCount() == 2 && !StringUtils.isEmpty((String)LeafMenuCellPane.this.info.getUiClassName()) && LeafMenuCellPane.this.info.isIsLeaf()) {
                LeafMenuCellPane.this.performDblclick();
            }
        }

        @Override
        public void mouseEntered(MouseEvent e) {
            KDPanel parent = (KDPanel)LeafMenuCellPane.this.getParent();
            LeafMenuLabelContainer preSelectedMenu = (LeafMenuLabelContainer)((Object)parent.getUserObject());
            if (preSelectedMenu != null) {
                preSelectedMenu.setHover(false);
                if (!preSelectedMenu.isComFunction()) {
                    preSelectedMenu.getBoundButton().setVisible(false);
                    preSelectedMenu.setButtonVisible(false);
                }
                preSelectedMenu.revalidate();
                preSelectedMenu.repaint();
                parent.setUserObject(null);
            }
            LeafMenuCellPane.this.bottomLeafContainer.getBoundButton().setVisible(true);
            LeafMenuCellPane.this.bottomLeafContainer.setButtonVisible(true);
            LeafMenuCellPane.this.bottomLeafContainer.setHover(true);
            LeafMenuCellPane.this.bottomLeafContainer.revalidate();
            LeafMenuCellPane.this.bottomLeafContainer.repaint();
        }

        @Override
        public void mouseExited(MouseEvent e) {
            if (!LeafMenuCellPane.this.bottomLeafContainer.isComFunction()) {
                LeafMenuCellPane.this.bottomLeafContainer.getBoundButton().setVisible(false);
                LeafMenuCellPane.this.bottomLeafContainer.setButtonVisible(false);
            }
            LeafMenuCellPane.this.bottomLeafContainer.setHover(false);
            LeafMenuCellPane.this.bottomLeafContainer.revalidate();
            LeafMenuCellPane.this.bottomLeafContainer.repaint();
        }

        @Override
        public void mouseMoved(MouseEvent e) {
            Point p = e.getPoint();
            LeafMenuLabelContainer container = LeafMenuCellPane.this.getLeafMenuLabelContainer();
            int labelWidth = container.getBoundLabel().getWidth();
            int buttonWidth = container.getBoundButton().getWidth();
            if (labelWidth - 10 <= p.x && labelWidth + buttonWidth + 10 >= p.x) {
                LeafMenuCellPane.this.setCursor(new Cursor(12));
                if (container.isComFunction()) {
                    LeafMenuCellPane.this.topLabel.setToolTipText(EASResource.getString((String)"com.kingdee.eas.base.uiframe.UIFRAMEAutoGenerateResource", (String)"74_LeafMenuCellPane"));
                } else {
                    LeafMenuCellPane.this.topLabel.setToolTipText(EASResource.getString((String)"com.kingdee.eas.base.uiframe.UIFRAMEAutoGenerateResource", (String)"75_LeafMenuCellPane"));
                }
                LeafMenuCellPane.this.topLabel.setAutoToolTipText(true);
            } else {
                LeafMenuCellPane.this.setCursor(new Cursor(0));
                LeafMenuCellPane.this.topLabel.setAutoToolTipText(false);
                LeafMenuCellPane.this.topLabel.setToolTipText(null);
            }
        }

        @Override
        public void mouseDragged(MouseEvent e) {
        }
    }
}

