/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.uiframe.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.BOSLocaleUtil;
import com.kingdee.bos.BOSObjectFactory;
import com.kingdee.bos.Context;
import com.kingdee.bos.ContextUtils;
import com.kingdee.bos.ORMRPCServiceLocator;
import com.kingdee.bos.apploader.appshell.IAppAdapter;
import com.kingdee.bos.ctrl.extendcontrols.KDBizMultiLangBox;
import com.kingdee.bos.ctrl.swing.KDFrame;
import com.kingdee.bos.ctrl.swing.KDMultiLangBox;
import com.kingdee.bos.ctrl.swing.plaf.KingdeeLookAndFeel;
import com.kingdee.bos.ctrl.swing.plaf.MultiLangIcon;
import com.kingdee.bos.ctrl.swing.util.CtrlSwingUtilities;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.framework.cache.CacheServiceFactory;
import com.kingdee.bos.framework.cache.CacheStat;
import com.kingdee.bos.framework.cache.config.CacheConfigManager;
import com.kingdee.bos.framework.cache.config.ICacheConfig;
import com.kingdee.bos.framework.session.BOSLoginException;
import com.kingdee.bos.framework.session.ILoginModule;
import com.kingdee.bos.framework.session.LoginContext;
import com.kingdee.bos.framework.session.LoginModuleFactory;
import com.kingdee.bos.framework.session.LoginType;
import com.kingdee.bos.metadata.MetaDataLoaderFactory;
import com.kingdee.bos.metadata.ResourceListenerManager;
import com.kingdee.bos.metadata.access.management.SimpleLanguageCollection;
import com.kingdee.bos.metadata.access.management.SimpleSolution;
import com.kingdee.bos.metadata.configure.ConfigMDUtil;
import com.kingdee.bos.rpc.loadbalance.distributer.LoginModuleUtil;
import com.kingdee.bos.rpcwrapper.RPCEngineFactory;
import com.kingdee.bos.sql.DbType;
import com.kingdee.bos.ui.face.IUIFactory;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIException;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.bos.ui.util.IUIActionPostman;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.apploader.framework.WebUIContainer;
import com.kingdee.eas.base.common.DCInfo;
import com.kingdee.eas.base.common.IDCRegister;
import com.kingdee.eas.base.license.CloudRegistSrvAgentFactory;
import com.kingdee.eas.base.license.ErpUserStatusEnum;
import com.kingdee.eas.base.license.ICloudRegistSrv;
import com.kingdee.eas.base.license.LicenseException;
import com.kingdee.eas.base.license.client.LicenseSrvAgentFactory;
import com.kingdee.eas.base.myeas.util.ClientPersonalSetUtil;
import com.kingdee.eas.base.param.util.ParamManager;
import com.kingdee.eas.base.permission.Administrator;
import com.kingdee.eas.base.permission.BasePMException;
import com.kingdee.eas.base.permission.ErpUserStatus;
import com.kingdee.eas.base.permission.LoginAuthorWayEnum;
import com.kingdee.eas.base.permission.PermissionCommonUtil;
import com.kingdee.eas.base.permission.SecurityInfo;
import com.kingdee.eas.base.permission.UserFacadeFactory;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.base.uiframe.EASLoginException;
import com.kingdee.eas.base.uiframe.IMainFrameServiceFacade;
import com.kingdee.eas.base.uiframe.MainFrameServiceFacadeFactory;
import com.kingdee.eas.base.uiframe.client.ChangePasswordUI;
import com.kingdee.eas.base.uiframe.client.ClientLoginContextInterceptor;
import com.kingdee.eas.base.uiframe.client.ILoginInitStrategy;
import com.kingdee.eas.base.uiframe.client.LoginFrame;
import com.kingdee.eas.base.uiframe.client.LoginInitBaseStrategy;
import com.kingdee.eas.base.uiframe.client.LoginParamCacheUtil;
import com.kingdee.eas.base.uiframe.client.MainFrameCallBack;
import com.kingdee.eas.base.uiframe.client.NewMainFrame;
import com.kingdee.eas.base.uiframe.client.SystemEntry;
import com.kingdee.eas.base.uiframe.client.UIConfig;
import com.kingdee.eas.base.uiframe.utils.SecurityValidator;
import com.kingdee.eas.base.uiframe.utils.UIFrameUtils;
import com.kingdee.eas.base.usermonitor.IUserMonitor;
import com.kingdee.eas.base.usermonitor.UserMonitorFactory;
import com.kingdee.eas.common.cache.CacheConfigImpl;
import com.kingdee.eas.common.client.ILoginListener;
import com.kingdee.eas.common.client.ILogoutListener;
import com.kingdee.eas.common.client.LocaleUtil;
import com.kingdee.eas.common.client.LoginEvent;
import com.kingdee.eas.common.client.LogoutEvent;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.framework.batchHandler.RequestContext;
import com.kingdee.eas.framework.batchHandler.client.UIActionPostman;
import com.kingdee.eas.util.AbortException;
import com.kingdee.eas.util.CryptException;
import com.kingdee.eas.util.CryptoTean;
import com.kingdee.eas.util.ExceptionUtil;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.ExceptionHandler;
import com.kingdee.util.IPUtils;
import com.kingdee.util.LocaleUtils;
import com.kingdee.util.StringUtils;
import java.awt.Component;
import java.io.File;
import java.io.Serializable;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.Socket;
import java.net.URI;
import java.net.URL;
import java.text.DateFormat;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import javax.swing.Icon;
import javax.swing.LookAndFeel;
import javax.swing.UIManager;
import org.apache.log4j.Logger;
import org.apache.log4j.PropertyConfigurator;

public class LoginHelper {
    public static final String USER_AUTH_PATTERN = "UserAuthPattern";
    public static final String DB_TYPE_CODE = "dbTypeCode";
    protected static final Logger logger = Logger.getLogger(LoginHelper.class);
    public static final int DB_SQLSERVER = 0;
    public static final int DB_DB2 = 1;
    public static final int DB_ORACLE = 2;
    public static final int DB_POSTGRESQL = 3;
    private static boolean isNewLoginFlow = false;
    private static Thread metaLoadThread = null;
    private static Thread LoadAuthenticatingThread = null;
    public static final String Load_Authenticating_Thread = "LoadAuthenticatingThread";
    public static final String LOGIN_CONTECT = "logincontext";
    static Context userLoginCtx;
    public static IAppAdapter app;
    private static boolean isReturnFromPortal;
    private static String portalRelogin;
    public static final String ALGORITHM = "DES";
    public static Locale lastloginlocale;
    private static ILoginModule loginModule;
    private static ArrayList dataCenterList;
    private static boolean inited;
    private static final String METADATACONFIG = "metadata.path";
    private static final String DCCLASSNAME = "com.kingdee.eas.base.common.DCRegister";

    public static ILoginModule getLoginModule() throws BOSException {
        long start = System.currentTimeMillis();
        ILoginModule loginModule = LoginModuleFactory.getRemoteInstance();
        if (UIFrameUtils.isLogged()) {
            logger.info((Object)UIFrameUtils.getLogText("getLoginModule :" + (System.currentTimeMillis() - start) + " ms"));
        }
        return loginModule;
    }

    public static void login(String userName, String password, String slnName, String dcName, Locale locale) throws BasePMException, EASLoginException {
        LoginHelper.login(userName, password, slnName, dcName, locale, 0);
    }

    public static void logout(String sessionID) throws EASLoginException {
        if (StringUtils.isEmpty((String)sessionID)) {
            logger.error((Object)"SessionId is Null when call logout!");
            return;
        }
        try {
            logger.info((Object)"Begin logout listener");
            LoginHelper.fireLogoutListener();
            logger.info((Object)"finish logout listener");
            IUserMonitor iUserMonitor = UserMonitorFactory.getRemoteInstance();
            iUserMonitor.deleteSessionAndUserMonitorInfo(sessionID, null);
            LoginHelper.clearSession();
            logger.info((Object)"Finish logout!");
        }
        catch (Exception e) {
            throw new EASLoginException(EASLoginException.LOGOUT_FAIL, e);
        }
    }

    public static void logout() throws EASLoginException {
        String sessionID = SysContext.getSysContext().getSessionID();
        LoginHelper.logout(sessionID);
        SysContext.getSysContext().setSessionID(null);
    }

    public static void login(String userName, String password, String slnName, String dcName, Locale locale, int dbType, String authPattern) throws BasePMException, EASLoginException {
        String sessionId = LoginHelper.loginExcludeInit(userName, password, slnName, dcName, locale, dbType, authPattern);
        LoginHelper.checkChangePassword(LoginFrame.getLoginFrame());
        LoginHelper.initAfterLogin();
        CacheStat.getInstance().setEnable(true);
    }

    public static void login(String userName, String password, String slnName, String dcName, Locale locale, int dbType) throws BasePMException, EASLoginException {
        LoginHelper.login(userName, password, slnName, dcName, locale, dbType, null);
    }

    public static String loginExcludeInit(String userName, String password, String slnName, String dcName, Locale locale, int dbType) throws BasePMException, EASLoginException {
        return LoginHelper.loginExcludeInit(userName, password, slnName, dcName, locale, dbType, "");
    }

    public static void clearSession() {
        String url = System.getProperty("EAS_SERVER");
        if (url == null) {
            url = UIConfig.getUrl();
        }
        BOSObjectFactory.clearSession((String)url);
    }

    private static LoginContext createLoginContext(String userName, String password, String slnName, String dcName, Locale locale, int dbType, String authPattern) throws EASLoginException, BasePMException {
        String orgId;
        InetAddress localhost = null;
        String clientIP = null;
        String clientName = null;
        long start = System.currentTimeMillis();
        try {
            localhost = LoginHelper.getLocalInetAddress();
            String string = clientIP = localhost == null ? clientIP : localhost.getHostAddress();
            if (localhost == null) {
                localhost = IPUtils.getFirstLocleAddress((boolean)false);
                clientIP = localhost.getHostAddress();
                if (localhost.isLoopbackAddress()) {
                    clientIP = InetAddress.getLocalHost().getHostAddress();
                    clientName = InetAddress.getLocalHost().getHostName();
                }
            }
            logger.info((Object)("clientIP = " + clientIP));
            logger.info((Object)("is IPV6 = " + (localhost instanceof Inet6Address)));
            logger.info((Object)(EASResource.getString((String)"com.kingdee.eas.base.uiframe.UIFRAMEAutoGenerateResource", (String)"9_SystemHelper") + clientIP));
            logger.info((Object)(EASResource.getString((String)"com.kingdee.eas.base.uiframe.UIFRAMEAutoGenerateResource", (String)"10_SystemHelper") + (localhost instanceof Inet6Address)));
            if (LoginHelper.isGetGostName().equalsIgnoreCase("false")) {
                clientName = clientIP;
                logger.warn((Object)"now don't get host name.....");
            }
            logger.info((Object)("......IPUtils getHostName spent: " + (System.currentTimeMillis() - start) + " ms."));
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            throw new EASLoginException(EASLoginException.LOCAL_IP_FAILURE, e);
        }
        if (slnName == null) {
            slnName = "eas";
        }
        String[] sln_org = slnName.split(";");
        slnName = sln_org[0];
        logger.info((Object)("SolutionName : " + slnName));
        String encodePwd = LoginHelper.encodePassword(userName, password);
        LoginContext ctx = new LoginContext(userName, encodePwd, slnName, dcName, locale, clientIP, clientName, null, null);
        if (sln_org.length > 1 && BOSUuid.isValid((String)(orgId = sln_org[1]), (boolean)true)) {
            ctx.put("defOrgID", (Object)orgId);
        }
        ctx.put("dbType", (Object)LoginHelper.getDbType(dbType));
        String sessionId = "";
        if (authPattern != null && !authPattern.equals("")) {
            String[] authPatternStr = authPattern.split(";");
            ctx.put(USER_AUTH_PATTERN, (Object)authPatternStr[0]);
            if (authPatternStr.length > 1) {
                sessionId = authPatternStr[1];
            }
        }
        logger.debug((Object)("this is context id:" + sessionId + ",auth:" + authPattern));
        ctx.put(DB_TYPE_CODE, (Object)new Integer(dbType));
        ctx.put("Password", (Object)encodePwd);
        if (!StringUtils.isEmpty((String)sessionId)) {
            ctx.setContextID(sessionId);
        }
        return ctx;
    }

    protected static InetAddress getLocalInetAddress() {
        try {
            String urlStr = System.getProperty("EAS_SERVER");
            if (urlStr == null || urlStr.isEmpty()) {
                urlStr = UIConfig.getUrl();
            }
            URI uri = new URI(urlStr);
            String host = uri.getHost();
            int port = uri.getPort();
            Socket socket = new Socket(host, port);
            InetAddress localAddress = socket.getLocalAddress();
            socket.close();
            return localAddress;
        }
        catch (Exception e) {
            logger.warn((Object)"Failed to connect the to server to get local address: ", (Throwable)e);
            return null;
        }
    }

    public static String loginExcludeInit(String userName, String password, String slnName, String dcName, Locale locale, int dbType, String authPattern) throws BasePMException, EASLoginException {
        long start = System.currentTimeMillis();
        LoginContext loginCtx = LoginHelper.createLoginContext(userName, password, slnName, dcName, locale, dbType, authPattern);
        loginCtx.setLoginType(LoginType.GUI);
        long showCost = System.currentTimeMillis() - start;
        if (UIFrameUtils.isLogged()) {
            logger.info((Object)UIFrameUtils.getLogText("LoginHelper.loginExcludeInit" + UIFrameUtils.getRes("res_47") + ">createLoginContext(),spent:" + showCost + " ms."));
        }
        UIFrameUtils.marked();
        LoginHelper.createSysContext(loginCtx);
        LoginHelper.beforeAuthenticating(loginCtx);
        if (LoginHelper.getLoadStyle() == 1) {
            LoginHelper.startAuthenticatingThread(loginCtx);
        }
        long start1 = System.currentTimeMillis();
        Context userCtx = LoginHelper.submitLogin(loginCtx);
        showCost = System.currentTimeMillis() - start1;
        logger.info((Object)UIFrameUtils.getLogText("LoginHelper.loginExcludeInit" + UIFrameUtils.getRes("res_47") + ">submitLogin(),spent:" + showCost + " ms."));
        LoginHelper.callLoginFrameHandler();
        start1 = System.currentTimeMillis();
        DateFormat format = BOSLocaleUtil.getDateFormat();
        Date now = new Date();
        UIConfig.setLastLoginDate(format.format(now));
        UIConfig.storeConfig();
        logger.info((Object)("LoginHelper UIConfig.storeConfig() spent : " + (System.currentTimeMillis() - start1) + " ms"));
        long startAfter = System.currentTimeMillis();
        LoginHelper.afterAuthenticated(userCtx);
        long costAfter = System.currentTimeMillis() - startAfter;
        logger.info((Object)(" *******invoke listener after login spent: " + costAfter + " ms."));
        long cost = System.currentTimeMillis() - start;
        logger.info((Object)(" loginExcludeInit spent: " + cost + " ms."));
        return userCtx.getContextID();
    }

    public static String loginExcludeInit(String userName, String password, String slnName, String dcName, Locale locale, int dbType, String authPattern, Map extendMap) throws BasePMException, EASLoginException {
        long start = System.currentTimeMillis();
        LoginContext loginCtx = LoginHelper.createLoginContext(userName, password, slnName, dcName, locale, dbType, authPattern);
        loginCtx.put("extendMap", (Object)extendMap);
        loginCtx.setLoginType(LoginType.GUI);
        long showCost = System.currentTimeMillis() - start;
        if (UIFrameUtils.isLogged()) {
            logger.info((Object)UIFrameUtils.getLogText("LoginHelper.loginExcludeInit" + UIFrameUtils.getRes("res_47") + ">createLoginContext(),spent:" + showCost + " ms."));
        }
        UIFrameUtils.marked();
        LoginHelper.createSysContext(loginCtx);
        LoginHelper.beforeAuthenticating(loginCtx);
        if (LoginHelper.getLoadStyle() == 1) {
            LoginHelper.startAuthenticatingThread(loginCtx);
        }
        long start1 = System.currentTimeMillis();
        Context userCtx = LoginHelper.submitLogin(loginCtx);
        showCost = System.currentTimeMillis() - start1;
        logger.info((Object)UIFrameUtils.getLogText("LoginHelper.loginExcludeInit" + UIFrameUtils.getRes("res_47") + ">submitLogin(),spent:" + showCost + " ms."));
        LoginHelper.callLoginFrameHandler();
        start1 = System.currentTimeMillis();
        DateFormat format = BOSLocaleUtil.getDateFormat();
        Date now = new Date();
        UIConfig.setLastLoginDate(format.format(now));
        UIConfig.storeConfig();
        logger.info((Object)("LoginHelper UIConfig.storeConfig() spent : " + (System.currentTimeMillis() - start1) + " ms"));
        long startAfter = System.currentTimeMillis();
        LoginHelper.afterAuthenticated(userCtx);
        long costAfter = System.currentTimeMillis() - startAfter;
        logger.info((Object)(" *******invoke listener after login spent: " + costAfter + " ms."));
        long cost = System.currentTimeMillis() - start;
        logger.info((Object)(" loginExcludeInit spent: " + cost + " ms."));
        return userCtx.getContextID();
    }

    private static void afterAuthenticated(Context userCtx) throws EASLoginException {
        LoginParamCacheUtil.clearParamCache();
        userLoginCtx = userCtx;
        LoginHelper.setUserInfo(userCtx);
        Locale locale = userCtx.getOriginLocale();
        LoginHelper.setLocaleToEnv(userCtx, locale);
        LoginHelper.createMultiLangBox(locale);
        LoginHelper.reset();
        LoginHelper.afterAuthenticated_ext(userCtx);
        MainFrameCallBack.firePropertyChange("AfterLogin", "old", "new");
    }

    private static void setUserInfo(Context userCtx) {
        boolean notRefesh;
        String remoteCache;
        UserInfo userInfo = (UserInfo)userCtx.get((Object)"UserInfo");
        SysContext sysContext = SysContext.getSysContext();
        sysContext.setCurrentUserInfo(userInfo);
        String sessionId = userCtx.getContextID();
        logger.info((Object)("This is  sessionId: " + sessionId + ""));
        sysContext.setSessionID(sessionId);
        String menuCache = UIConfig.getMenuCacheTime();
        if (!StringUtils.isEmpty((String)menuCache)) {
            if (UIFrameUtils.isLogged()) {
                logger.info((Object)UIFrameUtils.getLogText("LoginHelper.setUserInfo()  : menuCache = " + menuCache));
            }
        } else if (UIFrameUtils.isLogged()) {
            logger.info((Object)UIFrameUtils.getLogText("LoginHelper.setUserInfo()  : menuCache is null! "));
        }
        if (!StringUtils.isEmpty((String)(remoteCache = (String)userCtx.get((Object)"menuCache")))) {
            if (UIFrameUtils.isLogged()) {
                logger.info((Object)UIFrameUtils.getLogText("LoginHelper.setUserInfo()  : remoteCache = " + remoteCache));
            }
        } else if (UIFrameUtils.isLogged()) {
            logger.info((Object)UIFrameUtils.getLogText("LoginHelper.setUserInfo()  : remoteCache is null! "));
        }
        boolean bl = notRefesh = !StringUtils.isEmpty((String)menuCache) && menuCache.equals(remoteCache);
        if (UIFrameUtils.isLogged()) {
            logger.info((Object)UIFrameUtils.getLogText("LoginHelper.setUserInfo()  : notRefesh = " + notRefesh));
        }
        sysContext.setProperty((Object)"cacheMenu", (Object)(!notRefesh ? 1 : 0));
        if (!notRefesh && remoteCache != null) {
            sysContext.setProperty((Object)"cacheMenuTime", (Object)remoteCache);
        }
    }

    private static void afterAuthenticated_ext(Context userCtx) throws EASLoginException {
        if (isNewLoginFlow) {
            try {
                ClientLoginContextInterceptor.afterAuthenticated(userCtx);
            }
            catch (BOSLoginException e) {
                if (e.getCause() instanceof EASLoginException) {
                    throw (EASLoginException)((Object)e.getCause());
                }
                throw new EASLoginException(EASLoginException.EAS_LOGIN_FAIL);
            }
        } else {
            LoginHelper.callSysListener();
        }
        LoginHelper.checkChangePassword(SystemEntry.instance.getOwnerFrame());
    }

    private static void beforeAuthenticating(LoginContext loginCtx) throws EASLoginException {
        String loginFlow = System.getProperty("login.flow");
        isNewLoginFlow = "oncerpc".equalsIgnoreCase(loginFlow);
        loginCtx.put("SwitchToNewLoginFlow", (Object)Boolean.toString(isNewLoginFlow));
        loginCtx.put("ClientIP", (Object)loginCtx.getClientHostIP());
        loginCtx.put("ClientName", (Object)loginCtx.getClientHostIP());
        LoginHelper.beforeAuthenticating_ext(loginCtx);
    }

    private static void beforeAuthenticating_ext(LoginContext ctx) throws EASLoginException {
        if (isNewLoginFlow) {
            try {
                ClientLoginContextInterceptor.beforeAuthenticating(ctx);
            }
            catch (BOSLoginException e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
            }
        }
    }

    private static SysContext createSysContext(LoginContext loginCtx) {
        SysContext sysContext = new SysContext(loginCtx.getUserName(), loginCtx.getSlnName(), loginCtx.getAis(), loginCtx.getOriginLocale());
        SysContext.setSysContext((SysContext)sysContext);
        sysContext.setDCNumber(loginCtx.getAis());
        sysContext.setDcAlias(LoginHelper.getDcAliasFromDcNumber(loginCtx.getAis()));
        sysContext.setProperty((Object)"Password", loginCtx.get("Password"));
        sysContext.setProperty((Object)"dbType", loginCtx.get(DB_TYPE_CODE));
        sysContext.setClientIP(loginCtx.getClientHostIP());
        sysContext.setClientName(loginCtx.getClientHostName());
        sysContext.setProperty((Object)LOGIN_CONTECT, (Object)loginCtx);
        return sysContext;
    }

    private static void reset() {
        long startAfter = System.currentTimeMillis();
        if (CacheConfigManager.getConfig() != null) {
            CacheServiceFactory.getInstance().discardAll();
        }
        inited = false;
        long cost = System.currentTimeMillis() - startAfter;
        logger.info((Object)("------reset\uff0cclean Cache spent: " + cost + " ms."));
    }

    private static void setLocaleToEnv(Context userCtx, Locale locale) {
        long start = System.currentTimeMillis();
        if (userCtx.get((Object)"locals") == null) {
            Locale.setDefault(LocaleUtil.getOriginalLocale((Locale)locale));
            return;
        }
        SimpleSolution solution = (SimpleSolution)userCtx.get((Object)"locals");
        LocaleUtil.setSystemSolutionInfo((SimpleSolution)solution);
        SimpleLanguageCollection lc = solution.getLanguages();
        for (int i = 0; i < lc.size(); ++i) {
            if (lc.get(i).getLocale().equals(locale)) {
                Locale.setDefault(lc.get(i).getOriginalLocale());
            }
            UIFrameUtils.marked();
        }
        ContextUtils.setLocaleToEnv((Locale)locale);
        LocaleUtils.setDefaultLocale((Locale)locale);
        long cost = System.currentTimeMillis() - start;
        logger.info((Object)("--after authenticated, set Locale spent: " + cost + " ms."));
    }

    private static void createMultiLangBox(Locale locale) {
        long start = System.currentTimeMillis();
        Map langs = UIConfig.getLanguages();
        Locale[] locs = new Locale[langs.size()];
        Locale[] stdLocs = new Locale[langs.size()];
        Icon[] icons = new Icon[langs.size()];
        String[] descriptions = new String[langs.size()];
        Iterator iter = langs.keySet().iterator();
        int i = 0;
        while (iter.hasNext()) {
            String key = iter.next().toString();
            String[] locales = key.split("#");
            locs[i] = new Locale(locales[0]);
            stdLocs[i] = LocaleUtil.getOriginalLocale((Locale)locs[i]);
            icons[i] = locales.length > 1 ? new MultiLangIcon(locales[1]) : new MultiLangIcon(locs[i]);
            descriptions[i] = langs.get(key).toString();
            ++i;
        }
        KDBizMultiLangBox.createLanguageList((Locale[])locs, (Icon[])icons, (String[])descriptions, (Locale[])stdLocs);
        KDBizMultiLangBox.setDefaultLocale((Locale)locale);
        long cost = System.currentTimeMillis() - start;
        logger.info((Object)("--after authenticated, createMultiLangBox spent: " + cost + " ms."));
    }

    public static Context submitLogin(LoginContext ctx) throws BasePMException, EASLoginException {
        long start = System.currentTimeMillis();
        String url = System.getProperty("EAS_SERVER");
        if (url == null) {
            url = UIConfig.getUrl();
        }
        Context userCtx = null;
        try {
            String queryUrl;
            start = System.currentTimeMillis();
            ORMRPCServiceLocator.setCurrentServiceURL((String)url);
            BOSObjectFactory.clearSession((String)url);
            Context context = new Context(null, ctx.getSlnName(), ctx.getAis(), ctx.getOriginLocale(), null);
            ConfigMDUtil.setContextToEnv((Context)context);
            userCtx = LoginHelper.innerFullLogin(ctx);
            ConfigMDUtil.setContextToEnv((Context)userCtx);
            if (UIFrameUtils.isLogged()) {
                logger.info((Object)UIFrameUtils.getLogText("LoginHelper.loginExcludeInit" + UIFrameUtils.getRes("res_47") + ">submitLogin(): after innerFullLogin(),spent:" + (System.currentTimeMillis() - start) + " ms."));
            }
            if (!StringUtils.isEmpty((String)(queryUrl = (String)userCtx.get((Object)"QueryServiceURL"))) && !queryUrl.equalsIgnoreCase(url)) {
                if (UIFrameUtils.isLogged()) {
                    logger.info((Object)UIFrameUtils.getLogText("LoginHelper.loginExcludeInit" + UIFrameUtils.getRes("res_47") + ">submitLogin():queryUrl= " + queryUrl));
                }
                BOSObjectFactory.clearSession((String)queryUrl);
                ILoginModule queryLoginModule = LoginModuleFactory.getRemoteInstance((String)queryUrl);
                ctx.put("SwitchToNewLoginFlow", (Object)Boolean.toString(false));
                LoginHelper.innerLogin(queryLoginModule, ctx);
            }
        }
        catch (BOSException e) {
            throw new EASLoginException(EASLoginException.GET_LOGINMODULE_FAIL, e);
        }
        return userCtx;
    }

    public static void setTimeZone(Context userCtx) {
        TimeZone zone = (TimeZone)userCtx.get((Object)"ServerTimeZone");
        if (zone == null) {
            try {
                long start = System.currentTimeMillis();
                IMainFrameServiceFacade iMainFrameServiceFacade = MainFrameServiceFacadeFactory.getRemoteInstance();
                zone = iMainFrameServiceFacade.getServerTimeZone();
                long cost = System.currentTimeMillis() - start;
                logger.info((Object)(" set TimeZone spent: " + cost + " ms."));
            }
            catch (Exception e) {
                logger.debug((Object)e.toString(), (Throwable)e);
            }
        }
        TimeZone.setDefault(zone);
    }

    public static void setTimeZoneAuth() {
        try {
            long start = System.currentTimeMillis();
            IMainFrameServiceFacade iMainFrameServiceFacade = MainFrameServiceFacadeFactory.getRemoteInstance();
            TimeZone zone = iMainFrameServiceFacade.getServerTimeZone();
            TimeZone.setDefault(zone);
            long cost = System.currentTimeMillis() - start;
            logger.info((Object)(" set TimeZone spent: " + cost + " ms."));
        }
        catch (Exception e) {
            logger.debug((Object)e.toString(), (Throwable)e);
        }
    }

    public static String checkChangePassword(Component component) throws EASLoginException {
        long start = System.currentTimeMillis();
        UserInfo currUser = SysContext.getSysContext().getCurrentUserInfo();
        String pass = null;
        boolean isRequireChangePassword = false;
        SecurityInfo securityInfo = currUser.getSecurity();
        if (!Administrator.isSuperAdmin((IObjectPK)new ObjectUuidPK(currUser.getId())) && securityInfo != null && !securityInfo.isExpiredPassCanChg() && PermissionCommonUtil.isPassExpired((UserInfo)currUser)) {
            throw new EASLoginException(EASLoginException.USER_PASSWORD_INVALID);
        }
        SysContext sysContext = SysContext.getSysContext();
        String oldPass = sysContext.getProperty((Object)"Password").toString();
        oldPass = LoginHelper.decodePassword(currUser.getNumber(), oldPass);
        boolean isRegister = false;
        String authPattern = null;
        try {
            isRequireChangePassword = LoginHelper.isRequireChangePassword(currUser, oldPass);
            authPattern = UserFacadeFactory.getRemoteInstance().getAuthPattern();
            isRegister = LicenseSrvAgentFactory.getRemoteInstance().isRegister();
        }
        catch (Exception e) {
            ExceptionHandler.handle((Throwable)e);
        }
        if (!"BaseDB".equals(authPattern)) {
            return null;
        }
        if (!LoginAuthorWayEnum.NORMAL.equals((Object)currUser.getLoginAuthorWay())) {
            return null;
        }
        if (isRegister && !currUser.isChangedPW() && !ErpUserStatus.SUCCESSED.equals((Object)currUser.getErpUserStatus())) {
            try {
                ICloudRegistSrv iCloudRegistSrv = CloudRegistSrvAgentFactory.getRemoteInstance();
                ErpUserStatusEnum status = iCloudRegistSrv.getErpUserIsActived(currUser.getNumber());
                if (status != null && !ErpUserStatusEnum.SUCCESSED.equals((Object)status)) {
                    return null;
                }
            }
            catch (LicenseException e) {
                e.printStackTrace();
            }
        }
        if (isRequireChangePassword) {
            try {
                IUIFactory uiFactory = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory");
                UIContext uiContext = null;
                if (component != null) {
                    uiContext = new UIContext((Object)component);
                }
                UserInfo userInfoCopy = (UserInfo)currUser.clone();
                userInfoCopy.setPassword(oldPass);
                String updatePwReason = SecurityValidator.getUpdatePwReason(userInfoCopy);
                if (uiContext != null) {
                    uiContext.put((Object)"info", (Object)updatePwReason);
                }
                IUIWindow window = uiFactory.create(ChangePasswordUI.class.getName(), (Map)uiContext, null);
                window.show();
                ChangePasswordUI ui = (ChangePasswordUI)window.getUIObject();
                if (ui.isCancel) {
                    throw new AbortException();
                }
                pass = new String(ui.newPassword.getPassword());
            }
            catch (UIException e) {
                ExceptionHandler.handle((Throwable)e);
            }
        } else {
            pass = sysContext.getProperty((Object)"Password").toString();
            pass = LoginHelper.decodePassword(currUser.getNumber(), pass);
        }
        long cost = System.currentTimeMillis() - start;
        logger.info((Object)("when first login,check password spent:" + cost + " ms."));
        return pass;
    }

    private static boolean isRequireChangePassword(UserInfo currUser, String oldPwd) {
        UserInfo userInfoCopy = (UserInfo)currUser.clone();
        userInfoCopy.setPassword(oldPwd);
        return SecurityValidator.isRequireChangePassword(userInfoCopy);
    }

    public static String innerLogin(ILoginModule loginModule, LoginContext ctx) throws BasePMException, EASLoginException {
        long start = System.currentTimeMillis();
        String sessionId = null;
        ctx.put("ContextID", (Object)SysContext.getSysContext().getSessionID());
        try {
            sessionId = loginModule.login(ctx);
            ctx.put("ContextID", (Object)sessionId);
        }
        catch (BOSLoginException ble) {
            BasePMException cause = LoginHelper.getBasePMException(ble);
            if (cause != null) {
                throw cause;
            }
            throw new EASLoginException(EASLoginException.EAS_LOGIN_FAIL, ble);
        }
        long cost = System.currentTimeMillis() - start;
        logger.info((Object)(" LoginModule login spent:" + cost + " ms."));
        return sessionId;
    }

    public static Context innerFullLogin(ILoginModule loginModule, LoginContext ctx) throws BasePMException, EASLoginException {
        long start = System.currentTimeMillis();
        Context userCtx = null;
        try {
            if (metaLoadThread != null && metaLoadThread.isAlive() && isNewLoginFlow) {
                try {
                    metaLoadThread.join();
                }
                catch (Exception e) {
                    logger.info((Object)e);
                }
            }
            SystemEntry.instance.setWinState(0);
            userCtx = loginModule.fullLogin(ctx);
        }
        catch (BOSLoginException ble) {
            BasePMException cause = LoginHelper.getBasePMException(ble);
            if (cause != null) {
                throw cause;
            }
            Throwable ex = null;
            for (ex = ble; ex != null && ex.getCause() != ex; ex = ex.getCause()) {
                if (!(ex instanceof EASLoginException)) continue;
                throw (EASLoginException)((Object)ex);
            }
            throw new EASLoginException(EASLoginException.EAS_LOGIN_FAIL, ble);
        }
        long cost = System.currentTimeMillis() - start;
        if (UIFrameUtils.isLogged()) {
            logger.info((Object)UIFrameUtils.getLogText("LoginHelper.loginExcludeInit" + UIFrameUtils.getRes("res_47") + ">submitLogin():innerFullLogin(), spent:" + cost + " ms."));
        }
        return userCtx;
    }

    public static Context innerFullLogin(LoginContext ctx) throws BasePMException, EASLoginException, BOSException {
        long start = System.currentTimeMillis();
        Context userCtx = null;
        try {
            if (metaLoadThread != null && metaLoadThread.isAlive() && isNewLoginFlow) {
                try {
                    metaLoadThread.join();
                }
                catch (Exception e) {
                    logger.info((Object)e);
                }
            }
            SystemEntry.instance.setWinState(0);
            userCtx = LoginModuleUtil.fullLogin((LoginContext)ctx);
            logger.debug((Object)(EASResource.getString((String)"com.kingdee.eas.base.uiframe.UIFRAMEAutoGenerateResource", (String)"63_LoginHelper") + ctx.getClientHostIP()));
        }
        catch (BOSLoginException ble) {
            BasePMException cause = LoginHelper.getBasePMException(ble);
            if (cause != null) {
                throw cause;
            }
            Throwable ex = null;
            for (ex = ble; ex != null && ex.getCause() != ex; ex = ex.getCause()) {
                if (!(ex instanceof EASLoginException)) continue;
                throw (EASLoginException)((Object)ex);
            }
            throw new EASLoginException(EASLoginException.EAS_LOGIN_FAIL, ble);
        }
        long cost = System.currentTimeMillis() - start;
        logger.info((Object)(" LoginModule full login for load balance spent:" + cost + " ms."));
        return userCtx;
    }

    public static boolean isInited() {
        return inited;
    }

    public static void callSysListener() throws EASLoginException {
        try {
            LoginHelper.fireSysLoginListener();
        }
        catch (Exception e1) {
            throw new EASLoginException(EASLoginException.INIT_SYS_FAIL, e1);
        }
    }

    public static void initAfterLogin() throws EASLoginException {
        if (!LoginHelper.isInited()) {
            LoginHelper.fireLoginListener();
            UserInfo currUser = SysContext.getSysContext().getCurrentUserInfo();
            if (currUser == null || currUser.getId() == null) {
                throw new EASLoginException(EASLoginException.UNKNOWN_USER);
            }
            inited = true;
        }
    }

    public static void initFakeAfterLogin() throws EASLoginException {
        if (!LoginHelper.isInited()) {
            LoginHelper.fireLoginListener();
        }
    }

    public static boolean isWeb() {
        boolean isWeb = false;
        if (System.getProperty("EAS_SERVER") != null && System.getProperty("EAS_SERVER").toString().trim().length() > 1) {
            isWeb = true;
        }
        return isWeb;
    }

    public static boolean isMutilThread() {
        if (UIFrameUtils.isLogged()) {
            logger.info((Object)UIFrameUtils.getLogText(" isMutilThread() begin "));
        }
        boolean isMutilThread = false;
        int loadMetaMode = 0;
        try {
            loadMetaMode = Integer.parseInt(System.getProperty("loadMetaMode"));
        }
        catch (Exception e) {
            UIFrameUtils.logError(logger, " isMutilThread()  has some error : ", e);
            logger.error((Object)e.getMessage(), (Throwable)e);
            loadMetaMode = 0;
        }
        if (loadMetaMode == 1) {
            isMutilThread = true;
        }
        if (UIFrameUtils.isLogged()) {
            logger.info((Object)UIFrameUtils.getLogText(" isMutilThread():  loadMetaMode = " + loadMetaMode));
        }
        return isMutilThread;
    }

    public static void startMetaLoadThread(int mode) {
        String localstr = ClientPersonalSetUtil.getloginlanguageInpro();
        if (!StringUtils.isEmpty((String)localstr)) {
            lastloginlocale = new Locale(localstr.toUpperCase());
        }
        Thread loadAllIconThread = new Thread(){

            @Override
            public void run() {
                try {
                    long start = System.currentTimeMillis();
                    ResourceBase.loadAllInco((int)3, (Locale)lastloginlocale);
                    logger.info((Object)UIFrameUtils.getLogText(" loadAllInco(MutilThread) spent: " + (System.currentTimeMillis() - start) + "ms!"));
                }
                catch (Exception e) {
                    logger.error((Object)e);
                }
            }
        };
        loadAllIconThread.start();
        long start = System.currentTimeMillis();
        if (UIFrameUtils.isLogged()) {
            logger.info((Object)UIFrameUtils.getLogText(" LoginHelper.startMetaLoadThread():pre load metadata spent: " + (System.currentTimeMillis() - start) + "ms!"));
        }
    }

    public static int getMetaLoadThreadMode() {
        int loadMetaMode = 0;
        try {
            loadMetaMode = Integer.parseInt(System.getProperty("loadMetaMode"));
        }
        catch (Exception e) {
            loadMetaMode = 0;
        }
        return loadMetaMode;
    }

    public static int getLoadStyle() {
        int LoadStyle = 0;
        try {
            LoadStyle = Integer.parseInt(System.getProperty("loadStyle"));
        }
        catch (Exception e) {
            LoadStyle = 0;
        }
        return LoadStyle;
    }

    public static boolean isXmlSerail() {
        boolean isXmlSerail = true;
        try {
            isXmlSerail = Boolean.valueOf(System.getProperty("isXmlSerail"));
        }
        catch (Exception e) {
            isXmlSerail = true;
        }
        return isXmlSerail;
    }

    public static int getLookAndFeelStyle() {
        int setLookFeelStyle = 0;
        try {
            setLookFeelStyle = Integer.parseInt(System.getProperty("setLookFeelStyle"));
        }
        catch (Exception e) {
            setLookFeelStyle = 0;
        }
        return setLookFeelStyle;
    }

    public static int getIconLoadStyle() {
        int iconLoadStyle = 0;
        try {
            iconLoadStyle = Integer.parseInt(System.getProperty("IconLoadStyle"));
        }
        catch (Exception e) {
            iconLoadStyle = 0;
        }
        return iconLoadStyle;
    }

    public static int isPortalStyle() {
        int isPortalStyle = 0;
        try {
            isPortalStyle = Integer.parseInt(System.getProperty("isPortalStyle"));
        }
        catch (Exception e) {
            isPortalStyle = 0;
        }
        return isPortalStyle;
    }

    public static void startAuthenticatingThread(LoginContext loginCtx) {
        String name = Load_Authenticating_Thread;
        LoadAuthenticatingThread = new Thread(name){

            @Override
            public void run() {
                try {
                    logger.info((Object)"Now start Authenticating Thread.......");
                    long preloadStart = System.currentTimeMillis();
                    if (LoginHelper.getLookAndFeelStyle() != 0) {
                        LoginHelper.setLookFeel();
                    }
                    SystemEntry.instance.startApplication(null);
                    logger.info((Object)("new mainframe spent: " + (System.currentTimeMillis() - preloadStart) + "ms!"));
                    logger.info((Object)"  Authenticating Thread has completed.......");
                }
                catch (Exception e) {
                    logger.error((Object)e.getMessage(), (Throwable)e);
                }
            }
        };
        LoadAuthenticatingThread.start();
    }

    public static void setLookFeel() throws Exception {
        long log4jStart = System.currentTimeMillis();
        KingdeeLookAndFeel lf = new KingdeeLookAndFeel();
        UIManager.setLookAndFeel((LookAndFeel)lf);
        CtrlSwingUtilities.resetAppDefaultFocusTraversalKeys();
        long look2feelCost = System.currentTimeMillis() - log4jStart;
        logger.info((Object)("@@@@@@set LookAndFeel of init system env var :" + look2feelCost + " ms."));
    }

    public static void initAfterLoginExt() {
        long preloadStart = System.currentTimeMillis();
        LoginHelper.setTimeZone(userLoginCtx);
        inited = false;
        if (LoginHelper.getIconLoadStyle() != 0) {
            LoginHelper.startInitConfig();
        }
        logger.info((Object)("initAfterLoginExt cost  " + (System.currentTimeMillis() - preloadStart) + "ms!"));
    }

    public static void startInitConfig() {
        try {
            if (CacheConfigManager.getConfig() == null) {
                long startCache = System.currentTimeMillis();
                CacheConfigManager.registerConfig((ICacheConfig)new CacheConfigImpl());
                long costCache = System.currentTimeMillis() - startCache;
                logger.debug((Object)(" register cache : " + costCache + " ms."));
            }
            Thread loadAllImgThread = new Thread(){

                @Override
                public void run() {
                    long start = System.currentTimeMillis();
                    CtrlSwingUtilities.loadAllImages();
                    long cost = System.currentTimeMillis() - start;
                    logger.info((Object)("loadAllImages (MutilThread) : " + cost + " ms"));
                }
            };
            loadAllImgThread.start();
        }
        catch (Exception e0) {
            logger.error((Object)e0);
        }
    }

    public static String encodePassword(String userName, String password) {
        String encodedPassword = "";
        try {
            encodedPassword = CryptoTean.encrypt((String)userName, (String)password);
        }
        catch (CryptException e) {
            logger.error((Object)ExceptionUtil.getExcLinkStackTrace((Throwable)e));
        }
        return encodedPassword;
    }

    public static String decodePassword(String userName, String encodedPassword) {
        String password = "";
        try {
            password = CryptoTean.decrypt((String)userName, (String)encodedPassword);
        }
        catch (CryptException e) {
            logger.error((Object)ExceptionUtil.getExcLinkStackTrace((Throwable)e));
        }
        return password;
    }

    public static void login() throws BasePMException, EASLoginException {
        LoginHelper.login("test", "test", "eas", "ORAEASTEST", new Locale("L2"), 2);
    }

    public static Integer initSystemLogin(IAppAdapter app, Boolean isBootSystemStartUp) throws Exception {
        Integer reval = new Integer(0);
        if (UIFrameUtils.isLogged()) {
            logger.info((Object)UIFrameUtils.getLogText(" initSystemLogin begin: isBootSystemStartUp = " + isBootSystemStartUp));
        }
        if (null != ClientPersonalSetUtil.getloginlanguageInpro()) {
            logger.info((Object)("the locale set is " + ClientPersonalSetUtil.getloginlanguageInpro()));
            SysContext.setSysContext((SysContext)new SysContext("test", "eas", "eas", new Locale(ClientPersonalSetUtil.getloginlanguageInpro())));
        } else {
            SysContext.setSysContext((SysContext)new SysContext("test", "eas", "eas", new Locale("l2")));
        }
        ILoginInitStrategy loginInitStrategy = LoginInitBaseStrategy.getInstance();
        loginInitStrategy.init(null);
        if (UIFrameUtils.isLogged()) {
            logger.info((Object)UIFrameUtils.getLogText(" initSystemLogin end. "));
        }
        UIFrameUtils.marked();
        if (ResourceListenerManager.isMultiLanguages()) {
            KDMultiLangBox.multiLangBoxShouldSyncData((boolean)true);
        }
        try {
            if ("true".equals(ParamManager.getParamValue(null, null, (String)"IsUseSunInput"))) {
                KDFrame.openSunInputMethodComposer();
            } else {
                KDFrame.closeSunInputMethodComposer();
            }
        }
        catch (Exception e1) {
            logger.error((Object)"get Param", (Throwable)e1);
        }
        if (!isBootSystemStartUp.booleanValue()) {
            return reval;
        }
        DateFormat format = BOSLocaleUtil.getDateFormat();
        String strDate1 = UIConfig.getLastLoginDate();
        if (StringUtils.isEmpty((String)strDate1) || !isBootSystemStartUp.booleanValue()) {
            return reval;
        }
        try {
            Date date1 = format.parse(strDate1);
            Calendar calendar = Calendar.getInstance();
            calendar.add(5, -5);
            Date date_new = new Date(calendar.getTime().getTime());
            if (date_new.after(date1)) {
                if (UIFrameUtils.isLogged()) {
                    logger.info((Object)UIFrameUtils.getLogText(" LoginHelper:initSystemLogin()  LastLoginDate at least 5 days ago "));
                }
                calendar.add(5, -5);
                date_new = new Date(calendar.getTime().getTime());
                if (date_new.after(date1)) {
                    if (UIFrameUtils.isLogged()) {
                        logger.info((Object)UIFrameUtils.getLogText(" LoginHelper:initSystemLogin()  LastLoginDate at least 10 days ago "));
                        logger.info((Object)UIFrameUtils.getLogText(" LoginHelper:initSystemLogin()  delete StartUp item in reg! "));
                    }
                    reval = new Integer(-2);
                } else {
                    if (UIFrameUtils.isLogged()) {
                        logger.info((Object)UIFrameUtils.getLogText(" LoginHelper:initSystemLogin()  exist xiaozhushou now! "));
                    }
                    reval = new Integer(-1);
                }
            }
        }
        catch (ParseException err) {
            logger.error((Object)err.getMessage(), (Throwable)err);
            return reval;
        }
        if (UIFrameUtils.isLogged()) {
            logger.info((Object)UIFrameUtils.getLogText(" LoginHelper:initSystemLogin():reval =  " + reval.toString()));
        }
        return reval;
    }

    public static void virtualLogin(IAppAdapter app, Boolean flag) throws Exception {
        LoginHelper.app = app;
        if (!flag.booleanValue()) {
            return;
        }
        String url = UIConfig.getUrl();
        ArrayList dcList = null;
        IDCRegister dcRegister = (IDCRegister)RPCEngineFactory.getEngine((String)url).createObject(DCCLASSNAME, IDCRegister.class);
        dcList = dcRegister.getDCList();
        logger.info((Object)"get dclist from remote server.");
        if (dcList == null || dcList.size() == 0) {
            return;
        }
        DCInfo dc = new DCInfo();
        int dcIndex = UIConfig.getDcIndex();
        logger.info((Object)(" dcindex-------------------" + dcIndex));
        dc = (DCInfo)dcList.get(dcIndex);
        SystemEntry.instance.isVirtulLogin = true;
        SystemEntry.instance.login("virtualUser", "virtualUser", "eas", dc.getNumber(), new Locale("l2"), dc.getDBType(), null);
        SystemEntry.instance.setStartMode(0);
        LoginHelper.initAfterLogin();
        SystemEntry.isReLogin = false;
        NewMainFrame mainFrame = new NewMainFrame(null);
        mainFrame.virtulShow();
        mainFrame.setVisible(false);
        while (inited) {
            Thread.sleep(100L);
        }
        SystemEntry.instance.closeApplication();
    }

    private static void fireLoginListener() {
        long start = System.currentTimeMillis();
        Map sortedLoginListenerItemMap = UIConfig.getLoginListeners();
        if (sortedLoginListenerItemMap != null) {
            Iterator iterator = sortedLoginListenerItemMap.entrySet().iterator();
            boolean index = false;
            while (iterator.hasNext()) {
                String listenerName = (String)iterator.next().getValue();
                long start1 = System.currentTimeMillis();
                try {
                    Class<?> listenerClass = Class.forName(listenerName);
                    ILoginListener loginListener = (ILoginListener)listenerClass.newInstance();
                    if (loginListener != null) {
                        loginListener.logined(new LoginEvent());
                    }
                }
                catch (Exception exc) {
                    logger.error((Object)("Invoke user LoginListener " + listenerName + " fail!"));
                    logger.error((Object)ExceptionUtil.getExcLinkStackTrace((Throwable)exc));
                }
                long cost1 = System.currentTimeMillis() - start1;
                logger.info((Object)(" non system login listener[" + listenerName + "] spent: " + cost1 + " ms"));
            }
        }
        long cost = System.currentTimeMillis() - start;
        logger.info((Object)("all non system login listener spent: " + cost + " ms."));
    }

    private static void fireLogoutListener() {
        Map sortedLogoutListenerItemMap = UIConfig.getLogoutListeners();
        if (sortedLogoutListenerItemMap != null) {
            Iterator iterator = sortedLogoutListenerItemMap.entrySet().iterator();
            boolean index = false;
            while (iterator.hasNext()) {
                String listenerName = (String)iterator.next().getValue();
                try {
                    Class<?> listenerClass = Class.forName(listenerName);
                    ILogoutListener logoutListener = (ILogoutListener)listenerClass.newInstance();
                    if (logoutListener == null) continue;
                    logoutListener.logout(new LogoutEvent());
                }
                catch (Exception exc) {
                    logger.error((Object)("Invoke LogoutListener " + listenerName + " fail!"));
                    logger.error((Object)ExceptionUtil.getExcLinkStackTrace((Throwable)exc));
                }
            }
        }
    }

    private static void fireSysLoginListener() throws Exception {
        long start = System.currentTimeMillis();
        Map sortedLoginListenerItemMap = UIConfig.getSysLoginListeners();
        if (sortedLoginListenerItemMap != null) {
            Iterator iterator = sortedLoginListenerItemMap.entrySet().iterator();
            while (iterator.hasNext()) {
                String listenerName = (String)iterator.next().getValue();
                long startSys = System.currentTimeMillis();
                try {
                    Class<?> listenerClass = Class.forName(listenerName);
                    ILoginListener loginListener = (ILoginListener)listenerClass.newInstance();
                    if (loginListener != null) {
                        loginListener.logined(new LoginEvent());
                    }
                }
                catch (Exception e) {
                    logger.error((Object)("Invoke SysLoginListener " + listenerName + " fail!"));
                    logger.error((Object)ExceptionUtil.getExcLinkStackTrace((Throwable)e));
                    throw e;
                }
                long costSys = System.currentTimeMillis() - startSys;
                logger.info((Object)(" run system listener[" + listenerName + "] spent: " + costSys + " ms"));
            }
        }
        long cost = System.currentTimeMillis() - start;
        logger.info((Object)(" run all system login listener spent: " + cost + " ms"));
    }

    private static BasePMException getBasePMException(BOSLoginException be) {
        Throwable ex = null;
        for (ex = be; ex != null && ex.getCause() != ex; ex = ex.getCause()) {
            if (!(ex instanceof BasePMException)) continue;
            return (BasePMException)ex;
        }
        return null;
    }

    private static String getDbType(int dbType) {
        return DbType.getName((int)dbType);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Context guiReLogin(String contextId, String password) throws BasePMException, EASLoginException {
        Object obj = SysContext.getSysContext().getProperty((Object)LOGIN_CONTECT);
        logger.info((Object)"now portal notify gui to  relogin............");
        if (obj != null) {
            LoginContext oldCtx = (LoginContext)obj;
            logger.info((Object)("this is old pass:" + oldCtx.getUserPass()));
            String encodePwd = LoginHelper.encodePassword(oldCtx.getUserName(), password);
            oldCtx.setUserPass(encodePwd);
            oldCtx.put("Password", (Object)encodePwd);
            logger.info((Object)("this is new  pass:" + oldCtx.getUserPass()));
            logger.info((Object)("oldCtx is:" + oldCtx.getContextID() + " oldCtx is:" + oldCtx));
            oldCtx.setContextID(contextId);
            logger.info((Object)("oldCtx is:" + oldCtx.getContextID() + " oldCtx is:" + oldCtx));
            Context ctx = LoginHelper.submitLogin(oldCtx);
            SysContext.getSysContext().setSessionID(ctx.getContextID());
            String string = portalRelogin;
            synchronized (string) {
                isReturnFromPortal = true;
                logger.info((Object)"now notify the end relogin.......");
                portalRelogin.notify();
            }
            return ctx;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Context innerReLogin() throws BasePMException, EASLoginException {
        Object obj = SysContext.getSysContext().getProperty((Object)LOGIN_CONTECT);
        if (!SystemEntry.instance.isWebStart()) {
            if (obj != null) {
                LoginContext oldCtx = (LoginContext)obj;
                logger.info((Object)("oldCtx is:" + oldCtx.getContextID() + " oldCtx is:" + oldCtx));
                oldCtx.setContextID(SysContext.getSysContext().getSessionID());
                LoginHelper.beforeAuthenticating(oldCtx);
                logger.info((Object)("oldCtx is:" + oldCtx.getContextID() + " oldCtx is:" + oldCtx));
                Context ctx = LoginHelper.submitLogin(oldCtx);
                LoginHelper.afterAuthenticated(ctx);
                SysContext.getSysContext().setSessionID(ctx.getContextID());
                return ctx;
            }
            return null;
        }
        String url = System.getProperty("EAS_SERVER");
        if (url == null) {
            url = UIConfig.getUrl();
        }
        logger.info((Object)"##########now close old url");
        BOSObjectFactory.clearSession((String)url);
        if (obj != null) {
            LoginContext oldCtx = (LoginContext)obj;
            StringBuffer bf = new StringBuffer();
            bf.append(oldCtx.getUserName());
            bf.append(";");
            bf.append(oldCtx.getUserPass());
            bf.append(";");
            bf.append(oldCtx.getLocale());
            bf.append(";");
            bf.append(oldCtx.getSlnName());
            bf.append(";");
            bf.append(oldCtx.getAis());
            bf.append(";");
            bf.append(oldCtx.get(USER_AUTH_PATTERN));
            logger.info((Object)"this is portal relogin.......");
            try {
                WebUIContainer.getMsgHandler().sendMessage(13, (Object)bf.toString());
            }
            catch (Exception e) {
                logger.error((Object)("send messag 13 error:" + bf.toString() + "," + e.getMessage()), (Throwable)e);
            }
            logger.info((Object)"now has send portal relogin msg to ocx success.........");
            int tryCount = 3;
            int attemp = 1;
            String string = portalRelogin;
            synchronized (string) {
                while (!isReturnFromPortal) {
                    try {
                        if (attemp++ > tryCount) break;
                        portalRelogin.wait(200L);
                    }
                    catch (InterruptedException e) {
                        logger.error((Object)e.getMessage(), (Throwable)e);
                    }
                }
                logger.info((Object)"now end the wait from relogin.......");
                isReturnFromPortal = false;
            }
            Context ctx = LoginHelper.submitLogin(oldCtx);
            SysContext.getSysContext().setSessionID(ctx.getContextID());
            return ctx;
        }
        return null;
    }

    public static void relogin(boolean type) throws BasePMException, EASLoginException {
        Object obj = SysContext.getSysContext().getProperty((Object)LOGIN_CONTECT);
        if (type || obj == null) {
            String userName = SysContext.getSysContext().getUserName();
            String password = LoginHelper.decodePassword(userName, (String)SysContext.getSysContext().getProperty((Object)"Password"));
            String slnName = SysContext.getSysContext().getSlnName();
            String dcName = SysContext.getSysContext().getDcName();
            Locale locale = SysContext.getSysContext().getLocale();
            int dbType = (Integer)SysContext.getSysContext().getProperty((Object)"dbType");
            LoginHelper.login(userName, password, slnName, dcName, locale, dbType);
        } else {
            LoginHelper.submitLogin((LoginContext)obj);
        }
    }

    public static void relogin() throws BasePMException, EASLoginException {
        LoginHelper.relogin(true);
    }

    public static ArrayList getDCList() {
        IDCRegister dcRegister = (IDCRegister)RPCEngineFactory.getEngine((String)UIConfig.getUrl()).createObject(DCCLASSNAME, IDCRegister.class);
        try {
            dataCenterList = dcRegister.getDCList();
        }
        catch (Exception e) {
            logger.error((Object)"getDCList", (Throwable)e);
        }
        return dataCenterList;
    }

    public static String getDcAliasFromDcNumber(String dcNumber) {
        String dcAlias;
        block5: {
            dcAlias = "";
            try {
                ArrayList dcList;
                String local = SysContext.getSysContext().getLocale().toString().toUpperCase();
                if (dataCenterList == null || dataCenterList.size() == 0) {
                    LoginHelper.getDCList();
                }
                if ((dcList = dataCenterList) == null) break block5;
                for (int i = 0; i < dcList.size(); ++i) {
                    DCInfo dcInfo = (DCInfo)dcList.get(i);
                    if (!dcNumber.equals(dcInfo.getNumber())) continue;
                    dcAlias = dcInfo.getName(local);
                    break;
                }
            }
            catch (Exception e) {
                logger.error((Object)(UIFrameUtils.getRes("res_48") + e.getMessage()));
            }
        }
        if (StringUtils.isEmpty((String)dcAlias)) {
            dcAlias = dcNumber;
        }
        return dcAlias;
    }

    public static void initMetaDataLoader() {
        String metaDataPath = System.getProperty(METADATACONFIG);
        if (metaDataPath == null) {
            metaDataPath = UIConfig.getMetaDataDir();
        }
        if (metaDataPath == null) {
            logger.warn((Object)"Client metadatapath null!");
        } else {
            logger.debug((Object)("Client metadatapath : " + metaDataPath));
            MetaDataLoaderFactory.setClientMetaDataPath((String)metaDataPath);
        }
    }

    public static void initExceptionHandler() {
        String excHandlerKey = "sun.awt.exception.handler";
        String excHandlerValue = ExceptionHandler.class.getName();
        System.setProperty(excHandlerKey, excHandlerValue);
    }

    public static void initLog4jConfig() {
        String configItem = "log4j.configuration";
        String defaultValue = System.getProperty("easclient.root") + File.separator + "log4j.properties";
        if (System.getProperty(configItem) == null) {
            File log4jFile = new File(defaultValue);
            if (log4jFile.exists()) {
                logger.debug((Object)("Log4j path : " + defaultValue));
                PropertyConfigurator.configure((String)defaultValue);
            } else {
                URL url = LoginFrame.class.getClassLoader().getResource("log4j.properties");
                if (url != null) {
                    PropertyConfigurator.configure((URL)url);
                } else {
                    PropertyConfigurator.configure((String)defaultValue);
                }
            }
        }
    }

    public static void initTempUrl(String serverUrl) {
        String configItem = "appserver";
        if (System.getProperty(configItem) != null) {
            UIConfig.setTempUrl(System.getProperty(configItem));
        } else if (!StringUtils.isEmpty((String)serverUrl)) {
            UIConfig.setTempUrl(serverUrl);
        } else {
            logger.error((Object)"Don't set appserver url.");
        }
    }

    public static String isGetGostName() {
        String isGetGost = "true";
        try {
            isGetGost = System.getProperty("isGetGostName", "true");
        }
        catch (Exception e) {
            isGetGost = "true";
        }
        return isGetGost;
    }

    public static Thread getLoadAuthenticatingThread() {
        return LoadAuthenticatingThread;
    }

    public static void callLoginFrameHandler() {
        long start = System.currentTimeMillis();
        IUIActionPostman handler = UIActionPostman.getInstance(null);
        if (handler == null) {
            return;
        }
        RequestContext request = new RequestContext();
        request.setClassName("com.kingdee.eas.base.uiframe.app.LoginFrameHandler");
        request.setMethodName("handleLogin");
        if (LoginParamCacheUtil.getParams().get("NationalConfig") == null) {
            request.put("NoCacheData", (Object)Boolean.TRUE);
        }
        handler.setRequestContext((Serializable)request);
        try {
            handler.callHandler();
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        if (UIFrameUtils.isLogged()) {
            logger.info((Object)UIFrameUtils.getLogText("callLoginFrameHandler : " + (System.currentTimeMillis() - start) + " ms"));
        }
    }

    static {
        app = null;
        isReturnFromPortal = false;
        portalRelogin = "portalRelogin";
        lastloginlocale = new Locale("zh_CN");
        loginModule = null;
        dataCenterList = new ArrayList();
    }
}

