/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.uiframe.client;

import com.kingdee.bos.dao.ormapping.ObjectStringPK;
import com.kingdee.bos.metadata.configure.DownloadList;
import com.kingdee.eas.base.param.NantionalServiceFacadeFactory;
import com.kingdee.eas.base.param.util.ParamManager;
import com.kingdee.eas.base.permission.PermissionFactory;
import com.kingdee.eas.base.security.SecurityAuthParamManagerFactory;
import com.kingdee.eas.base.uiframe.ILoginParamCache;
import com.kingdee.eas.base.uiframe.LoginParamCacheFactory;
import com.kingdee.eas.base.uiframe.client.LoginHelper;
import com.kingdee.eas.base.uiframe.client.MenuVisitorHelper;
import com.kingdee.eas.base.usermonitor.NotAllowRepeatLoginUserFactory;
import com.kingdee.eas.basedata.org.OrgViewFactory;
import com.kingdee.util.StringUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.apache.log4j.Logger;

public class LoginParamCacheUtil {
    private static final Logger logger = Logger.getLogger(LoginParamCacheUtil.class);
    private static final String CACHE_FILE_NAME = "loginparamcache.dat";
    private static final String LAST_UPDATE_TIME_FILE_NAME = "loginParamLastUpdateTime.properties";
    private static HashMap params = new HashMap();

    public static HashMap getParams() {
        if (params.size() == 0) {
            params = LoginParamCacheUtil.getParamCache();
        }
        return params;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeParamCache() {
        FileOutputStream fo = null;
        ObjectOutputStream so = null;
        File cacheFile = null;
        String cacheDir = MenuVisitorHelper.getCacheDir();
        try {
            cacheFile = new File(cacheDir);
            if (!cacheFile.exists()) {
                cacheFile.mkdirs();
            }
            fo = new FileOutputStream(LoginParamCacheUtil.getFileName());
            so = new ObjectOutputStream(fo);
            so.writeObject(params);
        }
        catch (FileNotFoundException fe) {
            logger.info((Object)("write menu cache file not found:" + fe.getMessage()));
        }
        catch (Exception e) {
            logger.info((Object)("write menu cache file error:" + e.getMessage()));
        }
        finally {
            try {
                if (so != null) {
                    so.close();
                }
                if (fo != null) {
                    fo.close();
                }
            }
            catch (Exception fe) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static HashMap getParamCache() {
        File file;
        long start = System.currentTimeMillis();
        if (LoginParamCacheUtil.isNeedUpdateFromServer() && (file = new File(LoginParamCacheUtil.getFileName())).exists()) {
            file.delete();
        }
        FileInputStream fi = null;
        ObjectInputStream si = null;
        HashMap map = new HashMap();
        try {
            String fileName = LoginParamCacheUtil.getFileName();
            MenuVisitorHelper.mkDir(fileName);
            fi = new FileInputStream(LoginParamCacheUtil.getFileName());
            si = new ObjectInputStream(fi);
            map = (HashMap)si.readObject();
        }
        catch (FileNotFoundException fe) {
            logger.error((Object)("menu cache file not found:" + fe));
        }
        catch (Exception e) {
            logger.error((Object)("get menu cache file error:" + e));
        }
        finally {
            try {
                if (si != null) {
                    si.close();
                }
                if (fi != null) {
                    fi.close();
                }
            }
            catch (Exception fe) {}
        }
        logger.info((Object)("getParamCache cost:>>>>>>>>>>>" + (System.currentTimeMillis() - start)));
        return map;
    }

    private static boolean isNeedUpdateFromServer() {
        String propName;
        boolean flag = true;
        String fileName = LoginParamCacheUtil.getLoginParamLastUpdateTimeFileName();
        Properties props = new Properties();
        props = MenuVisitorHelper.loadPro(fileName);
        String cachtime = props.getProperty(propName = "loginParamLastUpdateTime") == null ? "" : props.getProperty(propName);
        long loginParamLastUpdateTime = System.currentTimeMillis();
        try {
            ILoginParamCache icache = LoginParamCacheFactory.getRemoteInstance();
            loginParamLastUpdateTime = icache.getLastUpdateTime();
        }
        catch (Exception e) {
            logger.error((Object)"", (Throwable)e);
        }
        if (StringUtils.isEmpty((String)cachtime) || Long.parseLong(cachtime) < loginParamLastUpdateTime) {
            props.setProperty(propName, String.valueOf(loginParamLastUpdateTime));
            MenuVisitorHelper.saveToPro(fileName, props);
        } else {
            flag = false;
        }
        return flag;
    }

    private static String getLoginParamLastUpdateTimeFileName() {
        return MenuVisitorHelper.getCacheDir() + LAST_UPDATE_TIME_FILE_NAME;
    }

    private static String getFileName() {
        return MenuVisitorHelper.getCacheDir() + CACHE_FILE_NAME;
    }

    public static HashMap getNationalConfig(String userId, String ouId, String languagename) {
        HashMap value = LoginParamCacheUtil.getNationalConfigFromCache(ouId);
        if (value != null) {
            return value;
        }
        return LoginParamCacheUtil.getNationalConfigFromServer(userId, ouId, languagename);
    }

    private static HashMap getNationalConfigFromCache(String ouId) {
        Object obj = LoginParamCacheUtil.getParams().get("NationalConfig");
        if (null == obj) {
            return null;
        }
        HashMap cache = (HashMap)obj;
        HashMap nationalConfig = (HashMap)cache.get(ouId);
        if (null == nationalConfig) {
            return null;
        }
        return nationalConfig;
    }

    private static HashMap getNationalConfigFromServer(String userId, String ouId, String languagename) {
        HashMap map = null;
        try {
            map = NantionalServiceFacadeFactory.getRemoteInstance().getNationalConfig(userId, ouId, languagename);
            LoginParamCacheUtil.cacheParam("NationalConfig", ouId, map);
        }
        catch (Exception e) {
            logger.error((Object)"", (Throwable)e);
        }
        return map;
    }

    public static Map getSSLConfig() {
        Object value = LoginParamCacheUtil.getParams().get("SSLConfig");
        if (value != null) {
            return (Map)value;
        }
        Map map = null;
        try {
            map = PermissionFactory.getRemoteInstance().getSSLConfiguration();
            LoginParamCacheUtil.cacheParam("SSLConfig", null, map);
        }
        catch (Exception e) {
            logger.error((Object)"", (Throwable)e);
        }
        return map;
    }

    public static ArrayList getDCList() {
        String key = "DCList";
        Object value = LoginParamCacheUtil.getParams().get(key);
        if (value != null) {
            return (ArrayList)value;
        }
        ArrayList dcList = null;
        try {
            dcList = LoginHelper.getDCList();
            LoginParamCacheUtil.cacheParam(key, null, dcList);
        }
        catch (Exception e) {
            logger.error((Object)"", (Throwable)e);
        }
        return dcList;
    }

    public static boolean isAllowRepeatLogin(String userID) {
        Object value = LoginParamCacheUtil.getParams().get("isAllowRepeatLogin");
        boolean isAllowRepeatLogin = true;
        if (value != null) {
            return Boolean.valueOf(StringUtils.cnulls(value));
        }
        try {
            isAllowRepeatLogin = NotAllowRepeatLoginUserFactory.getRemoteInstance().isAllowRepeatLogin(userID);
            LoginParamCacheUtil.cacheParam("isAllowRepeatLogin", null, isAllowRepeatLogin);
        }
        catch (Exception e) {
            logger.error((Object)"", (Throwable)e);
        }
        return isAllowRepeatLogin;
    }

    public static Object getParamValue(String paramNumber, String orgId, Object def) {
        Object value = LoginParamCacheUtil.getParams().get(paramNumber);
        if (orgId != null && value != null) {
            HashMap map = (HashMap)value;
            value = map.get(orgId);
        }
        if (value != null) {
            return value;
        }
        try {
            ObjectStringPK orgPK = null;
            if (!StringUtils.isEmpty((String)orgId)) {
                orgPK = new ObjectStringPK(orgId);
            }
            if ((value = ParamManager.getParamValue(null, orgPK, (String)paramNumber)) == null) {
                value = def;
            }
        }
        catch (Exception e) {
            logger.error((Object)"isusecus+++++++++++++++++++++++++++", (Throwable)e);
        }
        LoginParamCacheUtil.cacheParam(paramNumber, orgId, value);
        return value;
    }

    public static String getOrgClientExtImp() {
        Object value = LoginParamCacheUtil.getParams().get("OrgClientExtImp");
        String orgClientExtImp = "";
        if (value != null) {
            return StringUtils.cnulls(value);
        }
        try {
            orgClientExtImp = OrgViewFactory.getRemoteInstance().getOrgClientExtImp();
            LoginParamCacheUtil.cacheParam("OrgClientExtImp", null, orgClientExtImp);
        }
        catch (Exception e) {
            logger.error((Object)"", (Throwable)e);
        }
        return orgClientExtImp;
    }

    public static boolean isNeedUsbKeyPerm() {
        String paramName = "isNeedUsbKeyPerm";
        Object value = LoginParamCacheUtil.getParams().get(paramName);
        boolean isNeedUsbKeyPerm = false;
        if (value != null) {
            return Boolean.valueOf(StringUtils.cnulls(value));
        }
        try {
            isNeedUsbKeyPerm = SecurityAuthParamManagerFactory.getRemoteInstance().isEnableUsbkeyAuth();
            LoginParamCacheUtil.cacheParam(paramName, null, isNeedUsbKeyPerm);
        }
        catch (Exception e) {
            logger.error((Object)"", (Throwable)e);
        }
        return isNeedUsbKeyPerm;
    }

    public static String getUsbkeyImp() {
        String paramName = "UsbkeyImp";
        Object value = LoginParamCacheUtil.getParams().get(paramName);
        String usbkeyImp = "";
        if (value != null) {
            return StringUtils.cnulls(value);
        }
        try {
            usbkeyImp = SecurityAuthParamManagerFactory.getRemoteInstance().getUsbkeyConfigInfo().getUsbkeySupplierClass();
            if (usbkeyImp == null) {
                usbkeyImp = "";
            }
            LoginParamCacheUtil.cacheParam(paramName, null, usbkeyImp);
        }
        catch (Exception e) {
            logger.error((Object)"", (Throwable)e);
        }
        return usbkeyImp;
    }

    public static boolean isEnableWeb20() {
        String paramNumber = "EnableWeb20";
        Object value = LoginParamCacheUtil.getParams().get(paramNumber);
        boolean isEnableWeb20 = true;
        if (value != null) {
            return Boolean.parseBoolean(StringUtils.cnulls(value));
        }
        try {
            String paramValue = ParamManager.getParamValue(null, null, (String)paramNumber);
            isEnableWeb20 = !"false".equalsIgnoreCase(paramValue);
            LoginParamCacheUtil.cacheParam(paramNumber, null, String.valueOf(isEnableWeb20));
        }
        catch (Exception e) {
            logger.error((Object)"", (Throwable)e);
        }
        return isEnableWeb20;
    }

    public static DownloadList downloadConfigMetas() {
        String key = "downloadConfigMetas";
        Object value = LoginParamCacheUtil.getParams().get(key);
        if (value != null) {
            return (DownloadList)value;
        }
        return null;
    }

    public static void cacheParam(String paramNumber, String orgPK, Object value) {
        if (orgPK != null) {
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put(orgPK, value);
            params.put(paramNumber, map);
        } else {
            params.put(paramNumber, value);
        }
        LoginParamCacheUtil.writeParamCache();
    }

    public static void clearParamCache() {
        params.clear();
    }
}

