/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.uiframe.client;

import com.kingdee.bos.ctrl.swing.KDProgressBar;
import com.kingdee.eas.base.uiframe.client.LongTask;
import com.kingdee.eas.base.uiframe.client.MainStatusBar;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Timer;

class LongTaskMonitor {
    private LongTask task;
    private KDProgressBar progressBar;
    private MainStatusBar mainStatusBar;
    private Timer timer;

    public LongTaskMonitor(LongTask pTask) {
        if (pTask == null) {
            throw new IllegalArgumentException("Task is null!");
        }
        this.task = pTask;
        this.init();
    }

    private void init() {
        if (this.needTimer()) {
            this.timer = new Timer(this.task.getDelay(), new TimerListener());
        }
    }

    private void initStatusBar() {
        if (this.mainStatusBar != null) {
            this.mainStatusBar.setMessage("");
        }
        if (this.progressBar != null) {
            this.progressBar.setStringPainted(true);
            this.progressBar.setString("");
            this.progressBar.setMinimum(this.task.getMinimum());
            this.progressBar.setMaximum(this.task.getLengthOfTask());
        }
    }

    public void star() {
        if (this.mainStatusBar != null) {
            this.mainStatusBar.setMessage("");
        }
        if (this.progressBar != null) {
            this.progressBar.setString("");
            this.progressBar.setValue(this.progressBar.getMinimum());
        }
        this.task.go();
        this.timer.start();
    }

    private boolean needTimer() {
        return this.task.getTaskType() != 0;
    }

    void setMainStatusBar(MainStatusBar bar) {
        this.mainStatusBar = bar;
        if (this.mainStatusBar != null) {
            this.setProgressBar(this.mainStatusBar.getProgressBar());
        }
        this.initStatusBar();
    }

    private void setProgressBar(KDProgressBar bar) {
        this.progressBar = bar;
        this.initStatusBar();
    }

    class TimerListener
    implements ActionListener {
        TimerListener() {
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            switch (LongTaskMonitor.this.task.getTaskType()) {
                case 10: {
                    this.normalPerformed(evt);
                    break;
                }
                case 11: {
                    this.normalCancelPerformed(evt);
                    break;
                }
                case 20: {
                    this.modalPerformed(evt);
                    break;
                }
                case 21: {
                    this.modalCancelPerformed(evt);
                    break;
                }
            }
        }

        private void modalCancelPerformed(ActionEvent evt) {
            if (LongTaskMonitor.this.task.isCanceled() || LongTaskMonitor.this.task.isDone()) {
                LongTaskMonitor.this.timer.stop();
            }
        }

        private void normalCancelPerformed(ActionEvent evt) {
            if (LongTaskMonitor.this.task.isCanceled() || LongTaskMonitor.this.task.isDone()) {
                LongTaskMonitor.this.timer.stop();
            }
        }

        private void normalPerformed(ActionEvent evt) {
            LongTaskMonitor.this.progressBar.setValue(LongTaskMonitor.this.task.getCurrent());
            if (LongTaskMonitor.this.task.isIndeterminate()) {
                if (!LongTaskMonitor.this.progressBar.isIndeterminate()) {
                    LongTaskMonitor.this.progressBar.setIndeterminate(true);
                    LongTaskMonitor.this.progressBar.setString(null);
                }
            } else if (LongTaskMonitor.this.progressBar.isIndeterminate()) {
                LongTaskMonitor.this.progressBar.setIndeterminate(false);
            }
            if (LongTaskMonitor.this.task.getProgressMsg() != null) {
                LongTaskMonitor.this.progressBar.setStringPainted(true);
                LongTaskMonitor.this.progressBar.setString(LongTaskMonitor.this.task.getProgressMsg());
            }
            if (LongTaskMonitor.this.task.isCanceled() || LongTaskMonitor.this.task.isDone()) {
                LongTaskMonitor.this.timer.stop();
                if (LongTaskMonitor.this.mainStatusBar != null) {
                    LongTaskMonitor.this.mainStatusBar.setMessage(LongTaskMonitor.this.task.getMessage());
                }
            }
        }

        private void modalPerformed(ActionEvent evt) {
            if (LongTaskMonitor.this.task.isCanceled() || LongTaskMonitor.this.task.isDone()) {
                LongTaskMonitor.this.timer.stop();
            }
        }
    }
}

