/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.uiframe.client;

import com.kingdee.bos.ctrl.swing.KDFrame;
import com.kingdee.bos.ctrl.swing.KDMenuBar;
import com.kingdee.bos.ctrl.swing.KDMenuItem;
import com.kingdee.bos.ctrl.swing.KDStatusBar;
import com.kingdee.bos.ctrl.swing.KDToolBar;
import com.kingdee.bos.ctrl.swing.KDWorkButton;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.framework.cache.CacheStat;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.bos.ui.face.UIException;
import com.kingdee.bos.ui.util.ResourceBundleHelper;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.message.client.MessageCenterUI;
import com.kingdee.eas.base.message.client.TempMsgManager;
import com.kingdee.eas.base.myeas.DefaultOpenMenuCollection;
import com.kingdee.eas.base.myeas.DefaultOpenMenuInfo;
import com.kingdee.eas.base.myeas.ILastUsedFunction;
import com.kingdee.eas.base.myeas.LastUsedFunctionCollection;
import com.kingdee.eas.base.myeas.LastUsedFunctionFactory;
import com.kingdee.eas.base.permission.IMainMenuItem;
import com.kingdee.eas.base.permission.MainMenuItemCollection;
import com.kingdee.eas.base.permission.MainMenuItemFactory;
import com.kingdee.eas.base.permission.MainMenuItemInfo;
import com.kingdee.eas.base.ui.IMainUIContainer;
import com.kingdee.eas.base.uiframe.EASLoginException;
import com.kingdee.eas.base.uiframe.UIFrameResource;
import com.kingdee.eas.base.uiframe.client.AppletUtil;
import com.kingdee.eas.base.uiframe.client.BodyUI;
import com.kingdee.eas.base.uiframe.client.HelpUtils;
import com.kingdee.eas.base.uiframe.client.IUIManager;
import com.kingdee.eas.base.uiframe.client.LicenseHelper;
import com.kingdee.eas.base.uiframe.client.LoginFrame;
import com.kingdee.eas.base.uiframe.client.LoginHelper;
import com.kingdee.eas.base.uiframe.client.LoginSplash;
import com.kingdee.eas.base.uiframe.client.MainFrameCallBack;
import com.kingdee.eas.base.uiframe.client.MainMenuBar;
import com.kingdee.eas.base.uiframe.client.MainStatusBarManager;
import com.kingdee.eas.base.uiframe.client.MainToolBar;
import com.kingdee.eas.base.uiframe.client.MenuVisitorHelper;
import com.kingdee.eas.base.uiframe.client.UIFactoryHelper;
import com.kingdee.eas.base.uiframe.client.UIFrameClientUtil;
import com.kingdee.eas.base.uiframe.client.UIFrameContext;
import com.kingdee.eas.base.uiframe.client.UIObjectManager;
import com.kingdee.eas.base.uiframe.client.ui.IMainUIObject;
import com.kingdee.eas.base.uiframe.utils.UIFrameUtils;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.framework.client.CoreUI;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.ExceptionHandler;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Window;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.EventListener;
import java.util.HashSet;
import java.util.Iterator;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JToolBar;
import org.apache.log4j.Logger;

public class MainFrame
extends KDFrame
implements IMainUIObject {
    private static final long serialVersionUID = 4071374632600605752L;
    static Logger logger = Logger.getLogger(MainFrame.class);
    private boolean isFirst = true;
    private static boolean isReLogin = false;
    private static boolean closeConfirm = true;
    private LoginSplash loginSplash = new LoginSplash((Window)((Object)this));
    private static ArrayList sessionList = new ArrayList();
    private static MainFrame webMainFrame = null;
    static final int SYSTAB_COUNT = BodyUI.SYS_TAB_CLASSNAME_LIST.length;
    private ResourceBundleHelper resHelper;
    private IUIObject defaultUIObject = null;
    private MainMenuBar mainMenuBar = new MainMenuBar(null);
    private MainToolBar mainToolBar = new MainToolBar(null);
    JPanel pnlToolBar = new JPanel();
    BodyUI body = new BodyUI(this);
    UIObjectManager uiManager = new UIObjectManager(this.body);

    public static MainFrame getWebMainFrame() throws UIException {
        if (webMainFrame == null) {
            webMainFrame = new MainFrame();
        }
        return webMainFrame;
    }

    public LoginSplash getSplash() {
        return this.loginSplash;
    }

    public static boolean isOpenWebMainFrame() throws UIException {
        return webMainFrame != null;
    }

    public static void clearWebMainFrame() throws EASLoginException {
        isReLogin = true;
        if (webMainFrame != null) {
            closeConfirm = false;
            MainFrame.beforeLogout();
            MainFrame.closeApplication();
            webMainFrame.dispose();
            webMainFrame = null;
            MainStatusBarManager.clearStatus();
        } else {
            LoginHelper.logout();
        }
        isReLogin = false;
    }

    private static void beforeLogout() {
    }

    public static MainFrame getCurMainFrame(Component component) {
        Component child = component;
        for (Container parent = child.getParent(); parent != null; parent = parent.getParent()) {
            child = parent;
        }
        if (child instanceof MainFrame) {
            return (MainFrame)((Object)child);
        }
        throw new IllegalArgumentException("Component is not in mainframe");
    }

    static void closeApplication() {
        for (int i = sessionList.size() - 1; i >= 0; --i) {
            MainFrame mainFrame = (MainFrame)sessionList.get(i);
            mainFrame.closeMainFrame();
        }
    }

    static void closeApplicationWithoutConfirm() {
        MessageCenterUI.clearTime();
        for (int i = sessionList.size() - 1; i >= 0; --i) {
            MainFrame mainFrame = (MainFrame)sessionList.get(i);
            EventListener[] listeners = mainFrame.getListeners(WindowListener.class);
            if (listeners != null && listeners.length > 0) {
                for (int j = 0; j < listeners.length; ++j) {
                    mainFrame.removeWindowListener((WindowListener)listeners[j]);
                }
            }
            sessionList.remove(i);
            mainFrame.dispose();
        }
        webMainFrame = null;
    }

    public static void closeApplicationWhenSessionTimeOut() {
        if (!AppletUtil.isApplet) {
            System.exit(0);
        } else {
            MainFrame.closeApplicationWithoutConfirm();
        }
    }

    public static void reLogin() {
        boolean reLoginSuccess = true;
        MainFrame.beforeLogout();
        for (int i = sessionList.size() - 1; i >= 0; --i) {
            MainFrame mainFrame = (MainFrame)sessionList.get(i);
            if (mainFrame.uiManager.closeAllTab() && mainFrame.uiManager.closeAllWin()) {
                mainFrame.dispose();
                continue;
            }
            reLoginSuccess = false;
        }
        if (reLoginSuccess) {
            isReLogin = true;
            MainStatusBarManager.clearStatus();
        }
        MainFrameCallBack.rLoginPortal();
    }

    public MainFrame() throws UIException {
        this(null);
    }

    public MainFrame(IUIObject uiObject) throws UIException {
        try {
            LoginHelper.initAfterLogin();
        }
        catch (EASLoginException e) {
            ExceptionHandler.handle((Throwable)((Object)e));
        }
        this.defaultUIObject = uiObject;
        sessionList.add(this);
        this.jbInit();
        this.initBody();
        CacheStat.getInstance().setEnable(true);
        this.setSize(800, 600);
        this.setLocationRelativeTo(null);
    }

    @Override
    public void changeMenuToolBar(int index) {
        IUIObject curUiObject = (IUIObject)this.uiManager.tabUiObjects.get(index);
        this.addAppMenu(curUiObject);
        this.addAppToolBar(curUiObject);
        this.addAppStatusBar(curUiObject);
    }

    private void addAppMenu(IUIObject uiObject) {
        KDMenuBar menuBar = uiObject.getUIMenuBar();
        if (menuBar == null) {
            menuBar = new KDMenuBar();
        }
        ArrayList sysMenuBegin = this.mainMenuBar.getSysMenuBegin();
        for (int i = sysMenuBegin.size() - 1; i >= 0; --i) {
            menuBar.add((Component)((JMenu)sysMenuBegin.get(i)), 0);
        }
        ArrayList sysMenuEnd = this.mainMenuBar.getSysMenuEnd();
        Iterator iterator = sysMenuEnd.iterator();
        while (iterator.hasNext()) {
            menuBar.add((JMenu)iterator.next());
        }
        try {
            this.mainMenuBar.addShortCodeEntry((JPanel)uiObject, menuBar);
        }
        catch (Exception e) {
            this.handException(e);
        }
        try {
            if (uiObject instanceof CoreUI) {
                KDMenuItem miHelp = this.mainMenuBar.getMenuItem("CSHelp");
                this.initCSHelpListener(miHelp, (CoreUI)uiObject);
            }
        }
        catch (Exception e) {
            this.handException(e);
        }
        this.setJMenuBar((JMenuBar)menuBar);
    }

    private void addAppToolBar(IUIObject uiObject) {
        KDToolBar toolBar = uiObject.getUIToolBar();
        this.mainToolBar.removeSysButton(toolBar);
        if (toolBar == null) {
            toolBar = new KDToolBar();
        } else if (UIFactoryHelper.getVisibleComponentCount((JToolBar)toolBar) > 0) {
            toolBar.add((Component)this.mainToolBar.getEndSeparator());
        }
        if (toolBar.isFloatable()) {
            toolBar.setFloatable(false);
        }
        ArrayList sysToolBarBegin = this.mainToolBar.getSysToolBarBegin();
        for (int i = sysToolBarBegin.size() - 1; i >= 0; --i) {
            JComponent component = (JComponent)sysToolBarBegin.get(i);
            toolBar.add((Component)component, null, 1);
        }
        KDWorkButton btnClose = this.mainToolBar.getToolButton("close");
        KDWorkButton btnConfig = this.mainToolBar.getToolButton("config");
        if (this.body.isSysTab(uiObject)) {
            toolBar.add((Component)btnConfig);
            toolBar.add((Component)btnClose);
            btnClose.setEnabled(false);
        } else {
            ArrayList sysToolBarEnd = this.mainToolBar.getSysToolBarEnd();
            for (JComponent component : sysToolBarEnd) {
                toolBar.add((Component)component);
            }
            btnClose.setEnabled(true);
        }
        this.removeAllToolBar();
        KDToolBar[] mulToolBar = uiObject.getUIMultiToolBar();
        if (mulToolBar != null && mulToolBar.length > 0) {
            UIFrameClientUtil.setMultiToolBar(mulToolBar, toolBar, this);
        }
        if (toolBar.getParent() != null) {
            toolBar.getParent().validate();
        }
    }

    private void addAppStatusBar(IUIObject uiObject) {
        KDStatusBar oldStatusBar = this.getStatusBar();
        if (oldStatusBar != null) {
            this.removeStatusBar(oldStatusBar);
        }
        this.setStatusBar(uiObject.getStatusBar());
        if (this.getStatusBar() != null) {
            this.getStatusBar().revalidate();
            this.getStatusBar().repaint();
        }
    }

    void closeMainFrame() {
        if (closeConfirm) {
            this.body.join();
            if (MsgBox.showConfirm2((String)MainFrame.getString("MainMenuBar.confirmExit")) == 0 && this.uiManager.closeAllWin() && this.uiManager.closeAllTab()) {
                this.dispose();
            }
        } else if (this.uiManager.closeAllTab() && this.uiManager.closeAllWin()) {
            this.dispose();
        }
    }

    private static String getString(String strKey) {
        return UIFrameResource.getString(strKey);
    }

    @Override
    public void initBody() throws UIException {
        this.body.initSysTab((Frame)((Object)this));
        if (this.defaultUIObject != null) {
            this.uiManager.addTab(this.defaultUIObject);
        }
    }

    private MainMenuItemCollection getDefOpenMenu() {
        MainMenuItemCollection result = null;
        DefaultOpenMenuCollection openMenus = (DefaultOpenMenuCollection)UIFrameContext.getInstance().getProperty("DefOpenMenu");
        if (openMenus != null) {
            Iterator iter = openMenus.iterator();
            HashSet<String> set = new HashSet<String>();
            while (iter.hasNext()) {
                DefaultOpenMenuInfo info = (DefaultOpenMenuInfo)iter.next();
                MainMenuItemInfo menuItem = info.getMainMenu();
                if (menuItem == null || menuItem.getId() == null) continue;
                BOSUuid uuid = menuItem.getId();
                set.add(uuid.toString());
            }
            if (set.size() == 0) {
                return null;
            }
            EntityViewInfo view = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            view.setFilter(filter);
            filter.getFilterItems().add(new FilterItemInfo("id", set, CompareType.INCLUDE));
            try {
                IMainMenuItem iMainMenuItem = MainMenuItemFactory.getRemoteInstance();
                result = iMainMenuItem.getMainMenuItemCollection(view);
            }
            catch (Exception e) {
                ExceptionHandler.handle((Component)((Object)this), (Throwable)e);
            }
        }
        return result;
    }

    private boolean initDefOpenUI() {
        Timestamp startTime = new Timestamp(System.currentTimeMillis());
        try {
            MainMenuItemCollection menus = this.getDefOpenMenu();
            if (menus == null) {
                return false;
            }
            Iterator iter = menus.iterator();
            if (!iter.hasNext()) {
                return false;
            }
            while (iter.hasNext()) {
                try {
                    MenuVisitorHelper.showUIbyMenu((Component)((Object)this), (MainMenuItemInfo)iter.next());
                }
                catch (Exception e) {
                    ExceptionHandler.handle((Component)((Object)this), (Throwable)e);
                }
            }
        }
        catch (Exception e) {
            ExceptionHandler.handle((Component)((Object)this), (Throwable)e);
        }
        logger.info((Object)(UIFrameUtils.getRes("res_49") + (double)(System.currentTimeMillis() - startTime.getTime()) / 1000.0));
        return true;
    }

    private void jbInit() {
        this.resHelper = this.getResHelper();
        this.initIcon();
        this.setTitle(this.resHelper.getString("this.title") + "-" + SysContext.getSysContext().getProperty((Object)"DcAlias"));
        if (LicenseHelper.isTrail()) {
            this.setTitle(this.getTitle() + UIFrameResource.getString("Trail"));
        }
        this.setDefaultCloseOperation(0);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowOpened(WindowEvent e) {
                logger.info((Object)"Main Frame Opened.");
                MainFrame.this.body.getOpenSysTabThread().start();
            }

            @Override
            public void windowClosed(WindowEvent e) {
                MainFrame.this.this_windowClosed(e);
            }

            @Override
            public void windowClosing(WindowEvent e) {
                MainFrame.this.this_windowClosing(e);
            }
        });
        this.getContentPane().setLayout(new BorderLayout());
        this.pnlToolBar.setPreferredSize(new Dimension(-1, 30));
        this.pnlToolBar.setLayout(new BorderLayout());
        this.getContentPane().add((Component)((Object)this.body), "Center");
    }

    private void initIcon() {
        if (LoginFrame.TITLE_ICON == null) {
            LoginFrame.TITLE_ICON = EASResource.getImage((String)"imgEas_16");
        }
        this.setIconImage(LoginFrame.TITLE_ICON);
    }

    private ResourceBundleHelper getResHelper() {
        return new ResourceBundleHelper(this.getClass().getName(), SysContext.getSysContext().getOriginLocale());
    }

    private void this_windowClosed(WindowEvent e) {
        CacheStat.getInstance().printStat();
        if (!AppletUtil.isApplet) {
            TempMsgManager.stopInspectTimer();
            sessionList.remove(this);
            if (sessionList.size() == 0 && !isReLogin) {
                try {
                    LoginHelper.logout();
                }
                catch (EASLoginException e1) {
                    ExceptionHandler.handle((Component)((Object)this), (Throwable)((Object)e1));
                }
                System.exit(0);
            } else if (sessionList.size() == 0 && isReLogin) {
                try {
                    LoginHelper.logout();
                }
                catch (EASLoginException e1) {
                    ExceptionHandler.handle((Component)((Object)this), (Throwable)((Object)e1));
                }
                LoginFrame login = LoginFrame.getInstance();
                login.show();
                isReLogin = false;
            }
        } else if (isReLogin) {
            sessionList.remove(this);
            try {
                LoginHelper.logout();
            }
            catch (EASLoginException e1) {
                ExceptionHandler.handle((Component)((Object)this), (Throwable)((Object)e1));
            }
            isReLogin = false;
        }
    }

    private void this_windowClosing(WindowEvent e) {
        this.closeMainFrame();
    }

    private void handException(Throwable exc) {
        ExceptionHandler.handle((Component)((Object)this), (Throwable)exc);
    }

    @Override
    public IUIObject getSelectedUIObject() {
        return this.uiManager.getTabByIndex(this.body.getCurTabIndex());
    }

    private void initCSHelpListener(KDMenuItem menuItem, CoreUI ui) {
        HelpUtils.addCSHelp((JMenuItem)menuItem, (JComponent)ui);
    }

    boolean closeAllNonSysApp() {
        for (int i = sessionList.size() - 1; i >= 0; --i) {
            MainFrame mainFrame = (MainFrame)sessionList.get(i);
            if (!mainFrame.uiManager.closeAllTab() || !mainFrame.uiManager.closeAllWin()) {
                return false;
            }
            mainFrame.uiManager.body.resetOrg();
        }
        return true;
    }

    private void saveLastUsedFunction() {
        try {
            if (UIFrameContext.getInstance().getProperty("LastUsedFunction") != null) {
                ILastUsedFunction iLastUsedFunction = LastUsedFunctionFactory.getRemoteInstance();
                LastUsedFunctionCollection dataCollection = (LastUsedFunctionCollection)UIFrameContext.getInstance().getProperty("LastUsedFunction");
                iLastUsedFunction.betchAddNew((IObjectCollection)dataCollection);
            }
        }
        catch (Exception ex) {
            ExceptionHandler.handle((Component)((Object)this), (Throwable)ex);
        }
    }

    public void show() {
        super.show();
        if (this.isFirst) {
            if (this.loginSplash != null) {
                this.loginSplash.show();
            }
            this.isFirst = false;
        }
    }

    void doubleShow() {
        this.show();
        this.setExtendedState(6);
        if (this.initDefOpenUI()) {
            this.show();
        }
        if (!AppletUtil.isApplet) {
            TempMsgManager.getInstance();
            TempMsgManager.setParentUI((Component)((Object)this));
        }
    }

    @Override
    public void initApplication() {
    }

    @Override
    public Frame getMainOwner() {
        return this;
    }

    @Override
    public void setMainOwner(Frame owner) {
    }

    @Override
    public void initUI() {
    }

    public KDMenuBar getUIMenuBar() {
        return null;
    }

    public void setUIMenuBar(KDMenuBar menuBar) {
    }

    public KDToolBar getUIToolBar() {
        return null;
    }

    public void setUIToolBar(KDToolBar toolBar) {
    }

    @Override
    public IMainUIContainer getUIContainer() {
        return null;
    }

    @Override
    public void setUIContainer(IMainUIContainer uiWindow) {
    }

    @Override
    public IUIManager getUiManager() {
        return null;
    }

    @Override
    public BodyUI getBodyUI() {
        return null;
    }
}

