/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.uiframe.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.swing.KDList;
import com.kingdee.eas.base.permission.MainMenuItemInfo;
import com.kingdee.eas.base.uiframe.client.MainMenuConstants;
import com.kingdee.eas.util.client.ExceptionHandler;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import javax.swing.BorderFactory;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public abstract class MainMenuList
extends KDList {
    transient ListSelectionListener listSelectionListener = new ListSelectionListener(){

        @Override
        public void valueChanged(ListSelectionEvent e) {
            try {
                if (!e.getValueIsAdjusting()) {
                    MainMenuList.this.listSelectionChanged(e);
                }
            }
            catch (Throwable te) {
                ExceptionHandler.handle((Throwable)te);
            }
        }
    };
    MenuMouseAdapter adapter = new MenuMouseAdapter();

    public MainMenuList() {
        this.setSelectionMode(0);
        this.addListSelectionListener(this.listSelectionListener);
        this.setBorder(BorderFactory.createEmptyBorder());
        this.setFixedCellHeight(31);
        this.setBackground(MainMenuConstants.BACKGROUND_COLOR);
        this.setSelectionBackground(Color.WHITE);
        this.setSelectionForeground(Color.decode("#000000"));
    }

    protected void addMouseMotionListener() {
        this.addMouseMotionListener(this.adapter);
    }

    protected abstract void listSelectionChanged(ListSelectionEvent var1) throws BOSException;

    protected void addListSelectionListener() {
        this.addListSelectionListener(this.listSelectionListener);
    }

    protected void removeListSelectionListener() {
        this.removeListSelectionListener(this.listSelectionListener);
    }

    protected void addMouseListener() {
        this.addMouseListener(this.adapter);
    }

    protected void clearAdapterLocalVar() {
        this.adapter.clearLocalVar();
    }

    class MenuMouseAdapter
    extends MouseAdapter
    implements MouseMotionListener {
        private int preIndex = -1;
        private int lastIndex = -1;
        private final Cursor handCursor = new Cursor(12);

        MenuMouseAdapter() {
        }

        @Override
        public void mouseMoved(MouseEvent e) {
            KDList list = (KDList)e.getSource();
            list.setCursor(this.handCursor);
            int index = list.locationToIndex(e.getPoint());
            if (this.preIndex == index) {
                return;
            }
            if (-1 != this.preIndex) {
                MainMenuItemInfo preInfo = (MainMenuItemInfo)list.getElement(this.preIndex);
                preInfo.setBoolean("ISHOVER", false);
            }
            this.preIndex = index;
            MainMenuItemInfo info = (MainMenuItemInfo)list.getElement(index);
            info.setBoolean("ISHOVER", true);
            this.lastIndex = index;
            list.repaint();
        }

        @Override
        public void mouseExited(MouseEvent e) {
            KDList list = (KDList)e.getSource();
            if (this.lastIndex != -1) {
                MainMenuItemInfo preInfo = (MainMenuItemInfo)list.getElement(this.lastIndex);
                preInfo.setBoolean("ISHOVER", false);
                this.lastIndex = -1;
                list.repaint();
            }
            this.preIndex = -1;
        }

        @Override
        public void mouseDragged(MouseEvent e) {
        }

        public void clearLocalVar() {
            this.preIndex = -1;
            this.lastIndex = -1;
        }
    }
}

