/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.uiframe.client;

import com.kingdee.bos.ctrl.swing.DefaultKingdeeListCellRenderer;
import com.kingdee.eas.base.permission.MainMenuItemInfo;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.util.StringUtils;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import javax.swing.ImageIcon;
import javax.swing.JList;

public class MainMenuListCellRenderer
extends DefaultKingdeeListCellRenderer {
    private boolean _isHover = false;
    private boolean _isSelected = false;
    private String _text = null;
    private ImageIcon _imageIcon = null;
    private final Image hoverImage = EASResource.getImage((String)"image_item_hover");
    private final Image defaultImage = EASResource.getImage((String)"image_item_default");
    private final Image selectedImage = EASResource.getImage((String)"image_item_selected");

    public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
        MainMenuItemInfo menuInfo = (MainMenuItemInfo)value;
        this._isHover = menuInfo.getBoolean("ISHOVER");
        this._isSelected = menuInfo.getBoolean("ISSELECTED");
        super.getListCellRendererComponent(list, value, index, isSelected, cellHasFocus);
        this.setText("");
        this.setIcon(null);
        this._text = menuInfo.getName();
        this._imageIcon = (ImageIcon)menuInfo.get("IMAGEICON");
        return this;
    }

    protected void paintComponent(Graphics g) {
        int w = this.getWidth();
        int h = this.getHeight();
        Graphics2D g2d = (Graphics2D)g;
        if (this._isSelected) {
            g2d.drawImage(this.selectedImage, 0, 0, w, h, null);
        } else if (this._isHover) {
            g2d.drawImage(this.hoverImage, 0, 0, w, h, null);
        } else {
            g2d.drawImage(this.defaultImage, 0, 0, w, h, null);
        }
        g2d.setColor(this._isSelected ? Color.WHITE : Color.BLACK);
        g2d.drawString(StringUtils.isEmpty((String)this._text) ? "UNKNOWN" : this._text, w / 2 - 27, h / 2 + 5);
        g2d.drawImage(this._imageIcon.getImage(), w / 2 - 65, 4, 32, 24, null);
        super.paintComponent(g);
    }
}

