/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.uiframe.client;

import com.kingdee.bos.ctrl.swing.KDLabel;
import com.kingdee.bos.ctrl.swing.KDProgressBar;
import com.kingdee.bos.ctrl.swing.KDStatusBar;
import com.kingdee.bos.ctrl.swing.SimpleStatusBarPart;
import com.kingdee.eas.base.uiframe.UIFrameResource;
import com.kingdee.eas.base.uiframe.client.LoginParamCacheUtil;
import com.kingdee.eas.base.uiframe.client.MainStatusBarManager;
import com.kingdee.eas.base.uiframe.client.MsgPanelUtil;
import com.kingdee.eas.base.uiframe.client.NewMainFrame;
import com.kingdee.eas.base.uiframe.client.UIFrameUtil;
import com.kingdee.eas.basedata.org.AdminOrgUnitInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.CtrlUnitInfo;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.util.client.ExceptionHandler;
import com.kingdee.util.StringUtils;
import java.awt.Color;
import java.awt.Component;
import java.awt.Frame;
import java.awt.Point;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import org.apache.log4j.Logger;

public class MainStatusBar {
    private static final Logger logger = Logger.getLogger(MainStatusBar.class);
    static final String RENDER_PROGRESSBAR = "ProgressBar";
    static final int PART_PROGRESSBAR = 0;
    static final int PART_ORG = 1;
    static final int PART_USER = 2;
    static final int PART_PERIOD = 3;
    static final int PART_BUTTON = 4;
    static final String RENDER_ORGTITLE = "OrgTitle";
    static final String RENDER_ORGTEXT = "OrgText";
    static final String RENDER_USERNAMETITLE = "UserTitle";
    static final String RENDER_USERNAMETEXT = "UserText";
    static final String RENDER_USERALIASTITLE = "UserNameTitle";
    static final String RENDER_USERALIASTEXT = "UserNameText";
    static final String RENDER_PERIODTITLE = "PeriodTitle";
    static final String RENDER_PERIODTEXT = "PeriodText";
    static final String RENDER_BTNMESSAGE = "BtnMessage";
    static final String RENDER_BTNMONITOR = "monitor";
    private KDStatusBar statusBar;
    private KDProgressBar progressBar;
    private KDLabel lblMsg;
    KDLabel lblOrg;
    KDLabel lblUser;
    JLabel lblPeriod;
    JLabel lblPerTitle;
    JLabel lblCompanyforPopupPane = new KDLabel();
    JLabel lblAdminforPopupPane = new KDLabel();
    private JButton btnMessage;
    private JButton btnMonitor;
    private MainStatusBarManager.StatusBarBuilder statusBarBuilder;
    SimpleStatusBarPart partPeriod = null;

    public MainStatusBarManager.StatusBarBuilder getStatusBarBuilder() {
        return this.statusBarBuilder;
    }

    public void setStatusBarBuilder(MainStatusBarManager.StatusBarBuilder statusBarBuilder) {
        this.statusBarBuilder = statusBarBuilder;
    }

    public MainStatusBar(KDStatusBar aStatusBar, KDLabel aLblMsg) {
        this.statusBar = aStatusBar;
        this.progressBar = (KDProgressBar)aStatusBar.getPart(0).getRenderer((Object)RENDER_PROGRESSBAR).getComponent(aStatusBar);
        Color textColor = UIManager.getColor("eas.statusbar.fg");
        this.lblMsg = aLblMsg;
        this.lblMsg.setForeground(textColor);
        this.lblOrg = (KDLabel)aStatusBar.getPart(1).getRenderer((Object)RENDER_ORGTEXT).getComponent(aStatusBar);
        this.lblOrg.setText(MainStatusBar.getOrgText());
        this.lblOrg.setName("switchOrg");
        if (MsgPanelUtil.isMsgPanelVisible()) {
            this.lblOrg.addComponentListener((ComponentListener)new ComponentAdapter(){

                @Override
                public void componentMoved(ComponentEvent e) {
                    NewMainFrame mainFrame;
                    if (!MsgPanelUtil.isMsgPanelVisible()) {
                        return;
                    }
                    Component c = (Component)e.getSource();
                    Frame frame = UIFrameUtil.getCurrMainFrame(c);
                    if (frame instanceof NewMainFrame && (mainFrame = (NewMainFrame)((Object)frame)).getGuideMsgPanel() instanceof NewMainFrame.SwitchOrgMsgPanel) {
                        Point p = SwingUtilities.convertPoint(c.getParent(), c.getLocation(), (Component)((Object)mainFrame));
                        mainFrame.showGuideMsgLocation(p.x - 50, p.y - 170);
                    }
                }
            });
        }
        this.lblUser = (KDLabel)aStatusBar.getPart(2).getRenderer((Object)RENDER_USERNAMETITLE).getComponent(aStatusBar);
        this.btnMessage = (JButton)aStatusBar.getPart(4).getRenderer((Object)RENDER_BTNMESSAGE).getComponent(aStatusBar);
        this.btnMonitor = (JButton)aStatusBar.getPart(4).getRenderer((Object)RENDER_BTNMONITOR).getComponent(aStatusBar);
        this.partPeriod = aStatusBar.getPart(3);
        this.lblPeriod = (JLabel)aStatusBar.getPart(3).getRenderer((Object)RENDER_PERIODTEXT).getComponent(aStatusBar);
        this.lblPerTitle = (JLabel)aStatusBar.getPart(3).getRenderer((Object)RENDER_PERIODTITLE).getComponent(aStatusBar);
        this.setCurPeriod("");
    }

    public static MainStatusBar getMainStatusBar() {
        MainStatusBar result = null;
        try {
            result = MainStatusBarManager.getInstance().getMainStatusBar();
        }
        catch (Exception e) {
            e.printStackTrace(System.out);
            ExceptionHandler.handle((Throwable)e);
        }
        return result;
    }

    public KDStatusBar getStatusBar() {
        return this.statusBar;
    }

    public KDProgressBar getProgressBar() {
        return this.progressBar;
    }

    public void setMessage(String msg) {
        this.lblMsg.setText(msg);
    }

    public void setStatus(String strStatus) {
        if (strStatus == null || "".equals(strStatus)) {
            this.lblPerTitle.setVisible(false);
            this.lblPeriod.setVisible(false);
            this.partPeriod.setVisible(false);
        } else {
            this.lblPerTitle.setVisible(true);
            this.lblPeriod.setVisible(false);
            this.lblPerTitle.setText(strStatus);
            this.partPeriod.setVisible(true);
        }
    }

    public void setCurPeriod(String period) {
        if (period == null || "".equals(period)) {
            this.lblPerTitle.setVisible(false);
            this.lblPeriod.setVisible(false);
            this.partPeriod.setVisible(false);
        } else {
            this.lblPerTitle.setVisible(true);
            this.lblPeriod.setVisible(true);
            this.lblPeriod.setText(period);
            this.partPeriod.setVisible(true);
        }
    }

    public void setPerTitle(String title) {
        if (title == null || "".equals(title)) {
            this.lblPerTitle.setVisible(false);
            this.lblPeriod.setVisible(false);
            this.partPeriod.setVisible(false);
        } else {
            this.lblPerTitle.setVisible(true);
            this.lblPeriod.setVisible(true);
            this.lblPerTitle.setText(title);
            this.partPeriod.setVisible(true);
        }
    }

    public void setCurPeriod(String title, String period) {
        this.lblPerTitle.setVisible(true);
        this.lblPeriod.setVisible(true);
        this.lblPerTitle.setText(title);
        this.lblPeriod.setText(period);
        this.partPeriod.setVisible(true);
    }

    public String getMessage() {
        return this.lblMsg.getText();
    }

    public void setIcon(Icon icon) {
        this.lblMsg.setIcon(icon);
    }

    public Icon getIcon() {
        return this.lblMsg.getIcon();
    }

    public KDLabel getMsgLabel() {
        return this.lblMsg;
    }

    public static void remove(MainStatusBar mainStatusBar) {
        MainStatusBarManager.getInstance().remove(mainStatusBar);
    }

    JButton getBtnMessage() {
        return this.btnMessage;
    }

    public JButton getBtnMonitor() {
        return this.btnMonitor;
    }

    public static String getOrgText() {
        CtrlUnitInfo cu = SysContext.getSysContext().getCurrentCtrlUnit();
        OrgUnitInfo ou = SysContext.getSysContext().getCurrentOrgUnit();
        String cuName = cu.getName();
        String ouName = ou.getName();
        String orgName = "";
        String orgPre = MainStatusBar.getString("MainStatusBar.org2");
        orgName = StringUtils.equals((String)cuName, (String)ouName) ? orgPre + cu.getName() : orgPre + cu.getName() + "--" + ou.getName();
        if (MainStatusBar.isShowOrgNumber()) {
            orgName = StringUtils.equals((String)cuName, (String)ouName) ? orgPre + cu.getName() + "(" + cu.getNumber() + ")" : orgPre + cu.getName() + "(" + cu.getNumber() + ")--" + ou.getName() + "(" + ou.getNumber() + ")";
        }
        return orgName;
    }

    void switchOrg() {
        CompanyOrgUnitInfo company = SysContext.getSysContext().getCurrentFIUnit();
        AdminOrgUnitInfo admin = SysContext.getSysContext().getCurrentAdminUnit();
        if (company != null && company.isIsBizUnit()) {
            this.lblOrg.setForeground(UIManager.getColor("eas.statusbar.entity"));
            this.lblUser.setForeground(UIManager.getColor("eas.statusbar.entity"));
        } else {
            this.lblOrg.setForeground(UIManager.getColor("eas.statusbar.nonentity"));
            this.lblUser.setForeground(UIManager.getColor("eas.statusbar.nonentity"));
        }
        String orgName = MainStatusBar.getOrgText();
        this.lblOrg.setText(orgName);
        this.lblOrg.setToolTipText(orgName);
        if (this.getStatusBarBuilder() != null) {
            if (this.getStatusBarBuilder().getLblCompanyforPopupPane() != null) {
                this.getStatusBarBuilder().getLblCompanyforPopupPane().setText(company.getName());
                this.getStatusBarBuilder().getLblCompanyforPopupPane().setToolTipText(company.getName());
            }
            if (this.getStatusBarBuilder().getLblAdminforPopupPane() != null) {
                this.getStatusBarBuilder().getLblAdminforPopupPane().setText(admin.getName());
                this.getStatusBarBuilder().getLblAdminforPopupPane().setToolTipText(admin.getName());
            }
        }
        if (this.lblCompanyforPopupPane != null) {
            if (company != null) {
                this.lblCompanyforPopupPane.setText(company.getName());
                this.lblCompanyforPopupPane.setToolTipText(company.getName());
            } else {
                this.lblCompanyforPopupPane.setText(null);
            }
        }
        if (this.lblAdminforPopupPane != null) {
            if (admin != null) {
                this.lblAdminforPopupPane.setText(admin.getName());
                this.lblAdminforPopupPane.setToolTipText(admin.getName());
            } else {
                this.lblAdminforPopupPane.setText(null);
            }
        }
    }

    private static String getString(String strKey) {
        return UIFrameResource.getString(strKey);
    }

    private static boolean isShowOrgNumber() {
        String paramkey = "ShowOrgNumber";
        return "true".equalsIgnoreCase(StringUtils.cnulls((Object)LoginParamCacheUtil.getParamValue(paramkey, null, Boolean.FALSE)));
    }
}

