/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.uiframe.client;

import com.kingdee.eas.base.ui.IMainUIContainer;
import com.kingdee.eas.base.uiframe.EASLoginException;
import com.kingdee.eas.base.uiframe.UIFrameResource;
import com.kingdee.eas.base.uiframe.client.LoginHelper;
import com.kingdee.eas.base.uiframe.client.NewMainFrame;
import com.kingdee.eas.base.uiframe.client.SystemEntry;
import com.kingdee.eas.base.uiframe.client.UIModelDialog;
import com.kingdee.eas.base.uiframe.client.UIWinManager;
import com.kingdee.eas.base.uiframe.client.ui.IMainUIObject;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.util.ArrayList;
import org.apache.log4j.Logger;

public class MainUIObjectManager {
    protected static final Logger logger = Logger.getLogger(MainUIObjectManager.class);
    private UIModelDialog uiDialog;
    private IMainUIObject mainUIObject = null;
    private ArrayList sessionList = new ArrayList();
    private static MainUIObjectManager instance;

    public IMainUIObject getMainUIObject() {
        return this.mainUIObject;
    }

    public void setMainUIObject(IMainUIObject mainUIObject) {
        this.mainUIObject = mainUIObject;
    }

    public static MainUIObjectManager getInstance() {
        if (instance == null) {
            instance = new MainUIObjectManager();
        }
        return instance;
    }

    private MainUIObjectManager() {
    }

    public void addSession(IMainUIContainer uiContainer) {
        this.sessionList.add(uiContainer);
    }

    public void activatedWindow(IMainUIContainer window) {
        SystemEntry.instance.setCurrenContainer(window);
    }

    public void openedWindow(IMainUIContainer window) {
        if (window instanceof NewMainFrame && ((NewMainFrame)window).getMainUI().getBodyUI().getOpenSysTabThread() != null) {
            ((NewMainFrame)window).getMainUI().getBodyUI().getOpenSysTabThread().start();
        }
    }

    public boolean closingWindow(IMainUIContainer uiContainer, boolean closeConfirm) {
        if (uiContainer instanceof NewMainFrame) {
            NewMainFrame frame = (NewMainFrame)uiContainer;
            if (closeConfirm && !SystemEntry.instance.isWebStart()) {
                frame.getMainUI().getBodyUI().join();
                if (MsgBox.showConfirm2((String)MainUIObjectManager.getString("MainMenuBar.confirmExit")) == 0) {
                    if (frame.getMainUI().getUiManager().closeAllWin() && frame.getMainUI().getUiManager().closeAllTab()) {
                        frame.dispose();
                        return true;
                    }
                } else {
                    SysUtil.abort();
                }
            } else {
                frame.getMainUI().getBodyUI().join();
                if (frame.getMainUI().getUiManager().closeAllWin() && frame.getMainUI().getUiManager().closeAllTab()) {
                    frame.dispose();
                    return true;
                }
            }
            return false;
        }
        return true;
    }

    public synchronized void closedWindow(IMainUIContainer uiContainer) {
        if (!SystemEntry.instance.isWebStart()) {
            this.sessionList.remove(uiContainer);
            if (!SystemEntry.isReLogin) {
                if (this.sessionList.size() == 0 && SysContext.getSysContext().getSessionID() != null) {
                    try {
                        SystemEntry.instance.logout();
                    }
                    catch (EASLoginException e1) {
                        logger.error((Object)e1.getMessage(), (Throwable)((Object)e1));
                        MsgBox.showInfo((Component)((Object)((NewMainFrame)uiContainer)), (String)e1.getMessage());
                    }
                }
                if (this.sessionList.size() == 0) {
                    if (!SystemEntry.instance.isVirtulLogin) {
                        if (LoginHelper.app != null) {
                            LoginHelper.app.notifyAppStatus();
                        }
                        System.exit(-1);
                    } else {
                        SystemEntry.instance.isVirtulLogin = false;
                    }
                }
            }
        }
    }

    public boolean closeApplication(IMainUIContainer uiContainer, boolean closeConfirm) {
        return true;
    }

    public boolean closeAllNonSysApp() {
        if (SystemEntry.instance.isEmbedStart()) {
            if (this.mainUIObject == null) {
                return false;
            }
            if (!this.mainUIObject.getUiManager().closeAllTab() || !this.mainUIObject.getUiManager().closeAllWin()) {
                return false;
            }
            this.mainUIObject.getBodyUI().resetOrg();
        }
        for (int i = this.sessionList.size() - 1; i >= 0; --i) {
            if (!(this.sessionList.get(i) instanceof NewMainFrame)) continue;
            NewMainFrame mainFrame = (NewMainFrame)((Object)this.sessionList.get(i));
            if (!mainFrame.getMainUI().getUiManager().closeAllTab() || !mainFrame.getMainUI().getUiManager().closeAllWin()) {
                return false;
            }
            mainFrame.getMainUI().getBodyUI().resetOrg();
        }
        return true;
    }

    public boolean closeApplication(boolean isConfirm) {
        UIWinManager.getInstance().closeAllWin();
        for (int i = this.sessionList.size() - 1; i >= 0; --i) {
            NewMainFrame mainFrame;
            if (!(this.sessionList.get(i) instanceof NewMainFrame) || this.closingWindow(mainFrame = (NewMainFrame)((Object)this.sessionList.get(i)), isConfirm && !SystemEntry.instance.isWebStart())) continue;
            return false;
        }
        if (SystemEntry.instance.isEmbedStart()) {
            if (this.mainUIObject == null) {
                return false;
            }
            if (!this.mainUIObject.getUiManager().closeAllTab() || !this.mainUIObject.getUiManager().closeAllWin()) {
                return false;
            }
        }
        return true;
    }

    public boolean closeApplication() {
        UIWinManager.getInstance().closeAllWin();
        for (int i = this.sessionList.size() - 1; i >= 0; --i) {
            if (!(this.sessionList.get(i) instanceof NewMainFrame)) continue;
            NewMainFrame mainFrame = (NewMainFrame)((Object)this.sessionList.get(i));
            mainFrame.getMainUI().getBodyUI().join();
            if (!mainFrame.getMainUI().getUiManager().closeAllWin() || !mainFrame.getMainUI().getUiManager().closeAllTab()) continue;
            mainFrame.dispose();
        }
        return true;
    }

    public void clearInstance() {
        this.sessionList.clear();
        instance = null;
        this.mainUIObject = null;
    }

    private static String getString(String strKey) {
        return UIFrameResource.getString(strKey);
    }

    public UIModelDialog getUiDialog() {
        return this.uiDialog;
    }

    public void setUiDialog(UIModelDialog uiDialog) {
        this.uiDialog = uiDialog;
    }
}

