/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.uiframe.client;

import com.kingdee.bos.ctrl.swing.KDCheckBox;
import com.kingdee.bos.ctrl.swing.KDList;
import com.kingdee.bos.dao.query.ISQLExecutor;
import com.kingdee.bos.dao.query.SQLExecutorFactory;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.base.uiframe.IndustryEnum;
import com.kingdee.eas.base.uiframe.MenuUpdateModeEnum;
import com.kingdee.eas.base.uiframe.client.AbstractMenuUpdateUI;
import com.kingdee.eas.base.uiframe.client.MainMenuEditUI;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.jdbc.rowset.IRowSet;
import java.awt.Color;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.List;
import org.apache.log4j.Logger;

public class MenuUpdateUI
extends AbstractMenuUpdateUI {
    private static final Logger logger = CoreUIObject.getLogger(MenuUpdateUI.class);
    private static final String menuResource = "com.kingdee.eas.base.uiframe.MenuEditResource";
    private KDList list = new KDList();
    private KDCheckBox[] industryCheckBox;
    private MainMenuEditUI parent = null;

    public MenuUpdateUI() throws Exception {
        this.modeDescripLabel.setForeground(Color.red);
        this.initIndustryMenu();
        this.initUpdateMode();
        this.initCurrentIndustry();
        this.changeMenuMode(MenuUpdateModeEnum.AutoUpdate);
        this.CurrentIndustryLabel.setVisible(false);
        this.isIndustryCheckBox.setEnabled(false);
        this.isIndustryCheckBox.setVisible(false);
        this.kDComboBox1.setEnabled(false);
        this.kDComboBox1.setVisible(false);
    }

    public void onLoad() throws Exception {
        if (this.getUIContext().get("menuEdit") != null) {
            this.parent = (MainMenuEditUI)((Object)this.getUIContext().get("menuEdit"));
        }
        super.onLoad();
    }

    private void initCurrentIndustry() {
        String sql = "select * from T_BAS_MenuUpdate where Fid = 'menuUpdate' ";
        ISQLExecutor sqlExe = SQLExecutorFactory.getRemoteInstance((String)sql);
        try {
            IRowSet rs = sqlExe.executeSQL();
            if (rs.next()) {
                String industry = rs.getString("FIndustryStatus");
                int FIsUpdate = rs.getInt("FIsUpdate");
                if (FIsUpdate == 0) {
                    this.CurrentIndustryField.setText(this.getIndustry(""));
                } else {
                    this.CurrentIndustryField.setText(this.getIndustry(industry));
                    this.isIndustryCheckBox.setSelected(false);
                    int size = this.kDComboBox1.getItemCount();
                    for (int i = 0; i < size; ++i) {
                        IndustryEnum temp = (IndustryEnum)((Object)this.kDComboBox1.getItemAt(i));
                        if (!(temp.getValue() + "").equals(industry)) continue;
                        this.kDComboBox1.setSelectedIndex(i);
                    }
                }
            }
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
    }

    private String getIndustry(String type) {
        List industryEnums = IndustryEnum.getEnumList();
        StringBuffer bf = new StringBuffer();
        int size = industryEnums.size();
        String[] typesIndustry = type.split(";");
        int length = typesIndustry.length;
        IndustryEnum enumTemp = null;
        if (type.equals("") || type.equals("all")) {
            for (int i = 0; i < size; ++i) {
                enumTemp = (IndustryEnum)((Object)industryEnums.get(i));
                bf.append(enumTemp.getAlias());
                bf.append("+");
            }
        } else {
            block1: for (int j = 0; j < length; ++j) {
                for (int i = 0; i < size; ++i) {
                    enumTemp = (IndustryEnum)((Object)industryEnums.get(i));
                    if (!(enumTemp.getValue() + "").equals(typesIndustry[j])) continue;
                    bf.append(enumTemp.getAlias());
                    bf.append("+");
                    continue block1;
                }
            }
        }
        bf.deleteCharAt(bf.lastIndexOf("+"));
        return bf.toString();
    }

    private void initUpdateMode() {
        List updateMode = MenuUpdateModeEnum.getEnumList();
        this.InComboBox.addItems(updateMode.toArray());
        this.InComboBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent arg0) {
                MenuUpdateModeEnum mode = (MenuUpdateModeEnum)((Object)arg0.getItem());
                MenuUpdateUI.this.changeMenuMode(mode);
            }
        });
        this.updateBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                try {
                    MenuUpdateUI.this.updateMenu();
                    MenuUpdateUI.this.dispose();
                }
                catch (Exception e) {
                    logger.error((Object)("update menu error" + e.getMessage()), (Throwable)e);
                }
            }
        });
        this.cancelBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                MenuUpdateUI.this.dispose();
            }
        });
        this.isIndustryCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                if (MenuUpdateUI.this.isIndustryCheckBox.isSelected()) {
                    MenuUpdateUI.this.kDComboBox1.setEnabled(true);
                } else {
                    MenuUpdateUI.this.kDComboBox1.setEnabled(false);
                }
            }
        });
    }

    private void dispose() {
        this.destroyWindow();
    }

    public String getIndustrySelect() {
        IndustryEnum enumTemp = (IndustryEnum)((Object)this.kDComboBox1.getSelectedItem());
        return enumTemp.getValue() + "";
    }

    private void updateMenu() throws Exception {
        MenuUpdateModeEnum updateMode = (MenuUpdateModeEnum)((Object)this.InComboBox.getSelectedItem());
        if (this.isIndustryCheckBox.isSelected()) {
            String industry = this.getIndustrySelect();
            if (updateMode == MenuUpdateModeEnum.UPdateSys) {
                this.parent.updateSysMenu(industry);
            } else if (updateMode == MenuUpdateModeEnum.AutoUpdate) {
                this.parent.autoUpdateMenu(industry);
            } else if (updateMode == MenuUpdateModeEnum.AllUpdate) {
                this.parent.importAllSysMenu(industry);
            }
        } else if (updateMode == MenuUpdateModeEnum.UPdateSys) {
            this.parent.updateSysMenu(null);
        } else if (updateMode == MenuUpdateModeEnum.AutoUpdate) {
            this.parent.autoUpdateMenu(null);
        } else if (updateMode == MenuUpdateModeEnum.AllUpdate) {
            this.parent.importAllSysMenu(null);
        }
    }

    private void changeMenuMode(MenuUpdateModeEnum mode) {
        String text = null;
        if (mode == MenuUpdateModeEnum.AllUpdate) {
            text = EASResource.getString((String)menuResource, (String)"AllUpdateDec");
        } else if (mode == MenuUpdateModeEnum.AutoUpdate) {
            text = EASResource.getString((String)menuResource, (String)"autoUpdateDec");
        } else if (mode == MenuUpdateModeEnum.UPdateSys) {
            text = EASResource.getString((String)menuResource, (String)"ImportSysDec");
        }
        this.modeDescripLabel.setText(text);
    }

    private void selectAll(boolean flag) {
        int size = this.industryCheckBox.length;
        for (int i = 0; i < size; ++i) {
            if (flag) {
                this.industryCheckBox[i].setSelected(true);
                continue;
            }
            this.industryCheckBox[i].setSelected(false);
        }
    }

    private void initIndustryMenu() {
        List industryEnums = IndustryEnum.getEnumList();
        this.kDComboBox1.addItems(industryEnums.toArray());
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }
}

