/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.uiframe.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.swing.KDPopupMenu;
import com.kingdee.bos.ctrl.swing.KDTree;
import com.kingdee.bos.ctrl.swing.tree.DefaultKingdeeTreeNode;
import com.kingdee.bos.ctrl.swing.tree.KingdeeTreeModel;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.myeas.ComMenuFunctionCollection;
import com.kingdee.eas.base.myeas.ComMenuFunctionFactory;
import com.kingdee.eas.base.myeas.ComMenuFunctionInfo;
import com.kingdee.eas.base.myeas.IComMenuFunction;
import com.kingdee.eas.base.permission.IMainMenuItem;
import com.kingdee.eas.base.permission.MainMenuItemCollection;
import com.kingdee.eas.base.permission.MainMenuItemFactory;
import com.kingdee.eas.base.permission.MainMenuItemInfo;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.base.uiframe.EASMainMenuCacheUtil;
import com.kingdee.eas.base.uiframe.IMainFunctionMenu;
import com.kingdee.eas.base.uiframe.IMenuCache;
import com.kingdee.eas.base.uiframe.MainFunctionInfo;
import com.kingdee.eas.base.uiframe.MainFunctionMenuFactory;
import com.kingdee.eas.base.uiframe.MenuCacheFactory;
import com.kingdee.eas.base.uiframe.OpenMethod;
import com.kingdee.eas.base.uiframe.UIFrameResource;
import com.kingdee.eas.base.uiframe.client.MainMenuBuilder;
import com.kingdee.eas.base.uiframe.client.MainMenuTree;
import com.kingdee.eas.base.uiframe.client.UIConfig;
import com.kingdee.eas.base.uiframe.utils.StreamUtils;
import com.kingdee.eas.base.uiframe.utils.UIFrameUtils;
import com.kingdee.eas.basedata.org.MultiOrgsClientCacheImplUtil;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.util.client.ExceptionHandler;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JPopupMenu;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.apache.log4j.Logger;

public class MenuVisitorHelper {
    private static final boolean isSerializedXMLFormat = true;
    private static final String CURRENT_USER_COM_FUNC_MENU_CACHE_VERSION = "0.0";
    protected static final Logger logger = Logger.getLogger(MenuVisitorHelper.class);
    public static final String MYEAS = "MyEas";
    public static final String MAINFUNCTIONMENU = "MainFunctionMenu";
    private static HashMap subMenuMap;
    private static Set functionSet;
    private static String cachetiemfromtable;
    private static Boolean iswanttogetcache;
    private static String comfunccachtimefromtable;

    public static void showUIbyMenu(Component component, MainMenuItemInfo menuItem) throws Exception {
        MainMenuTree.showUI(component, menuItem);
    }

    static void createUIbyMenu(Component component, MainMenuItemInfo menuItem) throws Exception {
        MainMenuTree.createUI(component, menuItem);
    }

    public static ComMenuFunctionCollection getComFuncMenuColl() {
        String userId = SysContext.getSysContext().getCurrentUserInfo().getId().toString();
        ComMenuFunctionCollection coll = null;
        if (MenuVisitorHelper.isNeedCache(userId)) {
            coll = MenuVisitorHelper.getComFuncMenu();
        } else {
            try {
                IMainFunctionMenu iMainFunctionMenu = MainFunctionMenuFactory.getRemoteInstance();
                coll = iMainFunctionMenu.getComFunctionParent();
                MenuVisitorHelper.writeComFuncMenuCacheMenuTimeForUser();
                MenuVisitorHelper.writeComFuncMenuCache(coll);
            }
            catch (Exception e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
            }
        }
        return coll;
    }

    public static void buildFavoriteFunTree(KDTree tree) throws Exception {
        DefaultKingdeeTreeNode root = null;
        ComMenuFunctionCollection obcoll = MenuVisitorHelper.getComFuncMenuColl();
        if (obcoll != null && obcoll.size() > 0) {
            ComMenuFunctionInfo nodeData = obcoll.get(0);
            root = new DefaultKingdeeTreeNode((Object)nodeData);
            KingdeeTreeModel model = new KingdeeTreeModel((TreeNode)root, true);
            tree.setRootVisible(false);
            tree.setModel((TreeModel)model);
            MenuVisitorHelper.buildComFunChildrenWhithPerm(tree, root, (IObjectCollection)obcoll);
        } else {
            ComMenuFunctionInfo rootData = MenuVisitorHelper.createNewRootData();
            IComMenuFunction iComMenuFunction = ComMenuFunctionFactory.getRemoteInstance();
            String number = rootData.getNumber();
            if (iComMenuFunction.exists("where number = '" + number + "'")) {
                iComMenuFunction.delete("where number = '" + number + "' or longnumber like '" + number + "!%'");
            }
            IObjectPK pk = iComMenuFunction.addnew(rootData);
            rootData = (ComMenuFunctionInfo)iComMenuFunction.getValue(pk);
            root = new DefaultKingdeeTreeNode((Object)rootData);
            KingdeeTreeModel model = new KingdeeTreeModel((TreeNode)root, true);
            tree.setRootVisible(false);
            tree.setModel((TreeModel)model);
        }
        MenuVisitorHelper.reOrderTree(tree);
    }

    private static void reOrderTree(KDTree tree) {
        DefaultKingdeeTreeNode root = (DefaultKingdeeTreeNode)tree.getModel().getRoot();
        MenuVisitorHelper.reOrderNode(root);
        tree.setModel((TreeModel)new KingdeeTreeModel((TreeNode)root, true));
    }

    private static void reOrderNode(DefaultKingdeeTreeNode treeNode) {
        int i;
        DefaultKingdeeTreeNode[] childNodes = new DefaultKingdeeTreeNode[treeNode.getChildCount()];
        for (i = 0; i < childNodes.length; ++i) {
            childNodes[i] = (DefaultKingdeeTreeNode)treeNode.getChildAt(i);
        }
        for (i = 0; i < childNodes.length; ++i) {
            for (int j = i + 1; j < childNodes.length; ++j) {
                ComMenuFunctionInfo pre = (ComMenuFunctionInfo)childNodes[i].getUserObject();
                ComMenuFunctionInfo aft = (ComMenuFunctionInfo)childNodes[j].getUserObject();
                if (pre.getOrder() <= aft.getOrder()) continue;
                DefaultKingdeeTreeNode tempNode = childNodes[j];
                childNodes[j] = childNodes[i];
                childNodes[i] = tempNode;
            }
        }
        for (i = childNodes.length - 1; i >= 0; --i) {
            treeNode.remove(i);
        }
        for (i = 0; i < childNodes.length; ++i) {
            treeNode.add((MutableTreeNode)childNodes[i]);
        }
        for (i = 0; i < childNodes.length; ++i) {
            MenuVisitorHelper.reOrderNode(childNodes[i]);
        }
    }

    private static boolean isRefreshFuncMenu() {
        Boolean bool = (Boolean)SysContext.getSysContext().getProperty((Object)"cacheMenu");
        if (bool == null) {
            return true;
        }
        return bool;
    }

    public static boolean isCache(String userId) {
        if (StringUtils.isEmpty((String)userId)) {
            userId = SysContext.getSysContext().getCurrentUserInfo().getId().toString();
        }
        boolean getCacheflag = false;
        try {
            if (UIConfig.isLocalStoreFunUnit()) {
                if (UIFrameUtils.isLogged()) {
                    logger.info((Object)UIFrameUtils.getLogText("isCache(String userId):UIConfig.isLocalStoreFunUnit()  is true!"));
                }
                if (iswanttogetcache == null) {
                    iswanttogetcache = new Boolean(MenuVisitorHelper.iSWanttoGetUserCache(userId));
                }
                getCacheflag = iswanttogetcache.booleanValue();
            }
        }
        catch (Exception ex) {
            logger.error((Object)ex.getMessage(), (Throwable)ex);
        }
        logger.info((Object)("isCache(String userId)*********************************" + getCacheflag));
        return getCacheflag;
    }

    public static void initMenu(MainFunctionInfo fInfo) {
        subMenuMap = fInfo.getSubItemMap();
    }

    public static MainFunctionInfo initMainMenuFunctionPermissions() throws EASBizException, BOSException {
        long start1 = System.currentTimeMillis();
        MainFunctionInfo fInfo = null;
        long start = System.currentTimeMillis();
        String userId = SysContext.getSysContext().getCurrentUserInfo().getId().toString();
        if (UIConfig.isLocalStoreFunUnit()) {
            if (iswanttogetcache == null) {
                iswanttogetcache = new Boolean(MenuVisitorHelper.iSWanttoGetUserCache(userId));
            }
            if (iswanttogetcache.booleanValue()) {
                fInfo = MenuVisitorHelper.getCacheMenu();
            }
        }
        long end = System.currentTimeMillis();
        UIConfig.setUserId(userId);
        UIConfig.setOrgId(SysContext.getSysContext().getCurrentOrgUnit().getId().toString());
        UIConfig.setDcNumber(SysContext.getSysContext().getDCNumber());
        logger.info((Object)("----get menu data from cache file ---cost:" + (end - start)));
        if (fInfo == null) {
            String cacheTime;
            logger.info((Object)"Menu cache file may be not exit,system will load menu from server");
            start = System.currentTimeMillis();
            IMainFunctionMenu iMainFunctionMenu = MainFunctionMenuFactory.getRemoteInstance();
            fInfo = iMainFunctionMenu.getInitMenuData();
            end = System.currentTimeMillis();
            logger.info((Object)("----get menu data from server  ---cost:" + (end - start)));
            if (UIConfig.isLocalStoreFunUnit()) {
                start = System.currentTimeMillis();
                MenuVisitorHelper.writeCacheMenu(fInfo);
                MenuVisitorHelper.writeCacheMenuTimeForUser();
                end = System.currentTimeMillis();
                logger.info((Object)("----write menu data to cache file ---cost:" + (end - start)));
            }
            if ((cacheTime = (String)SysContext.getSysContext().getProperty((Object)"cacheMenuTime")) != null) {
                UIConfig.setMenuCacheTime(cacheTime);
            }
            UIConfig.setUserId(userId);
        }
        UIConfig.storeConfig();
        long start2 = System.currentTimeMillis();
        logger.info((Object)("getFunctionPermissions : " + (start2 - start1) + "ms!"));
        subMenuMap = fInfo.getSubItemMap();
        return fInfo;
    }

    public static MainFunctionInfo initMainMenuFunctionPermissionsForOrgSwitch() throws EASBizException, BOSException {
        long start1 = System.currentTimeMillis();
        MainFunctionInfo fInfo = null;
        long start = System.currentTimeMillis();
        String userId = SysContext.getSysContext().getCurrentUserInfo().getId().toString();
        if (UIConfig.isLocalStoreFunUnit()) {
            String cachetimeLocal;
            if (iswanttogetcache == null) {
                iswanttogetcache = new Boolean(MenuVisitorHelper.iSWanttoGetUserCache(userId));
            }
            if ((iswanttogetcache = !"".equals(cachetimeLocal = MenuVisitorHelper.getCacheTimeFromLocal()) && cachetimeLocal.equals(cachetiemfromtable) ? Boolean.valueOf(true) : Boolean.valueOf(false)).booleanValue() && !MenuVisitorHelper.isRefreshFuncMenu()) {
                fInfo = MenuVisitorHelper.getCacheMenu();
            }
        }
        long end = System.currentTimeMillis();
        UIConfig.setUserId(userId);
        UIConfig.setOrgId(SysContext.getSysContext().getCurrentOrgUnit().getId().toString());
        UIConfig.setDcNumber(SysContext.getSysContext().getDCNumber());
        logger.info((Object)("----get menu data from cache file ---cost:" + (end - start)));
        if (fInfo == null) {
            String cacheTime;
            logger.info((Object)"Menu cache file may be not exit,system will load menu from server");
            start = System.currentTimeMillis();
            IMainFunctionMenu iMainFunctionMenu = MainFunctionMenuFactory.getRemoteInstance();
            fInfo = iMainFunctionMenu.getInitMenuData();
            end = System.currentTimeMillis();
            logger.info((Object)("----get menu data from server  ---cost:" + (end - start)));
            start = System.currentTimeMillis();
            if (UIConfig.isLocalStoreFunUnit()) {
                MenuVisitorHelper.writeCacheMenu(fInfo);
                MenuVisitorHelper.writeCacheMenuTimeForUser();
            }
            if ((cacheTime = (String)SysContext.getSysContext().getProperty((Object)"cacheMenuTime")) != null) {
                UIConfig.setMenuCacheTime(cacheTime);
            }
            UIConfig.setUserId(userId);
            end = System.currentTimeMillis();
            logger.info((Object)("----write menu data to cache file ---cost:" + (end - start)));
        }
        UIConfig.storeConfig();
        long start2 = System.currentTimeMillis();
        logger.info((Object)("getFunctionPermissions : " + (start2 - start1) + "ms!"));
        subMenuMap = fInfo.getSubItemMap();
        return fInfo;
    }

    public static HashMap getSubItemMap() {
        return subMenuMap;
    }

    public static Set getFunctionSet() {
        return functionSet;
    }

    public static void setFunctionSet(Set functionSet) {
        MenuVisitorHelper.functionSet = functionSet;
    }

    public static MainFunctionInfo getCacheMenu() {
        String fileName = MenuVisitorHelper.getCacheFileName();
        try {
            Locale l = SysContext.getSysContext().getLocale();
            return EASMainMenuCacheUtil.readCacheMenu(fileName, l);
        }
        catch (Exception e) {
            logger.info((Object)"get menu cache file error:", (Throwable)e);
            return null;
        }
    }

    public static ComMenuFunctionCollection getComFuncMenu() {
        String fileName = MenuVisitorHelper.getComFuncCacheFileName();
        try {
            Locale l = SysContext.getSysContext().getLocale();
            return EASMainMenuCacheUtil.readComFuncCache(fileName, l);
        }
        catch (Exception e) {
            logger.info((Object)("get menu cache file error:+++++++++++++++++++++" + e.getMessage()));
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static MainFunctionInfo getCacheMenuBySerial(String fileName) {
        MainFunctionInfo fInfo = null;
        FileInputStream fi = null;
        ObjectInputStream si = null;
        try {
            fi = new FileInputStream(fileName);
            si = new ObjectInputStream(fi);
            fInfo = (MainFunctionInfo)si.readObject();
        }
        catch (FileNotFoundException fe) {
            logger.info((Object)("menu cache file not found:" + fe.getMessage()));
        }
        catch (Exception e) {
            logger.info((Object)("get menu cache file error:" + e.getMessage()));
        }
        finally {
            try {
                if (si != null) {
                    si.close();
                }
            }
            catch (Exception fe) {}
            try {
                if (fi != null) {
                    fi.close();
                }
            }
            catch (Exception fe) {}
        }
        return fInfo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ComMenuFunctionCollection getComMenuFuncCacheBySerial(String fileName) {
        ComMenuFunctionCollection comInfo = null;
        FileInputStream fi = null;
        ObjectInputStream si = null;
        try {
            fi = new FileInputStream(fileName);
            si = new ObjectInputStream(fi);
            comInfo = (ComMenuFunctionCollection)si.readObject();
        }
        catch (FileNotFoundException fe) {
            logger.info((Object)("menu cache file not found:" + fe.getMessage()));
        }
        catch (Exception e) {
            logger.info((Object)("get menu cache file error:" + e.getMessage()));
        }
        finally {
            try {
                if (si != null) {
                    si.close();
                }
            }
            catch (Exception fe) {}
            try {
                if (fi != null) {
                    fi.close();
                }
            }
            catch (Exception fe) {}
        }
        return comInfo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static MainFunctionInfo get2CacheMenu() {
        String fileName = MenuVisitorHelper.get2CacheFileName();
        MainFunctionInfo fInfo = null;
        FileInputStream fi = null;
        ObjectInputStream si = null;
        try {
            fi = new FileInputStream(fileName);
            si = new ObjectInputStream(fi);
            fInfo = (MainFunctionInfo)si.readObject();
        }
        catch (FileNotFoundException fe) {
            logger.info((Object)("menu cache file not found:" + fe.getMessage()));
        }
        catch (Exception e) {
            logger.info((Object)("get menu cache file error:" + e.getMessage()));
        }
        finally {
            try {
                if (si != null) {
                    si.close();
                }
            }
            catch (Exception fe) {}
            try {
                if (fi != null) {
                    fi.close();
                }
            }
            catch (Exception fe) {}
        }
        return fInfo;
    }

    public static String getCachName4Prepare() {
        String localflag = SysContext.getSysContext().getLocale().toString();
        String userId = UIConfig.getUserId();
        return localflag + userId;
    }

    public static String getCachName() {
        String localflag = SysContext.getSysContext().getLocale().toString();
        String userName = SysContext.getSysContext().getUserName();
        return localflag + userName;
    }

    public static void writeCacheMenu(MainFunctionInfo fInfo) {
        String fileName = MenuVisitorHelper.getCacheFileName();
        try {
            Locale l = SysContext.getSysContext().getLocale();
            EASMainMenuCacheUtil.writeCacheMenu(fInfo, fileName, l);
        }
        catch (IOException e) {
            logger.error((Object)("write menu cache file error:" + e.getMessage()));
        }
    }

    public static void writeComFuncMenuCache(ComMenuFunctionCollection cols) {
        String fileName = MenuVisitorHelper.getComFuncCacheFileName();
        try {
            Locale l = SysContext.getSysContext().getLocale();
            EASMainMenuCacheUtil.writeComFuncCache(cols, fileName, l);
        }
        catch (IOException e) {
            logger.error((Object)("write menu cache file error:" + e.getMessage()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void writeCacheFile(Object fInfo, String fileName) {
        String cacheDir = fileName.substring(0, fileName.lastIndexOf("/"));
        FileOutputStream fo = null;
        ObjectOutputStream so = null;
        try {
            File cacheFile = new File(cacheDir);
            if (!cacheFile.exists()) {
                cacheFile.mkdirs();
            }
            fo = new FileOutputStream(fileName);
            so = new ObjectOutputStream(fo);
            so.writeObject(fInfo);
        }
        catch (FileNotFoundException fe) {
            logger.info((Object)"write menu cache file not found:", (Throwable)fe);
        }
        catch (Exception e) {
            logger.info((Object)"write menu cache file error:", (Throwable)e);
        }
        finally {
            if (so != null) {
                try {
                    so.close();
                }
                catch (Exception ex) {
                    logger.error((Object)"stream close error!");
                }
            }
            if (fo != null) {
                try {
                    fo.close();
                }
                catch (Exception ex) {
                    logger.error((Object)"stream close error!");
                }
            }
        }
    }

    public static void writeCacheMenuTimeForUser() {
        String fileName = MenuVisitorHelper.getCacheTimeFlagFileName();
        Properties prop = new Properties();
        prop = MenuVisitorHelper.loadPro(fileName);
        if (cachetiemfromtable == null) {
            String userId = SysContext.getSysContext().getCurrentUserInfo().getId().toString();
            try {
                IMenuCache icache = MenuCacheFactory.getRemoteInstance();
                cachetiemfromtable = icache.getCacheTimeByUserid(userId);
            }
            catch (BOSException e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
            }
        }
        if (cachetiemfromtable != null) {
            prop.setProperty("UserMenuCacheTime", cachetiemfromtable);
            MenuVisitorHelper.saveToPro(fileName, prop);
        }
    }

    public static void writeComFuncMenuCacheMenuTimeForUser() {
        String fileName = MenuVisitorHelper.getComMenuCacheTimeFlagFileName();
        Properties prop = new Properties();
        prop = MenuVisitorHelper.loadPro(fileName);
        if (comfunccachtimefromtable == null) {
            String userId = SysContext.getSysContext().getCurrentUserInfo().getId().toString();
            try {
                IMenuCache icache = MenuCacheFactory.getRemoteInstance();
                comfunccachtimefromtable = icache.getComFuncMenuCache(userId);
            }
            catch (BOSException e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
            }
        }
        prop.setProperty("UserComFuncMenuCacheVersion", CURRENT_USER_COM_FUNC_MENU_CACHE_VERSION);
        if (comfunccachtimefromtable != null) {
            prop.setProperty("UserComFuncMenuCacheTime", comfunccachtimefromtable);
            MenuVisitorHelper.saveToPro(fileName, prop);
        }
    }

    public static boolean iSWanttoGetUserCache(String userId) {
        String cachtime;
        boolean flag = true;
        String fileName = MenuVisitorHelper.getCacheTimeFlagFileName();
        Properties prop = new Properties();
        prop = MenuVisitorHelper.loadPro(fileName);
        String string = cachtime = prop.getProperty("UserMenuCacheTime") == null ? "" : prop.getProperty("UserMenuCacheTime");
        if (cachetiemfromtable == null) {
            MenuVisitorHelper.getServerCacheTimes();
        }
        if (null == cachetiemfromtable || cachetiemfromtable != null && !cachtime.equals(cachetiemfromtable)) {
            flag = false;
        }
        return flag;
    }

    private static void getServerCacheTimes() {
        String userId = SysContext.getSysContext().getCurrentUserInfo().getId().toString();
        try {
            Map serverCacheTimeMap = MenuCacheFactory.getRemoteInstance().getServerCacheTimes(userId);
            cachetiemfromtable = (String)serverCacheTimeMap.get("menuCacheTime");
            comfunccachtimefromtable = (String)serverCacheTimeMap.get("comFunctionMenuCatcheTime");
        }
        catch (Exception e) {
            logger.error((Object)"getServerCacheTimes:", (Throwable)e);
        }
    }

    public static boolean isNeedCache(String userId) {
        String version;
        String cachtime;
        boolean flag = true;
        String fileName = MenuVisitorHelper.getComMenuCacheTimeFlagFileName();
        Properties prop = new Properties();
        prop = MenuVisitorHelper.loadPro(fileName);
        String string = cachtime = prop.getProperty("UserComFuncMenuCacheTime") == null ? "" : prop.getProperty("UserComFuncMenuCacheTime");
        if (comfunccachtimefromtable == null) {
            MenuVisitorHelper.getServerCacheTimes();
        }
        if (null == comfunccachtimefromtable || comfunccachtimefromtable != null && !cachtime.equals(comfunccachtimefromtable)) {
            flag = false;
        }
        if (!CURRENT_USER_COM_FUNC_MENU_CACHE_VERSION.equals(version = prop.getProperty("UserComFuncMenuCacheVersion", ""))) {
            return false;
        }
        return flag;
    }

    private static String getCacheTimeFromLocal() {
        String fileName = MenuVisitorHelper.getCacheTimeFlagFileName();
        Properties prop = new Properties();
        prop = MenuVisitorHelper.loadPro(fileName);
        String cachtime = prop.getProperty("UserMenuCacheTime") == null ? "" : prop.getProperty("UserMenuCacheTime");
        return cachtime;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public static Properties loadPro(String profilepath) {
        File proFile = new File(profilepath);
        Properties properties = new Properties();
        FileInputStream inputStream = null;
        if (proFile.exists()) {
            try {
                File file = proFile;
                synchronized (file) {
                    inputStream = new FileInputStream(proFile);
                }
                properties.load(inputStream);
            }
            catch (FileNotFoundException e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
                StreamUtils.closeStream(inputStream);
            }
            catch (IOException e2) {
                logger.error((Object)e2.getMessage(), (Throwable)e2);
                {
                    catch (Throwable throwable) {
                        StreamUtils.closeStream(inputStream);
                        throw throwable;
                    }
                }
                StreamUtils.closeStream(inputStream);
            }
            StreamUtils.closeStream(inputStream);
        }
        return properties;
    }

    public static void mkDir(String fileName) {
        if (StringUtils.isEmpty((String)fileName)) {
            return;
        }
        String dir = fileName.substring(0, fileName.lastIndexOf("/"));
        File dirFile = new File(dir);
        if (!dirFile.exists()) {
            dirFile.mkdirs();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void saveToPro(String profilepath, Properties properties) {
        FileOutputStream fos = null;
        try {
            File updateFile = new File(profilepath);
            MenuVisitorHelper.mkDir(profilepath);
            if (updateFile.exists()) {
                updateFile.delete();
            }
            updateFile.createNewFile();
            File file = updateFile;
            synchronized (file) {
                fos = new FileOutputStream(updateFile);
                properties.store(fos, null);
            }
        }
        catch (FileNotFoundException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        catch (IOException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        finally {
            if (fos != null) {
                try {
                    fos.close();
                }
                catch (Exception ex) {
                    logger.error((Object)"stream close error!");
                }
            }
        }
    }

    public static String get2CacheFileName() {
        return MenuVisitorHelper.getCacheFileName();
    }

    public static String getCacheDir() {
        StringBuffer cacheFb = new StringBuffer();
        String dcNumber = SysContext.getSysContext().getDCNumber();
        String appserver = "localhost";
        try {
            String appserverStr = UIConfig.getUrl().toLowerCase();
            if (appserverStr.startsWith("tcp:")) {
                appserverStr = appserverStr.replaceAll("tcp:", "http:");
            }
            URL appserverUrl = new URL(appserverStr);
            appserver = appserverUrl.getHost();
        }
        catch (MalformedURLException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        String easclientRoot = System.getProperty("user.dir");
        cacheFb.append(easclientRoot);
        cacheFb.append("/cache/");
        cacheFb.append(appserver);
        cacheFb.append("/");
        cacheFb.append(dcNumber);
        cacheFb.append("/");
        cacheFb.append(MultiOrgsClientCacheImplUtil.getPathStrFromObjID((String)MenuVisitorHelper.getCachName()));
        cacheFb.append("/");
        cacheFb.append("/");
        return cacheFb.toString();
    }

    public static String getCacheFileName() {
        StringBuffer cacheFb = new StringBuffer();
        cacheFb.append(MenuVisitorHelper.getCacheDir());
        cacheFb.append(MenuVisitorHelper.getCacheFileNameWithoutDir());
        return cacheFb.toString();
    }

    public static String getComFuncCacheFileName() {
        StringBuffer cacheFb = new StringBuffer();
        cacheFb.append(MenuVisitorHelper.getCacheDir());
        cacheFb.append(MenuVisitorHelper.getComMenuCacheFileNameWithoutDir());
        return cacheFb.toString();
    }

    private static String getCacheFileNameWithoutDir() {
        return "menuCache.xml";
    }

    private static String getComMenuCacheFileNameWithoutDir() {
        return "comFuncMenuCache.xml";
    }

    public static String getCacheTimeFlagFileName() {
        StringBuffer cacheFb = new StringBuffer();
        cacheFb.append(MenuVisitorHelper.getCacheDir());
        cacheFb.append("menuCacheTime.properties");
        return cacheFb.toString();
    }

    public static String getComMenuCacheTimeFlagFileName() {
        StringBuffer cacheFb = new StringBuffer();
        cacheFb.append(MenuVisitorHelper.getCacheDir());
        cacheFb.append("comFuncMenuCacheTime.properties");
        return cacheFb.toString();
    }

    public static void buildMenuTree(KDTree tree) throws EASBizException, BOSException {
        MainFunctionInfo fInfo = MenuVisitorHelper.initMainMenuFunctionPermissions();
        MainMenuItemCollection topMenuCols = fInfo.getTopLeverMenuCollection();
        HashMap subMenuMap = fInfo.getSubItemMap();
        if (topMenuCols == null || topMenuCols.size() < 1) {
            return;
        }
        if (subMenuMap == null || subMenuMap.size() < 1) {
            return;
        }
        DefaultKingdeeTreeNode root = new DefaultKingdeeTreeNode((Object)"EAS");
        MainMenuItemInfo menuInfo = null;
        for (int i = 0; i < topMenuCols.size(); ++i) {
            menuInfo = topMenuCols.get(i);
            root.add((MutableTreeNode)((DefaultKingdeeTreeNode)MainMenuBuilder.buildSubSysTree2(menuInfo.getLongNumber())));
        }
        tree.setModel((TreeModel)new KingdeeTreeModel((TreeNode)root));
        MainMenuBuilder.filterUnVisibleNode(tree);
        tree.expandPath(new TreePath(root.getPath()));
        tree.setShowsRootHandles(true);
    }

    public static void buildAllMenuTree(KDTree tree) throws EASBizException, BOSException {
        DefaultKingdeeTreeNode root = new DefaultKingdeeTreeNode((Object)"EAS");
        IMainFunctionMenu iMainFunctionMenu = MainFunctionMenuFactory.getRemoteInstance();
        IRowSet rowset = iMainFunctionMenu.getSubSys();
        ArrayList<String> parentNM = new ArrayList<String>();
        try {
            while (rowset.next()) {
                String ln = rowset.getString("FLongNumber");
                parentNM.add(ln);
            }
        }
        catch (SQLException exc) {
            throw new BOSException((Throwable)exc);
        }
        TreeNode[] nodeList = MainMenuBuilder.buildSubSysTree2(MenuVisitorHelper.ListToArray(parentNM));
        if (nodeList != null && nodeList.length >= 1) {
            int length = nodeList.length;
            for (int i = 0; i < length; ++i) {
                root.add((MutableTreeNode)((DefaultKingdeeTreeNode)nodeList[i]));
            }
        }
        tree.setModel((TreeModel)new KingdeeTreeModel((TreeNode)root));
        tree.expandPath(new TreePath(root.getPath()));
        tree.setShowsRootHandles(true);
        tree.repaint();
    }

    public static void buildAllMenuTreeForMenuType(KDTree tree, String menutype) throws EASBizException, BOSException {
        DefaultKingdeeTreeNode root = new DefaultKingdeeTreeNode((Object)"EAS");
        IMainFunctionMenu iMainFunctionMenu = MainFunctionMenuFactory.getRemoteInstance();
        IRowSet rowset = iMainFunctionMenu.getSubSysForMenuType(menutype);
        ArrayList<String> parentNM = new ArrayList<String>();
        try {
            while (rowset.next()) {
                String ln = rowset.getString("FLongNumber");
                parentNM.add(ln);
            }
        }
        catch (SQLException exc) {
            throw new BOSException((Throwable)exc);
        }
        TreeNode[] nodeList = MainMenuBuilder.buildSubSysTreeForMenuType(MenuVisitorHelper.ListToArray(parentNM), menutype);
        if (nodeList != null && nodeList.length >= 1) {
            int length = nodeList.length;
            for (int i = 0; i < length; ++i) {
                root.add((MutableTreeNode)((DefaultKingdeeTreeNode)nodeList[i]));
            }
        }
        tree.setModel((TreeModel)new KingdeeTreeModel((TreeNode)root));
        tree.expandPath(new TreePath(root.getPath()));
        tree.setShowsRootHandles(true);
        tree.repaint();
    }

    public static void buildSimpleMenuTree(KDTree tree) throws EASBizException, BOSException {
        DefaultKingdeeTreeNode root = new DefaultKingdeeTreeNode((Object)"EAS");
        IMainFunctionMenu iMainFunctionMenu = MainFunctionMenuFactory.getRemoteInstance();
        IRowSet rowset = iMainFunctionMenu.getSubSys();
        ArrayList<String> parentNM = new ArrayList<String>();
        try {
            while (rowset.next()) {
                String ln = rowset.getString("FLongNumber");
                parentNM.add(ln);
            }
        }
        catch (SQLException exc) {
            throw new BOSException((Throwable)exc);
        }
        TreeNode[] nodeList = MainMenuBuilder.buildSimpleSubSysTree2(MenuVisitorHelper.ListToArray(parentNM));
        if (nodeList != null && nodeList.length >= 1) {
            int length = nodeList.length;
            for (int i = 0; i < length; ++i) {
                root.add((MutableTreeNode)((DefaultKingdeeTreeNode)nodeList[i]));
            }
        }
        tree.setModel((TreeModel)new KingdeeTreeModel((TreeNode)root));
        tree.expandPath(new TreePath(root.getPath()));
        tree.setShowsRootHandles(true);
        tree.repaint();
    }

    private static String[] ListToArray(List list) {
        String[] parentNm = null;
        if (list != null && list.size() >= 1) {
            int size = list.size();
            parentNm = new String[size];
            for (int i = 0; i < size; ++i) {
                parentNm[i] = (String)list.get(i);
            }
        }
        return parentNm;
    }

    protected static void buildFavoriteFunChildren(KDTree tree, DefaultKingdeeTreeNode parentTreeNode) throws Exception {
        if (tree == null || parentTreeNode == null) {
            return;
        }
        ComMenuFunctionInfo nodeData = (ComMenuFunctionInfo)parentTreeNode.getUserObject();
        if (nodeData == null) {
            return;
        }
        IMainFunctionMenu iMainFunctionMenu = MainFunctionMenuFactory.getRemoteInstance();
        IRowSet rowset = iMainFunctionMenu.getFavoriteFunctionbyParent(nodeData.getLongNumber());
        if (rowset != null) {
            rowset.next();
        }
        MenuVisitorHelper.buildFavoriteFunChildren(tree, parentTreeNode, rowset);
    }

    protected static void buildFavoriteFunChildren(KDTree tree, DefaultKingdeeTreeNode parentTreeNode, IRowSet rowset) throws Exception {
        Icon closedIcon = UIFrameResource.getCommonIcon("imgTree_bigfolder_close");
        Icon openIcon = UIFrameResource.getCommonIcon("imgTree_bigfolder_open");
        Icon leafIcon = UIFrameResource.getCommonIcon("imgTree_bigicon_end");
        if (tree == null || parentTreeNode == null || rowset == null) {
            return;
        }
        DefaultKingdeeTreeNode beforeTreeNode = parentTreeNode;
        while (rowset.next()) {
            ComMenuFunctionInfo nodeData = MenuVisitorHelper.createDatafromRSNew(rowset, functionSet);
            if (nodeData == null) continue;
            DefaultKingdeeTreeNode treeNode = null;
            if (nodeData.isDir()) {
                treeNode = new DefaultKingdeeTreeNode((Object)nodeData);
                if (nodeData.getLevel() == 2) {
                    treeNode.setCustomClosedIcon(closedIcon);
                    treeNode.setCustomOpenIcon(openIcon);
                }
            } else {
                treeNode = new DefaultKingdeeTreeNode((Object)nodeData, null, false, false);
                treeNode.setCustomIcon(leafIcon);
            }
            if (beforeTreeNode.getLevel() == 0) {
                int index = MenuVisitorHelper.getInsertIndex(beforeTreeNode, treeNode);
                MenuVisitorHelper.setParentData(treeNode, beforeTreeNode);
                tree.insertNodeInto((MutableTreeNode)treeNode, (MutableTreeNode)beforeTreeNode, index);
            } else {
                int curLevel = nodeData.getLevel();
                for (int beforeLevel = ((ComMenuFunctionInfo)beforeTreeNode.getUserObject()).getLevel(); beforeLevel >= curLevel; --beforeLevel) {
                    beforeTreeNode = (DefaultKingdeeTreeNode)beforeTreeNode.getParent();
                }
                int index = MenuVisitorHelper.getInsertIndex(beforeTreeNode, treeNode);
                MenuVisitorHelper.setParentData(treeNode, beforeTreeNode);
                tree.insertNodeInto((MutableTreeNode)treeNode, (MutableTreeNode)beforeTreeNode, index);
            }
            beforeTreeNode = treeNode;
        }
    }

    protected static void buildComFunChildrenWhithPerm(KDTree tree, DefaultKingdeeTreeNode parentTreeNode, IObjectCollection obc) throws Exception {
        Icon closedIcon = UIFrameResource.getCommonIcon("imgTree_bigfolder_close");
        Icon openIcon = UIFrameResource.getCommonIcon("imgTree_bigfolder_open");
        Icon leafIcon = UIFrameResource.getCommonIcon("imgTree_bigicon_end");
        if (tree == null || parentTreeNode == null || obc == null) {
            return;
        }
        DefaultKingdeeTreeNode beforeTreeNode = parentTreeNode;
        for (int i = 1; i < obc.size(); ++i) {
            ComMenuFunctionInfo nodeData = (ComMenuFunctionInfo)obc.getObject(i);
            DefaultKingdeeTreeNode treeNode = null;
            if (nodeData.isDir()) {
                treeNode = new DefaultKingdeeTreeNode((Object)nodeData);
                if (nodeData.getLevel() == 2) {
                    treeNode.setCustomClosedIcon(closedIcon);
                    treeNode.setCustomOpenIcon(openIcon);
                }
            } else {
                treeNode = new DefaultKingdeeTreeNode((Object)nodeData, null, false, false);
                treeNode.setCustomIcon(leafIcon);
            }
            if (beforeTreeNode.getLevel() == 0) {
                int index = MenuVisitorHelper.getInsertIndex(beforeTreeNode, treeNode);
                MenuVisitorHelper.setParentData(treeNode, beforeTreeNode);
                tree.insertNodeInto((MutableTreeNode)treeNode, (MutableTreeNode)beforeTreeNode, index);
            } else {
                int curLevel = nodeData.getLongNumber().split("!").length;
                for (int beforeLevel = ((ComMenuFunctionInfo)beforeTreeNode.getUserObject()).getLongNumber().split("!").length; beforeLevel >= curLevel; --beforeLevel) {
                    beforeTreeNode = (DefaultKingdeeTreeNode)beforeTreeNode.getParent();
                }
                int index = MenuVisitorHelper.getInsertIndex(beforeTreeNode, treeNode);
                MenuVisitorHelper.setParentData(treeNode, beforeTreeNode);
                tree.insertNodeInto((MutableTreeNode)treeNode, (MutableTreeNode)beforeTreeNode, index);
            }
            beforeTreeNode = treeNode;
        }
    }

    static void refreshFavoriteFunTreeNode(KDTree tree, DefaultKingdeeTreeNode parentTreeNode) throws Exception {
        MenuVisitorHelper.buildFavoriteFunChildren(tree, parentTreeNode);
    }

    static void refreshMenuTreeNode(DefaultKingdeeTreeNode parentTreeNode) throws EASBizException, BOSException {
        MainMenuBuilder.buildMenuTreeNode(parentTreeNode);
    }

    private static ComMenuFunctionInfo createDatafromRS(IRowSet rowset) throws Exception {
        ComMenuFunctionInfo nodeData = new ComMenuFunctionInfo();
        nodeData.setId(BOSUuid.read((String)rowset.getString("FID")));
        nodeData.setName(rowset.getString("FName_" + SysContext.getSysContext().getLocale().toString()));
        nodeData.setNumber(rowset.getString("FNumber"));
        nodeData.setDescription(rowset.getString("FDescription_" + SysContext.getSysContext().getLocale().toString()));
        nodeData.setLongNumber(rowset.getString("FLongNumber"));
        if (rowset.getString("FMenuFunctionID") != null) {
            MainMenuItemInfo menuItem = new MainMenuItemInfo();
            menuItem.setId(BOSUuid.read((String)rowset.getString("FMenuFunctionID")));
            menuItem.setOpenMethod(OpenMethod.getEnum(rowset.getInt("FOpenMethod")));
            nodeData.setMenuFunction(menuItem);
        }
        nodeData.setDir(rowset.getBoolean("FDir"));
        nodeData.setLevel(rowset.getInt("FLevel"));
        nodeData.setIsLeaf(rowset.getInt("FIsLeaf") != 0);
        int order = rowset.getInt("FOrder");
        nodeData.setOrder(order < 0 ? 0 : order);
        return nodeData;
    }

    private static ComMenuFunctionInfo createDatafromRSNew(IRowSet rowset, Set functionSet) throws Exception {
        String function = rowset.getString("FFunction");
        if (!StringUtils.isEmpty((String)function) && !functionSet.contains(function)) {
            return null;
        }
        ComMenuFunctionInfo nodeData = new ComMenuFunctionInfo();
        nodeData.setId(BOSUuid.read((String)rowset.getString("FID")));
        nodeData.setName(rowset.getString("FName_" + SysContext.getSysContext().getLocale().toString()));
        nodeData.setNumber(rowset.getString("FNumber"));
        nodeData.setDescription(rowset.getString("FDescription_" + SysContext.getSysContext().getLocale().toString()));
        nodeData.setLongNumber(rowset.getString("FLongNumber"));
        if (rowset.getString("FMenuFunctionID") != null) {
            MainMenuItemInfo menuItem = new MainMenuItemInfo();
            menuItem.setId(BOSUuid.read((String)rowset.getString("FMenuFunctionID")));
            boolean isreport = rowset.getBoolean("FIsReport");
            menuItem.setIsReport(isreport);
            menuItem.setUiClassName(rowset.getString("FUiClassName"));
            menuItem.setOpenMethod(OpenMethod.getEnum(rowset.getInt("FOpenMethod")));
            nodeData.setMenuFunction(menuItem);
        }
        nodeData.setDir(rowset.getBoolean("FDir"));
        nodeData.setLevel(rowset.getInt("FLevel"));
        nodeData.setIsLeaf(rowset.getInt("FIsLeaf") != 0);
        int order = rowset.getInt("FOrder");
        nodeData.setOrder(order < 0 ? 0 : order);
        return nodeData;
    }

    private static ComMenuFunctionInfo createNewRootData() {
        ComMenuFunctionInfo rootData = new ComMenuFunctionInfo();
        MainMenuItemInfo virtualMenu = new MainMenuItemInfo();
        virtualMenu.setId(BOSUuid.create((BOSObjectType)virtualMenu.getBOSType()));
        rootData.setMenuFunction(virtualMenu);
        UserInfo currUser = (UserInfo)SysContext.getSysContext().getCurrentUser();
        rootData.setUser(currUser);
        rootData.setNumber("root" + currUser.getNumber());
        rootData.setLongNumber(rootData.getNumber());
        rootData.setName("virtual root");
        rootData.setDir(true);
        rootData.setIsLeaf(false);
        rootData.setLevel(1);
        rootData.setOrder(0);
        return rootData;
    }

    private static void setParentData(DefaultKingdeeTreeNode node, DefaultKingdeeTreeNode parentNode) {
        if (node == null || node.getUserObject() == null || parentNode == null || parentNode.getUserObject() == null) {
            return;
        }
        ComMenuFunctionInfo nodeData = (ComMenuFunctionInfo)node.getUserObject();
        ComMenuFunctionInfo parentData = (ComMenuFunctionInfo)parentNode.getUserObject();
        nodeData.setParent(parentData);
    }

    private static String getString(String strKey) {
        return UIFrameResource.getString(strKey);
    }

    private static KDTree getTree(ActionEvent e) {
        JPopupMenu pm = (JPopupMenu)((Component)e.getSource()).getParent();
        return (KDTree)pm.getInvoker();
    }

    private static int getInsertIndex(DefaultKingdeeTreeNode parent, DefaultKingdeeTreeNode treeNode) {
        if (parent == null || treeNode == null) {
            return -1;
        }
        ComMenuFunctionInfo data = (ComMenuFunctionInfo)treeNode.getUserObject();
        for (int i = 0; i < parent.getChildCount() - 1; ++i) {
            DefaultKingdeeTreeNode currTreeNode = (DefaultKingdeeTreeNode)parent.getChildAt(i);
            DefaultKingdeeTreeNode nextTreeNode = (DefaultKingdeeTreeNode)parent.getChildAt(i + 1);
            ComMenuFunctionInfo currData = (ComMenuFunctionInfo)currTreeNode.getUserObject();
            ComMenuFunctionInfo nextData = (ComMenuFunctionInfo)nextTreeNode.getUserObject();
            if (data.getOrder() < currData.getOrder() || data.getOrder() >= nextData.getOrder()) continue;
            return i;
        }
        return parent.getChildCount();
    }

    private static MainMenuItemInfo fetchMenuItem(KDTree tree) {
        MainMenuItemInfo menuItem = MenuVisitorHelper.getMenuItem(tree);
        if (menuItem == null) {
            return null;
        }
        try {
            IMainMenuItem iMainMenuItem = MainMenuItemFactory.getRemoteInstance();
            menuItem = iMainMenuItem.getMainMenuItemInfo((IObjectPK)new ObjectUuidPK(menuItem.getId()));
        }
        catch (Exception e) {
            ExceptionHandler.handle((Component)tree, (Throwable)e);
        }
        return menuItem;
    }

    private static MainMenuItemInfo getMenuItem(KDTree tree) {
        if (tree == null) {
            return null;
        }
        DefaultKingdeeTreeNode node = (DefaultKingdeeTreeNode)tree.getLastSelectedPathComponent();
        if (node == null) {
            return null;
        }
        Object obj = node.getUserObject();
        ComMenuFunctionInfo nodeData = (ComMenuFunctionInfo)obj;
        if (nodeData == null || nodeData.isDir() || nodeData.getMenuFunction() == null || nodeData.getMenuFunction().getId() == null) {
            return null;
        }
        return nodeData.getMenuFunction();
    }

    private static void performOpenMethod(ActionEvent e, OpenMethod openMethod) {
        KDTree tree = MenuVisitorHelper.getTree(e);
        MainMenuItemInfo menuItem = MenuVisitorHelper.fetchMenuItem(tree);
        MainMenuTree.showUI((Component)tree, menuItem, openMethod);
    }

    public static void addFavPopupListener(KDTree tree, final String source) {
        tree.addMouseListener((MouseListener)new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getButton() == 3) {
                    KDTree tree = (KDTree)e.getSource();
                    if (tree.getClosestPath(e.getX(), e.getY()) == null) {
                        return;
                    }
                    MainMenuItemInfo menuItemInfo = MenuVisitorHelper.getMenuItem(tree);
                    if (menuItemInfo == null) {
                        return;
                    }
                    MenuVisitor menuVisitor = new MenuVisitor();
                    KDPopupMenu[] mnuFav = menuVisitor.getMyEasFavPopupMenu();
                    if (menuItemInfo.getOpenMethod() != OpenMethod.MODEL) {
                        if (source == MenuVisitorHelper.MYEAS) {
                            mnuFav[0].show((Component)e.getSource(), e.getX(), e.getY());
                        }
                    } else if (source == MenuVisitorHelper.MYEAS) {
                        mnuFav[1].show((Component)e.getSource(), e.getX(), e.getY());
                    }
                }
            }
        });
    }

    static KDPopupMenu[] getMainFavPopupMenu() {
        MenuVisitor menuVisitor = new MenuVisitor();
        return menuVisitor.getMainFavPopupMenu();
    }

    public static void showUIByOpenMethod(Component component, MainMenuItemInfo menuItem, OpenMethod openMethod) {
        MainMenuTree.showUI(component, menuItem, openMethod);
    }

    public static void setMenuCacheParam() {
        iswanttogetcache = null;
        cachetiemfromtable = null;
        comfunccachtimefromtable = null;
    }

    static {
        functionSet = null;
        cachetiemfromtable = null;
        iswanttogetcache = null;
        comfunccachtimefromtable = null;
    }

    static class MenuVisitor {
        private KDPopupMenu[] mnuFav = new KDPopupMenu[4];
        private Action[] actOpenMethod = new Action[5];

        public MenuVisitor() {
            this.initAction();
            this.initPopMenu();
        }

        private void initAction() {
            this.actOpenMethod[0] = new ActionOpenMethod(MenuVisitorHelper.getString("MainMenuTree.fixTab"), OpenMethod.FIXTAB);
            this.actOpenMethod[1] = new ActionOpenMethod(MenuVisitorHelper.getString("MainMenuTree.newTab"), OpenMethod.NEWTAB);
            this.actOpenMethod[2] = new ActionOpenMethod(MenuVisitorHelper.getString("MainMenuTree.newWin"), OpenMethod.NEWWIN);
            this.actOpenMethod[3] = new ActionOpenMethod(MenuVisitorHelper.getString("MainMenuTree.newSession"), OpenMethod.NEWSESSION);
            this.actOpenMethod[4] = new ActionOpenMethod(MenuVisitorHelper.getString("MainMenuTree.model"), OpenMethod.MODEL);
        }

        private void initPopMenu() {
            this.mnuFav[0] = new KDPopupMenu();
            this.mnuFav[0].add(this.actOpenMethod[0]);
            this.mnuFav[0].add(this.actOpenMethod[1]);
            this.mnuFav[0].add(this.actOpenMethod[2]);
            this.mnuFav[0].addSeparator();
            this.mnuFav[0].add(this.actOpenMethod[3]);
            this.mnuFav[1] = new KDPopupMenu();
            this.mnuFav[1].add(this.actOpenMethod[4]);
            this.mnuFav[2] = new KDPopupMenu();
            this.mnuFav[2].add(this.actOpenMethod[0]);
            this.mnuFav[2].add(this.actOpenMethod[1]);
            this.mnuFav[2].add(this.actOpenMethod[2]);
            this.mnuFav[2].addSeparator();
            this.mnuFav[2].add(this.actOpenMethod[3]);
            this.mnuFav[3] = new KDPopupMenu();
            this.mnuFav[3].add(this.actOpenMethod[4]);
        }

        public KDPopupMenu[] getMainFavPopupMenu() {
            KDPopupMenu[] result = new KDPopupMenu[]{this.mnuFav[2], this.mnuFav[3]};
            return result;
        }

        public KDPopupMenu[] getMyEasFavPopupMenu() {
            KDPopupMenu[] result = new KDPopupMenu[]{this.mnuFav[0], this.mnuFav[1]};
            return result;
        }
    }

    static class ActionOpenMethod
    extends AbstractAction {
        private OpenMethod openMethod;

        public ActionOpenMethod(String name, OpenMethod openMethod) {
            super(name);
            this.openMethod = openMethod;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            MenuVisitorHelper.performOpenMethod(e, this.openMethod);
        }
    }
}

