/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.uiframe.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.swing.KDLabel;
import com.kingdee.bos.ctrl.swing.KDMenu;
import com.kingdee.bos.ctrl.swing.KDMenuItem;
import com.kingdee.bos.ctrl.swing.KDPanel;
import com.kingdee.bos.ctrl.swing.KDPopupMenu;
import com.kingdee.bos.ctrl.swing.KDTextField;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.bos.util.backport.Collections;
import com.kingdee.eas.base.myeas.ComMenuFunctionCollection;
import com.kingdee.eas.base.myeas.ComMenuFunctionFactory;
import com.kingdee.eas.base.myeas.ComMenuFunctionInfo;
import com.kingdee.eas.base.myeas.PageTypeEnum;
import com.kingdee.eas.base.permission.MainMenuItemInfo;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.base.permission.util.ToolUtils;
import com.kingdee.eas.base.uiframe.FunctionLabel;
import com.kingdee.eas.base.uiframe.MyComFunctionFacadeFactory;
import com.kingdee.eas.base.uiframe.OpenMethod;
import com.kingdee.eas.base.uiframe.WorkBenchUtil;
import com.kingdee.eas.base.uiframe.client.AbstractMyComFunctionPanel;
import com.kingdee.eas.base.uiframe.client.Item;
import com.kingdee.eas.base.uiframe.client.MenuVisitorHelper;
import com.kingdee.eas.base.uiframe.client.MsgPanelUtil;
import com.kingdee.eas.base.uiframe.client.NewMainFrame;
import com.kingdee.eas.base.uiframe.client.NewMainFunctionMenuUI;
import com.kingdee.eas.base.uiframe.client.NewMenuVisitorHelper;
import com.kingdee.eas.base.uiframe.client.PageButton;
import com.kingdee.eas.base.uiframe.client.PageButtonActionListener;
import com.kingdee.eas.base.uiframe.client.PopupPanel;
import com.kingdee.eas.base.uiframe.client.UIFactoryHelper;
import com.kingdee.eas.base.uiframe.client.UIFrameUtil;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.util.EASCommonResource;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.ExceptionHandler;
import com.kingdee.util.STConverter;
import com.kingdee.util.StringUtils;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionAdapter;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import javax.swing.ImageIcon;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.MenuElement;
import javax.swing.MenuSelectionManager;
import javax.swing.Popup;
import javax.swing.PopupFactory;
import javax.swing.SwingUtilities;
import org.apache.log4j.Logger;

public class MyComFunctionPanel
extends AbstractMyComFunctionPanel {
    private static final Logger logger = Logger.getLogger(MyComFunctionPanel.class);
    private static final int FUNCTION_DIRVGAP = 8;
    private static final int BUTTON_WIDHT = 90;
    private static final int BUTTON_HEIGHT = 90;
    private static final int FUNCTION_DIRCOL = 5;
    private static final int FUNCTION_DIRROW = 2;
    private static final Locale l1 = new Locale("L1");
    private static final Locale l2 = new Locale("L2");
    private static final Locale l3 = new Locale("L3");
    private static Locale l;
    PopupPanel popupPanel;
    DirTextField tfDirName;
    KDPanel dirPanel;
    DirClicked1PopupMenu dirClicked1PopupMenu;
    boolean isTaskRun;
    Timer timer = new Timer();
    MouseEnteredTask task;
    int functionPageSize;
    int functionPageCount;
    int functionNumber;
    KDMenu importDirMenu;
    Clicked3PopupMenu clicked3PopupMenu;
    KDPopupMenu dirClicked3PopupMenu;
    boolean isShowClicked3PopupMenu;
    ComMenuFunctionCollection functionColl;
    Map<String, ComMenuFunctionCollection> comMenuFunction;
    FunctionLabel currentDirLabel;
    FunctionLabel currentLabel;
    FunctionLabel functionByRightKey;
    Popup tipPopup;
    boolean isTipHide;
    private boolean isMousePressed;
    ComMenuFunctionInfo functionRoot;
    private NewMainFunctionMenuUI ower = null;
    public static List<MyComFunctionPanel> myCommonUI;
    private boolean isAddComFunction = false;
    FunctionLabel needDeleteDirLabel;
    boolean isCurrentDirLabelClicked = false;

    public static void reloadAndRepaint() {
        for (MyComFunctionPanel comp : myCommonUI) {
            comp.setAddComFunction(true);
            comp.refresh();
            comp.repaint();
        }
    }

    public MyComFunctionPanel(NewMainFunctionMenuUI ower) {
        this.ower = ower;
        l = SysContext.getSysContext().getLocale();
        this.initPopupMenus();
        this.initPopupPanel();
        myCommonUI.add(this);
    }

    public void refresh() {
        if (this.isAddComFunction) {
            NewMenuVisitorHelper.getComMenuCache().clear();
            this.initFunctionColl();
            this.loadAppFunctionPanel();
            this.initComMenuUiCache();
            this.isAddComFunction = false;
        }
    }

    public void setAddComFunction(boolean isAddComFunction) {
        this.isAddComFunction = isAddComFunction;
    }

    private void addPageButtons(KDPanel pagePanel, int count) {
        for (int i = 1; i <= count; ++i) {
            this.addPageButton(pagePanel, i);
        }
    }

    private void addPageButton(KDPanel pagePanel, int number) {
        PageButton button = new PageButton(number);
        button.addActionListener(new FunctionPageButtonActionListener());
        pagePanel.add((Component)button);
    }

    private void addFunctionPageButton() {
        if (this.functionColl == null || this.functionColl.size() == 0) {
            this.applicationpanel.removeAll();
            this.applicationpanel.repaint();
            return;
        }
        if (this.functionPageSize == 0) {
            return;
        }
        this.functionPageCount = this.functionColl.size() % this.functionPageSize > 0 ? this.functionColl.size() / this.functionPageSize + 1 : this.functionColl.size() / this.functionPageSize;
        this.functionNumber = 1;
        this.addFunctionLabel(this.applicationpanel);
        this.appPagePanel.removeAll();
        this.addPageButtons(this.appPagePanel, this.functionPageCount);
        if (this.functionPageCount == 1) {
            this.appPagePanel.getComponent(0).setVisible(false);
        }
        this.repaint();
    }

    private ComMenuFunctionCollection getComFunctionByParent(String parentId) {
        if (this.comMenuFunction == null || this.comMenuFunction.size() == 0 || this.comMenuFunction.get(parentId) == null || this.comMenuFunction.get(parentId).size() == 0) {
            try {
                ComMenuFunctionCollection coll = NewMenuVisitorHelper.getComMenuCollection(parentId);
                return coll;
            }
            catch (Exception e) {
                logger.error((Object)e);
                return null;
            }
        }
        return this.comMenuFunction.get(parentId);
    }

    private void removeFromFunctionCacheMap(ComMenuFunctionInfo functionInfo) {
        if (this.comMenuFunction.size() == 0) {
            return;
        }
        if (functionInfo.isDir()) {
            this.comMenuFunction.remove(functionInfo.getId().toString());
            this.comMenuFunction.put(functionInfo.getId().toString(), new ComMenuFunctionCollection());
        } else {
            if (StringUtils.equals((String)this.getFunctionRoot().getId().toString(), (String)functionInfo.getParent().getId().toString())) {
                return;
            }
            Collection<ComMenuFunctionCollection> coll = this.comMenuFunction.values();
            for (ComMenuFunctionCollection comMenuFunctionColl : coll) {
                if (!comMenuFunctionColl.contains(functionInfo)) continue;
                comMenuFunctionColl.remove(functionInfo);
                break;
            }
        }
    }

    private void addToFunctionCacheMap(ComMenuFunctionInfo functionInfo, ComMenuFunctionCollection comMenuFunctionCollection) {
        ComMenuFunctionCollection coll = this.getComFunctionByParent(functionInfo.getId().toString());
        if (coll != null) {
            if (comMenuFunctionCollection == null) {
                return;
            }
            for (int i = 0; i < comMenuFunctionCollection.size(); ++i) {
                coll.add(comMenuFunctionCollection.get(i));
            }
        } else {
            this.comMenuFunction.put(functionInfo.getId().toString(), comMenuFunctionCollection);
        }
    }

    private int getFunctionMaxOrderByParent(String parentId) {
        try {
            return MyComFunctionFacadeFactory.getRemoteInstance().getChildMaxOrder(parentId);
        }
        catch (Exception e) {
            logger.error((Object)e);
            return 0;
        }
    }

    private ComMenuFunctionCollection getComFunctionByRoot() {
        try {
            ComMenuFunctionCollection coll = MyComFunctionFacadeFactory.getRemoteInstance().getFirstComFunction();
            this.comMenuFunction.put(this.getFunctionRoot().getId().toString(), coll);
            return coll;
        }
        catch (Exception e) {
            logger.error((Object)e);
            return new ComMenuFunctionCollection();
        }
    }

    private void setChildStatusByMouseEntered(FunctionLabel label) {
        label.setInColor(WorkBenchUtil.getDirPanelColor());
        label.setBorderColor(WorkBenchUtil.getChildBorderColorByMouseEntered());
        label.setBorderWidth(1.0f);
    }

    private void setChildStatusByMousePressed(FunctionLabel label) {
        label.setMousePressed(true);
        label.setInColor(WorkBenchUtil.getChildInColorByMousePressed());
        label.setBorderColor(WorkBenchUtil.getChildBorderColorByMouseEntered());
    }

    private void setCustomStatus(FunctionLabel label) {
        label.setInColor(null);
        label.setBorderColor(null);
        label.setMousePressed(false);
        label.setOpen(false);
    }

    private void setStatusByMouseEntered(FunctionLabel label) {
        label.setInColor(Color.decode("#F7F7F7"));
        label.setBorderColor(Color.decode("#C8C8C8"));
        label.setBorderWidth(1.0f);
    }

    private void setStatusByMouseSelected(FunctionLabel label) {
        label.setMousePressed(true);
        label.setInColor(Color.decode("#FFFDEF"));
        label.setBorderColor(Color.decode("#C8C8C8"));
    }

    private void setDirCustomStatus(FunctionLabel label) {
        label.setIcon(EASResource.getIcon((String)"image_folderA_1"));
        label.setOpen(false);
        label.setInColor(null);
    }

    private void setDirStatusByMouseSelected(FunctionLabel label) {
        label.setIcon(EASResource.getIcon((String)"image_folderA_2"));
        label.setOpen(true);
    }

    private void setDirStatusByAddChild(FunctionLabel label) {
        label.setInColor(new Color(230, 228, 219));
        label.setBorderColor(new Color(86, 98, 110));
        label.setBorderWidth(2.0f);
    }

    private void setOperatorPanelCustomStatus() {
        this.applicationpanel.setSelectLabel(null);
        this.applicationpanel.setPolygonColor(null);
        this.applicationpanel.setBg(null);
    }

    private void setOperatorPanelNewStatus(FunctionLabel label) {
        this.applicationpanel.setSelectLabel(label);
        this.applicationpanel.setBg(new Color(240, 242, 244));
        this.applicationpanel.setPolygonColor(WorkBenchUtil.getDirTextColor());
    }

    private ComMenuFunctionCollection getDirFuncctionColl(ComMenuFunctionInfo functionInfo) {
        ComMenuFunctionCollection dirFunctionColl = new ComMenuFunctionCollection();
        String id = "";
        if (functionInfo != null) {
            id = functionInfo.getId().toString();
        }
        for (int i = 0; i < this.functionColl.size(); ++i) {
            if (!this.functionColl.get(i).isDir() || StringUtils.equals((String)this.functionColl.get(i).getId().toString(), (String)id) || this.getFunctionCountByParent(this.functionColl.get(i).getId().toString()) >= 10) continue;
            dirFunctionColl.add(this.functionColl.get(i));
        }
        return dirFunctionColl;
    }

    private void storeDirFunctionName(ComMenuFunctionInfo functionInfo) {
        String name = this.tfDirName.getText().trim();
        functionInfo.setName(STConverter.tc2sc((String)name), l1);
        functionInfo.setName(STConverter.tc2sc((String)name), l2);
        functionInfo.setName(STConverter.sc2tc((String)name), l3);
        try {
            ComMenuFunctionFactory.getRemoteInstance().update((IObjectPK)new ObjectUuidPK(functionInfo.getId()), (CoreBaseInfo)functionInfo);
        }
        catch (Exception e) {
            logger.error((Object)e);
        }
    }

    private void newMouseClicked3(MouseEvent e) {
        FunctionLabel thisLabel = (FunctionLabel)((Object)e.getSource());
        if (this.dirClicked1PopupMenu.isVisible() && !StringUtils.equals((String)thisLabel.getParent().getName(), (String)"dirPanel")) {
            return;
        }
        if (thisLabel.isIsDir()) {
            this.dirClicked3PopupMenu.show((Component)e.getSource(), e.getX(), e.getY());
        } else {
            ComMenuFunctionCollection dirFunctionColl;
            ComMenuFunctionInfo functionInfo = null;
            if (this.currentDirLabel != null) {
                functionInfo = this.currentDirLabel.getMenu();
            }
            if ((dirFunctionColl = this.getDirFuncctionColl(functionInfo)).size() > 0) {
                this.functionByRightKey = thisLabel;
                this.getFunctionChildPopupMenu(dirFunctionColl);
                this.importDirMenu.setVisible(true);
                this.clicked3PopupMenu.setPreferredSize(new Dimension(this.clicked3PopupMenu.getWidth(), 125));
            } else {
                this.importDirMenu.setVisible(false);
                this.clicked3PopupMenu.setPreferredSize(new Dimension(this.clicked3PopupMenu.getWidth(), 100));
            }
            this.isShowClicked3PopupMenu = true;
            this.clicked3PopupMenu.show((Component)e.getSource(), e.getX(), e.getY());
        }
    }

    private void newMouseClicked2(MouseEvent e) {
        this.dirClicked1PopupMenu.setVisible(false);
        FunctionLabel thisLabel = (FunctionLabel)((Object)e.getSource());
        ComMenuFunctionInfo thisFunctionInfo = thisLabel.getMenu();
        if (thisFunctionInfo.isDir()) {
            return;
        }
        this.openUIbyFunction(thisFunctionInfo, null);
    }

    private boolean functionNewMouseClicked1(FunctionLabel thisLabel) {
        ComMenuFunctionInfo thisFunctionInfo = thisLabel.getMenu();
        ComMenuFunctionCollection childFunctionColl = this.getComFunctionByParent(thisFunctionInfo.getId().toString());
        if (childFunctionColl == null || childFunctionColl.size() == 0) {
            return false;
        }
        int childCount = childFunctionColl.size();
        this.setPanelSize(childCount, thisLabel);
        this.tfDirName.setText(thisFunctionInfo.getName());
        this.dirPanel.removeAll();
        for (int i = 0; i < childFunctionColl.size(); ++i) {
            FunctionLabel childLabel = new FunctionLabel(childFunctionColl.get(i), false);
            childLabel.setPreferredSize(new Dimension(90, 90));
            this.installListener(childLabel);
            childLabel.setForeground(new Color(255, 255, 255));
            this.dirPanel.add((Component)((Object)childLabel));
        }
        return true;
    }

    private void newMouseClicked1(MouseEvent e) {
        if (this.isCurrentDirLabelClicked) {
            this.isCurrentDirLabelClicked = false;
            return;
        }
        FunctionLabel thisLabel = (FunctionLabel)((Object)e.getSource());
        thisLabel.requestFocus();
        if (StringUtils.equals((String)thisLabel.getParent().getName(), (String)"dirPanel")) {
            this.hidePopupMenu();
            return;
        }
        if (!thisLabel.isIsDir()) {
            return;
        }
        this.currentDirLabel = thisLabel;
        if (!this.functionNewMouseClicked1(thisLabel)) {
            return;
        }
        this.showPopup(thisLabel);
        thisLabel.getParent().repaint();
    }

    private void showTipPopup(KDLabel label) {
        this.hideTipPopup();
        Point popupPanelLocation = this.popupPanel.getLocationOnScreen();
        Point tipPopupLocation = new Point(popupPanelLocation.x, popupPanelLocation.y - 20);
        this.tipPopup = PopupFactory.getSharedInstance().getPopup(this.currentDirLabel.getParent(), (Component)label, tipPopupLocation.x, tipPopupLocation.y);
        this.tipPopup.show();
        this.isTipHide = false;
    }

    private void showEnoughTipPopup(FunctionLabel functionLabel) {
        this.hideTipPopup();
        KDLabel label = new KDLabel(EASResource.getString((String)"com.kingdee.eas.base.uiframe.client.WorkBenchResource", (String)"DIRENOUGH"));
        label.setForeground(Color.RED);
        Point labelLocation = functionLabel.getLocationOnScreen();
        Point enoughtipPopup = new Point(labelLocation.x, labelLocation.y - 20);
        this.tipPopup = PopupFactory.getSharedInstance().getPopup(functionLabel.getParent(), (Component)label, enoughtipPopup.x, enoughtipPopup.y);
        this.tipPopup.show();
        this.isTipHide = false;
        TipTask task = new TipTask(functionLabel);
        this.timer.schedule((TimerTask)task, 2000L);
    }

    private boolean verifyDirNameLength(String name) {
        if (StringUtils.isEmpty((String)name)) {
            name = this.currentDirLabel.getText();
            this.tfDirName.setText(name);
        }
        if (name.length() > 40) {
            name = name.substring(0, 40);
            this.tfDirName.setText(name);
        }
        return true;
    }

    private boolean verifyIsDirNameChanged(String name) {
        if (this.currentDirLabel == null) {
            return false;
        }
        return !StringUtils.equals((String)this.currentDirLabel.getMenu().getName(l), (String)name);
    }

    private boolean verifyIsSameDirName(String name) {
        if (this.currentDirLabel == null) {
            return false;
        }
        if (this.isFunctionSameName(this.currentDirLabel.getMenu(), name)) {
            KDLabel label = new KDLabel(EASResource.getString((String)"com.kingdee.eas.base.uiframe.client.WorkBenchResource", (String)"SAMEDIRNAME"));
            label.setForeground(Color.RED);
            this.showTipPopup(label);
            return true;
        }
        return false;
    }

    private void hideTipPopup() {
        if (!this.isTipHide && this.tipPopup != null) {
            this.tipPopup.hide();
            this.isTipHide = true;
            this.tipPopup = null;
        }
    }

    public boolean hideDirPopup() {
        this.setCurrentDirLabelClicked();
        if (this.currentDirLabel == null) {
            return true;
        }
        this.hideTipPopup();
        Object thisParentPanel = this.currentDirLabel.getParent();
        String name = this.tfDirName.getText().trim();
        if (!this.verifyDirNameLength(name)) {
            return false;
        }
        if (thisParentPanel == null) {
            thisParentPanel = this.applicationpanel;
        }
        ComMenuFunctionInfo thisFunctionInfo = this.currentDirLabel.getMenu();
        if (this.verifyIsDirNameChanged(name)) {
            if (this.verifyIsSameDirName(name)) {
                return false;
            }
            this.storeDirFunctionName(thisFunctionInfo);
        }
        this.currentDirLabel.setText(this.tfDirName.getText().trim());
        ((Component)thisParentPanel).repaint();
        this.setDirCustomStatus(this.currentDirLabel);
        this.currentDirLabel.repaint();
        this.needDeleteDirLabel = this.currentDirLabel;
        this.currentDirLabel = null;
        this.setCurrentLabelCustomerStatus();
        this.setOperatorPanelCustomStatus();
        this.repaint();
        return true;
    }

    private void setPanelSize(int childCount, FunctionLabel thisLabel) {
        int rows = 0;
        rows = (thisLabel.getHeight() + 35) * childCount + 35 <= thisLabel.getParent().getWidth() ? 1 : (childCount % 5 == 0 ? childCount / 5 : childCount / 5 + 1);
        int height = (thisLabel.getHeight() + 8) * rows + 8;
        this.tfDirName.setSize(new Dimension(100, 21));
        this.dirPanel.setSize(new Dimension(thisLabel.getParent().getWidth(), height));
        this.popupPanel.setSize(new Dimension(this.dirPanel.getWidth(), this.tfDirName.getHeight() + this.dirPanel.getHeight()));
        this.popupPanel.setPreferredSize(new Dimension(this.dirPanel.getWidth(), this.tfDirName.getHeight() + this.dirPanel.getHeight()));
    }

    private void showPopup(FunctionLabel thisLabel) {
        int popupY;
        this.setCurrentLabelCustomerStatus();
        this.setDirStatusByMouseSelected(thisLabel);
        this.setOperatorPanelNewStatus(thisLabel);
        Point point = SwingUtilities.convertPoint(thisLabel.getParent(), thisLabel.getLocation(), (Component)((Object)this.applicationpanel));
        int popupX = 0;
        if (point.y + thisLabel.getHeight() + 5 + this.popupPanel.getHeight() > this.getHeight()) {
            popupY = thisLabel.getLocation().y - this.popupPanel.getHeight() - 5;
            this.applicationpanel.setDown(false);
            thisLabel.setDown(false);
        } else {
            popupY = thisLabel.getLocation().y + thisLabel.getHeight() + 5;
            this.applicationpanel.setDown(true);
            thisLabel.setDown(true);
        }
        this.dirClicked1PopupMenu.setBorder(null);
        this.dirClicked1PopupMenu.add((Component)((Object)this.popupPanel));
        this.dirClicked1PopupMenu.show(thisLabel.getParent(), popupX, popupY);
        this.dirClicked1PopupMenu.requestFocus();
    }

    private void hidePopupMenu() {
        if (this.clicked3PopupMenu.isVisible()) {
            this.clicked3PopupMenu.isUseHidePopupMenu = true;
            this.clicked3PopupMenu.setVisible(false);
        }
    }

    private void newMouseEntered(MouseEvent e) {
        FunctionLabel thisLabel = (FunctionLabel)((Object)e.getSource());
        if (StringUtils.equals((String)thisLabel.getParent().getName(), (String)"dirPanel")) {
            if (this.isMousePressed) {
                return;
            }
            if (!thisLabel.isMousePressed()) {
                this.setChildStatusByMouseEntered(thisLabel);
                thisLabel.repaint();
            }
        } else if (!(this.dirClicked1PopupMenu.isVisible() || thisLabel.isMousePressed() || this.isMousePressed)) {
            this.setStatusByMouseEntered(thisLabel);
            thisLabel.repaint();
        }
        if (!this.isMousePressed) {
            return;
        }
        if (this.currentLabel.isIsDir() || ToolUtils.equalObject((Object)((Object)this.currentLabel), (Object)((Object)thisLabel))) {
            return;
        }
        Container thisParentPanel = this.currentLabel.getParent();
        if (thisParentPanel == null) {
            this.setCurrentLabelCustomerStatus();
            return;
        }
        Point newPosition = SwingUtilities.convertPoint((Component)((Object)thisLabel), e.getPoint(), thisParentPanel);
        if (newPosition.x < 0 || newPosition.y < 0 || newPosition.x > thisParentPanel.getWidth() || newPosition.y > thisParentPanel.getHeight()) {
            return;
        }
        this.task = new MouseEnteredTask(thisLabel);
        this.timer.schedule((TimerTask)this.task, 400L);
    }

    private void newMouseExited(MouseEvent e) {
        FunctionLabel thisLabel = (FunctionLabel)((Object)e.getSource());
        if (!(thisLabel.isMousePressed() || this.dirClicked1PopupMenu.isVisible() && !StringUtils.equals((String)thisLabel.getParent().getName(), (String)"dirPanel"))) {
            thisLabel.setInColor(null);
            thisLabel.repaint();
        }
        if (this.task == null) {
            return;
        }
        this.task.cancel();
        this.timer.purge();
        this.isTaskRun = false;
    }

    private ComMenuFunctionInfo getFunctionRoot() {
        if (this.functionRoot == null) {
            try {
                this.functionRoot = MyComFunctionFacadeFactory.getRemoteInstance().getFunctionRoot();
            }
            catch (Exception e) {
                logger.error((Object)e);
            }
        }
        return this.functionRoot;
    }

    private void storeFunction2LastLocation(ComMenuFunctionInfo thisFunctionInfo, ComMenuFunctionInfo root) {
        this.removeFromFunctionCacheMap(thisFunctionInfo);
        thisFunctionInfo.setParent(root);
        thisFunctionInfo.setLevel(root.getLevel() + 1);
        thisFunctionInfo.setLongNumber(root.getLongNumber() + "!" + thisFunctionInfo.getNumber());
        try {
            ComMenuFunctionFactory.getRemoteInstance().update((IObjectPK)new ObjectUuidPK(thisFunctionInfo.getId()), (CoreBaseInfo)thisFunctionInfo);
        }
        catch (EASBizException e) {
            logger.error((Object)e);
        }
        catch (BOSException e) {
            logger.error((Object)e);
        }
    }

    private void processRemoveDir(Container parent, FunctionLabel dirFunctionLabel) {
        if (this.dirPanel.getComponentCount() == 1) {
            this.dirPanel.getComponent(0).setForeground(null);
            parent.add(this.dirPanel.getComponent(0), this.getButtonIndex(dirFunctionLabel));
        }
        parent.remove((Component)((Object)dirFunctionLabel));
        parent.validate();
        parent.repaint();
        dirFunctionLabel = null;
        this.dirClicked1PopupMenu.setVisible(false);
    }

    private void exchangeByDir2Desktop(int thisIndex, int newIndex) {
        Container parent = this.currentDirLabel.getParent();
        FunctionLabel newLabel = (FunctionLabel)((Object)parent.getComponent(parent.getComponentCount() - 1));
        Component[] childComponents = parent.getComponents();
        this.exchangeOrder(childComponents, this.currentDirLabel, newLabel, thisIndex, newIndex);
        this.exchangeOrder(childComponents, this.currentDirLabel, newLabel, newIndex - 1, newIndex);
    }

    private void functionByDir2Desktop(FunctionLabel thisLabel, Container thisParentPanel) {
        ComMenuFunctionInfo thisFunctionInfo = thisLabel.getMenu();
        ComMenuFunctionInfo thisFunctionParentInfo = this.currentDirLabel.getMenu();
        ComMenuFunctionInfo root = this.getFunctionRoot();
        if (root == null) {
            return;
        }
        int childCount = thisParentPanel.getComponentCount();
        if (childCount <= 1) {
            this.processRemoveDir((Container)((Object)this.applicationpanel), this.currentDirLabel);
        }
        if (this.applicationpanel.getComponentCount() >= this.functionPageSize) {
            int pageCount = (this.functionColl.size() + 1) % this.functionPageSize > 0 ? (this.functionColl.size() + 1) / this.functionPageSize + 1 : (this.functionColl.size() + 1) / this.functionPageSize;
            if (pageCount > this.functionPageCount) {
                ++this.functionPageCount;
                this.appPagePanel.getComponent(0).setVisible(true);
                this.addPageButton(this.appPagePanel, this.functionPageCount);
                this.appPagePanel.revalidate();
                this.appPagePanel.repaint();
            }
        } else {
            thisLabel.setForeground(new Color(0, 0, 0));
            this.applicationpanel.add((Component)((Object)thisLabel));
            this.applicationpanel.validate();
            this.applicationpanel.repaint();
        }
        this.removeFromFunctionCacheMap(thisFunctionInfo);
        this.processWhenRemove(thisFunctionInfo, childCount, thisFunctionParentInfo);
    }

    private String getFunctionGroup(Locale l) {
        return EASCommonResource.getString((String)"com.kingdee.eas.base.uiframe.client.WorkBenchResource", (String)"FUNCTIONGROUP", (Locale)l);
    }

    private String getDirName(String tmpName, int number) {
        return StringUtils.isEmpty((String)tmpName) ? null : tmpName + "(" + number + ")";
    }

    private ComMenuFunctionInfo createDirFunctionInfo(ComMenuFunctionInfo newFunctionInfo) {
        ComMenuFunctionInfo dirFunctionInfo = new ComMenuFunctionInfo();
        dirFunctionInfo.setParent(this.getFunctionRoot());
        int number = this.getDirFunctionMaxNumber();
        String tmpName_l1 = this.getFunctionGroup(l1);
        String tmpName_l2 = this.getFunctionGroup(l2);
        String tmpName_l3 = this.getFunctionGroup(l3);
        if (number == 10000) {
            // empty if block
        }
        if (number != -1) {
            tmpName_l1 = this.getDirName(tmpName_l1, number);
            tmpName_l2 = this.getDirName(tmpName_l2, number);
            tmpName_l3 = this.getDirName(tmpName_l3, number);
        }
        dirFunctionInfo.setName(tmpName_l1, l1);
        dirFunctionInfo.setName(tmpName_l2, l2);
        dirFunctionInfo.setName(tmpName_l3, l3);
        MainMenuItemInfo virtualMenu = new MainMenuItemInfo();
        virtualMenu.setId(BOSUuid.create((BOSObjectType)virtualMenu.getBOSType()));
        dirFunctionInfo.setMenuFunction(virtualMenu);
        UserInfo currUser = SysContext.getSysContext().getCurrentUserInfo();
        dirFunctionInfo.setUser(currUser);
        dirFunctionInfo.setNumber("#" + System.currentTimeMillis() + currUser.getNumber());
        dirFunctionInfo.setLongNumber(this.getFunctionRoot().getLongNumber() + "!" + dirFunctionInfo.getNumber());
        dirFunctionInfo.setOrder(newFunctionInfo.getOrder());
        dirFunctionInfo.setDir(true);
        dirFunctionInfo.setIsLeaf(false);
        dirFunctionInfo.setLevel(2);
        dirFunctionInfo.setPageType(PageTypeEnum.EXTERNAL_LINK_G);
        dirFunctionInfo.setFavextinfo(null);
        return dirFunctionInfo;
    }

    private void createDirPanel(FunctionLabel thisLabel, FunctionLabel newLabel, FunctionLabel dirLabel, String dirName) {
        this.installListener(dirLabel);
        this.tfDirName.setText(dirName);
        this.setPanelSize(2, newLabel);
        this.dirPanel.removeAll();
        FunctionLabel button1 = new FunctionLabel(newLabel.getMenu(), false);
        button1.setPreferredSize(new Dimension(90, 90));
        this.installListener(button1);
        button1.setForeground(new Color(255, 255, 255));
        this.dirPanel.add((Component)((Object)button1));
        this.installListener(thisLabel);
        thisLabel.setForeground(new Color(255, 255, 255));
        this.dirPanel.add((Component)((Object)thisLabel));
        int newButtonIndex = this.getButtonIndex(newLabel);
        Container newButtonParent = newLabel.getParent();
        Component[] allButtons = newButtonParent.getComponents();
        allButtons[newButtonIndex] = dirLabel;
        newButtonParent.removeAll();
        for (int i = 0; i < allButtons.length; ++i) {
            newButtonParent.add(allButtons[i]);
        }
        newButtonParent.validate();
        newButtonParent.repaint();
        this.currentDirLabel = dirLabel;
        this.showPopup(dirLabel);
    }

    private void functionInDesktop(FunctionLabel thisLabel, Container thisParentPanel, Point newPosition) {
        ComMenuFunctionInfo thisFunctionInfo = thisLabel.getMenu();
        Component c = thisParentPanel.getComponentAt(newPosition);
        if (c instanceof FunctionLabel) {
            FunctionLabel newLabel = (FunctionLabel)((Object)c);
            ComMenuFunctionInfo newFunctionInfo = newLabel.getMenu();
            if (ToolUtils.equalObject((Object)((Object)thisLabel), (Object)((Object)newLabel))) {
                return;
            }
            if (!this.isTaskRun || thisFunctionInfo.isDir()) {
                this.exchangeButtons(thisLabel, newLabel);
            } else if (!newFunctionInfo.isDir()) {
                newLabel.setBorder(null);
                ComMenuFunctionInfo dirFunctionInfo = this.createDirFunctionInfo(newFunctionInfo);
                FunctionLabel dirButton = new FunctionLabel(dirFunctionInfo, true);
                dirButton.setPreferredSize(new Dimension(90, 90));
                String dirName = dirFunctionInfo.getName();
                this.functionColl.remove(thisFunctionInfo);
                Container newButtonParent = newLabel.getParent();
                this.addLastFunction(newButtonParent);
                newButtonParent.validate();
                newButtonParent.repaint();
                this.createDirPanel(thisLabel, newLabel, dirButton, dirName);
                this.processWhenCreateDir(dirFunctionInfo, newFunctionInfo, thisFunctionInfo);
                this.functionColl = this.getComFunctionByRoot();
            } else {
                int childCount = this.getFunctionCountByParent(newFunctionInfo.getId().toString());
                if (childCount == 10) {
                    this.showEnoughTipPopup(newLabel);
                } else {
                    thisParentPanel.remove((Component)((Object)thisLabel));
                    this.storeFunctionInfo(newFunctionInfo, thisFunctionInfo);
                    this.functionColl = this.getComFunctionByRoot();
                    this.addLastFunction(thisParentPanel);
                    thisParentPanel.validate();
                    thisParentPanel.repaint();
                }
            }
        } else {
            if (thisParentPanel.getComponentCount() == 1) {
                return;
            }
            FunctionLabel newLabel = this.getNewLabel(thisLabel, thisParentPanel, newPosition);
            this.addButton2DesktopLast(thisLabel, thisParentPanel, newLabel);
        }
    }

    private void addButton2DesktopLast(FunctionLabel thisLabel, Container thisParentPanel, FunctionLabel newLabel) {
        if (newLabel == null) {
            newLabel = (FunctionLabel)((Object)thisParentPanel.getComponent(thisParentPanel.getComponentCount() - 1));
            if (!ToolUtils.equalObject((Object)thisParentPanel.getComponent(thisParentPanel.getComponentCount() - 2), (Object)((Object)thisLabel))) {
                this.exchangeButtons(thisLabel, newLabel);
            }
        }
        this.exchangeButtons(thisLabel, newLabel);
    }

    private void addLastFunction(Container parent) {
        int pageCount = 0;
        pageCount = this.functionColl.size() % this.functionPageSize > 0 ? this.functionColl.size() / this.functionPageSize + 1 : this.functionColl.size() / this.functionPageSize;
        if (pageCount < this.functionPageCount) {
            this.appPagePanel.remove(this.functionPageCount - 1);
            --this.functionPageCount;
            if (this.functionPageCount == 1) {
                this.appPagePanel.getComponent(0).setVisible(false);
            }
            this.appPagePanel.revalidate();
            this.appPagePanel.repaint();
        }
        if (this.functionNumber * this.functionPageSize - 1 >= this.functionColl.size()) {
            return;
        }
        ComMenuFunctionInfo lastFunctionInfo = this.functionColl.get(this.functionNumber * this.functionPageSize - 1);
        FunctionLabel lastButton = new FunctionLabel(lastFunctionInfo, lastFunctionInfo.isDir());
        lastButton.setPreferredSize(new Dimension(90, 90));
        this.installListener(lastButton);
        parent.add((Component)((Object)lastButton));
    }

    private void newMousePressed(MouseEvent e) {
        FunctionLabel thisButton = (FunctionLabel)((Object)e.getSource());
        this.setCurrentLabelCustomerStatus();
        this.isMousePressed = true;
        this.currentLabel = thisButton;
        if (StringUtils.equals((String)thisButton.getParent().getName(), (String)"dirPanel")) {
            this.setChildStatusByMousePressed(thisButton);
        } else {
            this.setStatusByMouseSelected(thisButton);
        }
        thisButton.repaint();
    }

    private Point getMousePointWhenMouseReleased(MouseEvent e, FunctionLabel thisLabel, Container thisParentPanel) {
        Point mousePosition = e.getPoint();
        Point newPosition = null;
        newPosition = StringUtils.equals((String)thisParentPanel.getName(), (String)"dirPanel") ? SwingUtilities.convertPoint((Component)((Object)thisLabel), mousePosition, (Component)((Object)this.popupPanel)) : SwingUtilities.convertPoint((Component)((Object)thisLabel), mousePosition, thisParentPanel);
        return newPosition;
    }

    private void newMouseReleased(MouseEvent e) {
        this.isMousePressed = false;
        this.popupPanel.reset();
        this.applicationpanel.reset();
        FunctionLabel thisLabel = (FunctionLabel)((Object)e.getSource());
        if (thisLabel.getParent() == null) {
            return;
        }
        Container thisParentPanel = thisLabel.getParent();
        Point newPosition = this.getMousePointWhenMouseReleased(e, thisLabel, thisParentPanel);
        if (newPosition == null) {
            return;
        }
        if (StringUtils.equals((String)thisParentPanel.getName(), (String)"dirPanel") && (newPosition.x < 0 || newPosition.y < 0 || newPosition.x > this.popupPanel.getWidth() || newPosition.y > this.popupPanel.getHeight())) {
            thisParentPanel.remove((Component)((Object)thisLabel));
            thisParentPanel.validate();
            thisParentPanel.repaint();
            this.functionByDir2Desktop(thisLabel, thisParentPanel);
        } else if (StringUtils.equals((String)thisParentPanel.getName(), (String)"dirPanel") && newPosition.x < this.popupPanel.getWidth() && newPosition.y < this.popupPanel.getHeight()) {
            Point mouseToParentPanel = SwingUtilities.convertPoint((Component)((Object)thisLabel), e.getPoint(), thisParentPanel);
            Component c = thisParentPanel.getComponentAt(mouseToParentPanel);
            if (c instanceof FunctionLabel) {
                FunctionLabel newButton = (FunctionLabel)((Object)c);
                if (ToolUtils.equalObject((Object)((Object)thisLabel), (Object)((Object)newButton))) {
                    return;
                }
                this.exchangeButtons(thisLabel, newButton);
            } else {
                FunctionLabel newButton = this.getNewLabel(thisLabel, thisParentPanel, newPosition);
                this.addButton2DesktopLast(thisLabel, thisParentPanel, newButton);
            }
        } else {
            if (newPosition.x < 0 || newPosition.y < 0 || newPosition.x > thisParentPanel.getWidth() || newPosition.y > thisParentPanel.getHeight()) {
                return;
            }
            this.functionInDesktop(thisLabel, thisParentPanel, newPosition);
        }
    }

    private FunctionLabel getNewLabel(FunctionLabel thisLabel, Container thisParentPanel, Point newLocation) {
        Component[] childComponents = thisParentPanel.getComponents();
        for (int i = 0; i < childComponents.length; ++i) {
            FunctionLabel tmp = (FunctionLabel)((Object)childComponents[i]);
            if (tmp.getLocation().x <= newLocation.x || tmp.getLocation().y >= newLocation.y || tmp.getLocation().y + thisLabel.getHeight() <= newLocation.y) continue;
            return tmp;
        }
        return null;
    }

    private int getDirFunctionMaxNumber() {
        ArrayList<Integer> tmpList = new ArrayList<Integer>();
        String name = EASCommonResource.getString((String)"com.kingdee.eas.base.uiframe.client.WorkBenchResource", (String)"FUNCTIONGROUP", (Locale)l);
        if (this.functionColl == null) {
            this.functionColl = this.getComFunctionByRoot();
        }
        if (this.functionColl.size() == 0) {
            return 10000;
        }
        for (int i = 0; i < this.functionColl.size(); ++i) {
            String functionName = this.functionColl.get(i).getName(l);
            tmpList.add(this.getSN(functionName, name));
        }
        return this.getMaxNumber(tmpList);
    }

    private int getSN(String name1, String name2) {
        if (name1.indexOf(name2) > -1) {
            String tmp = name1.substring(name1.indexOf(name2));
            int leftIndex = tmp.indexOf("(");
            if (leftIndex == -1) {
                return 0;
            }
            int rightIndex = tmp.indexOf(")");
            String number = tmp.substring(leftIndex + 1, rightIndex);
            return Integer.parseInt(number);
        }
        return -1;
    }

    private int getMaxNumber(List tmpList) {
        if (tmpList == null || tmpList.size() == 0) {
            return -1;
        }
        Object max = Collections.max((Collection)tmpList);
        int tmpNumber = 1;
        if (max instanceof Integer) {
            if ((Integer)max == -1) {
                return -1;
            }
            tmpNumber = (Integer)max + 1;
        }
        return tmpNumber;
    }

    private void newMouseDragged(MouseEvent e) {
        Point p;
        if (e.getButton() == 3) {
            return;
        }
        FunctionLabel thisButton = (FunctionLabel)((Object)e.getSource());
        Image image = null;
        if (thisButton.getIcon() instanceof ImageIcon) {
            image = ((ImageIcon)thisButton.getIcon()).getImage();
        }
        if (StringUtils.equals((String)thisButton.getParent().getName(), (String)"dirPanel")) {
            p = SwingUtilities.convertPoint((Component)((Object)thisButton), e.getPoint(), (Component)((Object)this.popupPanel));
            if (p.x > 0 && p.y > 0 && p.y < this.popupPanel.getHeight() && p.x < this.popupPanel.getWidth()) {
                this.applicationpanel.reset();
                this.popupPanel.drawImage(p.x, p.y, image);
                return;
            }
            this.popupPanel.reset();
        }
        p = SwingUtilities.convertPoint((Component)((Object)thisButton), e.getPoint(), (Component)((Object)this.applicationpanel));
        this.applicationpanel.drawImage(p.x, p.y, image);
    }

    private KDMenu getFunctionChildPopupMenu(ComMenuFunctionCollection dirFunctionColl) {
        this.importDirMenu.removeAll();
        for (int i = 0; i < dirFunctionColl.size(); ++i) {
            KDMenuItem tmp = new KDMenuItem();
            tmp.setText(dirFunctionColl.get(i).getName());
            tmp.setUserObject((Object)dirFunctionColl.get(i));
            tmp.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    KDMenuItem menu = (KDMenuItem)e.getSource();
                    ComMenuFunctionInfo dirFunctionInfo = (ComMenuFunctionInfo)menu.getUserObject();
                    if (MyComFunctionPanel.this.functionByRightKey == null) {
                        return;
                    }
                    ComMenuFunctionInfo functionInfo = MyComFunctionPanel.this.functionByRightKey.getMenu();
                    Container parent = MyComFunctionPanel.this.functionByRightKey.getParent();
                    parent.remove((Component)((Object)MyComFunctionPanel.this.functionByRightKey));
                    MyComFunctionPanel.this.removeFromFunctionCacheMap(functionInfo);
                    MyComFunctionPanel.this.storeFunctionInfo(dirFunctionInfo, functionInfo);
                    MyComFunctionPanel.this.removeFunctionFromDir(parent, functionInfo);
                }
            });
            this.importDirMenu.add((JMenuItem)tmp);
        }
        return this.importDirMenu;
    }

    private void removeFunctionFromDir(Container parent, ComMenuFunctionInfo functionInfo) {
        if (StringUtils.equals((String)parent.getName(), (String)"dirPanel")) {
            ComMenuFunctionInfo parentInfo = this.needDeleteDirLabel.getMenu();
            if (parent.getComponentCount() <= 1) {
                this.processRemoveDir((Container)((Object)this.applicationpanel), this.needDeleteDirLabel);
                this.updateChildWhenRemoveDir(parentInfo);
            } else {
                parent.validate();
                parent.repaint();
                return;
            }
        }
        this.functionColl = this.getComFunctionByRoot();
        if (this.applicationpanel.getComponentCount() == 0) {
            this.addFunctionPageButton();
        } else {
            this.addLastFunction((Container)((Object)this.applicationpanel));
        }
        this.applicationpanel.validate();
        this.applicationpanel.repaint();
    }

    private void installListener(FunctionLabel functionLabel) {
        functionLabel.addMouseMotionListener(new MouseMotionAdapter(){

            @Override
            public void mouseDragged(MouseEvent e) {
                MyComFunctionPanel.this.newMouseDragged(e);
            }
        });
        functionLabel.addMouseListener(new FunctionMouseListener());
    }

    private void addFunctionLabel(KDPanel parentPanel) {
        int startNumber;
        parentPanel.removeAll();
        int maxNumber = this.functionNumber * this.functionPageSize > this.functionColl.size() ? this.functionColl.size() : this.functionNumber * this.functionPageSize;
        for (int i = startNumber = (this.functionNumber - 1) * this.functionPageSize; i < maxNumber; ++i) {
            ComMenuFunctionInfo functionInfo = this.functionColl.get(i);
            FunctionLabel label = new FunctionLabel(functionInfo, functionInfo.isDir());
            label.setPreferredSize(new Dimension(90, 90));
            this.installListener(label);
            parentPanel.add((Component)((Object)label));
        }
        parentPanel.revalidate();
        parentPanel.repaint();
    }

    private int getButtonIndex(FunctionLabel button) {
        Container thisParentPanel = button.getParent();
        int buttonIndex = 0;
        Component[] allButtons = thisParentPanel.getComponents();
        for (int i = 0; i < allButtons.length; ++i) {
            if (!ToolUtils.equalObject((Object)allButtons[i], (Object)((Object)button))) continue;
            buttonIndex = i;
            break;
        }
        return buttonIndex;
    }

    private void exchangeOrder4backwardMoving(Component[] childComponents, FunctionLabel thisLabel, FunctionLabel newLabel, int thisIndex, int newIndex) {
        int newOrder = ((FunctionLabel)((Object)childComponents[newIndex - 1])).getMenu().getOrder();
        for (int i = newIndex - 1; i > thisIndex; --i) {
            FunctionLabel label1 = (FunctionLabel)((Object)childComponents[i - 1]);
            FunctionLabel label2 = (FunctionLabel)((Object)childComponents[i]);
            ComMenuFunctionInfo functionInfo1 = label1.getMenu();
            ComMenuFunctionInfo functionInfo2 = label2.getMenu();
            int order = functionInfo1.getOrder();
            functionInfo2.setOrder(order);
        }
        ComMenuFunctionInfo functionInfo = thisLabel.getMenu();
        functionInfo.setOrder(newOrder);
        for (int i = thisIndex; i < newIndex - 1; ++i) {
            childComponents[i] = childComponents[i + 1];
        }
        childComponents[newIndex - 1] = thisLabel;
    }

    private void exchangeOrder4forewardMoving(Component[] childComponents, FunctionLabel thisLabel, FunctionLabel newLabel, int thisIndex, int newIndex) {
        int newOrder = newLabel.getMenu().getOrder();
        for (int i = newIndex; i < thisIndex; ++i) {
            FunctionLabel label1 = (FunctionLabel)((Object)childComponents[i]);
            FunctionLabel label2 = (FunctionLabel)((Object)childComponents[i + 1]);
            ComMenuFunctionInfo functionInfo1 = label1.getMenu();
            ComMenuFunctionInfo functionInfo2 = label2.getMenu();
            int order = functionInfo2.getOrder();
            functionInfo1.setOrder(order);
        }
        ComMenuFunctionInfo functionInfo = thisLabel.getMenu();
        functionInfo.setOrder(newOrder);
        for (int i = thisIndex; i > newIndex; --i) {
            childComponents[i] = childComponents[i - 1];
        }
        childComponents[newIndex] = thisLabel;
    }

    private void exchangeOrder4nearMoving(Component[] childComponents, FunctionLabel thisLabel, FunctionLabel newLabel, int thisIndex, int newIndex) {
        childComponents[thisIndex] = newLabel;
        childComponents[newIndex] = thisLabel;
        ComMenuFunctionInfo functionInfo1 = newLabel.getMenu();
        ComMenuFunctionInfo functionInfo2 = thisLabel.getMenu();
        int order = functionInfo1.getOrder();
        functionInfo1.setOrder(functionInfo2.getOrder());
        functionInfo2.setOrder(order);
    }

    private void exchangeButtons(FunctionLabel thisButton, FunctionLabel newButton) {
        Container thisParentPanel = thisButton.getParent();
        Component[] allButtons = thisParentPanel.getComponents();
        int thisButtonIndex = this.getButtonIndex(thisButton);
        int buttonIndex = this.getButtonIndex(newButton);
        thisParentPanel.removeAll();
        this.exchangeOrder(allButtons, thisButton, newButton, thisButtonIndex, buttonIndex);
        for (int i = 0; i < allButtons.length; ++i) {
            thisParentPanel.add(allButtons[i]);
        }
        thisParentPanel.validate();
        this.storeNewOrder(thisParentPanel, thisButtonIndex, buttonIndex);
    }

    private void exchangeOrder(Component[] childComponents, FunctionLabel thisLabel, FunctionLabel newLabel, int thisIndex, int newIndex) {
        if (Math.abs(thisIndex - newIndex) == 0) {
            return;
        }
        if (Math.abs(thisIndex - newIndex) == 1) {
            this.exchangeOrder4nearMoving(childComponents, thisLabel, newLabel, thisIndex, newIndex);
        } else if (thisIndex < newIndex) {
            this.exchangeOrder4backwardMoving(childComponents, thisLabel, newLabel, thisIndex, newIndex);
        } else if (thisIndex > newIndex) {
            this.exchangeOrder4forewardMoving(childComponents, thisLabel, newLabel, thisIndex, newIndex);
        }
    }

    private int getFunctionCountByParent(String parentId) {
        try {
            return MyComFunctionFacadeFactory.getRemoteInstance().getChildCount(parentId);
        }
        catch (Exception e) {
            logger.equals(e);
            return 0;
        }
    }

    private void storeNewDirFunction(ComMenuFunctionInfo dirFunctionInfo) {
        try {
            IObjectPK pk = ComMenuFunctionFactory.getRemoteInstance().addnew(dirFunctionInfo);
            dirFunctionInfo.setId(BOSUuid.read((String)pk.toString()));
        }
        catch (Exception e) {
            logger.equals(e);
        }
    }

    private void storeFunctionInfo(ComMenuFunctionInfo dirFunctionInfo, ComMenuFunctionInfo functionInfo) {
        functionInfo.setParent(dirFunctionInfo);
        functionInfo.setLevel(dirFunctionInfo.getLevel() + 1);
        functionInfo.setOrder(this.getFunctionMaxOrderByParent(dirFunctionInfo.getId().toString()) + 1);
        functionInfo.setLongNumber(dirFunctionInfo.getLongNumber() + "!" + functionInfo.getNumber());
        try {
            ComMenuFunctionFactory.getRemoteInstance().update((IObjectPK)new ObjectUuidPK(functionInfo.getId()), (CoreBaseInfo)functionInfo);
            if (dirFunctionInfo.getParent() != null) {
                ComMenuFunctionCollection coll = new ComMenuFunctionCollection();
                coll.add(functionInfo);
                this.addToFunctionCacheMap(dirFunctionInfo, coll);
            } else {
                this.removeFromFunctionCacheMap(functionInfo);
            }
        }
        catch (Exception e) {
            logger.equals(e);
        }
    }

    private void storeFunctionNewOrder(ComMenuFunctionCollection coll, Container parent) {
        try {
            MyComFunctionFacadeFactory.getRemoteInstance().storeNewFunctionOrder(coll);
            if (StringUtils.equals((String)parent.getName(), (String)"dirPanel")) {
                if (coll == null || coll.size() == 0 || this.currentDirLabel == null) {
                    return;
                }
                ComMenuFunctionInfo parentInfo = this.currentDirLabel.getMenu();
                ComMenuFunctionCollection cmfc = this.comMenuFunction.get(parentInfo.getId().toString());
                this.sortByOrder(cmfc);
            } else {
                this.sortByOrder(this.functionColl);
            }
        }
        catch (Exception e) {
            logger.equals(e);
        }
    }

    private void sortByOrder(ComMenuFunctionCollection cmfc) {
        for (int i = 0; i < cmfc.size(); ++i) {
            for (int j = cmfc.size() - 1; j > 0; --j) {
                if (cmfc.get(j).getOrder() >= cmfc.get(j - 1).getOrder()) continue;
                ComMenuFunctionInfo tmpInfo = cmfc.get(j);
                cmfc.setObject(j, (IObjectValue)cmfc.get(j - 1));
                cmfc.addObject(j - 1, (IObjectValue)tmpInfo);
            }
        }
    }

    private ComMenuFunctionCollection getNearFunctionNeedUpdate(Container parentPanel, int oldIndex, int newIndex) {
        Component[] childComponents = parentPanel.getComponents();
        ComMenuFunctionCollection tmpColl = new ComMenuFunctionCollection();
        Component button1 = childComponents[oldIndex];
        Component button2 = childComponents[newIndex];
        ComMenuFunctionInfo functionInfo1 = ((FunctionLabel)((Object)button1)).getMenu();
        ComMenuFunctionInfo functionInfo2 = ((FunctionLabel)((Object)button2)).getMenu();
        ComMenuFunctionInfo tmpFunction1 = new ComMenuFunctionInfo();
        ComMenuFunctionInfo tmpFunction2 = new ComMenuFunctionInfo();
        tmpFunction1.setId(functionInfo1.getId());
        tmpFunction1.setOrder(functionInfo1.getOrder());
        tmpColl.add(tmpFunction1);
        tmpFunction2.setId(functionInfo2.getId());
        tmpFunction2.setOrder(functionInfo2.getOrder());
        tmpColl.add(tmpFunction2);
        return tmpColl;
    }

    private ComMenuFunctionCollection getBackwardFunctionNeedUpdate(Container parentPanel, int oldIndex, int newIndex) {
        Component[] childComponents = parentPanel.getComponents();
        ComMenuFunctionCollection tmpColl = new ComMenuFunctionCollection();
        for (int i = oldIndex; i < newIndex; ++i) {
            FunctionLabel tmp = (FunctionLabel)((Object)childComponents[i]);
            ComMenuFunctionInfo functionInfo = tmp.getMenu();
            ComMenuFunctionInfo tmpFunction = new ComMenuFunctionInfo();
            tmpFunction.setId(functionInfo.getId());
            tmpFunction.setOrder(functionInfo.getOrder());
            tmpColl.add(tmpFunction);
        }
        return tmpColl;
    }

    private ComMenuFunctionCollection getForewardFunctionNeedUpdate(Container parentPanel, int oldIndex, int newIndex) {
        Component[] childComponents = parentPanel.getComponents();
        ComMenuFunctionCollection tmpColl = new ComMenuFunctionCollection();
        for (int i = newIndex; i <= oldIndex; ++i) {
            FunctionLabel tmp = (FunctionLabel)((Object)childComponents[i]);
            ComMenuFunctionInfo functionInfo = tmp.getMenu();
            ComMenuFunctionInfo tmpFunction = new ComMenuFunctionInfo();
            tmpFunction.setId(functionInfo.getId());
            tmpFunction.setOrder(functionInfo.getOrder());
            tmpColl.add(tmpFunction);
        }
        return tmpColl;
    }

    private ComMenuFunctionCollection getFunctionNeedUpdate(Container parentPanel, int oldIndex, int newIndex) {
        if (Math.abs(oldIndex - newIndex) == 1) {
            return this.getNearFunctionNeedUpdate(parentPanel, oldIndex, newIndex);
        }
        if (oldIndex > newIndex) {
            return this.getForewardFunctionNeedUpdate(parentPanel, oldIndex, newIndex);
        }
        return this.getBackwardFunctionNeedUpdate(parentPanel, oldIndex, newIndex);
    }

    private void storeNewOrder(Container parentPanel, int oldIndex, int newIndex) {
        if (Math.abs(oldIndex - newIndex) == 0) {
            return;
        }
        ComMenuFunctionCollection coll = this.getFunctionNeedUpdate(parentPanel, oldIndex, newIndex);
        this.storeFunctionNewOrder(coll, parentPanel);
    }

    private String getResource(String resName) {
        return EASResource.getString((String)"com.kingdee.eas.base.uiframe.client.WorkBenchResource", (String)resName);
    }

    private void initPopupMenus() {
        this.dirClicked1PopupMenu = new DirClicked1PopupMenu();
        this.dirClicked1PopupMenu.setLightWeightPopupEnabled(false);
        this.clicked3PopupMenu = new Clicked3PopupMenu();
        this.clicked3PopupMenu.setLightWeightPopupEnabled(false);
        KDMenuItem fixTabMenu = new KDMenuItem(this.getResource("fixTab"));
        KDMenuItem newTabMenu = new KDMenuItem(this.getResource("newTab"));
        KDMenuItem newWinMenu = new KDMenuItem(this.getResource("newWin"));
        KDMenuItem removeMenu = new KDMenuItem(this.getResource("remove"));
        KDMenuItem removeDirMenu = new KDMenuItem(this.getResource("removeDir"));
        fixTabMenu.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MyComFunctionPanel.this.fixTabAction_actionPerformed(e);
            }
        });
        newTabMenu.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MyComFunctionPanel.this.newTabAction_actionPerformed(e);
            }
        });
        newWinMenu.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MyComFunctionPanel.this.newWinAction_actionPerformed(e);
            }
        });
        removeMenu.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MyComFunctionPanel.this.removeAction_actionPerformed(e);
            }
        });
        removeDirMenu.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MyComFunctionPanel.this.removeDirAction_actionPerformed(e);
            }
        });
        this.clicked3PopupMenu.add((JMenuItem)fixTabMenu);
        this.clicked3PopupMenu.add((JMenuItem)newTabMenu);
        this.clicked3PopupMenu.add((JMenuItem)newWinMenu);
        this.clicked3PopupMenu.addSeparator();
        this.clicked3PopupMenu.add((JMenuItem)removeMenu);
        this.clicked3PopupMenu.addSeparator();
        this.importDirMenu = new KDMenu(EASResource.getString((String)"com.kingdee.eas.base.uiframe.client.WorkBenchResource", (String)"IMPORTDIR"));
        this.importDirMenu.getPopupMenu().setLightWeightPopupEnabled(false);
        this.clicked3PopupMenu.add((JMenuItem)this.importDirMenu);
        this.dirClicked3PopupMenu = new KDPopupMenu();
        this.dirClicked3PopupMenu.setLightWeightPopupEnabled(false);
        this.dirClicked3PopupMenu.add((JMenuItem)removeDirMenu);
    }

    public void load() {
        this.initFunctionColl();
        if (this.functionColl == null || this.functionColl.size() == 0) {
            this.addTipLabel();
            return;
        }
        this.loadAppFunctionPanel();
        this.initComMenuUiCache();
    }

    private void initComMenuUiCache() {
        try {
            for (int initUiNumber = 0; this.functionColl.get(initUiNumber) != null && initUiNumber < 10; ++initUiNumber) {
                String uiClassName = this.functionColl.get(initUiNumber).getMenuFunction().getUiClassName();
                if (StringUtils.isEmpty((String)uiClassName)) continue;
                UIContext uiContext = new UIContext((Object)this);
                String[] pkAndClassName = UIFactoryHelper.getMetaDataPkAndClassName(uiClassName, (Map)uiContext);
                String metaDataPK = pkAndClassName[0];
                uiClassName = pkAndClassName[1];
                String key0 = UIFactoryHelper.createKey0(metaDataPK, uiClassName);
                UIFactoryHelper.getUIFactoryHelperThread().add(new Item(key0, metaDataPK, uiClassName));
            }
        }
        catch (Exception e) {
            logger.error((Object)e);
        }
    }

    private void initFunctionColl() {
        long t1 = System.currentTimeMillis();
        logger.error((Object)("load comFuntion -- t1=" + t1));
        ComMenuFunctionInfo root = this.getFunctionRoot();
        if (root == null) {
            return;
        }
        NewMenuVisitorHelper.initComMenuCache();
        this.comMenuFunction = new HashMap<String, ComMenuFunctionCollection>();
        this.comMenuFunction = NewMenuVisitorHelper.getComMenuCache();
        this.functionColl = this.comMenuFunction.get(root.getId().toString());
        logger.error((Object)("load comFuntion ----cost = " + (System.currentTimeMillis() - t1)));
    }

    private void loadAppFunctionPanel() {
        this.applicationpanel.removeAll();
        this.applicationpanel.setLayout(new FlowLayout(0, 35, 15));
        this.addOnAppFunctionPanel(this.applicationpanel);
        this.installListener4ApplicationPanel();
    }

    private void installListener4ApplicationPanel() {
        this.applicationpanel.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
                KDPanel panel = (KDPanel)e.getSource();
                MyComFunctionPanel.this.addOnAppFunctionPanel(panel);
            }
        });
        this.applicationpanel.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                MyComFunctionPanel.this.setCurrentLabelCustomerStatus();
            }
        });
    }

    private void addTipLabel() {
        KDLabel tipLabel = new KDLabel();
        tipLabel.setText(EASResource.getString((String)"com.kingdee.eas.base.uiframe.client.WorkBenchResource", (String)"functionTip"));
        tipLabel.setFont(new Font(null, 0, 24));
        tipLabel.setForeground(new Color(145, 181, 210));
        tipLabel.setHorizontalAlignment(0);
        tipLabel.setVerticalAlignment(0);
        this.applicationpanel.setLayout(new BorderLayout());
        this.applicationpanel.add((Component)tipLabel, "Center");
    }

    private void addOnAppFunctionPanel(KDPanel panel) {
        boolean isShowBossGzhTip;
        this.functionPageSize = this.getPageSize(panel, 125, 105);
        this.addFunctionPageButton();
        if (MsgPanelUtil.isMsgPanelVisible() && this.applicationpanel.getComponentCount() > 0) {
            this.applicationpanel.getComponent(0).addComponentListener(new ComponentAdapter(){

                @Override
                public void componentMoved(ComponentEvent e) {
                    NewMainFrame mainFrame;
                    if (!MsgPanelUtil.isMsgPanelVisible()) {
                        return;
                    }
                    Component c = (Component)e.getSource();
                    Frame frame = UIFrameUtil.getCurrMainFrame((Component)((Object)MyComFunctionPanel.this.applicationpanel));
                    if (frame instanceof NewMainFrame && (mainFrame = (NewMainFrame)((Object)frame)).getGuideMsgPanel() instanceof NewMainFrame.CreateDirMsgPanel) {
                        Point p = SwingUtilities.convertPoint((Component)((Object)MyComFunctionPanel.this.applicationpanel), c.getLocation(), (Component)((Object)mainFrame));
                        mainFrame.showGuideMsgLocation(p.x - 30, p.y + 60);
                    }
                }
            });
        }
        if (!(isShowBossGzhTip = MsgPanelUtil.getBossGzhHidden()) && this.applicationpanel.getComponentCount() > 0) {
            this.applicationpanel.getComponent(0).addComponentListener(new ComponentAdapter(){

                @Override
                public void componentMoved(ComponentEvent e) {
                    Component c = (Component)e.getSource();
                    Frame frame = UIFrameUtil.getCurrMainFrame((Component)((Object)MyComFunctionPanel.this.applicationpanel));
                    if (frame instanceof NewMainFrame) {
                        NewMainFrame mainFrame = (NewMainFrame)((Object)frame);
                        mainFrame.showBossGzhTip();
                    }
                }
            });
        }
    }

    private void initTfDirName() {
        this.tfDirName = new DirTextField();
        this.tfDirName.setOpaque(false);
        this.tfDirName.setPreferredSize(new Dimension(100, 21));
        this.tfDirName.setBorder(null);
        this.tfDirName.setForeground(Color.WHITE);
        this.tfDirName.setSelectAllOnFocus(false);
        this.tfDirName.setFont(new Font(null, 1, 13));
        this.tfDirName.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent e) {
                MyComFunctionPanel.this.hidePopupMenu();
                MyComFunctionPanel.this.setCurrentLabelCustomerStatus();
                DirTextField textField = (DirTextField)((Object)e.getSource());
                textField.isFocus = true;
                textField.repaint();
            }

            @Override
            public void focusLost(FocusEvent e) {
                DirTextField textField = (DirTextField)((Object)e.getSource());
                MyComFunctionPanel.this.hideTipPopup();
                if (!MyComFunctionPanel.this.verifyDirNameLength(textField.getText())) {
                    return;
                }
                if (MyComFunctionPanel.this.verifyIsDirNameChanged(textField.getText()) && MyComFunctionPanel.this.verifyIsSameDirName(textField.getText())) {
                    return;
                }
                textField.isFocus = false;
                textField.repaint();
            }
        });
    }

    private void initDirPanel() {
        this.dirPanel = new KDPanel();
        this.dirPanel.setBackground(WorkBenchUtil.getDirPanelColor());
        this.dirPanel.setName("dirPanel");
        this.dirPanel.setLayout((LayoutManager)new FlowLayout(0, 35, 8));
        this.dirPanel.addMouseListener((MouseListener)new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                MyComFunctionPanel.this.hidePopupMenu();
                MyComFunctionPanel.this.setCurrentLabelCustomerStatus();
                MyComFunctionPanel.this.dirPanel.requestFocus();
            }
        });
    }

    private void initPopupPanel() {
        this.initTfDirName();
        this.initDirPanel();
        this.popupPanel = new PopupPanel();
        this.popupPanel.setLayout(new BorderLayout());
        this.popupPanel.add((Component)((Object)this.tfDirName), "North");
        this.popupPanel.add((Component)this.dirPanel, "Center");
    }

    private void setCurrentLabelCustomerStatus() {
        if (this.currentLabel != null) {
            this.setCustomStatus(this.currentLabel);
            this.isMousePressed = false;
            this.currentLabel.repaint();
            this.currentLabel = null;
            this.applicationpanel.reset();
        }
    }

    private int getPageSize(KDPanel panel, int w, int h) {
        int panelWidth = panel.getWidth();
        int panelHeight = panel.getHeight();
        int cols = panelWidth / w;
        int rows = panelHeight / h;
        return cols * rows;
    }

    private boolean isFunctionSameName(ComMenuFunctionInfo functionInfo, String name) {
        for (int i = 0; i < this.functionColl.size(); ++i) {
            if (StringUtils.equals((String)this.functionColl.get(i).getId().toString(), (String)functionInfo.getId().toString()) || !StringUtils.equalsIgnoreCase((String)this.functionColl.get(i).getName(), (String)name)) continue;
            return true;
        }
        return false;
    }

    private void removeFunctionFromDB(ComMenuFunctionInfo functionInfo) {
        try {
            String filterInfo = "fid = '" + functionInfo.getId().toString() + "'";
            MyComFunctionFacadeFactory.getRemoteInstance().deleteFunction(filterInfo);
            this.removeFromFunctionCacheMap(functionInfo);
        }
        catch (Exception e) {
            logger.error((Object)e);
        }
    }

    private void updateChildWhenRemoveDir(ComMenuFunctionInfo thisFunctionParentInfo) {
        try {
            ComMenuFunctionFactory.getRemoteInstance().removeDirWhenOneChild(thisFunctionParentInfo.getId().toString());
            this.removeFromFunctionCacheMap(thisFunctionParentInfo);
        }
        catch (Exception e) {
            logger.error((Object)EASResource.getString((String)"com.kingdee.eas.base.uiframe.UIFRAMEAutoGenerateResource", (String)"53_MyComFunctionPanel"));
            logger.error((Object)e);
        }
    }

    private void removeDirFunctionFromDB(ComMenuFunctionInfo functionInfo) {
        try {
            this.currentDirLabel = null;
            String filterInfo = "fid = '" + functionInfo.getId().toString() + "' or fparentid = '" + functionInfo.getId().toString() + "'";
            MyComFunctionFacadeFactory.getRemoteInstance().deleteFunction(filterInfo);
            this.removeFromFunctionCacheMap(functionInfo);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected void openUIbyFunction(ComMenuFunctionInfo functionInfo, OpenMethod model) {
        try {
            MenuVisitorHelper.showUIByOpenMethod((Component)((Object)this), functionInfo.getMenuFunction(), model);
        }
        catch (Exception e) {
            ExceptionHandler.handle((Component)((Object)this), (Throwable)e);
        }
    }

    public void fixTabAction_actionPerformed(ActionEvent e) {
        JPopupMenu menu = (JPopupMenu)((JMenuItem)e.getSource()).getParent();
        FunctionLabel functionLabel = (FunctionLabel)((Object)menu.getInvoker());
        this.openUIbyFunction(functionLabel.getMenu(), OpenMethod.FIXTAB);
    }

    public void newTabAction_actionPerformed(ActionEvent e) {
        JPopupMenu menu = (JPopupMenu)((JMenuItem)e.getSource()).getParent();
        FunctionLabel functionLabel = (FunctionLabel)((Object)menu.getInvoker());
        this.openUIbyFunction(functionLabel.getMenu(), OpenMethod.NEWTAB);
    }

    public void newSessionAction_actionPerformed(ActionEvent e) {
        JPopupMenu menu = (JPopupMenu)((JMenuItem)e.getSource()).getParent();
        FunctionLabel functionLabel = (FunctionLabel)((Object)menu.getInvoker());
        this.openUIbyFunction(functionLabel.getMenu(), OpenMethod.NEWSESSION);
    }

    public void newWinAction_actionPerformed(ActionEvent e) {
        JPopupMenu menu = (JPopupMenu)((JMenuItem)e.getSource()).getParent();
        FunctionLabel functionLabel = (FunctionLabel)((Object)menu.getInvoker());
        this.openUIbyFunction(functionLabel.getMenu(), OpenMethod.NEWWIN);
    }

    public void removeAction_actionPerformed(ActionEvent e) {
        JPopupMenu menu = (JPopupMenu)((JMenuItem)e.getSource()).getParent();
        FunctionLabel functionLabel = (FunctionLabel)((Object)menu.getInvoker());
        Container parent = functionLabel.getParent();
        parent.remove((Component)((Object)functionLabel));
        ComMenuFunctionInfo functionInfo = functionLabel.getMenu();
        this.removeFunctionFromDB(functionInfo);
        this.removeFunctionFromDir(parent, functionInfo);
    }

    public void removeDirAction_actionPerformed(ActionEvent e) {
        JPopupMenu menu = (JPopupMenu)((JMenuItem)e.getSource()).getParent();
        FunctionLabel functionLabel = (FunctionLabel)((Object)menu.getInvoker());
        Container parent = functionLabel.getParent();
        parent.remove((Component)((Object)functionLabel));
        this.removeDirFunctionFromDB(functionLabel.getMenu());
        this.functionColl = this.getComFunctionByRoot();
        if (parent.getComponentCount() == 0) {
            this.addFunctionPageButton();
        } else {
            this.addLastFunction(parent);
        }
        parent.validate();
        parent.repaint();
    }

    protected void setCurrentDirLabelClicked() {
        if (EventQueue.getCurrentEvent() == null) {
            this.isCurrentDirLabelClicked = false;
            return;
        }
        Object source = EventQueue.getCurrentEvent().getSource();
        if (source instanceof FunctionLabel) {
            FunctionLabel label = (FunctionLabel)((Object)source);
            this.isCurrentDirLabelClicked = ToolUtils.equalObject((Object)((Object)label), (Object)((Object)this.currentDirLabel));
        }
    }

    private void processWhenCreateDir(ComMenuFunctionInfo dirFunctionInfo, ComMenuFunctionInfo newFunctionInfo, ComMenuFunctionInfo thisFunctionInfo) {
        long t1 = System.currentTimeMillis();
        this.storeNewDirFunction(dirFunctionInfo);
        logger.info((Object)(EASResource.getString((String)"com.kingdee.eas.base.uiframe.UIFRAMEAutoGenerateResource", (String)"54_MyComFunctionPanel") + (System.currentTimeMillis() - t1)));
        this.storeFunctionInfo(dirFunctionInfo, newFunctionInfo);
        logger.info((Object)(EASResource.getString((String)"com.kingdee.eas.base.uiframe.UIFRAMEAutoGenerateResource", (String)"55_MyComFunctionPanel") + (System.currentTimeMillis() - t1)));
        this.storeFunctionInfo(dirFunctionInfo, thisFunctionInfo);
        logger.info((Object)(EASResource.getString((String)"com.kingdee.eas.base.uiframe.UIFRAMEAutoGenerateResource", (String)"56_MyComFunctionPanel") + (System.currentTimeMillis() - t1)));
        logger.info((Object)(EASResource.getString((String)"com.kingdee.eas.base.uiframe.UIFRAMEAutoGenerateResource", (String)"57_MyComFunctionPanel") + (System.currentTimeMillis() - t1)));
    }

    private void processWhenRemove(ComMenuFunctionInfo thisFunctionInfo, int childCount, ComMenuFunctionInfo thisFunctionParentInfo) {
        long t1 = System.currentTimeMillis();
        this.storeFunctionInfo(this.getFunctionRoot(), thisFunctionInfo);
        logger.info((Object)(EASResource.getString((String)"com.kingdee.eas.base.uiframe.UIFRAMEAutoGenerateResource", (String)"58_MyComFunctionPanel") + (System.currentTimeMillis() - t1)));
        if (childCount <= 1) {
            this.updateChildWhenRemoveDir(thisFunctionParentInfo);
        }
        logger.info((Object)(EASResource.getString((String)"com.kingdee.eas.base.uiframe.UIFRAMEAutoGenerateResource", (String)"59_MyComFunctionPanel") + (System.currentTimeMillis() - t1)));
        this.functionColl = this.getComFunctionByRoot();
        logger.info((Object)(EASResource.getString((String)"com.kingdee.eas.base.uiframe.UIFRAMEAutoGenerateResource", (String)"60_MyComFunctionPanel") + (System.currentTimeMillis() - t1)));
        if (childCount <= 1) {
            this.loadAppFunctionPanel();
            this.appPagePanel.revalidate();
            this.appPagePanel.repaint();
        }
        logger.info((Object)(EASResource.getString((String)"com.kingdee.eas.base.uiframe.UIFRAMEAutoGenerateResource", (String)"61_MyComFunctionPanel") + (System.currentTimeMillis() - t1)));
    }

    static {
        myCommonUI = new ArrayList<MyComFunctionPanel>();
    }

    class MouseEnteredTask
    extends TimerTask {
        FunctionLabel label;

        public MouseEnteredTask(FunctionLabel label) {
            this.label = label;
        }

        @Override
        public void run() {
            MyComFunctionPanel.this.isTaskRun = true;
            MyComFunctionPanel.this.setDirStatusByAddChild(this.label);
            this.label.repaint();
        }
    }

    class TipTask
    extends TimerTask {
        FunctionLabel label;

        public TipTask(FunctionLabel label) {
            this.label = label;
        }

        @Override
        public void run() {
            MyComFunctionPanel.this.hideTipPopup();
        }
    }

    class DirClicked1PopupMenu
    extends JPopupMenu {
        DirClicked1PopupMenu() {
        }

        @Override
        public void setVisible(boolean b) {
            if (!b) {
                if (MyComFunctionPanel.this.isShowClicked3PopupMenu) {
                    return;
                }
                if (!MyComFunctionPanel.this.hideDirPopup()) {
                    MenuSelectionManager.defaultManager().setSelectedPath(new MenuElement[]{MyComFunctionPanel.this.dirClicked1PopupMenu});
                    return;
                }
            }
            super.setVisible(b);
        }
    }

    class Clicked3PopupMenu
    extends JPopupMenu {
        protected boolean isUseHidePopupMenu;

        Clicked3PopupMenu() {
        }

        @Override
        public void setVisible(boolean b) {
            if (!b && !this.isUseHidePopupMenu) {
                MyComFunctionPanel.this.isShowClicked3PopupMenu = false;
                MenuSelectionManager.defaultManager().setSelectedPath(new MenuElement[]{MyComFunctionPanel.this.dirClicked1PopupMenu});
            }
            this.isUseHidePopupMenu = false;
            super.setVisible(b);
        }
    }

    class DirTextField
    extends KDTextField {
        boolean isFocus = false;

        DirTextField() {
        }

        protected void paintComponent(Graphics g) {
            int w = this.getWidth();
            Graphics2D g2d = (Graphics2D)g.create();
            g2d.setColor(WorkBenchUtil.getDirTextColor());
            g2d.fillRect(0, 0, w, this.getHeight());
            if (this.isFocus) {
                this.setForeground(new Color(0, 0, 0));
                g2d.setColor(new Color(255, 255, 255));
                FontMetrics metrics = g2d.getFontMetrics();
                Rectangle2D r2d = metrics.getStringBounds(this.getText(), g);
                g2d.setClip(2, 1, (int)r2d.getWidth() + 10, 19);
                g2d.fillRect(2, 1, (int)r2d.getWidth() + 10, 19);
            } else {
                this.setForeground(Color.WHITE);
            }
            super.paintComponent(g);
        }
    }

    class FunctionMouseListener
    extends MouseAdapter {
        FunctionMouseListener() {
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            if (e.getButton() == 1) {
                if (e.getClickCount() == 1) {
                    MyComFunctionPanel.this.newMouseClicked1(e);
                }
                if (e.getClickCount() == 2) {
                    MyComFunctionPanel.this.newMouseClicked2(e);
                }
            } else if (e.getButton() == 3) {
                MyComFunctionPanel.this.newMouseClicked3(e);
            }
        }

        @Override
        public void mouseEntered(MouseEvent e) {
            MyComFunctionPanel.this.newMouseEntered(e);
        }

        @Override
        public void mouseExited(MouseEvent e) {
            MyComFunctionPanel.this.newMouseExited(e);
        }

        @Override
        public void mousePressed(MouseEvent e) {
            MyComFunctionPanel.this.newMousePressed(e);
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            MyComFunctionPanel.this.newMouseReleased(e);
        }
    }

    class FunctionPageButtonActionListener
    extends PageButtonActionListener {
        FunctionPageButtonActionListener() {
        }

        @Override
        public void processEvent(ActionEvent e) {
            PageButton button = (PageButton)e.getSource();
            MyComFunctionPanel.this.functionNumber = button.getNumber();
            MyComFunctionPanel.this.addFunctionLabel(MyComFunctionPanel.this.applicationpanel);
        }
    }
}

