/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.uiframe.client;

import com.kingdee.bos.ctrl.common.CtrlUtil;
import com.kingdee.bos.ctrl.common.LanguageManager;
import com.kingdee.bos.ctrl.swing.StringUtils;
import com.kingdee.bos.ctrl.swing.event.TreeNodeStateChangeEvent;
import com.kingdee.bos.ctrl.swing.event.TreeNodeStateChangeListener;
import com.kingdee.bos.ctrl.swing.resource.KDResourceManager;
import com.kingdee.bos.ctrl.swing.tree.DefaultKingdeeTreeNode;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.base.uiframe.Entity;
import com.kingdee.eas.base.uiframe.IMySearchFacade;
import com.kingdee.eas.base.uiframe.MySearchFacadeFactory;
import com.kingdee.eas.base.uiframe.client.AbstractMySearchConfigUI;
import com.kingdee.eas.base.uiframe.client.WorkBenchTreeHelper;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.event.ActionEvent;
import java.awt.event.KeyEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import org.apache.log4j.Logger;

public class MySearchConfigUI
extends AbstractMySearchConfigUI {
    private static final Logger logger = CoreUIObject.getLogger(MySearchConfigUI.class);
    private String resClassName = "com.kingdee.eas.base.uiframe.client.WorkBenchResource";
    private List xmlEntityList;
    private List searchEntity;
    private List selectEntityList;
    private boolean isConfirmClose;

    @Override
    public void storeFields() {
        super.storeFields();
    }

    public void onLoad() throws Exception {
        super.onLoad();
        WorkBenchTreeHelper.adjustFocusPolicy(this.kdtSearchField);
        this.setUITitle(EASResource.getString((String)this.resClassName, (String)"SEARCHSERVER"));
        this.btnSearch.setIcon((Icon)new ImageIcon(KDResourceManager.getImageOfRapid((String)this.getMLS("picFind", "tree_demand.png"))));
        this.getEntityCollection();
        this.initTree();
        this.searchEntity = (List)this.getUIContext().get("entityList");
        if (this.searchEntity == null || this.searchEntity.size() == 0) {
            return;
        }
        this.selectEntityList = CtrlUtil.Collection.cloneList((List)this.searchEntity);
        this.setNodeCheckedByMySearch((DefaultKingdeeTreeNode)this.mySearchConfigTree.getModel().getRoot(), this.selectEntityList);
    }

    private String getMLS(String key, String defaultValue) {
        return LanguageManager.getLangMessage((String)key, (String)"com.kingdee.bos.ctrl.swing.KDTreeView", (String)defaultValue);
    }

    private void setNodeCheckedByMySearch(DefaultKingdeeTreeNode node, List entityList) {
        block0: for (int i = 0; i < node.getChildCount(); ++i) {
            DefaultKingdeeTreeNode subNode = (DefaultKingdeeTreeNode)node.getChildAt(i);
            if (!subNode.isLeaf()) {
                this.setNodeCheckedByMySearch(subNode, entityList);
                continue;
            }
            if (!(subNode.getUserObject() instanceof Entity)) continue;
            Entity subEntity = (Entity)subNode.getUserObject();
            for (int j = 0; j < entityList.size(); ++j) {
                if (!StringUtils.equals((String)((Entity)entityList.get(j)).getBostype(), (String)subEntity.getBostype())) continue;
                subNode.setChecked(true);
                entityList.remove(j);
                continue block0;
            }
        }
    }

    private void getEntityCollection() throws Exception {
        this.xmlEntityList = MySearchFacadeFactory.getRemoteInstance().getEntityFromXML();
    }

    private void initTree() {
        DefaultKingdeeTreeNode root = this.createRootNode();
        this.buildTree(root);
        this.mySearchConfigTree.addTreeNodeStateChangeListener(new TreeNodeStateChangeListener(){

            public void nodeStateChange(TreeNodeStateChangeEvent event) {
                MySearchConfigUI.this.doTreeNodeStateChange(event);
            }
        });
    }

    private void doTreeNodeStateChange(TreeNodeStateChangeEvent event) {
        DefaultKingdeeTreeNode node = (DefaultKingdeeTreeNode)event.getNode();
        boolean selected = node.isChecked();
        this.selectAllChildrenOfTheSelectedNode(node, selected);
        this.mySearchConfigTree.repaint();
    }

    private void selectAllChildrenOfTheSelectedNode(DefaultKingdeeTreeNode node, boolean selected) {
        DefaultKingdeeTreeNode subNode = null;
        int n = node.getChildCount();
        for (int i = 0; i < n; ++i) {
            subNode = (DefaultKingdeeTreeNode)node.getChildAt(i);
            if (this.canTheNodeBeSelected(subNode)) {
                subNode.setChecked(selected);
            }
            this.selectAllChildrenOfTheSelectedNode(subNode, selected);
        }
    }

    private boolean canTheNodeBeSelected(DefaultKingdeeTreeNode node) {
        return node.isCheckBoxVisible() && node.isCheckBoxEnabled();
    }

    private void buildTree(DefaultKingdeeTreeNode node) {
        Entity parentEntity = null;
        DefaultKingdeeTreeNode parentNode = node;
        block0: for (int i = 0; i < this.xmlEntityList.size(); ++i) {
            Entity childEntity = (Entity)this.xmlEntityList.get(i);
            DefaultKingdeeTreeNode childNode = this.createNode(childEntity);
            childNode.setText(!StringUtils.isEmpty((String)childEntity.getName()) ? childEntity.getName() : childEntity.getBostype());
            if (parentNode != null && !parentNode.isRoot() && parentNode.getUserObject() instanceof Entity) {
                parentEntity = (Entity)parentNode.getUserObject();
            }
            if (StringUtils.equalsIgnoreCase((String)childEntity.getParent(), (String)"root")) {
                parentNode = node;
                parentNode.add((MutableTreeNode)childNode);
                parentNode = childNode;
                continue;
            }
            while (true) {
                if (parentEntity != null && StringUtils.equalsIgnoreCase((String)childEntity.getParent(), (String)parentEntity.getName())) {
                    parentNode.add((MutableTreeNode)childNode);
                    parentNode = childNode;
                    continue block0;
                }
                parentNode = (DefaultKingdeeTreeNode)parentNode.getParent();
                parentEntity = (Entity)parentNode.getUserObject();
            }
        }
        this.mySearchConfigTree.setModel((TreeModel)new DefaultTreeModel((TreeNode)node));
        this.mySearchConfigTree.setRootVisible(false);
        this.mySearchConfigTree.setShowCheckBox(true);
        this.mySearchConfigTree.setShowsRootHandles(true);
    }

    private DefaultKingdeeTreeNode createRootNode() {
        return new DefaultKingdeeTreeNode((Object)"eas");
    }

    private DefaultKingdeeTreeNode createNode(Entity entity) {
        return new DefaultKingdeeTreeNode((Object)entity);
    }

    private List getSelectedNode(DefaultKingdeeTreeNode node, List selectedNodeList) throws Exception {
        for (int i = 0; i < node.getChildCount(); ++i) {
            DefaultKingdeeTreeNode childNode = (DefaultKingdeeTreeNode)node.getChildAt(i);
            if (!childNode.isLeaf()) {
                this.getSelectedNode(childNode, selectedNodeList);
            }
            if (!childNode.isLeaf() || !childNode.isChecked() || !(childNode.getUserObject() instanceof Entity)) continue;
            selectedNodeList.add((Entity)childNode.getUserObject());
        }
        return selectedNodeList;
    }

    public boolean destroyWindow() {
        super.destroyWindow();
        if (!this.isConfirmClose) {
            this.selectEntityList = this.searchEntity;
        }
        this.setUserObject(this.selectEntityList);
        return true;
    }

    private void storeEntity() throws Exception {
        String userId = SysContext.getSysContext().getCurrentUserInfo().getId().toString();
        ArrayList<String> bostypeList = new ArrayList<String>();
        for (int i = 0; i < this.selectEntityList.size(); ++i) {
            Entity entity = (Entity)this.selectEntityList.get(i);
            bostypeList.add(entity.getBostype());
        }
        IMySearchFacade iMySearchFacade = MySearchFacadeFactory.getRemoteInstance();
        iMySearchFacade.saveEntity2DB(userId, bostypeList);
    }

    @Override
    protected void btnSearch_actionPerformed(ActionEvent e) throws Exception {
        WorkBenchTreeHelper.searchNodeEvent(this.mySearchConfigTree, this.kdtSearchField);
    }

    @Override
    protected void btnConfirm_actionPerformed(ActionEvent e) throws Exception {
        super.btnConfirm_actionPerformed(e);
        this.selectEntityList = this.getSelectedNode((DefaultKingdeeTreeNode)this.mySearchConfigTree.getModel().getRoot(), new ArrayList());
        if (this.selectEntityList.size() > 3) {
            MsgBox.showWarning((String)EASResource.getString((String)this.resClassName, (String)"ABOVETHREE"));
            return;
        }
        this.isConfirmClose = true;
        this.getUIWindow().close();
        this.storeEntity();
    }

    @Override
    protected void btnCancel_actionPerformed(ActionEvent e) throws Exception {
        this.destroyWindow();
    }

    @Override
    protected void kdtSearchField_keyPressed(KeyEvent e) throws Exception {
        if (10 == e.getKeyCode()) {
            WorkBenchTreeHelper.searchNodeEvent(this.mySearchConfigTree, this.kdtSearchField);
        }
    }
}

