/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.uiframe.client;

import com.kingdee.bos.BOSException;
import com.kingdee.eas.base.myeas.ComMenuFunctionCollection;
import com.kingdee.eas.base.permission.MainMenuItemInfo;
import com.kingdee.eas.base.uiframe.IMainFunctionMenu;
import com.kingdee.eas.base.uiframe.MainFunctionMenuFactory;
import com.kingdee.eas.base.uiframe.MenuCacheFactory;
import com.kingdee.eas.base.uiframe.MyComFunctionFacadeFactory;
import com.kingdee.eas.base.uiframe.client.MenuVisitorHelper;
import com.kingdee.eas.base.uiframe.client.NewEASMainMenuCacheUtil;
import com.kingdee.eas.base.uiframe.client.UIConfig;
import com.kingdee.eas.base.uiframe.utils.UIFrameUtils;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.util.client.ExceptionHandler;
import com.kingdee.util.StringUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import org.apache.log4j.Logger;

public class NewMenuVisitorHelper {
    private static final Logger logger = Logger.getLogger(NewMenuVisitorHelper.class);
    private static Boolean isTimestampEquals = null;
    private static Boolean isComMenuTimestampEquals = null;
    private static Map<String, List<MainMenuItemInfo>> menuCache = null;
    private static Map<String, ComMenuFunctionCollection> comMenuCache = null;
    private static String serverMenuTimestamp = null;
    private static String serverComMenuTimestamp = null;
    private static final String menuCacheFileName = "newMenuCache.xml";
    private static final String menuTimestampFileName = "newMenuCacheTime.properties";
    private static final String comFuncMenuCacheFileName = "newComFuncMenuCache.xml";
    private static final String comFuncMenuTimestampFileName = "newComFuncMenuCacheTime.properties";
    private static List reptlist = null;

    public static List getReptlist() {
        return reptlist;
    }

    public static void setReptlist(List reptlist) {
        NewMenuVisitorHelper.reptlist = reptlist;
    }

    static void initMenuCache() {
        try {
            if (NewMenuVisitorHelper.isTimestampEquals()) {
                menuCache = NewMenuVisitorHelper.getCacheMenu();
                UIConfig.setUserId(SysContext.getSysContext().getCurrentUserInfo().getId().toString());
                UIConfig.setOrgId(SysContext.getSysContext().getCurrentOrgUnit().getId().toString());
                UIConfig.setDcNumber(SysContext.getSysContext().getDCNumber());
            }
            if (menuCache == null) {
                menuCache = NewMenuVisitorHelper.getMenuFromServer(null);
                NewMenuVisitorHelper.updateLocalCache();
            }
            UIConfig.storeConfig();
        }
        catch (EASBizException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            ExceptionHandler.handle((Throwable)e);
        }
        catch (BOSException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            ExceptionHandler.handle((Throwable)e);
        }
    }

    static void initComMenuCache() {
        if (NewMenuVisitorHelper.isComMenuTimestampEquals()) {
            comMenuCache = NewMenuVisitorHelper.getComMenuCacheFromLocal();
        }
        try {
            if (comMenuCache == null || comMenuCache.size() == 0) {
                comMenuCache = NewMenuVisitorHelper.getComMenuFromServer(null);
                NewMenuVisitorHelper.updateLocalComMenuCache();
            }
        }
        catch (Exception e) {
            logger.error((Object)e);
        }
    }

    public static Map<String, ComMenuFunctionCollection> getComMenuCache() {
        if (comMenuCache == null) {
            NewMenuVisitorHelper.initComMenuCache();
        }
        return comMenuCache == null ? new HashMap() : comMenuCache;
    }

    static List<MainMenuItemInfo> buildSubNodesByParentId(String parentId) throws BOSException {
        List<MainMenuItemInfo> result;
        if (menuCache == null) {
            NewMenuVisitorHelper.initMenuCache();
        }
        if ((result = menuCache.get(parentId)) == null) {
            Map<String, List<MainMenuItemInfo>> temp = null;
            try {
                temp = NewMenuVisitorHelper.getMenuFromServer(parentId);
            }
            catch (EASBizException e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
                throw new BOSException((Throwable)e);
            }
            NewMenuVisitorHelper.addMenuToCache(menuCache, temp);
            return temp.get(parentId);
        }
        if (result.size() == 0) {
            return new ArrayList<MainMenuItemInfo>();
        }
        return result;
    }

    static ComMenuFunctionCollection getComMenuCollection(String parentId) {
        if (comMenuCache == null) {
            NewMenuVisitorHelper.initComMenuCache();
        }
        if (comMenuCache == null) {
            return new ComMenuFunctionCollection();
        }
        ComMenuFunctionCollection coll = comMenuCache.get(parentId);
        if (coll == null || coll.size() == 0) {
            Map<String, ComMenuFunctionCollection> tmp = null;
            try {
                tmp = NewMenuVisitorHelper.getComMenuFromServer(parentId);
            }
            catch (Exception e) {
                logger.error((Object)e);
            }
            if (tmp == null || tmp.size() == 0) {
                return new ComMenuFunctionCollection();
            }
            NewMenuVisitorHelper.addComMenuToCache(comMenuCache, tmp);
            return tmp.get(parentId);
        }
        return coll;
    }

    public static void updateComMenuCacheByMyComFunctionPanel(Map<String, ComMenuFunctionCollection> comMenuMap) {
        comMenuCache.putAll(comMenuMap);
    }

    static boolean isTimestampEquals() {
        try {
            if (UIConfig.isLocalStoreFunUnit()) {
                if (isTimestampEquals == null) {
                    isTimestampEquals = new Boolean(NewMenuVisitorHelper.compareClientAndServerTimestamp());
                }
                return isTimestampEquals;
            }
        }
        catch (Exception ex) {
            logger.error((Object)ex.getMessage(), (Throwable)ex);
        }
        return false;
    }

    static boolean isComMenuTimestampEquals() {
        try {
            isComMenuTimestampEquals = new Boolean(NewMenuVisitorHelper.compareComMenuClientAndServerTimestamp());
            return isComMenuTimestampEquals;
        }
        catch (Exception ex) {
            logger.error((Object)ex.getMessage(), (Throwable)ex);
            return false;
        }
    }

    static String getMenuCacheFileName(String fileName) {
        if (StringUtils.isEmpty((String)fileName)) {
            return "Empty_FileName";
        }
        StringBuffer cacheFb = new StringBuffer();
        cacheFb.append(MenuVisitorHelper.getCacheDir());
        cacheFb.append(fileName);
        return cacheFb.toString();
    }

    private static boolean compareClientAndServerTimestamp() {
        String cachetime;
        boolean flag = true;
        String fileName = NewMenuVisitorHelper.getMenuCacheFileName(menuTimestampFileName);
        Properties prop = new Properties();
        prop = MenuVisitorHelper.loadPro(fileName);
        String string = cachetime = prop.getProperty("UserMenuCacheTime") == null ? "" : prop.getProperty("UserMenuCacheTime");
        if (serverMenuTimestamp == null) {
            NewMenuVisitorHelper.initServerTimestamp();
        }
        if (null == serverMenuTimestamp || serverMenuTimestamp != null && !cachetime.equals(serverMenuTimestamp)) {
            flag = false;
        }
        return flag;
    }

    private static boolean compareComMenuClientAndServerTimestamp() {
        boolean flag = true;
        String fileName = NewMenuVisitorHelper.getMenuCacheFileName(comFuncMenuTimestampFileName);
        Properties prop = new Properties();
        prop = MenuVisitorHelper.loadPro(fileName);
        String cachetime = prop.getProperty("UserComFuncMenuCacheTime") == null ? "" : prop.getProperty("UserComFuncMenuCacheTime");
        NewMenuVisitorHelper.initServerTimestamp();
        if (null == serverComMenuTimestamp || serverComMenuTimestamp != null && !cachetime.equals(serverComMenuTimestamp)) {
            flag = false;
        }
        return flag;
    }

    private static void initServerTimestamp() {
        String userId = SysContext.getSysContext().getCurrentUserInfo().getId().toString();
        try {
            Map serverCacheTimeMap = MenuCacheFactory.getRemoteInstance().getServerCacheTimes(userId);
            serverMenuTimestamp = (String)serverCacheTimeMap.get("menuCacheTime");
            serverComMenuTimestamp = (String)serverCacheTimeMap.get("comFunctionMenuCatcheTime");
        }
        catch (Exception e) {
            logger.error((Object)"getServerCacheTimes:", (Throwable)e);
        }
    }

    static Map<String, List<MainMenuItemInfo>> getCacheMenu() {
        String fileName = NewMenuVisitorHelper.getMenuCacheFileName(menuCacheFileName);
        try {
            Locale locale = SysContext.getSysContext().getLocale();
            return NewEASMainMenuCacheUtil.readCacheMenu(fileName, locale);
        }
        catch (BOSException e) {
            logger.error((Object)("get menu cache file error:" + e.getMessage()), (Throwable)e);
            return null;
        }
    }

    static Map<String, ComMenuFunctionCollection> getComMenuCacheFromLocal() {
        String fileName = NewMenuVisitorHelper.getMenuCacheFileName(comFuncMenuCacheFileName);
        try {
            Locale locale = SysContext.getSysContext().getLocale();
            return NewEASMainMenuCacheUtil.readComFuncCache(fileName, locale);
        }
        catch (Exception e) {
            logger.error((Object)("get ComMenu cache file error:" + e.getMessage()), (Throwable)e);
            return null;
        }
    }

    static void writeCacheMenu(Map<String, List<MainMenuItemInfo>> menuCache) {
        String fileName = NewMenuVisitorHelper.getMenuCacheFileName(menuCacheFileName);
        try {
            Locale locale = SysContext.getSysContext().getLocale();
            NewEASMainMenuCacheUtil.writeCacheMenu(fileName, locale, menuCache);
        }
        catch (BOSException e) {
            logger.error((Object)("get menu cache file error:" + e.getMessage()), (Throwable)e);
        }
    }

    static void writeComMenuCache(Map<String, ComMenuFunctionCollection> comMenuCache) {
        String fileName = NewMenuVisitorHelper.getMenuCacheFileName(comFuncMenuCacheFileName);
        try {
            Locale locale = SysContext.getSysContext().getLocale();
            NewEASMainMenuCacheUtil.writeComFuncCache(comMenuCache, fileName, locale);
        }
        catch (Exception e) {
            logger.error((Object)("get menu cache file error:" + e.getMessage()), (Throwable)e);
        }
    }

    static Map<String, List<MainMenuItemInfo>> getMenuFromServer(String parentId) throws EASBizException, BOSException {
        if (reptlist != null) {
            reptlist = UIFrameUtils.getPermissionReportMenuids(null);
        }
        IMainFunctionMenu iMenu = MainFunctionMenuFactory.getRemoteInstance();
        return iMenu.getChildMenuByParent(parentId, reptlist);
    }

    static Map<String, ComMenuFunctionCollection> getComMenuFromServer(String parentId) throws Exception {
        HashMap<String, ComMenuFunctionCollection> comMenuMap = new HashMap();
        if (parentId == null) {
            comMenuMap = MyComFunctionFacadeFactory.getRemoteInstance().getAllComFunction();
        } else {
            ComMenuFunctionCollection coll = MyComFunctionFacadeFactory.getRemoteInstance().getComFunction(parentId);
            if (coll == null || coll.size() == 0) {
                return new HashMap<String, ComMenuFunctionCollection>();
            }
            comMenuMap.put(parentId, coll);
        }
        return comMenuMap;
    }

    static Map<String, List<MainMenuItemInfo>> addMenuToCache(Map<String, List<MainMenuItemInfo>> source, Map<String, List<MainMenuItemInfo>> destin) {
        if (destin == null) {
            return source;
        }
        source.putAll(destin);
        return source;
    }

    static Map<String, ComMenuFunctionCollection> addComMenuToCache(Map<String, ComMenuFunctionCollection> source, Map<String, ComMenuFunctionCollection> destin) {
        if (destin == null) {
            return source;
        }
        source.putAll(destin);
        return source;
    }

    static void updateLocalCache() {
        String cacheTime;
        if (UIConfig.isLocalStoreFunUnit()) {
            NewMenuVisitorHelper.writeCacheMenu(menuCache);
            NewMenuVisitorHelper.writeCacheMenuTimeForUser();
        }
        if (!StringUtils.isEmpty((String)(cacheTime = (String)SysContext.getSysContext().getProperty((Object)"cacheMenuTime")))) {
            UIConfig.setMenuCacheTime(cacheTime);
        }
        UIConfig.setUserId(SysContext.getSysContext().getCurrentUserInfo().getId().toString());
    }

    static void updateLocalComMenuCache() {
        NewMenuVisitorHelper.writeComMenuCache(comMenuCache);
        NewMenuVisitorHelper.writeComMenuCacheTimeForUser();
    }

    static void writeCacheMenuTimeForUser() {
        String fileName = NewMenuVisitorHelper.getMenuCacheFileName(menuTimestampFileName);
        Properties prop = new Properties();
        prop = MenuVisitorHelper.loadPro(fileName);
        if (serverMenuTimestamp == null) {
            NewMenuVisitorHelper.initServerTimestamp();
        }
        if (serverMenuTimestamp != null) {
            prop.setProperty("UserMenuCacheTime", serverMenuTimestamp);
            MenuVisitorHelper.saveToPro(fileName, prop);
        }
        isTimestampEquals = true;
    }

    static void writeComMenuCacheTimeForUser() {
        String fileName = NewMenuVisitorHelper.getMenuCacheFileName(comFuncMenuTimestampFileName);
        Properties prop = new Properties();
        prop = MenuVisitorHelper.loadPro(fileName);
        NewMenuVisitorHelper.initServerTimestamp();
        if (serverComMenuTimestamp != null) {
            prop.setProperty("UserComFuncMenuCacheTime", serverComMenuTimestamp);
            MenuVisitorHelper.saveToPro(fileName, prop);
        }
        isComMenuTimestampEquals = true;
    }

    static void clearCache() {
        menuCache = null;
        comMenuCache = null;
        isTimestampEquals = null;
        serverMenuTimestamp = null;
        isComMenuTimestampEquals = null;
        serverComMenuTimestamp = null;
        reptlist = null;
    }

    public static void clearComMenuCache() {
        comMenuCache = null;
        isComMenuTimestampEquals = null;
        serverComMenuTimestamp = null;
    }
}

