/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.uiframe.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.swing.KDLabel;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.base.permission.SMSValidataException;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.base.uiframe.SMSValidataCodeFacadeFactory;
import com.kingdee.eas.base.uiframe.client.AbstractSMSValidataCodeUI;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.util.client.EASResource;
import java.awt.Color;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import org.apache.log4j.Logger;

public class SMSValidataCodeUI
extends AbstractSMSValidataCodeUI {
    private static final Logger logger = CoreUIObject.getLogger(SMSValidataCodeUI.class);
    public boolean isCancel = true;
    private UserInfo user = null;
    private static final String RESOURCE = "com.kingdee.eas.base.uiframe.client.LoginFrameResx";
    private static int reSendTime = 60;

    public void onLoad() throws Exception {
        super.onLoad();
        this.cancel.setEnabled(true);
        this.confirm.setEnabled(true);
        this.user = (UserInfo)this.getUIContext().get("user");
        this.labelGetCode.addMouseListener((MouseListener)new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent paramMouseEvent) {
                SMSValidataCodeUI.this.sendSMSCode();
            }
        });
        this.sendSMSCode();
    }

    @Override
    public void actionConfirm_actionPerformed(ActionEvent e) throws Exception {
        String code = this.txtCode.getStringValue();
        try {
            boolean checkCode = SMSValidataCodeFacadeFactory.getRemoteInstance().checkCode(this.user.getNumber(), code);
            if (!checkCode) {
                throw new EASBizException(SMSValidataException.CHECK_ERROR);
            }
            this.isCancel = false;
            this.getUIWindow().close();
        }
        catch (EASBizException e1) {
            this.showError(e1.getMessage());
        }
    }

    @Override
    public void actionCancel_actionPerformed(ActionEvent e) throws Exception {
        this.isCancel = true;
        this.getUIWindow().close();
    }

    private void sendSMSCode() {
        try {
            int sendType = SMSValidataCodeFacadeFactory.getRemoteInstance().sendCode(this.user.getNumber());
            this.startTimer(reSendTime, sendType);
        }
        catch (EASBizException e) {
            this.showError(e.getMessage());
        }
        catch (BOSException e) {
            this.showError(this.getResx("sendError"));
        }
    }

    private void startTimer(int reGetTime, int sendType) {
        if (sendType == 0) {
            this.showSuccess(this.getResx("sendCellSuccess"));
        } else {
            this.showSuccess(this.getResx("sendEmailSuccess"));
        }
        SendTimerTask task = new SendTimerTask(reGetTime, this.labelGetCode);
        Thread thread = new Thread(task);
        thread.start();
    }

    private String getResx(String resxItemName) {
        return EASResource.getString((String)RESOURCE, (String)resxItemName);
    }

    private void showSuccess(String message) {
        this.errMsg.setText(message);
        this.errMsg.setForeground(Color.BLUE);
    }

    private void showError(String message) {
        this.errMsg.setText(message);
        this.errMsg.setForeground(Color.RED);
        Font topFont = this.errMsg.getFont().deriveFont(0, 13.0f);
        this.errMsg.setFont(topFont);
    }

    private class SendTimerTask
    implements Runnable {
        private KDLabel labelGetCode;
        private int reGetTime;

        public SendTimerTask(int reGetTime, KDLabel labelGetCode) {
            this.reGetTime = reGetTime;
            this.labelGetCode = labelGetCode;
        }

        @Override
        public void run() {
            try {
                this.labelGetCode.removeMouseListener(this.labelGetCode.getMouseListeners()[1]);
                this.labelGetCode.setText(SMSValidataCodeUI.this.getResx("send") + "(" + this.reGetTime + ")");
                while (true) {
                    Thread.sleep(1000L);
                    if (this.reGetTime == 0) {
                        this.labelGetCode.setText(SMSValidataCodeUI.this.getResx("send"));
                        this.labelGetCode.addMouseListener((MouseListener)new MouseAdapter(){

                            @Override
                            public void mouseClicked(MouseEvent e) {
                                if (SendTimerTask.this.labelGetCode.isEnabled()) {
                                    SMSValidataCodeUI.this.sendSMSCode();
                                }
                            }
                        });
                        break;
                    }
                    --this.reGetTime;
                    this.labelGetCode.setText(SMSValidataCodeUI.this.getResx("resend") + "(" + this.reGetTime + ")");
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }
}

