/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.uiframe.client;

import com.kingdee.bos.ctrl.common.WinSystemProxy;
import com.kingdee.bos.ctrl.swing.KDButton;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.base.uiframe.UIFrameResource;
import com.kingdee.eas.base.uiframe.client.UIConfig;
import com.kingdee.eas.base.uiframe.client.ui.RpcDialog;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.geom.Line2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.net.ConnectException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.util.Locale;
import javax.swing.BorderFactory;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.Border;
import javax.swing.border.TitledBorder;
import org.apache.log4j.Logger;

public class ShowSysInfoUI
extends JDialog {
    private static final Logger logger = CoreUIObject.getLogger(ShowSysInfoUI.class);
    JDialog rpcDialog;
    private final String LOCATION_RESOURCE_ON_SERVER = "/classloader/patch/eas_applet.jar";
    private long sleepTime = 1000L;
    private int CHECKTIMES = 3;
    private String ALLOC = ShowSysInfoUI.getString("allocated");
    private String USED = ShowSysInfoUI.getString("used");
    public Surface surf;
    public Surface physics;
    JLabel lblNet = new JLabel();
    boolean doControls;
    private String netStat = null;
    boolean isStop = false;

    public ShowSysInfoUI(Frame owner) {
        super(owner);
        this.initLayout();
        this.pack();
        this.setLocationRelativeTo(null);
    }

    protected void initLayout() {
        JPanel contentPane = (JPanel)this.getContentPane();
        contentPane.setPreferredSize(new Dimension(506, 356));
        contentPane.setLayout(new BorderLayout());
        JPanel controls = new JPanel();
        controls.setLayout(new BorderLayout());
        Border loweredetched = BorderFactory.createEtchedBorder();
        TitledBorder title = BorderFactory.createTitledBorder(loweredetched, ShowSysInfoUI.getString("jvmMemory"));
        title.setTitlePosition(2);
        controls.setBorder(title);
        this.surf = new Surface("jvm", 1000L);
        controls.add((Component)this.surf, "Center");
        JPanel controls1 = new JPanel();
        controls1.setLayout(new BorderLayout());
        loweredetched = BorderFactory.createEtchedBorder();
        title = BorderFactory.createTitledBorder(loweredetched, ShowSysInfoUI.getString("phyMemory"));
        title.setTitlePosition(2);
        controls1.setBorder(title);
        this.physics = new Surface("physics", 1000L);
        controls1.add((Component)this.physics, "Center");
        JPanel topPanel = new JPanel();
        topPanel.setLayout(new GridLayout(0, 1));
        topPanel.add(controls);
        topPanel.add(controls1);
        contentPane.add((Component)topPanel, "Center");
        JPanel controls2 = new JPanel();
        controls2.setLayout(new BorderLayout());
        contentPane.add((Component)controls2, "South");
        JPanel bPan = new JPanel();
        bPan.setLayout(new BorderLayout());
        bPan.setLayout(new BorderLayout());
        loweredetched = BorderFactory.createEtchedBorder();
        title = BorderFactory.createTitledBorder(loweredetched, ShowSysInfoUI.getString("netSpeed"));
        title.setTitlePosition(2);
        bPan.setBorder(title);
        this.lblNet.setText(ShowSysInfoUI.getString("netTesting"));
        this.lblNet.setIconTextGap(100);
        this.lblNet.setHorizontalAlignment(0);
        bPan.add((Component)this.lblNet, "Center");
        controls2.add((Component)bPan, "Center");
        JPanel bottomPan = new JPanel();
        bottomPan.setLayout(new FlowLayout(2));
        controls2.add((Component)bottomPan, "South");
        KDButton btnOK = new KDButton(UIFrameResource.getCommonString("ok"));
        btnOK.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ShowSysInfoUI.this.closeWin();
            }
        });
        KDButton btnGC = new KDButton(ShowSysInfoUI.getString("fullGc"));
        btnGC.setMargin(new Insets(0, 0, 0, 0));
        btnGC.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                System.gc();
                System.gc();
                System.gc();
            }
        });
        KDButton btnDump = new KDButton("Dump");
        btnDump.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ShowSysInfoUI.this.ibmdump();
            }
        });
        KDButton rpcPing = new KDButton("Rpc Ping");
        btnGC.setMargin(new Insets(0, 0, 0, 0));
        rpcPing.setLimitedSize(false);
        rpcPing.setPreferredSize(new Dimension(88, 21));
        rpcPing.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ShowSysInfoUI.this.rpcPing();
            }
        });
        bottomPan.add((Component)rpcPing);
        bottomPan.add((Component)btnDump);
        bottomPan.add((Component)btnGC);
        bottomPan.add((Component)btnOK);
        this.startCheck();
    }

    private void rpcPing() {
        this.rpcDialog = new RpcDialog(this);
        this.rpcDialog.setTitle("Rpc Ping");
        this.rpcDialog.setModal(true);
        ((RpcDialog)this.rpcDialog).ping(null);
        this.rpcDialog.setVisible(true);
    }

    private void ibmdump() {
        if (System.getProperty("java.vendor", "").toUpperCase(Locale.ENGLISH).startsWith("IBM")) {
            try {
                Class<?> cls = Class.forName("com.ibm.jvm.Dump");
                Method method = cls.getMethod("JavaDump", null);
                method.invoke(cls, null);
                method = cls.getMethod("HeapDump", null);
                method.invoke(cls, null);
            }
            catch (ClassNotFoundException e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
            }
            catch (Exception e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
            }
        }
    }

    private void closeWin() {
        this.stopCheck();
        this.dispose();
    }

    public void startCheck() {
        this.surf.start();
        this.physics.start();
        new Thread(new Runnable(){

            @Override
            public void run() {
                while (!ShowSysInfoUI.this.isShowing()) {
                    try {
                        Thread.sleep(500L);
                    }
                    catch (InterruptedException e) {
                        return;
                    }
                }
                while (!ShowSysInfoUI.this.isStop && ShowSysInfoUI.this.isShowing()) {
                    String netCap = ShowSysInfoUI.this.checkNetSpeed();
                    ShowSysInfoUI.this.lblNet.setText(netCap);
                    try {
                        Thread.sleep(5000L);
                    }
                    catch (InterruptedException e) {
                        break;
                    }
                }
            }
        }).start();
    }

    public void stopCheck() {
        this.surf.stop();
        this.physics.stop();
        this.isStop = true;
    }

    private static String getString(String strKey) {
        return UIFrameResource.getString(strKey);
    }

    public URL findSrcOnServer() throws MalformedURLException {
        String srvUrlPath = System.getProperty("UPDATE_SERVER");
        if (srvUrlPath == null || srvUrlPath.equals("")) {
            srvUrlPath = UIConfig.getUrl().replaceFirst("tcp", "http") + ":6888/easWebClient";
        }
        return new URL(srvUrlPath + "/classloader/patch/eas_applet.jar");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String checkNetSpeed() {
        URL url = null;
        byte[] buf = new byte[4096];
        InputStream in = null;
        long start = System.currentTimeMillis();
        long stop = 0L;
        try {
            url = this.findSrcOnServer();
            URLConnection connect = url.openConnection();
            start = stop = System.currentTimeMillis();
            in = connect.getInputStream();
            int len = 0;
            long aSize = 0L;
            do {
                len = in.read(buf);
                aSize += (long)len;
            } while (len > 0);
            stop = System.currentTimeMillis();
            int factor = 1000;
            long dt = stop - start;
            if (dt == 0L) {
                String string = this.netStat = ShowSysInfoUI.getString("netNormal");
                return string;
            }
            long ls = aSize / 1024L * 1000L / (stop - start);
            long lsx = ls * 8L;
            long kbpsx = Math.round((double)lsx * 10.02);
            long kbps = kbpsx / 10L;
            long filebits = 8L * aSize;
            long downloadt = Math.round(filebits / (kbps * 1000L));
            this.netStat = ShowSysInfoUI.getString("netSpeed") + (long)(Math.round(aSize) / 1024 * 1000) / (stop - start) + ShowSysInfoUI.getString("kbpsPerSec");
        }
        catch (ConnectException e) {
            this.netStat = ShowSysInfoUI.getString("testConnFail");
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        catch (IOException e) {
            this.netStat = ShowSysInfoUI.getString("testConnFail");
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (Exception ex) {
                    logger.error((Object)"stream close error!");
                }
            }
        }
        return this.netStat;
    }

    public static void main(String[] s) throws IOException {
        ShowSysInfoUI demo = new ShowSysInfoUI(null);
        demo.show();
    }

    public long getSleepTime() {
        return this.sleepTime;
    }

    public void setSleepTime(long sleepTime) {
        this.sleepTime = sleepTime;
        if (this.surf != null) {
            this.surf.sleepAmount = sleepTime;
        }
        if (this.physics != null) {
            this.physics.sleepAmount = sleepTime;
        }
    }

    public class Surface
    extends JPanel
    implements Runnable {
        private String type = "jvm";
        public Thread thread;
        public long sleepAmount = 1000L;
        private int w;
        private int h;
        private BufferedImage bimg;
        private Graphics2D big;
        private Font font = new Font("Times New Roman", 0, 11);
        private Runtime r = Runtime.getRuntime();
        private int columnInc;
        private int[] pts;
        private int ptNum;
        private int ascent;
        private int descent;
        private float freeMemory;
        private float totalMemory;
        private Rectangle graphOutlineRect = new Rectangle();
        private Rectangle2D mfRect = new Rectangle2D.Float();
        private Rectangle2D muRect = new Rectangle2D.Float();
        private Line2D graphLine = new Line2D.Float();
        private Color graphColor = new Color(46, 139, 87);
        private Color mfColor = new Color(0, 100, 0);
        private String usedStr;
        WinSystemProxy proxy = WinSystemProxy.getInstance();

        public Surface(String ti, long sleepAmoun) {
            this.type = ti;
            this.sleepAmount = sleepAmoun;
            this.setBackground(Color.black);
            this.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    if (Surface.this.thread == null) {
                        Surface.this.start();
                    } else {
                        Surface.this.stop();
                    }
                }
            });
        }

        @Override
        public Dimension getMinimumSize() {
            return this.getPreferredSize();
        }

        @Override
        public Dimension getMaximumSize() {
            return this.getPreferredSize();
        }

        @Override
        public Dimension getPreferredSize() {
            return new Dimension(135, 80);
        }

        @Override
        public void paint(Graphics g) {
            int j;
            int i;
            if (this.big == null) {
                return;
            }
            this.big.setBackground(this.getBackground());
            this.big.clearRect(0, 0, this.w, this.h);
            float freeMemory = 0.0f;
            float totalMemory = 0.0f;
            if (this.type.equals("jvm")) {
                freeMemory = this.r.freeMemory();
                totalMemory = this.r.totalMemory();
            } else if (this.type.equals("physics")) {
                freeMemory = this.proxy.getAvailPhys();
                totalMemory = this.proxy.getTotalPhys();
            } else {
                return;
            }
            this.big.setColor(Color.green);
            this.big.drawString(String.valueOf((int)totalMemory / 1024) + "K " + ShowSysInfoUI.this.ALLOC, 4.0f, (float)this.ascent + 0.5f);
            this.usedStr = String.valueOf((int)(totalMemory - freeMemory) / 1024) + "K " + ShowSysInfoUI.this.USED;
            this.big.drawString(this.usedStr, 4, this.h - this.descent);
            float ssH = this.ascent + this.descent;
            float remainingHeight = (float)this.h - ssH * 2.0f - 0.5f;
            float blockHeight = remainingHeight / 10.0f;
            float blockWidth = 20.0f;
            float remainingWidth = (float)this.w - blockWidth - 10.0f;
            this.big.setColor(this.mfColor);
            int MemUsage = (int)(freeMemory / totalMemory * 10.0f);
            for (i = 0; i < MemUsage; ++i) {
                this.mfRect.setRect(5.0, ssH + (float)i * blockHeight, blockWidth, blockHeight - 1.0f);
                this.big.fill(this.mfRect);
            }
            this.big.setColor(Color.green);
            while (i < 10) {
                this.muRect.setRect(5.0, ssH + (float)i * blockHeight, blockWidth, blockHeight - 1.0f);
                this.big.fill(this.muRect);
                ++i;
            }
            this.big.setColor(this.graphColor);
            int graphX = 30;
            int graphY = (int)ssH;
            int graphW = this.w - graphX - 5;
            int graphH = (int)remainingHeight;
            this.graphOutlineRect.setRect(graphX, graphY, graphW, graphH);
            this.big.draw(this.graphOutlineRect);
            int graphRow = graphH / 10;
            for (int j2 = graphY; j2 <= graphH + graphY; j2 += graphRow) {
                this.graphLine.setLine(graphX, j2, graphX + graphW, j2);
                this.big.draw(this.graphLine);
            }
            int graphColumn = graphW / 15;
            if (this.columnInc == 0) {
                this.columnInc = graphColumn;
            }
            for (j = graphX + this.columnInc; j < graphW + graphX; j += graphColumn) {
                this.graphLine.setLine(j, graphY, j, graphY + graphH);
                this.big.draw(this.graphLine);
            }
            --this.columnInc;
            if (this.pts == null) {
                this.pts = new int[graphW];
                this.ptNum = 0;
            } else if (this.pts.length != graphW) {
                int[] tmp = null;
                if (this.ptNum < graphW) {
                    tmp = new int[this.ptNum];
                    System.arraycopy(this.pts, 0, tmp, 0, tmp.length);
                } else {
                    tmp = new int[graphW];
                    System.arraycopy(this.pts, this.pts.length - tmp.length, tmp, 0, tmp.length);
                    this.ptNum = tmp.length - 2;
                }
                this.pts = new int[graphW];
                System.arraycopy(tmp, 0, this.pts, 0, tmp.length);
            } else {
                this.big.setColor(Color.yellow);
                this.pts[this.ptNum] = (int)((float)graphY + (float)graphH * (freeMemory / totalMemory));
                j = graphX + graphW - this.ptNum;
                int k = 0;
                while (k < this.ptNum) {
                    if (k != 0) {
                        if (this.pts[k] != this.pts[k - 1]) {
                            this.big.drawLine(j - 1, this.pts[k - 1], j, this.pts[k]);
                        } else {
                            this.big.fillRect(j, this.pts[k], 1, 1);
                        }
                    }
                    ++k;
                    ++j;
                }
                if (this.ptNum + 2 == this.pts.length) {
                    for (j = 1; j < this.ptNum; ++j) {
                        this.pts[j - 1] = this.pts[j];
                    }
                    --this.ptNum;
                } else {
                    ++this.ptNum;
                }
            }
            g.drawImage(this.bimg, 0, 0, this);
        }

        public void start() {
            this.thread = new Thread(this);
            this.thread.setPriority(1);
            this.thread.setName("MemoryMonitor");
            this.thread.start();
        }

        public synchronized void stop() {
            this.thread = null;
            this.notify();
        }

        @Override
        public void run() {
            Thread me = Thread.currentThread();
            while (this.thread == me && !this.isShowing() || this.getSize().width == 0) {
                try {
                    Thread.sleep(500L);
                }
                catch (InterruptedException e) {
                    return;
                }
            }
            while (this.thread == me && this.isShowing()) {
                Dimension d = this.getSize();
                if (d.width != this.w || d.height != this.h) {
                    this.w = d.width;
                    this.h = d.height;
                    this.bimg = (BufferedImage)this.createImage(this.w, this.h);
                    this.big = this.bimg.createGraphics();
                    FontMetrics fm = this.big.getFontMetrics(this.font);
                    this.ascent = fm.getAscent();
                    this.descent = fm.getDescent();
                }
                this.repaint();
                try {
                    Thread.sleep(this.sleepAmount);
                }
                catch (InterruptedException e) {
                    break;
                }
            }
            this.thread = null;
        }
    }
}

