/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.uiframe.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.BOSObjectFactory;
import com.kingdee.bos.Context;
import com.kingdee.bos.ORMRPCServiceLocator;
import com.kingdee.bos.ctrl.swing.util.CtrlSwingUtilities;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.framework.cache.ActionCache;
import com.kingdee.bos.invokecounter.RPCInvokeCounter;
import com.kingdee.bos.invokecounter.RPCLogEventQueue;
import com.kingdee.bos.invokecounter.RpcLogFtpUploader;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.bos.ui.face.UIException;
import com.kingdee.eas.base.message.client.TempMsgManager;
import com.kingdee.eas.base.permission.BasePMException;
import com.kingdee.eas.base.permission.UserFactory;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.base.ui.IMainUIContainer;
import com.kingdee.eas.base.uiframe.EASLoginException;
import com.kingdee.eas.base.uiframe.client.EmbedMainUI;
import com.kingdee.eas.base.uiframe.client.IWebListener;
import com.kingdee.eas.base.uiframe.client.LoginFrame;
import com.kingdee.eas.base.uiframe.client.LoginHelper;
import com.kingdee.eas.base.uiframe.client.LoginParamCacheUtil;
import com.kingdee.eas.base.uiframe.client.MainFrameCallBack;
import com.kingdee.eas.base.uiframe.client.MainFunctionMenuUI;
import com.kingdee.eas.base.uiframe.client.MainStatusBarManager;
import com.kingdee.eas.base.uiframe.client.MainUIObjectManager;
import com.kingdee.eas.base.uiframe.client.MenuVisitorHelper;
import com.kingdee.eas.base.uiframe.client.MsgPanelUtil;
import com.kingdee.eas.base.uiframe.client.NewMainFrame;
import com.kingdee.eas.base.uiframe.client.NewMainFunctionMenuUI;
import com.kingdee.eas.base.uiframe.client.VMoptions;
import com.kingdee.eas.base.uiframe.client.WebInvoker;
import com.kingdee.eas.base.uiframe.client.ui.IMainUIObject;
import com.kingdee.eas.base.uiframe.client.ui.web20.statistics.UserOprationObserver;
import com.kingdee.eas.base.uiframe.utils.ParamUtils;
import com.kingdee.eas.base.uiframe.utils.UIFrameUtils;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.basedata.org.MultiOrgSwitchUtils;
import com.kingdee.eas.basedata.org.client.DefaultOrgF7PromptDialog;
import com.kingdee.eas.basedata.org.client.SwitchOrgF7PromptDialog;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.csinterface.util.ThrowableHelper;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.client.customized.PlatformParam;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.ExceptionHandler;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.EventQueue;
import java.awt.Frame;
import java.awt.Toolkit;
import java.io.File;
import java.util.Locale;
import java.util.Map;
import javax.swing.JApplet;
import javax.swing.JOptionPane;
import org.apache.log4j.Logger;

public class SystemEntry {
    protected static final Logger logger = Logger.getLogger(SystemEntry.class);
    private static final String RESOURCE = "com.kingdee.eas.base.permission.PermissionResource";
    private int winState = 0;
    public static boolean isReLogin = false;
    public boolean isVirtulLogin = false;
    public static final int CLIENTSTART = 0;
    public static final int WEBSTART = 1;
    public static final int WEBEMBEDSTART = 2;
    private boolean isRunedMetaLoadThread = false;
    private int startMode = 0;
    public static final int DB_SQLSERVER = 0;
    public static final int DB_DB2 = 1;
    public static final int DB_ORACLE = 2;
    public static final SystemEntry instance = new SystemEntry();
    IMainUIContainer container = null;
    public IMainUIObject mainUIObject = null;
    IMainUIContainer mainFrameInstance = null;
    JApplet applet = null;
    public boolean isToEas = false;

    public JApplet getApplet() {
        return this.applet;
    }

    public void setApplet(JApplet applet) {
        this.applet = applet;
    }

    private SystemEntry() {
    }

    public int getStartMode() {
        return this.startMode;
    }

    public void setStartMode(int startMode) {
        this.startMode = startMode;
    }

    public boolean isWebStart() {
        return this.startMode != 0;
    }

    public boolean isEmbedStart() {
        return this.startMode == 2;
    }

    public String login(String userName, String password, String slnName, String dcName, Locale locale) throws BasePMException, EASLoginException {
        return this.login(userName, password, slnName, dcName, locale, 0, "");
    }

    public String login(String userName, String password, String slnName, String dcName, Locale locale, int dbType) throws BasePMException, EASLoginException {
        return this.login(userName, password, slnName, dcName, locale, dbType, "");
    }

    public String login(String userName, String password, String slnName, String dcName, Locale locale, int dbType, String authPattern) throws BasePMException, EASLoginException {
        long start = System.currentTimeMillis();
        String sessionId = null;
        this.beforeLogin();
        long showCost = System.currentTimeMillis() - start;
        if (UIFrameUtils.isLogged()) {
            logger.info((Object)UIFrameUtils.getLogText("SystemEntry.login" + UIFrameUtils.getRes("res_47") + ">beforeLogin(),spent:" + showCost + " ms."));
        }
        long start1 = System.currentTimeMillis();
        sessionId = LoginHelper.loginExcludeInit(userName, password, slnName, dcName, locale, dbType, authPattern);
        showCost = System.currentTimeMillis() - start1;
        if (UIFrameUtils.isLogged()) {
            logger.info((Object)UIFrameUtils.getLogText("SystemEntry.login" + UIFrameUtils.getRes("res_47") + ">LoginHelper.loginExcludeInit(),spent:" + showCost + " ms."));
        }
        long cost = System.currentTimeMillis() - start;
        logger.debug((Object)("Login system env var : " + cost + " ms! seesionId=" + sessionId));
        start1 = System.currentTimeMillis();
        this.initAfterLogin();
        showCost = System.currentTimeMillis() - start1;
        if (UIFrameUtils.isLogged()) {
            logger.info((Object)UIFrameUtils.getLogText("SystemEntry.login" + UIFrameUtils.getRes("res_47") + ">initAfterLogin(),spent:" + showCost + " ms."));
        }
        return sessionId;
    }

    public String login(String userName, String password, String slnName, String dcName, Locale locale, int dbType, String authPattern, Map extendMap) throws BasePMException, EASLoginException {
        long start = System.currentTimeMillis();
        String sessionId = null;
        this.beforeLogin();
        long showCost = System.currentTimeMillis() - start;
        if (UIFrameUtils.isLogged()) {
            logger.info((Object)UIFrameUtils.getLogText("SystemEntry.login" + UIFrameUtils.getRes("res_47") + ">beforeLogin(),spent:" + showCost + " ms."));
        }
        long start1 = System.currentTimeMillis();
        sessionId = LoginHelper.loginExcludeInit(userName, password, slnName, dcName, locale, dbType, authPattern, extendMap);
        showCost = System.currentTimeMillis() - start1;
        if (UIFrameUtils.isLogged()) {
            logger.info((Object)UIFrameUtils.getLogText("SystemEntry.login" + UIFrameUtils.getRes("res_47") + ">LoginHelper.loginExcludeInit(),spent:" + showCost + " ms."));
        }
        long cost = System.currentTimeMillis() - start;
        logger.debug((Object)("Login system env var : " + cost + " ms! seesionId=" + sessionId));
        start1 = System.currentTimeMillis();
        this.initAfterLogin();
        showCost = System.currentTimeMillis() - start1;
        if (UIFrameUtils.isLogged()) {
            logger.info((Object)UIFrameUtils.getLogText("SystemEntry.login" + UIFrameUtils.getRes("res_47") + ">initAfterLogin(),spent:" + showCost + " ms."));
        }
        return sessionId;
    }

    public void initAfterLogin() {
        try {
            LoginHelper.initAfterLogin();
            TempMsgManager.getInstance();
            this.initWebListerner();
        }
        catch (Exception e) {
            ExceptionHandler.handle((Component)this.getOwnerFrame(), (Throwable)e);
        }
    }

    private void beforeLogin() {
        isReLogin = false;
    }

    public Context innerReLogin() throws BasePMException, EASLoginException {
        String orgId = SysContext.getSysContext().getCurrentOrgUnit().getId().toString();
        Context ctx = LoginHelper.innerReLogin();
        try {
            MultiOrgSwitchUtils.switchOrgForLogin(null, (String)orgId);
        }
        catch (EASBizException e) {
            logger.info((Object)"switchOrgForLogin is:", (Throwable)e);
        }
        catch (BOSException e) {
            logger.info((Object)"switchOrgForLogin is:", (Throwable)e);
        }
        return ctx;
    }

    public void relogin(boolean type) throws BasePMException, EASLoginException {
        if (type) {
            this.relogin();
        } else {
            LoginHelper.relogin(false);
        }
    }

    public void relogin() throws BasePMException, EASLoginException {
        if (this.isWebStart()) {
            MainFrameCallBack.rLoginPortal();
            return;
        }
        isReLogin = true;
        boolean closeOk = false;
        closeOk = MainUIObjectManager.getInstance().closeApplication(false);
        if (!closeOk) {
            isReLogin = false;
            return;
        }
        this.logout();
        if (!this.isWebStart()) {
            LoginFrame login = LoginFrame.getInstance();
            login.show();
        }
        MenuVisitorHelper.setMenuCacheParam();
        LoginParamCacheUtil.clearParamCache();
        MainFunctionMenuUI.clearMap();
        PlatformParam.refreshPlatformParamCaches();
    }

    public void logout() throws EASLoginException {
        NewMainFunctionMenuUI.saveMenuCacheToLocalFile();
        MsgPanelUtil.clearCache();
        MainFrameCallBack.firePropertyChange("ReLogin", "old", "new");
        try {
            if (ParamUtils.getBooleanParamValue(null, null, "EnableWeb20")) {
                UserOprationObserver.logout();
            }
            LoginHelper.logout();
        }
        finally {
            CtrlSwingUtilities.clearMenuKeyboardHelper();
            MainUIObjectManager.getInstance().clearInstance();
            MainFrameCallBack.clearCallBack();
            MainStatusBarManager.clearStatus();
            this.clearInstance();
        }
    }

    public void closeApplication(boolean isConfirm) throws EASLoginException {
        if (MainUIObjectManager.getInstance().closeApplication(isConfirm)) {
            this.logout();
            TempMsgManager.stopInspectTimer();
        } else {
            SysUtil.abort();
        }
    }

    public void closeApplication() throws EASLoginException {
        MainUIObjectManager.getInstance().closeApplication();
    }

    public boolean closingWindow(IMainUIContainer uiContainer, boolean closeConfirm) {
        return MainUIObjectManager.getInstance().closingWindow(uiContainer, closeConfirm);
    }

    public void changeDefaultOrg(Frame owner) {
        if (owner == null) {
            owner = this.getOwnerFrame();
        }
        UserInfo userInfo = SysContext.getSysContext().getCurrentUserInfo();
        DefaultOrgF7PromptDialog orgF7 = new DefaultOrgF7PromptDialog(owner);
        orgF7.setTitle(EASResource.getString((String)RESOURCE, (String)"setDefaultOrg"));
        orgF7.setMultiSelect(false);
        orgF7.show();
        FullOrgUnitInfo newDefaultOrgInfo = (FullOrgUnitInfo)orgF7.getData();
        if (newDefaultOrgInfo == null) {
            return;
        }
        UserInfo newUserInfo = new UserInfo();
        newUserInfo.setDefOrgUnit(newDefaultOrgInfo);
        newUserInfo.setId(userInfo.getId());
        try {
            UserFactory.getRemoteInstance().update((IObjectPK)new ObjectUuidPK(userInfo.getId()), (CoreBaseInfo)newUserInfo);
            userInfo.setDefOrgUnit(newDefaultOrgInfo);
        }
        catch (Exception e) {
            logger.error((Object)e);
            MsgBox.showDetailAndOK((Component)owner, (String)EASResource.getString((String)RESOURCE, (String)"changeDefaultOrgFail"), (String)ThrowableHelper.toString((Exception)e), (int)1);
            return;
        }
        int choise = MsgBox.showConfirm2((String)EASResource.getString((String)RESOURCE, (String)"changeDefaultOrgSuccess"));
        switch (choise) {
            case 0: {
                if (!MultiOrgSwitchUtils.checkBeforeSwitch((Component)owner)) {
                    return;
                }
                MultiOrgSwitchUtils.switchOrgForClient((Component)owner, (String)newDefaultOrgInfo.getId().toString());
                break;
            }
            case 1: {
                break;
            }
        }
    }

    public void switchOrg(Frame owner) {
        if (owner == null) {
            owner = this.getOwnerFrame();
        }
        if (!MultiOrgSwitchUtils.checkBeforeSwitch((Component)owner)) {
            return;
        }
        SwitchOrgF7PromptDialog f7ui = new SwitchOrgF7PromptDialog(owner);
        f7ui.show();
    }

    private void initRes() {
        File datacenter = new File(System.getProperty("EAS_HOME") + File.separator + "client" + File.separator + "deploy" + File.separator + "client" + File.separator + "datacenters.xml");
        if (datacenter.exists()) {
            datacenter.delete();
        }
    }

    public void initSystem(final String appServerUrl, boolean isSupportMutilThread) throws Exception {
        long start = System.currentTimeMillis();
        if (System.getProperty("EAS_SERVER") == null && appServerUrl != null) {
            System.setProperty("EAS_SERVER", appServerUrl);
        }
        long vmStart = System.currentTimeMillis();
        VMoptions vm = new VMoptions();
        vm.initSystemPor();
        long vmCost = System.currentTimeMillis() - vmStart;
        logger.info((Object)("Init VMoptions of init system env var :" + vmCost + " ms."));
        Thread loadConfigFileThread = new Thread(){

            @Override
            public void run() {
                long initConfigStart = System.currentTimeMillis();
                LoginHelper.initTempUrl(appServerUrl);
                ORMRPCServiceLocator.setCurrentServiceURL((String)appServerUrl);
                BOSObjectFactory.clearSession((String)appServerUrl);
                long initConfigCost = System.currentTimeMillis() - initConfigStart;
                logger.info((Object)(" load config.xml of init system env var (MutilThread) :" + initConfigCost + " ms."));
            }
        };
        loadConfigFileThread.start();
        long log4jStart = System.currentTimeMillis();
        LoginHelper.initLog4jConfig();
        long log4jCost = System.currentTimeMillis() - log4jStart;
        logger.info((Object)("initLog4jConfig of init system env var :" + log4jCost + " ms."));
        LoginHelper.initExceptionHandler();
        LoginHelper.initMetaDataLoader();
        long start1 = System.currentTimeMillis();
        if (isSupportMutilThread) {
            LoginHelper.startMetaLoadThread(1);
        } else {
            LoginHelper.startMetaLoadThread(0);
        }
        long showCost = System.currentTimeMillis() - start1;
        if (UIFrameUtils.isLogged()) {
            logger.info((Object)UIFrameUtils.getLogText("LoginHelper.startMetaLoadThread(),spent111:" + showCost + " ms."));
        }
        if (LoginHelper.getLookAndFeelStyle() == 0) {
            LoginHelper.setLookFeel();
        }
        if (LoginHelper.getIconLoadStyle() == 0) {
            LoginHelper.startInitConfig();
        }
        Toolkit.getDefaultToolkit().getSystemEventQueue().push((EventQueue)new RPCLogEventQueue());
        RpcLogFtpUploader.addShutdownHook();
        long cost = System.currentTimeMillis() - start;
        this.initRes();
        RPCInvokeCounter.init();
        ActionCache.init();
        if (UIFrameUtils.isLogged()) {
            logger.info((Object)UIFrameUtils.getLogText("Init system env var : " + cost + " ms!"));
        }
    }

    public void initWebListerner() {
        try {
            if (this.applet == null) {
                return;
            }
            WebInvoker.clearInstace();
            WebInvoker webInvoker = WebInvoker.createInstance(this.applet);
            String keys = null;
            if (!this.applet.getName().equals("apploader")) {
                keys = this.applet.getParameter("WebListener");
            }
            if (keys == null || "".equals(keys)) {
                keys = "com.kingdee.eas.cp.eip.apploader.RefreshPageJSParameterProvider;com.kingdee.eas.cp.eip.apploader.CMAuditingJSParameterProvider;com.kingdee.eas.cp.eip.apploader.DPAuditingJSParameterProvider";
            }
            String[] lists = keys.split(";");
            for (int i = 0; i < lists.length; ++i) {
                try {
                    String key = lists[i];
                    IWebListener webListener = (IWebListener)Class.forName(key.trim()).newInstance();
                    webInvoker.addListener(webListener);
                    continue;
                }
                catch (InstantiationException e) {
                    logger.error((Object)e);
                    continue;
                }
                catch (IllegalAccessException e) {
                    logger.error((Object)e);
                    continue;
                }
                catch (ClassNotFoundException e) {
                    logger.error((Object)e);
                }
            }
        }
        catch (Exception e0) {
            logger.error((Object)e0);
        }
    }

    protected void beforeStart() {
        isReLogin = false;
    }

    public IMainUIObject startApplication(IUIObject uiObject) throws UIException {
        IMainUIObject mainUIObj;
        if (this.startMode == 0) {
            mainUIObj = this.clientEntryStart(uiObject);
            logger.info((Object)"************************This is StartMode : CLIENTSTART ");
        } else if (this.startMode == 2) {
            mainUIObj = this.webEmbedEntryStart((IMainUIContainer)this.applet, uiObject);
            logger.info((Object)"************************This is StartMode : WEBEMBEDSTART ");
        } else {
            mainUIObj = this.webEntryStart(this.applet, uiObject);
            logger.info((Object)"************************This is StartMode : WEBE START ");
        }
        this.afterLoginApp();
        return mainUIObj;
    }

    public IMainUIObject startApplication() throws UIException {
        IMainUIObject mainUIObj = null;
        if (this.startMode == 0) {
            mainUIObj = this.clientEntryStart();
        } else if (this.startMode == 2) {
            mainUIObj = this.webEmbedEntryStart((IMainUIContainer)this.applet);
        }
        this.afterLoginApp();
        if (mainUIObj != null && mainUIObj.getMainOwner() != null) {
            mainUIObj.getMainOwner().repaint();
        }
        return mainUIObj;
    }

    public IMainUIObject clientEntryStart() throws UIException {
        if (UIFrameUtils.isLogged()) {
            logger.info((Object)UIFrameUtils.getLogText(" SystemEntry.clientEntryStart() begin......"));
        }
        long start = System.currentTimeMillis();
        if (this.container != null && this.container instanceof NewMainFrame) {
            if (UIFrameUtils.isLogged()) {
                logger.info((Object)UIFrameUtils.getLogText(" SystemEntry.clientEntryStart() end direct......  spent: " + (System.currentTimeMillis() - start) + "ms!"));
            }
            return ((NewMainFrame)this.container).getMainUI();
        }
        long start1 = System.currentTimeMillis();
        this.beforeStart();
        if (UIFrameUtils.isLogged()) {
            logger.info((Object)UIFrameUtils.getLogText(" SystemEntry.clientEntryStart().beforeStart() end......  spent: " + (System.currentTimeMillis() - start1) + "ms!"));
        }
        start1 = System.currentTimeMillis();
        NewMainFrame mainFrame = new NewMainFrame();
        if (UIFrameUtils.isLogged()) {
            logger.info((Object)UIFrameUtils.getLogText(" SystemEntry.clientEntryStart().new NewMainFrame() end......  spent: " + (System.currentTimeMillis() - start1) + "ms!"));
        }
        this.mainFrameInstance = mainFrame;
        start1 = System.currentTimeMillis();
        this.mainUIObject = mainFrame.getMainUI();
        if (UIFrameUtils.isLogged()) {
            logger.info((Object)UIFrameUtils.getLogText(" SystemEntry.clientEntryStart().mainFrame.getMainUI() end......  spent: " + (System.currentTimeMillis() - start1) + "ms!"));
        }
        if (UIFrameUtils.isLogged()) {
            logger.info((Object)UIFrameUtils.getLogText(" SystemEntry.clientEntryStart() end......  spent: " + (System.currentTimeMillis() - start) + "ms!"));
        }
        UIFrameUtils.marked();
        return this.mainUIObject;
    }

    private void afterLoginApp() {
        if (LoginParamCacheUtil.isEnableWeb20()) {
            UserOprationObserver.login();
        }
    }

    public IMainUIObject webEmbedEntryStart(IMainUIContainer applet, IUIObject uiObject) {
        if (LoginHelper.getLoadStyle() == 0) {
            this.beforeStart();
            if (this.getCurrenContainer() != null) {
                return this.mainUIObject;
            }
            this.setStartMode(2);
            JApplet app = (JApplet)applet;
            EmbedMainUI mainUI = null;
            try {
                Frame frame = JOptionPane.getFrameForComponent(app);
                mainUI = new EmbedMainUI(applet, uiObject);
                app.getContentPane().setLayout(new BorderLayout());
                app.setContentPane((Container)((Object)mainUI));
                mainUI.setMainOwner(frame);
                mainUI.initBody();
                MainUIObjectManager.getInstance().setMainUIObject(mainUI);
                MainUIObjectManager.getInstance().addSession(applet);
                this.container = applet;
                this.setCurrenContainer(applet);
                this.mainUIObject = mainUI;
                if (this.mainUIObject.getBodyUI().getOpenSysTabThread() != null) {
                    this.mainUIObject.getBodyUI().getOpenSysTabThread().start();
                }
                applet.setInit(true);
                return mainUI;
            }
            catch (UIException e) {
                ExceptionHandler.handle((Component)app, (Throwable)e);
                return null;
            }
        }
        if (Thread.currentThread().getName().equals("LoadAuthenticatingThread")) {
            return this.webEmbedEntryStart(applet);
        }
        long startMainFrame = System.currentTimeMillis();
        JApplet app = (JApplet)applet;
        if (LoginHelper.getLoadAuthenticatingThread() != null && LoginHelper.getLoadAuthenticatingThread().isAlive()) {
            try {
                LoginHelper.getLoadAuthenticatingThread().join();
            }
            catch (Exception e) {
                logger.info((Object)"interrupt thread eror.");
            }
        }
        try {
            EmbedMainUI mainUI = null;
            Frame frame = JOptionPane.getFrameForComponent(app);
            mainUI = new EmbedMainUI(applet, null);
            app.setContentPane((Container)((Object)mainUI));
            mainUI.setMainOwner(frame);
            this.mainUIObject = mainUI;
            MainUIObjectManager.getInstance().setMainUIObject(mainUI);
            MainUIObjectManager.getInstance().getMainUIObject().initBody();
            if (this.mainUIObject.getBodyUI().getOpenSysTabThread() != null) {
                this.mainUIObject.getBodyUI().getOpenSysTabThread().start();
            }
        }
        catch (UIException e) {
            ExceptionHandler.handle((Component)app, (Throwable)e);
        }
        long costMainFrame = System.currentTimeMillis() - startMainFrame;
        logger.info((Object)(" only show main frame spent:" + costMainFrame + " ms."));
        return this.mainUIObject;
    }

    public IMainUIObject webEmbedEntryStart(IMainUIContainer applet) {
        this.beforeStart();
        if (this.getCurrenContainer() != null) {
            return this.mainUIObject;
        }
        this.setStartMode(2);
        JApplet app = (JApplet)applet;
        IMainUIObject mainUI = null;
        app.getContentPane().setLayout(new BorderLayout());
        MainUIObjectManager.getInstance().addSession(applet);
        this.container = applet;
        this.setCurrenContainer(applet);
        this.mainUIObject = mainUI;
        applet.setInit(true);
        return mainUI;
    }

    public IMainUIObject webEntryStart(JApplet applet0, IUIObject uiObject) throws UIException {
        if (LoginHelper.getLoadStyle() == 0) {
            if (applet0 != null) {
                this.applet = applet0;
            }
            NewMainFrame mainFrame = null;
            if (this.container == null) {
                mainFrame = (NewMainFrame)this.clientEntryStart(uiObject).getUIContainer();
            } else {
                mainFrame = (NewMainFrame)this.container;
                boolean isShowing = mainFrame.isShowing();
                mainFrame.show();
                if (!isShowing) {
                    mainFrame.setExtendedState(6);
                }
            }
            this.mainUIObject = mainFrame.getMainUI();
        } else {
            if (Thread.currentThread().getName().equals("LoadAuthenticatingThread")) {
                return this.webEntryStart(applet0);
            }
            long startMainFrame = System.currentTimeMillis();
            if (LoginHelper.getLoadAuthenticatingThread() != null && LoginHelper.getLoadAuthenticatingThread().isAlive()) {
                try {
                    LoginHelper.getLoadAuthenticatingThread().join();
                }
                catch (Exception e) {
                    logger.info((Object)e);
                }
            }
            if (this.mainFrameInstance instanceof NewMainFrame) {
                NewMainFrame mainFrame = (NewMainFrame)this.mainFrameInstance;
                if (!instance.isWebStart()) {
                    LoginFrame.getInstance().hideInstance();
                }
                if (this.mainUIObject == null) {
                    mainFrame.setDefaultUIObject(null);
                    mainFrame.doubleShow();
                    this.container = mainFrame;
                    boolean isShowing = mainFrame.isShowing();
                    if (!isShowing) {
                        mainFrame.setExtendedState(6);
                    }
                    this.mainUIObject = mainFrame.getMainUI();
                } else {
                    boolean isShowing = mainFrame.isShowing();
                    mainFrame.show();
                    if (!isShowing) {
                        mainFrame.setExtendedState(6);
                    }
                }
            }
            long costMainFrame = System.currentTimeMillis() - startMainFrame;
            logger.info((Object)(" only show main frame spent:" + costMainFrame + " ms."));
        }
        return this.mainUIObject;
    }

    public IMainUIObject webEntryStart(JApplet applet0) throws UIException {
        if (applet0 != null) {
            this.applet = applet0;
        }
        NewMainFrame mainFrame = null;
        if (this.container == null) {
            this.clientEntryStart();
            mainFrame = (NewMainFrame)instance.getCurrenContainer();
        } else {
            mainFrame = (NewMainFrame)this.container;
        }
        return this.mainUIObject;
    }

    public IMainUIObject clientEntryStart(IUIObject uiObject) throws UIException {
        if (UIFrameUtils.isLogged()) {
            logger.info((Object)UIFrameUtils.getLogText(" SystemEntry.clientEntryStart(IUIObject):LoginHelper.getLoadStyle()=" + LoginHelper.getLoadStyle()));
        }
        if (LoginHelper.getLoadStyle() == 0) {
            if (this.container != null && this.container instanceof NewMainFrame) {
                return ((NewMainFrame)this.container).getMainUI();
            }
            this.initAfterLogin();
            this.beforeStart();
            NewMainFrame mainFrame = new NewMainFrame(uiObject);
            if (!this.isWebStart()) {
                SystemEntry.instance.isToEas = true;
                LoginFrame.getInstance().hideInstance();
            }
            this.container = mainFrame;
            this.mainUIObject = mainFrame.getMainUI();
            mainFrame.doubleShow();
        } else {
            if (Thread.currentThread().getName().equals("LoadAuthenticatingThread")) {
                return this.clientEntryStart();
            }
            long startMainFrame = System.currentTimeMillis();
            if (LoginHelper.getLoadAuthenticatingThread() != null && LoginHelper.getLoadAuthenticatingThread().isAlive()) {
                try {
                    LoginHelper.getLoadAuthenticatingThread().join();
                }
                catch (Exception e) {
                    logger.info((Object)e);
                }
            }
            if (this.mainFrameInstance != null) {
                this.initAfterLogin();
                NewMainFrame mainFrame = (NewMainFrame)this.mainFrameInstance;
                try {
                    if (!instance.isWebStart()) {
                        SystemEntry.instance.isToEas = true;
                        LoginFrame.getInstance().hideInstance();
                    }
                    mainFrame.setDefaultUIObject(null);
                    this.container = mainFrame;
                    SystemEntry.instance.mainUIObject = mainFrame.getMainUI();
                    mainFrame.doubleShow();
                }
                catch (Exception e) {
                    ExceptionHandler.handle((Throwable)e);
                }
            }
            long costMainFrame = System.currentTimeMillis() - startMainFrame;
            logger.info((Object)(" only show main frame spent:" + costMainFrame + " ms."));
        }
        return this.mainUIObject;
    }

    public NewMainFrame newSessionStart(IUIObject uiObject) throws UIException {
        NewMainFrame mainframe = new NewMainFrame(uiObject);
        mainframe.doubleShow();
        return mainframe;
    }

    public IMainUIContainer getCurrenContainer() {
        return this.container;
    }

    public void setCurrenContainer(IMainUIContainer container) {
        if (this.container == null) {
            return;
        }
        this.container = container;
        if (container instanceof NewMainFrame && ((NewMainFrame)container).isActive()) {
            this.mainUIObject = ((NewMainFrame)container).getMainUI();
        }
    }

    public void createCurrenContainer(IUIObject uiObject) {
        if (this.container == null) {
            try {
                NewMainFrame mainFrame = new NewMainFrame(uiObject);
                if (!this.isWebStart()) {
                    SystemEntry.instance.isToEas = true;
                    LoginFrame.getInstance().hideInstance();
                }
                this.container = mainFrame;
                this.mainUIObject = mainFrame.getMainUI();
                mainFrame.doubleShow();
            }
            catch (UIException err) {
                logger.error((Object)err);
            }
        }
    }

    public Frame getOwnerFrame() {
        if (this.isEmbedStart()) {
            return JOptionPane.getFrameForComponent(this.applet);
        }
        if (this.isWebStart()) {
            if (this.container instanceof NewMainFrame ? !((NewMainFrame)this.container).isVisible() : this.applet != null) {
                return JOptionPane.getFrameForComponent(this.applet);
            }
        } else if (this.container == null) {
            return (Frame)LoginFrame.getLoginFrame();
        }
        return (Frame)this.container;
    }

    public void clearInstance() {
        this.container = null;
        this.mainUIObject = null;
    }

    public IMainUIObject getMainUIObject() {
        return this.mainUIObject;
    }

    public int getWinState() {
        return this.winState;
    }

    public void setWinState(int winState) {
        this.winState = winState;
    }

    public boolean isClose() {
        return this.winState == 1;
    }

    public boolean setClose() {
        return this.winState == 0;
    }

    public void setRunedMetaLoadThread(boolean isRunedMetaLoadThread) {
        this.isRunedMetaLoadThread = isRunedMetaLoadThread;
    }

    public boolean isRunedMetaLoadThread() {
        return this.isRunedMetaLoadThread;
    }
}

