/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.uiframe.client;

import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.util.StringUtils;
import java.util.HashMap;
import java.util.Map;

public class UIFindCond {
    String uiClassName = null;
    Map uiContext = null;
    Map dataObjects = null;
    String oprt = null;
    boolean onUIContext = true;
    boolean onDataObject = true;
    boolean onOprt = true;
    String uiClassParam = null;
    String expectParam = null;

    UIFindCond() {
    }

    UIFindCond(IUIObject ui) {
        this.uiClassName = ui.getClass().getName();
        this.uiContext = ui.getUIContext();
        this.dataObjects = ui.getDataObjects();
        this.oprt = ui.getOprtState();
        if (this.uiContext != null) {
            this.uiClassParam = (String)this.uiContext.get("UIClassParam");
            this.expectParam = (String)this.uiContext.get("BOTPUIParam");
        }
    }

    UIFindCond(String uiClassName, Map uiContext, Map dataObjects, String oprt) {
        this(uiClassName, uiContext, dataObjects, oprt, null);
    }

    UIFindCond(String uiClassName, Map uiContext, Map dataObjects, String oprt, String uiClassParam) {
        this.uiClassName = uiClassName;
        this.uiContext = uiContext;
        this.dataObjects = dataObjects;
        this.oprt = oprt;
        this.uiClassParam = uiClassParam;
        if (uiContext != null) {
            this.expectParam = (String)uiContext.get("BOTPUIParam");
        }
    }

    void enableCond(boolean onUIContext, boolean onDataObject, boolean onOprt) {
        this.onUIContext = onUIContext;
        this.onDataObject = onDataObject;
        this.onOprt = onOprt;
    }

    private static boolean checkDataObjectsEqual(Map source, Map target) {
        return true;
    }

    private static boolean checkUIContextEqual(Map source, Map target) {
        if (source == null) {
            source = new HashMap();
        }
        if (target == null) {
            target = new HashMap();
        }
        if (source.size() < target.size()) {
            return false;
        }
        for (Map.Entry targetEntry : target.entrySet()) {
            if ("checkLicense".equals(targetEntry.getKey())) continue;
            if (!source.containsKey(targetEntry.getKey())) {
                return false;
            }
            Object sourceValue = source.get(targetEntry.getKey());
            if (targetEntry.getValue() == sourceValue) continue;
            if (targetEntry.getValue() != null && sourceValue != null) {
                if (!(targetEntry.getValue() instanceof String) || !(sourceValue instanceof String) || targetEntry.getValue().equals(sourceValue)) continue;
                return false;
            }
            return false;
        }
        return true;
    }

    private static boolean checkStringEqual(String source, String target) {
        if ("".equals(source)) {
            source = null;
        }
        if ("".equals(target)) {
            target = null;
        }
        if (source == target) {
            return true;
        }
        if (source != null && target != null) {
            return source.equals(target);
        }
        return false;
    }

    private static boolean checkOprtEqual(String source, String target) {
        if ("".equals(source)) {
            source = null;
        }
        if ("".equals(target)) {
            target = null;
        }
        if (source == target) {
            return true;
        }
        if (!"EDIT".equals(source) && !"VIEW".equals(source)) {
            return true;
        }
        if (source == target) {
            return true;
        }
        if (source != null && target != null) {
            return source.equals(target);
        }
        return false;
    }

    private static boolean checkUIClassNameEqual(String source, String target) {
        if ("".equals(source)) {
            source = null;
        }
        if ("".equals(target)) {
            target = null;
        }
        if (source == target) {
            return true;
        }
        if (source != null && target != null) {
            return source.equals(target) || source.equals(target + "PIEx") || source.equals(target + "CTEx");
        }
        return false;
    }

    boolean checkCondition(UIFindCond cond) {
        return !(!UIFindCond.checkUIClassNameEqual(this.uiClassName, cond.uiClassName) && !this.checkOriginalMenuClassName(cond.uiClassName) || cond.onUIContext && !UIFindCond.checkUIContextEqual(this.uiContext, cond.uiContext) || cond.onDataObject && !UIFindCond.checkDataObjectsEqual(this.dataObjects, cond.dataObjects) || cond.onOprt && !UIFindCond.checkOprtEqual(this.oprt, cond.oprt) || !UIFindCond.checkStringEqual(this.uiClassParam, cond.uiClassParam) || !UIFindCond.checkStringEqual(this.expectParam, cond.expectParam));
    }

    private boolean checkOriginalMenuClassName(String uiClassName) {
        if (StringUtils.isEmpty((String)uiClassName)) {
            return false;
        }
        if (this.uiContext != null) {
            String originalMenuClassName = (String)this.uiContext.get("originalMenuClassName");
            if (StringUtils.isEmpty((String)originalMenuClassName) || !this.uiClassName.startsWith(originalMenuClassName)) {
                return false;
            }
            return originalMenuClassName.equals(uiClassName);
        }
        return false;
    }
}

