/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.uiframe.client;

import com.kingdee.bos.ctrl.swing.KDToolBar;
import com.kingdee.bos.ctrl.swing.KDWorkButton;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.eas.base.myeas.ToolBarStyleEnum;
import com.kingdee.eas.base.ui.IMainUIContainer;
import com.kingdee.eas.base.uiframe.client.BodyUI;
import com.kingdee.eas.base.uiframe.client.LongTask;
import com.kingdee.eas.base.uiframe.client.LongTaskMonitor;
import com.kingdee.eas.base.uiframe.client.MainStatusBar;
import com.kingdee.eas.base.uiframe.client.NewMainFrame;
import com.kingdee.eas.base.uiframe.client.SystemEntry;
import com.kingdee.eas.base.uiframe.client.UIFindCond;
import com.kingdee.eas.base.uiframe.client.UIFrameContext;
import com.kingdee.util.StringUtils;
import java.applet.Applet;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.lang.reflect.Method;
import java.util.Map;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import org.apache.log4j.Logger;

public class UIFrameUtil {
    private static final Logger logger = Logger.getLogger(UIFrameUtil.class);
    public static final String MSGCENTERUI = "com.kingdee.eas.base.message.client.MessageCenterUI";

    public static void locateDefaultNode(IUIObject messageUI) {
        if (messageUI == null || !StringUtils.equals((String)MSGCENTERUI, (String)messageUI.getClass().getName())) {
            return;
        }
        try {
            Class<?> clazz = Class.forName(MSGCENTERUI);
            int target = clazz.getField("TARGET_TASK").getInt(null);
            int subnode = clazz.getField("SUB_NODE_DEFAULT").getInt(null);
            Method counterMethod = clazz.getMethod("getNotReadMessageCounter", null);
            Object obj = counterMethod.invoke(null, null);
            if (obj == null) {
                Method queryUnreadTasks = messageUI.getClass().getMethod("queryUnreadTasks", null);
                queryUnreadTasks.invoke((Object)messageUI, null);
            }
            if (obj.getClass().getField("forwarnCount").getInt(obj) > 0) {
                target = clazz.getField("TARGET_NOTICE").getInt(null);
                subnode = clazz.getField("SUB_NODE_FORWARN").getInt(null);
            } else if (obj.getClass().getField("noticeCount").getInt(obj) > 0) {
                target = clazz.getField("TARGET_NOTICE").getInt(null);
            } else if (obj.getClass().getField("imCount").getInt(obj) > 0) {
                target = clazz.getField("TARGET_IM").getInt(null);
            }
            Method locateDefaultNode = messageUI.getClass().getMethod("locateDefaultNode", Integer.TYPE, Integer.TYPE);
            locateDefaultNode.invoke((Object)messageUI, target, subnode);
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
    }

    public static void setCurTabToMessageCenter() {
        if (SystemEntry.instance.getMainUIObject() == null || SystemEntry.instance.getMainUIObject().getBodyUI() == null) {
            return;
        }
        for (int i = 0; i < BodyUI.SYS_TAB_CLASSNAME_LIST.length; ++i) {
            if (BodyUI.SYS_TAB_CLASSNAME_LIST[i].indexOf(MSGCENTERUI) < 0) continue;
            SystemEntry.instance.getMainUIObject().getBodyUI().setCurTabIndex(i);
            return;
        }
    }

    public static IUIObject[] findUIObject(String uiClassName) {
        if (SystemEntry.instance.getMainUIObject() != null) {
            return SystemEntry.instance.getMainUIObject().getUiManager().findUIObject(uiClassName);
        }
        return null;
    }

    public static IUIObject[] findUIObject(Frame owner, String uiClassName) {
        IUIObject[] iUIObjectArray;
        if (owner == null || uiClassName == null || uiClassName.length() == 0) {
            return null;
        }
        UIFindCond cond = new UIFindCond();
        cond.uiClassName = uiClassName;
        cond.enableCond(false, false, false);
        Object ui = null;
        if (owner instanceof NewMainFrame) {
            SystemEntry.instance.setCurrenContainer((NewMainFrame)((Object)owner));
        }
        if (SystemEntry.instance.getMainUIObject() != null) {
            SystemEntry.instance.getMainUIObject().getUiManager().findUIObject(cond);
        }
        if (ui == null) {
            iUIObjectArray = null;
        } else {
            IUIObject[] iUIObjectArray2 = new IUIObject[1];
            iUIObjectArray = iUIObjectArray2;
            iUIObjectArray2[0] = ui;
        }
        return iUIObjectArray;
    }

    public static IUIObject getUIObject(Component c) {
        for (Component p = c; p != null; p = p.getParent()) {
            if (!(p instanceof IUIObject)) continue;
            return (IUIObject)p;
        }
        return null;
    }

    public static Frame getCurrMainFrame(Component component) {
        IUIWindow uiWindow;
        IUIObject ui;
        Map context;
        Component c;
        if (component == null) {
            throw new IllegalArgumentException("Argument component is null");
        }
        Component window = SwingUtilities.getRoot(component);
        if (window instanceof Applet) {
            return JOptionPane.getFrameForComponent(window);
        }
        if (window instanceof Frame) {
            return (Frame)window;
        }
        if (window instanceof Dialog) {
            return UIFrameUtil.getCurrMainFrame(((Dialog)window).getOwner());
        }
        if (window instanceof NewMainFrame) {
            return (NewMainFrame)((Object)window);
        }
        if (window instanceof IUIWindow && (c = (Component)(context = (ui = (uiWindow = (IUIWindow)window).getUIObject()).getUIContext()).get("OwnerWindow")) != null) {
            return UIFrameUtil.getCurrMainFrame(c);
        }
        throw new IllegalArgumentException("Component is not associated mainframe");
    }

    static IUIObject getCurrUIObject(Component c) {
        Component window = SwingUtilities.getRoot(c);
        if (window instanceof IUIWindow) {
            return ((IUIWindow)window).getUIObject();
        }
        if (window instanceof IMainUIContainer) {
            return SystemEntry.instance.getMainUIObject().getSelectedUIObject();
        }
        return null;
    }

    public static void startLongTask(LongTask task, MainStatusBar mainStatusBar) {
        if (task == null) {
            return;
        }
        LongTaskMonitor monitor = new LongTaskMonitor(task);
        if (mainStatusBar != null) {
            monitor.setMainStatusBar(mainStatusBar);
        }
        monitor.star();
    }

    public static void setButtonDefaultStyl(KDToolBar toolBar, KDWorkButton button) {
        ToolBarStyleEnum toolBarStyleEnum = (ToolBarStyleEnum)UIFrameContext.getInstance().getProperty("ToolbarStyle");
        if (toolBarStyleEnum != null) {
            if (toolBarStyleEnum.equals((Object)ToolBarStyleEnum.IconText)) {
                toolBar.setTextIconDisStyle((short)3);
                button.setText(null);
                button.setTextIconDisStyle((short)2);
                button.setIsControlByParent(false);
            } else if (toolBarStyleEnum.equals((Object)ToolBarStyleEnum.OnlyIcon)) {
                toolBar.setTextIconDisStyle((short)2);
            } else if (toolBarStyleEnum.equals((Object)ToolBarStyleEnum.OnlyText)) {
                toolBar.setTextIconDisStyle((short)1);
            } else if (toolBarStyleEnum.equals((Object)ToolBarStyleEnum.IconAllText)) {
                toolBar.setTextIconDisStyle((short)3);
            }
        } else {
            button.setIsControlByParent(true);
        }
    }

    public static void startLongTask(LongTask task) {
        UIFrameUtil.startLongTask(task, null);
    }
}

