/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.uiframe.client.ui;

import com.kingdee.bos.ctrl.swing.KDScrollPane;
import com.kingdee.bos.ctrl.swing.KDTextArea;
import com.kingdee.bos.rpcwrapper.RemotePing;
import com.kingdee.eas.base.uiframe.client.ui.InfoObserver;
import com.kingdee.util.StringUtils;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.util.Locale;
import javax.swing.JDialog;
import javax.swing.JPanel;

public class RpcDialog
extends JDialog
implements InfoObserver {
    public PrintStream out = null;
    private RpcOutputStream outStream = null;
    private KDTextArea txtLog;
    RemotePing ping;

    public RpcDialog(JDialog dialog) {
        super(dialog);
        this.initLayout();
        this.pack();
        this.setLocationRelativeTo(null);
    }

    private void initLayout() {
        JPanel contentPane = (JPanel)this.getContentPane();
        contentPane.setPreferredSize(new Dimension(380, 280));
        contentPane.setLayout(new BorderLayout());
        this.txtLog = new KDTextArea();
        KDScrollPane scroll = new KDScrollPane((Component)this.txtLog);
        this.outStream = new RpcOutputStream(this);
        this.out = new PrintStream(this.outStream);
        contentPane.add((Component)scroll, "Center");
    }

    public void clearLog() {
        this.txtLog.setText("");
        if (this.outStream != null) {
            this.outStream.reset();
        }
    }

    public void ping(String[] args) {
        if (this.ping == null) {
            this.ping = new RemotePing();
        }
        this.clearLog();
        String url = null;
        int inputSize = 0;
        int returnSize = 0;
        int calculateTimes = 0;
        int allocation = 0;
        int times = 1;
        int duration = 8000;
        int sessions = 1;
        int sleep = 1000;
        boolean validate = true;
        if (args != null) {
            for (int i = 0; i < args.length; ++i) {
                String arg = args[i];
                if ("-server".equalsIgnoreCase(arg)) {
                    url = args[++i];
                } else if ("-t".equalsIgnoreCase(arg)) {
                    times = this.parseSize(args[++i]);
                    validate = this.validate("t", times);
                } else if ("-input".equalsIgnoreCase(arg)) {
                    inputSize = this.parseSize(args[++i]);
                    validate = this.validate("input", inputSize);
                } else if ("-return".equalsIgnoreCase(arg)) {
                    returnSize = this.parseSize(args[++i]);
                    validate = this.validate("return", returnSize);
                } else if ("-calcu".equalsIgnoreCase(arg)) {
                    calculateTimes = this.parseSize(args[++i]);
                    validate = this.validate("calcu", calculateTimes);
                } else if ("-alloc".equalsIgnoreCase(arg)) {
                    allocation = this.parseSize(args[++i]);
                    validate = this.validate("alloc", allocation);
                } else if ("-duration".equalsIgnoreCase(arg)) {
                    duration = this.parseSize(args[++i]);
                } else if ("-sessions".equalsIgnoreCase(arg)) {
                    if ((sessions = this.parseSize(args[++i])) < 1) {
                        sessions = 1;
                    }
                } else if ("-sleep".equalsIgnoreCase(arg) && (sleep = this.parseSize(args[++i])) < 500) {
                    sleep = 500;
                }
                if (validate) continue;
                return;
            }
        }
        if (url == null) {
            url = System.getProperty("appserver");
        }
        if (StringUtils.isEmpty(url) || !url.toLowerCase(Locale.ENGLISH).startsWith("tcp://") && !url.toLowerCase(Locale.ENGLISH).startsWith("tcps://") && !url.toLowerCase(Locale.ENGLISH).startsWith("http://")) {
            this.printUseage();
            return;
        }
        RemotePing.pingRPCServerLongtime((String)url, (int)times, (int)duration, (int)sleep, (PrintStream)this.out);
    }

    int parseSize(String sSize) {
        sSize = sSize.toLowerCase().trim();
        int factor = 1;
        if (sSize.endsWith("k")) {
            sSize = sSize.substring(0, sSize.length() - 1);
            factor = 1024;
        } else if (sSize.endsWith("m")) {
            sSize = sSize.substring(0, sSize.length() - 1);
            factor = 0x100000;
        }
        try {
            int size = Integer.parseInt(sSize);
            return size * factor;
        }
        catch (NumberFormatException e) {
            return -1;
        }
    }

    void printUseage() {
        this.out.println("java -cp [classpath] com.kingdee.bos.rpcwrapper.RemotePing [options]");
        this.out.println("options is:");
        this.out.println("                -server     :rpc server url (for example tcp://localhost:11034)");
        this.out.println("                [-sessions] :sessions (default 1) ");
        this.out.println("                [-duration] :duration (default 1000*60ms )");
        this.out.println("                [-sleep]    :sleep (default 1000*5ms )");
        this.out.println("                -t          :ping times");
        this.out.println("                -input      :input data size (for example  2k,512)");
        this.out.println("                -return     :return data size (for example 2k,512)");
        this.out.println("                -calcu      :calculate Times (for example 1000)");
        this.out.println("                -alloc      :allocation memory size (for example 512k,10m)");
    }

    boolean validate(String argName, int size) {
        if (size < 0) {
            this.out.println("arg " + argName + " need a number");
            this.printUseage();
            return false;
        }
        return true;
    }

    @Override
    public void appendInfo(String info) {
        if (this.isVisible()) {
            this.txtLog.setText(info);
        }
    }

    @Override
    public void reset() {
        if (this.isVisible()) {
            this.txtLog.setText("");
        }
    }

    class RpcOutputStream
    extends ByteArrayOutputStream {
        InfoObserver textCont;

        public RpcOutputStream(InfoObserver textCont) {
            this.textCont = textCont;
        }

        @Override
        public synchronized void write(byte[] b, int off, int len) {
            super.write(b, off, len);
            this.textCont.appendInfo(this.toString());
        }

        @Override
        public synchronized void reset() {
            super.reset();
            this.textCont.reset();
        }
    }
}

