/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.uiframe.client.ui.gpt;

import com.alibaba.fastjson.JSONObject;
import com.kingdee.bos.ctrl.kds.model.struct.embed.browser.IExecutePanel;
import com.kingdee.bos.ctrl.kds.model.struct.embed.browser.IPageReady;
import com.kingdee.bos.ctrl.kds.model.struct.embed.browser.jfx.KDWebViewPanel;
import com.kingdee.bos.ctrl.swing.KDLabel;
import com.kingdee.bos.ctrl.swing.KDPanel;
import com.kingdee.eas.base.uiframe.client.UIConfig;
import com.kingdee.eas.base.uiframe.client.ui.IMainUIObject;
import com.kingdee.eas.base.uiframe.client.ui.gpt.ChatgptFunction;
import com.kingdee.eas.base.uiframe.client.ui.gpt.ChatgptHeader;
import com.kingdee.eas.base.uiframe.client.ui.login.KDRoundRectBorder;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.cp.eip.sso.SSOHandleFacadeFactory;
import com.kingdee.util.StringUtils;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLEncoder;
import javafx.application.Platform;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.Border;
import netscape.javascript.JSObject;

public class ChatgptUI
extends KDPanel {
    private KDLabel img = new KDLabel();
    private KDLabel tips = new KDLabel();
    private KDLabel close = new KDLabel();
    private KDLabel refresh = new KDLabel();
    private KDLabel adjust = new KDLabel();
    private KDPanel header = new ChatgptHeader();
    private static String CHATGPT_URL = "/easweb/webviews/gpt/index.html#/?isGui=true";
    public KDWebViewPanel browser = null;
    private IMainUIObject mainUIObject = null;
    private String cookies = null;

    public ChatgptUI(IMainUIObject mainUIObject) {
        this.mainUIObject = mainUIObject;
        this.jbinit();
    }

    private void jbinit() {
        this.setLayout(null);
        this.setOpaque(true);
        this.header.setLayout(null);
        this.header.setBounds(0, 0, 420, 40);
        this.header.setBackground(Color.white);
        this.img.setIcon((Icon)new ImageIcon(((Object)((Object)this)).getClass().getResource("chatgpt.png")));
        this.img.setBounds(8, 5, 40, 40);
        this.tips.setText("GPT\u52a9\u624b");
        this.tips.setFont(new Font("Dialog", 0, 14));
        this.tips.setBounds(58, 12, 80, 18);
        this.tips.setForeground(Color.WHITE);
        this.close.setIcon((Icon)new ImageIcon(((Object)((Object)this)).getClass().getResource("close.png")));
        this.close.setBounds(372, 10, 50, 25);
        this.close.addMouseListener((MouseListener)new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                ChatgptUI.this.setVisible(false);
            }
        });
        this.refresh.setIcon((Icon)new ImageIcon(((Object)((Object)this)).getClass().getResource("refresh.png")));
        this.refresh.setBounds(322, 10, 50, 25);
        this.refresh.addMouseListener((MouseListener)new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                ChatgptUI.this.refresh();
            }
        });
        this.adjust.setIcon((Icon)new ImageIcon(((Object)((Object)this)).getClass().getResource("adjust.png")));
        this.adjust.setBounds(272, 10, 50, 25);
        this.adjust.addMouseListener((MouseListener)new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                Dimension oldSize = ChatgptUI.this.getSize();
                if (oldSize.getWidth() == 420.0) {
                    ChatgptUI.this.adjust.setIcon((Icon)new ImageIcon(this.getClass().getResource("adjust_close.png")));
                    ChatgptUI.this.setSize(((JComponent)((Object)ChatgptUI.this.mainUIObject)).getWidth(), (int)oldSize.getHeight());
                } else {
                    ChatgptUI.this.adjust.setIcon((Icon)new ImageIcon(this.getClass().getResource("adjust.png")));
                    ChatgptUI.this.setSize(420, (int)oldSize.getHeight());
                }
                ChatgptUI.this.header.setBounds(0, 0, ChatgptUI.this.getWidth(), 40);
                ChatgptUI.this.adjust.setBounds(ChatgptUI.this.getWidth() - 48 - 100, 10, 50, 25);
                ChatgptUI.this.refresh.setBounds(ChatgptUI.this.getWidth() - 48 - 50, 10, 50, 25);
                ChatgptUI.this.close.setBounds(ChatgptUI.this.getWidth() - 48, 10, 50, 25);
                ((JComponent)((Object)ChatgptUI.this.mainUIObject)).repaint();
            }
        });
        this.header.add((Component)this.img);
        this.header.add((Component)this.tips);
        this.header.add((Component)this.close);
        this.header.add((Component)this.refresh);
        this.header.add((Component)this.adjust);
        this.initBrowser();
        this.add((Component)this.header);
        this.add(this.browser.getMainComponent());
        Color firstShadowColor = UIManager.getColor("MenuBar.firstShadowColor");
        if (firstShadowColor == null) {
            firstShadowColor = Color.decode("#E6EDF3");
        }
        KDRoundRectBorder border = new KDRoundRectBorder(8, 1);
        border.setBorderColor(firstShadowColor);
        this.setBorder(border);
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
                ChatgptUI.this.browser.setBounds(0, 40, ChatgptUI.this.getWidth(), ChatgptUI.this.getHeight() - 40);
                ChatgptUI.this.browser.revalidate();
                ChatgptUI.this.browser.repaint();
            }
        });
    }

    private void refresh() {
        try {
            this.browser.setLoadingCompleted(false);
            String serverURL = ChatgptUI.getEasWebServerURL();
            Color background = this.header.getBackground();
            int colorStyle = UIConfig.getUiColorStyle();
            String color = "blue";
            switch (colorStyle) {
                case 5: {
                    color = "blue";
                    break;
                }
                case 2: {
                    color = "orange";
                    break;
                }
                case 0: {
                    color = "green";
                    break;
                }
                case 4: {
                    color = "red";
                    break;
                }
            }
            String redirect = CHATGPT_URL + "&color=" + URLEncoder.encode(color, "utf-8");
            String url = serverURL + "/" + SSOHandleFacadeFactory.getRemoteInstance().getGUItoPortalUrl(URLEncoder.encode(redirect, "utf-8"), true, SysContext.getSysContext().getLocale().toString(), SysContext.getSysContext().getDCNumber());
            this.browser.load(url);
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }

    private void initBrowser() {
        this.browser = new KDWebViewPanel("", new IPageReady(){

            public void onReady(IExecutePanel panel) {
                ChatgptFunction function = new ChatgptFunction(ChatgptUI.this.mainUIObject, (IExecutePanel)ChatgptUI.this.browser);
                ChatgptUI.this.browser.registerFunction(function.getMember(), function.getFunctionName(), (Object)function, true);
                try {
                    ChatgptUI.this.cookies = (String)ChatgptUI.this.browser.getEngine().executeScript("document.cookie");
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        });
        this.browser.setBackground(new Color(238, 246, 255));
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                ChatgptUI.this.refresh();
            }
        });
    }

    public static String getEasWebServerURL() {
        String serverURL = System.getProperty("EASPORTAL_ROOT");
        String rpcURL = System.getProperty("EAS_SERVER");
        if (StringUtils.isEmpty((String)serverURL)) {
            serverURL = "http://localhost:6888/portal";
        } else {
            int index = serverURL.indexOf("/easportal");
            if (index > 0) {
                serverURL = serverURL.substring(0, index) + "/portal";
            }
        }
        if (!StringUtils.isEmpty((String)rpcURL) && rpcURL.indexOf("https") > -1) {
            serverURL = serverURL.replace("http", "https");
        } else {
            String isHttps = System.getProperty("IS_HTTPS");
            if (Boolean.valueOf(isHttps).booleanValue()) {
                serverURL = serverURL.replace("http", "https");
            }
        }
        return serverURL;
    }

    public void paint(Graphics g) {
        Border border = this.getBorder();
        if (border instanceof KDRoundRectBorder) {
            ((KDRoundRectBorder)border).paintClip((Component)((Object)this), g, 0, 0, this.getWidth(), this.getHeight());
        }
        super.paint(g);
    }

    public void setVisible(boolean isVisible) {
        super.setVisible(isVisible);
        Platform.runLater(() -> {
            JSObject window = (JSObject)this.browser.getEngine().executeScript("window");
            JSONObject params = new JSONObject();
            params.put("visible", (Object)isVisible);
            window.call("GUI_setVisible", params.toJSONString());
        });
    }

    public void changeToUI(Component component) {
        if (this.browser != null) {
            String uiClass = component.getClass().getName();
            Platform.runLater(() -> {
                JSObject window = (JSObject)this.browser.getEngine().executeScript("window");
                JSONObject params = new JSONObject();
                params.put("uiClass", (Object)uiClass);
                window.call("GUI_tabbarChange", params.toJSONString());
            });
        }
    }

    public void closeApplication() {
        try {
            String serverURL = ChatgptUI.getEasWebServerURL();
            String host = serverURL.replace("portal", "");
            if (this.cookies != null && this.cookies.length() > 0) {
                try {
                    URL url = new URL(host + "easweb/gpt.do?method=releaseLicense");
                    HttpURLConnection conn = (HttpURLConnection)url.openConnection();
                    conn.setConnectTimeout(3000);
                    conn.setReadTimeout(3000);
                    conn.setRequestProperty("cookie", this.cookies);
                    int code = conn.getResponseCode();
                    System.out.println(code);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            this.browser.load(host + "eassso/logout");
            this.browser.load(host + "easweb/logout?isSso=true");
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }
}

