/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.uiframe.client.ui.login;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.IllegalSessionStateException;
import com.kingdee.bos.SQLDataException;
import com.kingdee.bos.dao.ObjectNotFoundException;
import com.kingdee.bos.dao.ormapping.FindedTooMuchRecordsException;
import com.kingdee.bos.dao.ormapping.ObjectReferedException;
import com.kingdee.bos.rpc.RPCException;
import com.kingdee.bos.rpc.ce.RPCConnectException;
import com.kingdee.bos.rpc.io.RPCIOException;
import com.kingdee.bos.rpcwrapper.Utils;
import com.kingdee.bos.transaction.ConcurrentException;
import com.kingdee.bos.ui.face.UIException;
import com.kingdee.bos.workflow.exception.AlreadyTransferMethodToWfTransactionManageException;
import com.kingdee.eas.base.license.LicenseException;
import com.kingdee.eas.base.permission.PermissionServiceException;
import com.kingdee.eas.base.uiframe.EASLoginException;
import com.kingdee.eas.base.uiframe.client.SystemEntry;
import com.kingdee.eas.base.uiframe.client.ui.login.MsgBox;
import com.kingdee.eas.basedata.org.OUException;
import com.kingdee.eas.common.BizReferenceException;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.framework.exception.EASMultiException;
import com.kingdee.eas.util.AbortException;
import com.kingdee.eas.util.BizReference;
import com.kingdee.eas.util.ExceptionUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.ExceptionHandlerFactory;
import com.kingdee.eas.util.client.IExceptionHandler;
import com.kingdee.jdbc.rowset.FetchedTooMuchRowsException;
import com.kingdee.util.BaseException;
import com.kingdee.util.NumericException;
import com.kingdee.util.StringUtils;
import com.kingdee.util.UuidException;
import java.awt.Component;
import java.awt.Frame;
import java.awt.IllegalComponentStateException;
import java.awt.KeyboardFocusManager;
import java.awt.Window;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.InvalidClassException;
import java.io.OptionalDataException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.lang.reflect.Method;
import java.lang.reflect.UndeclaredThrowableException;
import java.net.ConnectException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.sql.SQLException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Locale;
import java.util.Properties;
import org.apache.log4j.Logger;

public class ExceptionHandler {
    private static Logger logger = Logger.getLogger((String)ExceptionHandler.class.getName());
    private static String commonResource = "com.kingdee.eas.common.CommonResource";
    private static String easCommonResource = "com.kingdee.eas.common.EASCommonResource";
    private static int handleSessionClosedExceptionAgain = 0;
    private static final int handleSessionClosedExceptionAgainMax = 100;
    private static final int SQL_DB_DEADLOCK_ERR_CODE = 1205;

    public static void handle(Throwable exc) {
        try {
            ExceptionHandler.handle(null, ExceptionHandler.getFriendlyMsg(exc), exc);
        }
        catch (NoClassDefFoundError ne) {
            Window owner = KeyboardFocusManager.getCurrentKeyboardFocusManager().getActiveWindow();
            com.kingdee.eas.util.client.MsgBox.showConnectionError((Component)owner);
        }
    }

    public static void handle(String errMsg, Throwable exc) {
        try {
            ExceptionHandler.handle(null, ExceptionHandler.getFriendlyMsg(exc), exc);
        }
        catch (NoClassDefFoundError ne) {
            Window owner = KeyboardFocusManager.getCurrentKeyboardFocusManager().getActiveWindow();
            com.kingdee.eas.util.client.MsgBox.showConnectionError((Component)owner);
        }
    }

    public static void handle(Component owner, Throwable exc) {
        try {
            ExceptionHandler.handle(owner, ExceptionHandler.getFriendlyMsg(exc), exc);
        }
        catch (NoClassDefFoundError ne) {
            com.kingdee.eas.util.client.MsgBox.showConnectionError((Component)owner);
        }
    }

    public static void handle(Component owner, String errMsg, Throwable exc) {
        if (ExceptionHandler.isIgnoreException(exc)) {
            return;
        }
        logger.error((Object)"exception :", exc);
        if (owner == null) {
            owner = KeyboardFocusManager.getCurrentKeyboardFocusManager().getActiveWindow();
        }
        if (ExceptionHandler.isTheAlreayLoginExceptionForUserMonitorListener(exc)) {
            logger.error((Object)"isTheAlreayLoginExceptionForUserMonitorListener");
            return;
        }
        if (exc instanceof AbortException) {
            logger.error((Object)"is AbortException");
            return;
        }
        if (ExceptionHandler.handleArrayIndexOutOfBounds(owner, exc)) {
            logger.error((Object)"is ArrayIndexOutOfBounds");
        } else if (ExceptionHandler.handleAlreadyTransferMethodToWfTransactionManage(owner, exc)) {
            logger.error((Object)"is AlreadyTransferMethodToWfTransactionManage");
        } else if (ExceptionHandler.handleLicenseException(owner, exc)) {
            logger.error((Object)"is LicenseException");
        } else if (ExceptionHandler.handleNullPointerException(owner, exc)) {
            logger.error((Object)"is NullPointerException");
        } else if (ExceptionHandler.isRPCConnectException(exc)) {
            logger.error((Object)"is RPCConnectException");
            ExceptionHandler.handleRpcConnectionException(owner, errMsg, exc);
        } else {
            if (exc instanceof UIException && exc.getCause() != null) {
                logger.error((Object)"is UIException");
                ExceptionHandler.handle(owner, exc.getCause());
                return;
            }
            if (ExceptionHandler.handlePermissionServiceException(owner, exc)) {
                logger.error((Object)"is PermissionServiceException");
            } else if (ExceptionHandler.handleOptionalDataException(owner, exc)) {
                logger.error((Object)"is OptionalDataException");
            } else {
                if (exc instanceof UndeclaredThrowableException) {
                    logger.error((Object)"is UndeclaredThrowableException:");
                    UndeclaredThrowableException uex = (UndeclaredThrowableException)exc;
                    if (uex != null) {
                        if (uex.getUndeclaredThrowable() instanceof BOSException || uex.getUndeclaredThrowable() instanceof EASBizException) {
                            ExceptionHandler.handle(owner, uex.getUndeclaredThrowable());
                        } else {
                            ExceptionHandler.handle(owner, exc.getCause());
                        }
                    }
                    return;
                }
                if (exc instanceof ObjectReferedException) {
                    logger.error((Object)"is ObjectReferedException:");
                    StringBuffer msg = new StringBuffer();
                    BizReference ref = (BizReference)((ObjectReferedException)exc).getReferingObject();
                    if (ref != null) {
                        Object[] objects = new Object[1];
                        String locale = SysContext.getSysContext().getLocale().toString();
                        objects[0] = ref.getRefEntityAlias(new Locale(locale));
                        String template = EASResource.getString((String)commonResource, (String)"isReferedError");
                        msg.append(MessageFormat.format(template, objects));
                    } else {
                        msg.append(EASResource.getString((String)commonResource, (String)"ReferCheckError"));
                    }
                    String message = exc.getMessage();
                    Throwable t = exc;
                    while (t.getCause() != null) {
                        t = t.getCause();
                        message = t.getMessage();
                        if (!(t instanceof BizReferenceException)) continue;
                    }
                    if (StringUtils.isEmpty((String)message)) {
                        message = msg.toString();
                    }
                    com.kingdee.eas.util.client.MsgBox.showDetailAndOK((Component)owner, (String)msg.toString(), (String)message, (int)0);
                    return;
                }
                if (ExceptionHandler.isConnectionException(exc)) {
                    logger.error((Object)("is ConnectionException:" + exc));
                    ExceptionHandler.handleConnectionException(owner, errMsg, exc);
                } else if (ExceptionHandler.isSessionClosedException(exc)) {
                    if (++handleSessionClosedExceptionAgain > 100) {
                        logger.error((Object)("handleSessionClosedExceptionAgain is:" + handleSessionClosedExceptionAgain), exc);
                        System.exit(-1);
                    }
                    ExceptionHandler.handleSessionClosedException(owner, errMsg, exc);
                } else if (ExceptionHandler.isAppServerRestartedException(exc)) {
                    logger.error((Object)"is AppServerRestartedException:");
                    ExceptionHandler.handleAppServerRestartedException(owner, errMsg, exc);
                } else {
                    if (exc instanceof RPCException && exc.getCause() instanceof ConcurrentException) {
                        logger.error((Object)"is RPCException:");
                        String tempMsg = EASResource.getString((String)commonResource, (String)"serverBusy");
                        com.kingdee.eas.util.client.MsgBox.showError((Component)owner, (String)tempMsg);
                        return;
                    }
                    if (exc instanceof EASMultiException) {
                        EASMultiException eMul = (EASMultiException)exc;
                        com.kingdee.eas.util.client.MsgBox.showError((Component)owner, (String)eMul.getMessage());
                    } else if (ExceptionHandler.isEASBizExceptionCause(exc)) {
                        logger.info((Object)("EASBizException:" + exc));
                        EASBizException temp = ExceptionHandler.getEASBizExceptionCause(exc);
                        if (temp != null) {
                            MsgBox.showInfo((Frame)owner, temp.getMessage());
                        }
                    } else {
                        if (exc instanceof NumericException) {
                            logger.info((Object)"detail:", exc);
                            com.kingdee.eas.util.client.MsgBox.showError((Component)owner, (String)errMsg);
                            return;
                        }
                        if (exc instanceof IllegalComponentStateException) {
                            if ("component must be showing on the screen to determine its location".equals(exc.getMessage())) {
                                return;
                            }
                        } else if (!ExceptionHandler.isTheIllegalAgumentException(exc)) {
                            if (ExceptionHandler.isTooMuchRecordException(exc)) {
                                ExceptionHandler.handleTooMuchRecordException(owner, exc);
                            } else if (exc instanceof ObjectNotFoundException) {
                                String detail = ExceptionHandler.buildDetail(exc);
                                logger.debug((Object)detail);
                                String msg = new EASBizException(EASBizException.CHECKEXIST).getMessage();
                                com.kingdee.eas.util.client.MsgBox.showError((Component)owner, (String)msg);
                            } else if (ExceptionHandler.isDBDeadLockException(exc)) {
                                ExceptionHandler.handleDBDeadLockException(owner, exc);
                            } else if (!ExceptionHandler.handleClassNotFoundException(owner, exc)) {
                                if (ExceptionHandler.isChineseMachineNameException(exc)) {
                                    ExceptionHandler.handleChineseMachineNameException(owner, exc);
                                } else if (exc instanceof OutOfMemoryError) {
                                    logger.error((Object)"outofmemory!", exc);
                                    System.exit(-1);
                                } else if (exc instanceof StackOverflowError) {
                                    logger.error((Object)"StackOverflowError!", exc);
                                    System.exit(-1);
                                } else {
                                    if (ExceptionHandler.isHandleNospaceException(exc)) {
                                        com.kingdee.eas.util.client.MsgBox.showError((Component)owner, (String)EASResource.getString((String)"noServerSpace"));
                                        return;
                                    }
                                    if (ExceptionHandler.handledByUpdateModule(owner, exc)) {
                                        return;
                                    }
                                    IExceptionHandler handler = ExceptionHandlerFactory.getHandler((Throwable)exc);
                                    if (handler != null) {
                                        handler.handler(owner, errMsg, exc);
                                        return;
                                    }
                                    String detail = ExceptionHandler.buildDetail(exc);
                                    com.kingdee.eas.util.client.MsgBox.showError((Component)owner, (String)errMsg, (String)detail);
                                    return;
                                }
                            }
                        }
                    }
                }
            }
        }
    }

    private static boolean isEASBizExceptionCause(Throwable exc) {
        for (Throwable cause = exc; cause != null; cause = cause.getCause()) {
            if (!(cause instanceof EASBizException)) continue;
            return true;
        }
        return false;
    }

    private static EASBizException getEASBizExceptionCause(Throwable exc) {
        for (Throwable cause = exc; cause != null; cause = cause.getCause()) {
            if (!(cause instanceof EASBizException)) continue;
            return (EASBizException)cause;
        }
        return null;
    }

    private static boolean handledByUpdateModule(Component owner, Throwable exc) {
        try {
            String exceptionDetail = ExceptionHandler.buildDetail(exc);
            Class<?> clazz = Class.forName("com.kingdee.eas.client.startup.update.exception.ExceptionHandler");
            Method method = clazz.getMethod("convertKnownException2FriendlyWords", ClassLoader.class, Throwable.class);
            String words = (String)method.invoke(clazz.newInstance(), ExceptionHandler.class.getClassLoader(), exc);
            logger.info((Object)(EASResource.getString((String)"com.kingdee.eas.common.COMMONAutoGenerateResource", (String)"23_ExceptionHandler") + words));
            if (!StringUtils.isEmpty((String)words)) {
                com.kingdee.eas.util.client.MsgBox.showDetailAndOK((Component)owner, (String)words, (String)exceptionDetail, (int)0);
                return true;
            }
            return false;
        }
        catch (Throwable t) {
            logger.error((Object)EASResource.getString((String)"com.kingdee.eas.common.COMMONAutoGenerateResource", (String)"24_ExceptionHandler"), t);
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean isApploaderStartException(Throwable exc) {
        for (Throwable cause = exc; cause != null; cause = cause.getCause()) {
            if (!(exc instanceof NoClassDefFoundError) && !(exc instanceof NoSuchMethodError) && !(exc instanceof InvalidClassException | exc instanceof ClassNotFoundException)) continue;
            BufferedReader in = null;
            try {
                int index;
                String url = System.getProperty("updateJnlpUrl");
                if (url == null) continue;
                String easClientCodeBaseStr = url.substring(0, url.lastIndexOf("/"));
                if (easClientCodeBaseStr != null && !easClientCodeBaseStr.endsWith("/")) {
                    easClientCodeBaseStr = easClientCodeBaseStr + "/";
                }
                URL jnlpUrl = new URL(easClientCodeBaseStr + "/JnlpVersion");
                System.out.println("this is updateJnlpUrl:" + jnlpUrl.toString());
                URLConnection cn = jnlpUrl.openConnection();
                in = new BufferedReader(new InputStreamReader(((HttpURLConnection)cn).getInputStream()));
                String fulljnlpVersionStr = in.readLine();
                String fulljnlpVersion = "";
                String ondemandJnlpVersionStr = in.readLine();
                String ondemandJnlpVersion = "";
                if (fulljnlpVersionStr != null && fulljnlpVersionStr.substring(0, index = fulljnlpVersionStr.indexOf("=")).equals("fullJnlpVersion")) {
                    fulljnlpVersion = fulljnlpVersionStr.substring(index + 1);
                }
                if (ondemandJnlpVersionStr != null && ondemandJnlpVersionStr.substring(0, index = ondemandJnlpVersionStr.indexOf("=")).equals("ondemandJnlpVersion")) {
                    ondemandJnlpVersion = ondemandJnlpVersionStr.substring(index + 1);
                }
                File updatecacheFile = new File(System.getProperty("EAS_HOME") + "/client/", "update.properties");
                System.out.println("this is updatePropertiesPath:" + updatecacheFile);
                Properties properties = new Properties();
                if (updatecacheFile.exists()) {
                    try (FileInputStream inputStream = null;){
                        File file = updatecacheFile;
                        synchronized (file) {
                            inputStream = new FileInputStream(updatecacheFile);
                        }
                        properties.load(inputStream);
                        inputStream.close();
                    }
                }
                String localFullJnlp = properties.getProperty("fulljnlpversion");
                System.out.println("...............this is the local fullJnlp:" + localFullJnlp);
                String localdemandJnlp = properties.getProperty("ondemandjnlpversion");
                System.out.println("...............this is the local demandJnlp:" + localdemandJnlp);
                System.out.println("...............this is the server fullJnlp:" + fulljnlpVersion);
                System.out.println("...............this is the server demandJnlp:" + ondemandJnlpVersion);
                if (!localFullJnlp.equals(fulljnlpVersion) || !localdemandJnlp.equals(ondemandJnlpVersion)) {
                    boolean bl = true;
                    return bl;
                }
                boolean bl = false;
                return bl;
            }
            catch (IOException e) {
                e.printStackTrace();
                continue;
            }
            finally {
                if (in != null) {
                    try {
                        in.close();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            }
        }
        return false;
    }

    private static boolean isRPCConnectException(Throwable exc) {
        boolean retValue = false;
        logger.error((Object)"deal isRPCConnectException");
        while (exc != null) {
            logger.error((Object)("this error is:" + exc));
            if (exc instanceof RPCConnectException) {
                logger.error((Object)"this error RPCConnectException:");
                if (((RPCConnectException)exc).getType() != 6004) {
                    logger.error((Object)"this error RPCConnectException is not LB_INDICATOR_URL_ERROR");
                    retValue = true;
                }
            }
            exc = exc.getCause();
        }
        logger.error((Object)("this is not isRPCConnectException: retValue " + retValue));
        if (retValue && SystemEntry.instance.isClose()) {
            logger.error((Object)"exit eas,return false");
            SystemEntry.instance.setClose();
            retValue = false;
        }
        logger.error((Object)("retValue " + retValue));
        return retValue;
    }

    private static void handleRpcConnectionException(Component owner, String errMsg, Throwable exc) {
        com.kingdee.eas.util.client.MsgBox.showConnectionError((Component)owner);
    }

    private static boolean isHandleNospaceException(Throwable exc) {
        return exc instanceof BOSException && exc.getMessage() != null && exc.getMessage().indexOf("No space left on device") != -1;
    }

    private static boolean handleOptionalDataException(Component owner, Throwable exc) {
        boolean handled = false;
        if (exc instanceof RPCException && exc.getCause() instanceof OptionalDataException) {
            String detail = ExceptionHandler.buildDetail(exc);
            logger.debug((Object)"handle RPC Communication Exception!");
            logger.debug((Object)detail);
            String msg = new EASBizException(EASBizException.RPCCOMMERR).getMessage();
            com.kingdee.eas.util.client.MsgBox.showError((Component)owner, (String)msg, (String)detail);
            handled = true;
        }
        return handled;
    }

    private static boolean handlePermissionServiceException(Component owner, Throwable exc) {
        boolean handled = false;
        Throwable cause = exc;
        do {
            if (!(cause instanceof PermissionServiceException)) continue;
            com.kingdee.eas.util.client.MsgBox.showError((Component)owner, (String)cause.getMessage());
            handled = true;
            break;
        } while ((cause = cause.getCause()) != null);
        return handled;
    }

    private static void handleAppServerRestartedException(Component owner, String errMsg, Throwable exc) {
        logger.debug((Object)"handle AppServer Restarted Exception!");
        String detail = ExceptionHandler.buildDetail(exc);
        com.kingdee.eas.util.client.MsgBox.showError((Component)owner, (String)EASResource.getString((String)"appServerRestartedMsg"), (String)detail);
    }

    private static boolean isAppServerRestartedException(Throwable exc) {
        if (exc == null) {
            return false;
        }
        while (!Utils.isRPCException((Throwable)exc) || Utils.getRPCErrorCode((Throwable)exc) != 1005) {
            if (exc.getCause() == null) {
                return false;
            }
            exc = exc.getCause();
        }
        return true;
    }

    private static boolean isTheIllegalAgumentException(Throwable exc) {
        boolean isIt = false;
        if (exc instanceof IllegalArgumentException) {
            String msg = "TextHitInfo is out of range";
            if (exc.getMessage() != null && exc.getMessage().equals(msg)) {
                isIt = true;
            }
        }
        return isIt;
    }

    private static boolean handleClassNotFoundException(Component owner, Throwable exc) {
        boolean handled = false;
        Throwable cause = exc;
        do {
            if (!(cause instanceof ClassNotFoundException)) continue;
            String detail = ExceptionHandler.buildDetail(exc);
            logger.debug((Object)"handle ClassNotFound Exception!");
            logger.debug((Object)detail);
            String msg = EASResource.getString((String)commonResource, (String)"ClassNotFound");
            com.kingdee.eas.util.client.MsgBox.showError((Component)owner, (String)msg);
            handled = true;
            break;
        } while ((cause = cause.getCause()) != null);
        return handled;
    }

    private static void handleSessionClosedException(Component owner, String errMsg, Throwable exc) {
        logger.debug((Object)"handle Session Closed Exception!");
        String detail = ExceptionHandler.buildDetail(exc);
        com.kingdee.eas.util.client.MsgBox.showError((Component)owner, (String)MessageFormat.format(EASResource.getString((String)"sessionClosedMsg"), "\n", "\n", "\n"), (String)detail);
    }

    private static boolean isSessionClosedException(Throwable exc) {
        if (exc == null) {
            return false;
        }
        while (true) {
            int errorCode = Utils.getRPCErrorCode((Throwable)exc);
            if (Utils.isRPCException((Throwable)exc) && (errorCode == 1002 || errorCode == 1001) || exc instanceof IllegalSessionStateException || Utils.isRPCException((Throwable)exc) && exc.getCause() instanceof IllegalStateException && exc.getCause().getMessage().indexOf("Cannot found session info") != -1) {
                return true;
            }
            if (exc.getCause() == null) {
                return false;
            }
            exc = exc.getCause();
        }
    }

    private static boolean isTheAlreayLoginExceptionForUserMonitorListener(Throwable exc) {
        boolean isIt = false;
        EASLoginException alreadyLogin = new EASLoginException(EASLoginException.ALREADY_LOGIN);
        for (Throwable cause = exc; cause != null; cause = cause.getCause()) {
            if (!(cause instanceof EASLoginException) || !((EASLoginException)((Object)cause)).getCode().equals(alreadyLogin.getCode())) continue;
            isIt = true;
            break;
        }
        return isIt;
    }

    private static boolean isDBDeadLockException(Throwable exc) {
        boolean isDBDeadLock = false;
        for (Throwable cause = exc; cause != null; cause = cause.getCause()) {
            if (!(cause instanceof SQLException) || ((SQLException)cause).getErrorCode() != 1205) continue;
            isDBDeadLock = true;
            break;
        }
        return isDBDeadLock;
    }

    private static boolean isChineseMachineNameException(Throwable exc) {
        boolean isChineseMachineName = false;
        for (Throwable cause = exc; cause != null; cause = cause.getCause()) {
            if (!(cause instanceof UuidException) || !((UuidException)cause).getMessage().equals("Unexpected failure")) continue;
            isChineseMachineName = true;
            break;
        }
        return isChineseMachineName;
    }

    private static void handleConnectionException(Component owner, String errMsg, Throwable exc) {
        logger.debug((Object)"handle Connection Exception!");
        com.kingdee.eas.util.client.MsgBox.showConnectionError((Component)owner);
    }

    private static void handleDBDeadLockException(Component owner, Throwable exc) {
        String detail = ExceptionHandler.buildDetail(exc);
        logger.debug((Object)"handle DBDeadLock Exception!");
        logger.debug((Object)detail);
        String msg = new EASBizException(EASBizException.DBDEADLOCK).getMessage();
        com.kingdee.eas.util.client.MsgBox.showError((Component)owner, (String)msg);
    }

    private static void handleChineseMachineNameException(Component owner, Throwable exc) {
        String detail = ExceptionHandler.buildDetail(exc);
        logger.debug((Object)"handle Chinese Machine Exception!");
        logger.debug((Object)detail);
        String msg = EASResource.getString((String)commonResource, (String)"chineseMachineName");
        com.kingdee.eas.util.client.MsgBox.showError((Component)owner, (String)msg);
    }

    public static String buildDetail(Throwable exc) {
        StringBuffer detail = new StringBuffer();
        if (exc instanceof NumericException) {
            detail.append(EASResource.getString((String)commonResource, (String)"errorNo"));
            detail.append(((NumericException)exc).getCode());
            detail.append(System.getProperty("line.separator"));
        }
        detail.append(EASResource.getString((String)commonResource, (String)"errorMessage"));
        detail.append(exc.getMessage());
        detail.append(System.getProperty("line.separator"));
        detail.append(EASResource.getString((String)commonResource, (String)"errorStackDetail"));
        if (exc instanceof BaseException) {
            detail.append(ExceptionHandler.getStackTraceFromBaseException(exc));
        } else {
            detail.append(ExceptionUtil.getExcLinkStackTrace((Throwable)exc));
        }
        logger.error((Object)detail);
        return detail.toString();
    }

    private static String getObExceptionEntity(Throwable exc) {
        int start = exc.getMessage().indexOf(":");
        int end = exc.getMessage().indexOf(" ");
        String entityName = exc.getMessage().substring(start, end);
        return entityName;
    }

    private static String getStackTraceFromBaseException(Throwable exc) {
        String str = "";
        try {
            BaseException be = (BaseException)exc;
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            PrintStream ps = new PrintStream((OutputStream)baos, false, "UTF8");
            be.printStackTrace(ps);
            str = baos.toString("UTF8");
        }
        catch (Exception exception) {
            // empty catch block
        }
        return str;
    }

    private static String getFriendlyMsg(Throwable exc) {
        if (exc instanceof NumericException) {
            return exc.getMessage();
        }
        return EASResource.getString((String)easCommonResource, (String)"fatalErrMsg");
    }

    private static boolean isConnectionException(Throwable exc) {
        if (exc == null) {
            return false;
        }
        while (true) {
            boolean isConnectionException = Utils.isRPCException((Throwable)exc) && (Utils.getRPCErrorCode((Throwable)exc) == 2004 || exc.getCause() instanceof ConnectException);
            boolean isRPCIOexception = exc instanceof RPCIOException;
            boolean isNetworkException = ExceptionHandler.isNetworkErrorException(exc);
            if (isConnectionException || isRPCIOexception || isNetworkException) {
                return true;
            }
            if (exc.getCause() == null) {
                return false;
            }
            exc = exc.getCause();
        }
    }

    private static boolean isNetworkErrorException(Throwable exc) {
        return exc instanceof SQLDataException && (exc.getMessage() != null && exc.getMessage().indexOf("Network error IOException") != -1 || exc.getMessage().indexOf("No route to host") != -1);
    }

    public static void main(String[] args) {
        UIException e = new UIException((Throwable)new OUException(OUException.CAN_NOT_DELETE_CU));
        ExceptionHandler.handle(e);
    }

    private static boolean isTooMuchRecordException(Throwable e) {
        if (e instanceof FetchedTooMuchRowsException || e instanceof FindedTooMuchRecordsException) {
            return true;
        }
        if (e.getCause() != null) {
            return ExceptionHandler.isTooMuchRecordException(e.getCause());
        }
        return e.getMessage() != null && e.getMessage().lastIndexOf("Caused exception message is: fetched too much rows:") != -1;
    }

    private static void handleTooMuchRecordException(Component owner, Throwable e) {
        String detail = ExceptionHandler.buildDetail(e);
        String msg = EASResource.getString((String)"com.kingdee.eas.common.CommonResource", (String)"tooMuchRecordError");
        com.kingdee.eas.util.client.MsgBox.showError((Component)owner, (String)msg, (String)detail);
    }

    public static boolean handleOrgMissingRecord(Component owner, Throwable e, String msg) {
        boolean handled = false;
        if (e instanceof ObjectNotFoundException) {
            handled = true;
            com.kingdee.eas.util.client.MsgBox.showError((Component)owner, (String)msg);
        }
        return handled;
    }

    public static boolean handleOrgMissingRecord(Component owner, Throwable e) {
        return ExceptionHandler.handleOrgMissingRecord(owner, e, EASResource.getString((String)commonResource, (String)"OrgMissingRecord"));
    }

    public static boolean handleOrgMissingRecord2(Component owner, Throwable e) {
        return ExceptionHandler.handleOrgMissingRecord(owner, e, EASResource.getString((String)commonResource, (String)"OrgMissingRecord2"));
    }

    private static boolean handleArrayIndexOutOfBounds(Component owner, Throwable e) {
        String aim = "javax.swing.RepaintManager";
        if (e instanceof ArrayIndexOutOfBoundsException) {
            for (Throwable cause = e; cause != null; cause = cause.getCause()) {
                StackTraceElement[] stackTraces = cause.getStackTrace();
                for (int i = 0; i < stackTraces.length; ++i) {
                    if (stackTraces[i].toString().indexOf("javax.swing.RepaintManager") == -1) continue;
                    return true;
                }
            }
        }
        return false;
    }

    private static boolean handleAlreadyTransferMethodToWfTransactionManage(Component owner, Throwable e) {
        boolean handled = false;
        if (e instanceof AlreadyTransferMethodToWfTransactionManageException) {
            com.kingdee.eas.util.client.MsgBox.showError((Component)owner, (String)EASResource.getString((String)commonResource, (String)"AlreadyInWorkflow"));
            handled = true;
        }
        return handled;
    }

    private static boolean handleLicenseException(Component owner, Throwable e) {
        boolean handled = false;
        String aim = "can not get current Org Unit";
        if (e instanceof LicenseException && e.getMessage().indexOf("can not get current Org Unit") != -1) {
            com.kingdee.eas.util.client.MsgBox.showError((Component)owner, (String)EASResource.getString((String)commonResource, (String)"LicenseNeedCompany"));
            handled = true;
        }
        return handled;
    }

    private static boolean handleNullPointerException(Component owner, Throwable e) {
        ArrayList<String> aimList = new ArrayList<String>();
        aimList.add("sun.awt.windows.WInputMethod.dispatchEvent(WInputMethod.java:253)");
        aimList.add("sun.awt.windows.WInputMethod.dispatchEvent(Unknown Source)");
        aimList.add("com.kingdee.bos.ctrl.swing.plaf.KingdeeTabbedPaneUI$StyleData.getInteger(KingdeeTabbedPaneUI.java:722)");
        if (e instanceof NullPointerException) {
            for (Throwable cause = e; cause != null; cause = cause.getCause()) {
                StackTraceElement[] stackTraces = cause.getStackTrace();
                for (int i = 0; i < stackTraces.length; ++i) {
                    int listSize = aimList.size();
                    for (int listIndex = 0; listIndex < listSize; ++listIndex) {
                        if (stackTraces[i].toString().indexOf(StringUtils.cnulls(aimList.get(listIndex))) == -1) continue;
                        logger.debug((Object)("???NullPointerExcepition:" + StringUtils.cnulls(aimList.get(listIndex))));
                        return true;
                    }
                }
            }
        }
        return false;
    }

    private static boolean isIgnoreException(Throwable t) {
        if (t == null) {
            return false;
        }
        try {
            String[] ignoreKeywords = new String[]{"Non-Java exception raised, not handled!"};
            while (true) {
                Throwable cause;
                String message;
                if ((message = t.getMessage()) != null) {
                    for (String keyword : ignoreKeywords) {
                        if (!message.toLowerCase().contains(keyword.toLowerCase())) continue;
                        return true;
                    }
                }
                if ((cause = t.getCause()) != null && cause != t) {
                    t = cause;
                    continue;
                }
                break;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }
}

