/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.uiframe.client.util;

import com.kingdee.bos.json.JSONObject;
import com.kingdee.eas.base.license.ILicenseSrvAgent;
import com.kingdee.eas.base.license.LicenseBaseInfo;
import com.kingdee.eas.base.license.client.LicenseSrvAgentFactory;
import com.kingdee.eas.base.log.StatisticConstant;
import com.kingdee.util.StringUtils;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.NameValuePair;
import org.apache.commons.httpclient.methods.PostMethod;
import org.apache.log4j.Logger;

public class CloudUtil {
    private static Logger logger = Logger.getLogger(CloudUtil.class);
    private static String customerID = "unknown";
    private static String productVersion = "unknown";
    private static JSONObject strategy;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static JSONObject getStrategy() {
        if (strategy != null) {
            return strategy;
        }
        HttpClient http = new HttpClient();
        String url = "https://api.cmcloud.cn/api/portal.do";
        PostMethod post = null;
        try {
            post = new PostMethod(url);
            NameValuePair actionPart = new NameValuePair("action", "log.strategy");
            NameValuePair productIdPart = new NameValuePair("productId", StatisticConstant.PRODUCT_ID);
            NameValuePair productVersionPart = new NameValuePair("productVer", productVersion);
            NameValuePair[] parts = new NameValuePair[]{actionPart, productIdPart, productVersionPart};
            post.setRequestBody(parts);
            http.executeMethod((HttpMethod)post);
            String response = new String(post.getResponseBodyAsString().getBytes("utf-8"));
            JSONObject responseJson = new JSONObject(response);
            JSONObject strategyJson = responseJson.getJSONObject("strategy");
            post.releaseConnection();
            JSONObject jSONObject = strategyJson;
            return jSONObject;
        }
        catch (Throwable e) {
            logger.error((Object)"", e);
            strategy = new JSONObject();
        }
        finally {
            post.releaseConnection();
        }
        return strategy;
    }

    public static String getLicenseCheckPeriod() {
        return CloudUtil.getPeriod("verifyPeriod");
    }

    public static String getPeriod(String type) {
        JSONObject strategyJson = CloudUtil.getStrategy();
        try {
            String ret;
            if (strategyJson != null && !StringUtils.isEmpty((String)(ret = strategyJson.getString(type)))) {
                return ret;
            }
        }
        catch (Throwable t) {
            logger.error((Object)"", t);
        }
        return StatisticConstant.ERROR;
    }

    public static String getSendPeriod() {
        return CloudUtil.getPeriod("sendPeriod");
    }

    static {
        try {
            ILicenseSrvAgent agent = LicenseSrvAgentFactory.getRemoteInstance();
            LicenseBaseInfo baseInfo = agent.getLicenseBaseInfo();
            customerID = baseInfo.getSerialNum();
            productVersion = baseInfo.getVersion();
        }
        catch (Throwable e) {
            logger.error((Object)"", e);
        }
        strategy = null;
    }
}

