/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.uiframe.client.util;

import com.kingdee.eas.base.attachment.common.AttachmentClientManager;
import com.kingdee.eas.base.attachment.common.AttachmentManagerFactory;
import com.kingdee.eas.base.attachment.common.ComplexAttachmentInfo;
import com.kingdee.eas.base.uiframe.UIFrameResource;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.util.StringUtils;
import java.awt.Image;
import java.io.File;
import java.io.IOException;
import javax.imageio.ImageIO;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import org.apache.log4j.Logger;

public class ImageIconUtil {
    private static final Logger logger = Logger.getLogger(ImageIconUtil.class);
    private static final String EAS_FIRST_LOAD_RESOURCE_NAME = "com.kingdee.eas.basedata.common.EASFirstLoadImageResource";
    private static final Icon defaultIcon = EASResource.getIcon((String)"imgMenumodule_icon_mab");

    public static Icon getTopMenuIconByImagePath(String imagePath) {
        if (StringUtils.isEmpty((String)imagePath)) {
            return defaultIcon;
        }
        Icon icon = null;
        if (imagePath.startsWith("imgMenumodule_eas_")) {
            icon = EASResource.getIcon((String)("com.kingdee.eas.basedata.common.EASFirstLoadImageResource." + imagePath));
        } else if (imagePath.startsWith("img") && !imagePath.startsWith("imgMenumodule_eas_")) {
            icon = UIFrameResource.getCommonIcon(imagePath);
        } else {
            try {
                AttachmentClientManager acm = AttachmentManagerFactory.getClientManager();
                String[] attParams = imagePath.split(";");
                ComplexAttachmentInfo attinfo = acm.getComplexAttachmentInfo(attParams[0]);
                if (attinfo != null) {
                    byte[] data = attinfo.getContent();
                    icon = new ImageIcon(data);
                }
            }
            catch (Exception ex) {
                logger.error((Object)("get attchment icon error" + ex.getMessage()));
            }
        }
        return icon;
    }

    public static Image getImageByPath(String imagePath) {
        if (StringUtils.isEmpty((String)imagePath)) {
            return null;
        }
        try {
            return ImageIO.read(new File(imagePath));
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }
}

