/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.uiframe.client.util.httpDownload;

import com.kingdee.eas.base.uiframe.client.util.httpDownload.HttpTimeoutHandler;
import com.kingdee.eas.base.uiframe.client.util.httpDownload.LimitedInputStream;
import com.kingdee.eas.util.client.EASResource;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;
import java.net.ConnectException;
import java.net.HttpURLConnection;
import java.net.SocketTimeoutException;
import java.net.URL;
import java.util.Enumeration;
import java.util.Properties;
import org.apache.log4j.Logger;

public class HttpDownloadUtil {
    private static final Logger logger = Logger.getLogger(HttpDownloadUtil.class);
    private static final int downloadTimeOut = Integer.parseInt(System.getProperty("downloadTimeout", "30000"));
    private static HttpURLConnection httpConnection;

    public static void main(String[] args) {
        System.setProperty("UPDATE_SERVER", "http://192.168.33.196:9888/easWebClient");
        System.setProperty("EAS_HOME", "f:/kingdee7505/eas");
        HttpDownloadUtil.downloadFileFromServer("BarcodePrint/BCLW32.DLL");
        HttpDownloadUtil.downloadFileFromServer("BarcodePrint/KDPrint121.dll");
        HttpDownloadUtil.downloadFileFromServer("BarcodePrint/KDBarCode.ocx");
        HttpDownloadUtil.downloadFileFromServer("BarcodePrint/WinPort.dll");
        HttpDownloadUtil.downloadFileFromServer("BarcodePrint/BCLW32.DLL");
        HttpDownloadUtil.downloadFileFromServer("BarcodePrint/KDBarCodeDesigner.exe");
        HttpDownloadUtil.downloadFileFromServer("BarcodePrint/jacob.dll");
        HttpDownloadUtil.downloadFileFromServer("BarcodePrint/KDBarCodeRuntime.dll");
        HttpDownloadUtil.downloadFileFromServer("BarcodePrint/TestKBC.kbc");
        HttpDownloadUtil.downloadFileFromServer("BarcodePrint/fatest.kbc");
        HttpDownloadUtil.downloadFileFromServer("BarcodePrint/MyKBC.kbc");
        HttpDownloadUtil.downloadFileFromServer("BarcodePrint/TestKBC2.kbc");
        HttpDownloadUtil.downloadFileFromServer("BarcodePrint/TestKB-test.kbc");
        HttpDownloadUtil.downloadFileFromServer("BarcodePrint/kdbldds.xml");
        HttpDownloadUtil.downloadFileFromServer("BarcodePrint/tempPrintData.xml");
        HttpDownloadUtil.downloadFileFromServer("BarcodePrint/tempPrintData-1.xml");
        HttpDownloadUtil.downloadFileFromServer("BarcodePrint/sampledata.xml");
        HttpDownloadUtil.downloadFileFromServer("BarcodePrint/kdBarcodeModels.xml");
        HttpDownloadUtil.downloadFileFromServer("BarcodePrint/unRegdll.bat");
        HttpDownloadUtil.downloadFileFromServer("BarcodePrint/regdll.bat");
        HttpDownloadUtil.downloadFileFromServer("BarcodePrint/regjcob.bat");
    }

    public static boolean downloadFileFromServer(String filePath) {
        String server = System.getProperty("UPDATE_SERVER");
        String localDirRoot = System.getProperty("EAS_HOME");
        try {
            HttpDownloadUtil.realDownloadFile(server, localDirRoot + "/client", filePath);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    private static long realDownloadFile(String server, String localDirRoot, String filePath) throws Exception {
        File downloadTemp;
        File destFile = new File(localDirRoot + "/" + filePath);
        if (!destFile.getParentFile().exists()) {
            destFile.getParentFile().mkdirs();
        }
        if (!(downloadTemp = new File(localDirRoot + "/" + filePath + ".tmp")).getParentFile().exists()) {
            downloadTemp.getParentFile().mkdirs();
        }
        String fileToDownload = filePath;
        try {
            long startTime = System.currentTimeMillis();
            long downloadSize = HttpDownloadUtil.retry(server, downloadTemp, fileToDownload);
            long fileDownloadElapseTime = System.currentTimeMillis() - startTime;
            long l = fileDownloadElapseTime = fileDownloadElapseTime > 0L ? fileDownloadElapseTime : 1L;
            if (-1L == downloadSize) {
                downloadTemp.delete();
                throw new Exception(EASResource.getString((String)"com.kingdee.eas.base.uiframe.UIFRAMEAutoGenerateResource", (String)"12_HttpDownloadUtil"));
            }
            downloadTemp.renameTo(destFile);
            return downloadSize;
        }
        catch (Throwable e) {
            downloadTemp.delete();
            throw new Exception("download error", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static long retry(String server, File downloadTemp, String fileToDownload) throws IOException {
        long downloadSize = 0L;
        RandomAccessFile tmpFile = null;
        InputStream is = null;
        BufferedInputStream bufInput = null;
        for (int i = 1; i < 3; ++i) {
            try {
                tmpFile = new RandomAccessFile(downloadTemp, "rw");
                Properties requetProps = new Properties();
                long hasDownloaded = tmpFile.length();
                if (hasDownloaded > 0L) {
                    tmpFile.seek(hasDownloaded - 1L);
                    requetProps.setProperty("Range", "bytes=" + (hasDownloaded - 1L) + "-");
                }
                is = HttpDownloadUtil.getHttpInputStream(server, requetProps, fileToDownload);
                byte[] buf = new byte[1536];
                bufInput = new BufferedInputStream(is);
                int ret = 0;
                while ((ret = bufInput.read(buf, 0, buf.length)) != -1) {
                    tmpFile.write(buf, 0, ret);
                    hasDownloaded += (long)ret;
                    downloadSize += (long)ret;
                }
                HttpDownloadUtil.closeWorker();
                long l = downloadSize;
                return l;
            }
            catch (SocketTimeoutException ste) {
                logger.error((Object)("Socket timeout, retry [" + i + "] ......"));
                continue;
            }
            catch (ConnectException ce) {
                if (ce.getMessage().indexOf("timeout") >= 0) {
                    logger.error((Object)("Socket timeout, retry [" + i + "] ......"));
                    continue;
                }
                throw ce;
            }
            catch (Exception ex) {
                if (HttpDownloadUtil.isNeedRetry(ex)) {
                    logger.error((Object)("Socket timeout, retry [" + i + "] ......"));
                    continue;
                }
                logger.error((Object)EASResource.getString((String)"com.kingdee.eas.base.uiframe.UIFRAMEAutoGenerateResource", (String)"12_HttpDownloadUtil"), (Throwable)ex);
                try {
                    throw ex;
                }
                catch (Exception e) {
                    e.printStackTrace();
                    continue;
                }
            }
            finally {
                HttpDownloadUtil.closeWorker();
                if (is != null) {
                    try {
                        is.close();
                    }
                    catch (IOException e) {
                        logger.error((Object)"stream close error!");
                    }
                }
                if (bufInput != null) {
                    try {
                        bufInput.close();
                    }
                    catch (IOException e) {
                        logger.error((Object)"stream close error!");
                    }
                }
                if (tmpFile != null) {
                    try {
                        tmpFile.close();
                    }
                    catch (IOException e) {
                        logger.error((Object)"stream close error!");
                    }
                }
            }
        }
        return -1L;
    }

    private static InputStream getHttpInputStream(String server, Properties requetProps, String fileToDownload) throws IOException {
        String downloadURL = server + "/" + fileToDownload;
        URL url = null;
        try {
            url = new URL((URL)null, downloadURL, new HttpTimeoutHandler(downloadTimeOut * 2));
            httpConnection = (HttpURLConnection)url.openConnection();
            httpConnection.setRequestProperty("Connection", "Close");
            if (requetProps != null) {
                String key = "";
                Enumeration<Object> en = requetProps.keys();
                while (en.hasMoreElements()) {
                    key = (String)en.nextElement();
                    httpConnection.setRequestProperty(key, requetProps.getProperty(key));
                }
            }
            httpConnection.setRequestMethod("GET");
            httpConnection.connect();
        }
        catch (IOException e) {
            logger.error((Object)EASResource.getString((String)"com.kingdee.eas.base.uiframe.UIFRAMEAutoGenerateResource", (String)"12_HttpDownloadUtil"), (Throwable)e);
            throw e;
        }
        int contentLength = httpConnection.getContentLength();
        if (contentLength == -1) {
            return httpConnection.getInputStream();
        }
        return new LimitedInputStream(httpConnection.getInputStream(), contentLength);
    }

    private static void closeWorker() {
        if (httpConnection != null) {
            try {
                httpConnection.disconnect();
            }
            catch (Throwable t) {
                logger.error((Object)"", t);
            }
        }
    }

    private static boolean isNeedRetry(Throwable tb) {
        while (tb != null) {
            if (SocketTimeoutException.class.isInstance(tb)) {
                return true;
            }
            if (ConnectException.class.isInstance(tb)) {
                return tb.getMessage().indexOf("timeout") >= 0 || tb.getMessage().indexOf("timed out") >= 0;
            }
            tb = tb.getCause();
        }
        return false;
    }
}

