/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.uiframe.client.util.httpDownload;

import java.io.IOException;
import java.io.InputStream;

public class LimitedInputStream
extends InputStream {
    private long available;
    private long markedAvailable;
    private InputStream in;

    public LimitedInputStream(InputStream pIn, int pAvailable) {
        this.in = pIn;
        this.available = pAvailable;
    }

    public long getAvailable() {
        return this.available;
    }

    @Override
    public int read() throws IOException {
        if (this.available > 0L) {
            --this.available;
            return this.in.read();
        }
        return -1;
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        if (this.available > 0L) {
            int read;
            if ((long)len > this.available) {
                len = (int)this.available;
            }
            this.available = (read = this.in.read(b, off, len)) == -1 ? 0L : (this.available -= (long)read);
            return read;
        }
        return -1;
    }

    @Override
    public long skip(long n) throws IOException {
        long skip = this.in.skip(n);
        if (this.available > 0L) {
            this.available -= skip;
        }
        return skip;
    }

    @Override
    public void mark(int readlimit) {
        this.in.mark(readlimit);
        this.markedAvailable = this.available;
    }

    @Override
    public void reset() throws IOException {
        this.in.reset();
        this.available = this.markedAvailable;
    }

    @Override
    public boolean markSupported() {
        return true;
    }
}

