/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.uiframe.utils;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.KDBizMultiLangBox;
import com.kingdee.bos.ctrl.swing.KDTree;
import com.kingdee.bos.ctrl.swing.LanguageInfo;
import com.kingdee.bos.ctrl.swing.tree.DefaultKingdeeTreeNode;
import com.kingdee.bos.ctrl.swing.tree.KingdeeTreeModel;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.permission.PermItemInfo;
import com.kingdee.eas.base.uiframe.BizTypeEnum;
import com.kingdee.eas.base.uiframe.ISysMenuFacade;
import com.kingdee.eas.base.uiframe.IndustryEnum;
import com.kingdee.eas.base.uiframe.OpenMethod;
import com.kingdee.eas.base.uiframe.SysMenuFacadeFactory;
import com.kingdee.eas.base.uiframe.SysMenuItemInfo;
import com.kingdee.eas.base.uiframe.client.IMenuComponent;
import com.kingdee.eas.base.uiframe.client.MenuComposite;
import com.kingdee.eas.base.uiframe.client.MenuLeaf;
import com.kingdee.eas.base.uiframe.client.util.SysMenuComparator;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import java.awt.Color;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.swing.Icon;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.apache.log4j.Logger;

public class SysMenuBuilder {
    protected static Logger logger = Logger.getLogger(SysMenuBuilder.class);
    public static final String sample = "com.kingdee.eas.base.uiframe.client.MyUI";
    public static final Color disableColor = new Color(102, 102, 102);
    private static final Icon ICON_FOLDER_OPEN = EASResource.getIcon((String)"imgTree_folder_openpick");
    private static final Icon ICON_FOLDER_CLOSE = EASResource.getIcon((String)"imgTree_folder_closepick");
    private static final Icon ICON_LEAF = EASResource.getIcon((String)"imgTree_folder_leafpick");

    public static SysMenuItemInfo getMenuInfoByID(String menuID, boolean isHandleIcon) throws EASBizException, BOSException {
        if (StringUtils.isEmpty((String)menuID)) {
            return null;
        }
        ISysMenuFacade sysMenuFacade = SysMenuFacadeFactory.getRemoteInstance();
        IRowSet rowset = sysMenuFacade.getSysMenuByID(menuID);
        try {
            if (rowset.next()) {
                SysMenuItemInfo menuItemInfo = new SysMenuItemInfo();
                menuItemInfo.setId(BOSUuid.read((String)rowset.getString("FID")));
                SysMenuBuilder.setMultiLangValue(menuItemInfo, rowset);
                menuItemInfo.setNumber(rowset.getString("FNumber"));
                menuItemInfo.setIndustry(IndustryEnum.getEnum(rowset.getInt("FIndustry")));
                menuItemInfo.setNoSuit(rowset.getString("FNoSuit"));
                menuItemInfo.setLongNumber(rowset.getString("FLongNumber"));
                if (rowset.getString("FParent") != null) {
                    SysMenuItemInfo parentItemInfo = new SysMenuItemInfo();
                    parentItemInfo.setId(BOSUuid.read((String)rowset.getString("FParent")));
                    menuItemInfo.setParent(parentItemInfo);
                }
                menuItemInfo.setLevel(rowset.getInt("FLevel"));
                menuItemInfo.setIsLeaf(rowset.getBoolean("FIsLeaf"));
                menuItemInfo.setOrder(rowset.getString("FOrder"));
                menuItemInfo.setImagePath(rowset.getString("FImagePath"));
                menuItemInfo.setEnabled(rowset.getBoolean("FEnabled"));
                menuItemInfo.setVisible(rowset.getBoolean("FVisible"));
                menuItemInfo.setIsReport(rowset.getBoolean("FIsReport"));
                menuItemInfo.setUiClassName(rowset.getString("FUiClassName"));
                menuItemInfo.setUiClassParam(rowset.getString("FUiClassParam"));
                menuItemInfo.setUiOprt(rowset.getString("FUiOprt"));
                menuItemInfo.setOpenMethod(OpenMethod.getEnum(rowset.getInt("FOpenMethod")));
                menuItemInfo.setShortcutCode(rowset.getString("FShortcutCode"));
                if (rowset.getString("FFunction") != null && rowset.getString("FFunction").trim().length() > 0) {
                    PermItemInfo pemission = new PermItemInfo();
                    pemission.setId(BOSUuid.read((String)rowset.getString("FFunction")));
                    menuItemInfo.setFunction(pemission);
                }
                menuItemInfo.setString("FSysMenuID", rowset.getString("FSysMenuID"));
                return menuItemInfo;
            }
        }
        catch (SQLException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            throw new BOSException((Throwable)e);
        }
        return null;
    }

    public static void buildAllMenuTree(KDTree tree, BizTypeEnum menuType, String industry, boolean isHandleIcon) throws EASBizException, BOSException {
        ISysMenuFacade sysMenuFacade = SysMenuFacadeFactory.getRemoteInstance();
        String locale = SysContext.getSysContext().getLocale().toString();
        HashMap<String, List<SysMenuItemInfo>> parentMapper = new HashMap<String, List<SysMenuItemInfo>>();
        parentMapper.put("topNodes", new ArrayList());
        IRowSet rowset = sysMenuFacade.getAllMenuTree(menuType, industry);
        try {
            while (rowset.next()) {
                SysMenuItemInfo menuItemInfo = new SysMenuItemInfo();
                menuItemInfo.setId(BOSUuid.read((String)rowset.getString("FID")));
                menuItemInfo.setName(rowset.getString("FName_" + locale));
                menuItemInfo.setNumber(rowset.getString("FNumber"));
                menuItemInfo.setIsLeaf(rowset.getBoolean("FIsLeaf"));
                menuItemInfo.setLongNumber(rowset.getString("FLongNumber"));
                menuItemInfo.setOrder(rowset.getString("FOrder"));
                menuItemInfo.setEnabled(rowset.getBoolean("FEnabled"));
                if (!StringUtils.isEmpty((String)rowset.getString("FParent"))) {
                    SysMenuItemInfo parentInfo = new SysMenuItemInfo();
                    parentInfo.setId(BOSUuid.read((String)rowset.getString("FParent")));
                    menuItemInfo.setParent(parentInfo);
                    ArrayList<SysMenuItemInfo> subNodes = (ArrayList<SysMenuItemInfo>)parentMapper.get(rowset.getString("FParent"));
                    if (subNodes == null) {
                        subNodes = new ArrayList<SysMenuItemInfo>();
                        parentMapper.put(rowset.getString("FParent"), subNodes);
                    }
                    subNodes.add(menuItemInfo);
                } else {
                    ((List)parentMapper.get("topNodes")).add(menuItemInfo);
                }
                menuItemInfo.setString("FSysMenuID", rowset.getString("FSysMenuID"));
            }
        }
        catch (SQLException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            throw new BOSException((Throwable)e);
        }
        DefaultKingdeeTreeNode root = SysMenuBuilder.insertNodesIntoRoot(parentMapper, isHandleIcon);
        tree.setModel((TreeModel)new KingdeeTreeModel((TreeNode)root));
        tree.expandPath(new TreePath(root.getPath()));
        tree.setShowsRootHandles(true);
        tree.repaint();
    }

    private static DefaultKingdeeTreeNode insertNodesIntoRoot(Map<String, List<SysMenuItemInfo>> parentMapper, boolean isHandleIcon) {
        DefaultKingdeeTreeNode root = new DefaultKingdeeTreeNode((Object)"EAS");
        List<SysMenuItemInfo> topNodes = parentMapper.get("topNodes");
        Collections.sort(topNodes, new SysMenuComparator("order"));
        for (int i = 0; i < topNodes.size(); ++i) {
            SysMenuItemInfo info = topNodes.get(i);
            DefaultKingdeeTreeNode node = null;
            if (info.isIsLeaf()) {
                node = new MenuLeaf(info);
                if (!info.isEnabled()) {
                    node.setTextColor(disableColor);
                }
                if (isHandleIcon && !StringUtils.isEmpty((String)topNodes.get(i).getString("FSysMenuID"))) {
                    node.setCustomIcon(ICON_LEAF);
                }
            } else {
                node = new MenuComposite(info);
                if (isHandleIcon && !StringUtils.isEmpty((String)topNodes.get(i).getString("FSysMenuID"))) {
                    node.setCustomOpenIcon(ICON_FOLDER_OPEN);
                    node.setCustomClosedIcon(ICON_FOLDER_CLOSE);
                }
            }
            root.add((MutableTreeNode)node);
            SysMenuBuilder.stepAddNodesIntoParent(node, parentMapper, isHandleIcon);
        }
        return root;
    }

    private static void stepAddNodesIntoParent(DefaultKingdeeTreeNode root, Map<String, List<SysMenuItemInfo>> parentMapper, boolean isHandleIcon) {
        SysMenuItemInfo info = (SysMenuItemInfo)root.getUserObject();
        String keyID = info.getId().toString();
        List<SysMenuItemInfo> subNodes = parentMapper.get(keyID);
        if (subNodes != null && subNodes.size() > 0) {
            Collections.sort(subNodes, new SysMenuComparator("longNumber"));
            for (int i = 0; i < subNodes.size(); ++i) {
                SysMenuItemInfo subNodeInfo = subNodes.get(i);
                DefaultKingdeeTreeNode node = null;
                if (subNodeInfo.isIsLeaf()) {
                    node = new MenuLeaf(subNodeInfo);
                    if (!subNodeInfo.isEnabled()) {
                        node.setTextColor(disableColor);
                    }
                    if (isHandleIcon && !StringUtils.isEmpty((String)subNodeInfo.getString("FSysMenuID"))) {
                        node.setCustomIcon(ICON_LEAF);
                    }
                    root.add((MutableTreeNode)node);
                    continue;
                }
                node = new MenuComposite(subNodeInfo);
                if (isHandleIcon && !StringUtils.isEmpty((String)subNodeInfo.getString("FSysMenuID"))) {
                    node.setCustomOpenIcon(ICON_FOLDER_OPEN);
                    node.setCustomClosedIcon(ICON_FOLDER_CLOSE);
                }
                root.add((MutableTreeNode)node);
                SysMenuBuilder.stepAddNodesIntoParent(node, parentMapper, isHandleIcon);
            }
        }
    }

    public static void buildAllMenuTree(KDTree tree) throws EASBizException, BOSException {
        DefaultKingdeeTreeNode root = new DefaultKingdeeTreeNode((Object)"EAS");
        ISysMenuFacade sysMenuFacade = SysMenuFacadeFactory.getRemoteInstance();
        IRowSet rowset = sysMenuFacade.getSubSys();
        try {
            while (rowset.next()) {
                String ln = rowset.getString("FLongNumber");
                root.add((MutableTreeNode)((DefaultKingdeeTreeNode)SysMenuBuilder.buildSubSysTree(ln)));
            }
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        tree.setModel((TreeModel)new KingdeeTreeModel((TreeNode)root));
        tree.expandPath(new TreePath(root.getPath()));
        tree.setShowsRootHandles(true);
        tree.repaint();
    }

    private static TreeNode buildSubSysTree(String longNumber) throws EASBizException, BOSException {
        DefaultKingdeeTreeNode root = null;
        try {
            ISysMenuFacade sysMenuFacade = SysMenuFacadeFactory.getRemoteInstance();
            IRowSet rowset = sysMenuFacade.getMenuByParent(longNumber);
            Hashtable<String, MenuLeaf> menuht = new Hashtable<String, MenuLeaf>();
            SysMenuItemInfo menuItemInfo = null;
            DefaultKingdeeTreeNode menuComponent = null;
            IMenuComponent parent = null;
            SysMenuItemInfo parentItemInfo = null;
            PermItemInfo pemission = null;
            while (rowset.next()) {
                menuItemInfo = new SysMenuItemInfo();
                menuItemInfo.setId(BOSUuid.read((String)rowset.getString("FID")));
                SysMenuBuilder.setMultiLangValue(menuItemInfo, rowset);
                menuItemInfo.setNumber(rowset.getString("FNumber"));
                menuItemInfo.setIndustry(IndustryEnum.getEnum(rowset.getInt("FIndustry")));
                menuItemInfo.setNoSuit(rowset.getString("FNoSuit"));
                menuItemInfo.setLongNumber(rowset.getString("FLongNumber"));
                if (rowset.getString("FParent") != null) {
                    parentItemInfo = new SysMenuItemInfo();
                    parentItemInfo.setId(BOSUuid.read((String)rowset.getString("FParent")));
                    menuItemInfo.setParent(parentItemInfo);
                } else {
                    menuItemInfo.setParent(null);
                }
                menuItemInfo.setLevel(rowset.getInt("FLevel"));
                menuItemInfo.setIsLeaf(rowset.getInt("FIsLeaf") != 0);
                menuItemInfo.setOrder(rowset.getString("FOrder"));
                menuItemInfo.setImagePath(rowset.getString("FImagePath"));
                menuItemInfo.setEnabled(rowset.getInt("FEnabled") != 0);
                menuItemInfo.setVisible(rowset.getInt("FVisible") != 0);
                menuItemInfo.setIsReport(rowset.getInt("FIsReport") != 0);
                menuItemInfo.setUiClassName(rowset.getString("FUiClassName"));
                menuItemInfo.setUiClassParam(rowset.getString("FUiClassParam"));
                menuItemInfo.setUiOprt(rowset.getString("FUiOprt"));
                menuItemInfo.setOpenMethod(OpenMethod.getEnum(rowset.getInt("FOpenMethod")));
                menuItemInfo.setShortcutCode(rowset.getString("FShortcutCode"));
                if (rowset.getString("FFunction") != null && rowset.getString("FFunction").trim().length() > 0) {
                    pemission = new PermItemInfo();
                    pemission.setId(BOSUuid.read((String)rowset.getString("FFunction")));
                    menuItemInfo.setFunction(pemission);
                }
                if (rowset.getInt("FIsLeaf") == 1) {
                    menuComponent = new MenuLeaf(menuItemInfo);
                    if (StringUtils.isEmpty((String)rowset.getString("FUiClassName")) || sample.equals(rowset.getString("FUiClassName")) || rowset.getInt("FEnabled") == 0) {
                        ((DefaultKingdeeTreeNode)menuComponent).setTextColor(disableColor);
                    }
                } else {
                    menuComponent = new MenuComposite(menuItemInfo);
                    menuht.put(menuItemInfo.getId().toString(), (MenuLeaf)menuComponent);
                }
                if (rowset.getString("FParent") == null) {
                    root = menuComponent;
                    continue;
                }
                parent = (IMenuComponent)menuht.get(rowset.getString("FParent"));
                if (parent == null) continue;
                parent.addComponent((IMenuComponent)menuComponent);
            }
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        return root;
    }

    public static void buildAllMenuTreeForCust(KDTree tree) throws EASBizException, BOSException {
        DefaultKingdeeTreeNode root = new DefaultKingdeeTreeNode((Object)"EAS");
        ISysMenuFacade sysMenuFacade = SysMenuFacadeFactory.getRemoteInstance();
        IRowSet rowset = sysMenuFacade.getSubSys();
        try {
            while (rowset.next()) {
                String ln = rowset.getString("FLongNumber");
                root.add((MutableTreeNode)((DefaultKingdeeTreeNode)SysMenuBuilder.buildSubSysTreeForCust(ln, "")));
            }
        }
        catch (SQLException exc) {
            throw new BOSException((Throwable)exc);
        }
        tree.setModel((TreeModel)new KingdeeTreeModel((TreeNode)root));
        tree.expandPath(new TreePath(root.getPath()));
        tree.setShowsRootHandles(true);
        tree.repaint();
    }

    public static void buildAllMenuTreeForCust(KDTree tree, String IndustryType) throws EASBizException, BOSException {
        DefaultKingdeeTreeNode root = new DefaultKingdeeTreeNode((Object)"EAS");
        ISysMenuFacade sysMenuFacade = SysMenuFacadeFactory.getRemoteInstance();
        IRowSet rowset = sysMenuFacade.getSubSys();
        try {
            while (rowset.next()) {
                String ln = rowset.getString("FLongNumber");
                DefaultKingdeeTreeNode treeNode = (DefaultKingdeeTreeNode)SysMenuBuilder.buildSubSysTreeForCust(ln, IndustryType);
                if (treeNode == null) continue;
                root.add((MutableTreeNode)treeNode);
            }
        }
        catch (SQLException exc) {
            throw new BOSException((Throwable)exc);
        }
        tree.setModel((TreeModel)new KingdeeTreeModel((TreeNode)root));
        tree.expandPath(new TreePath(root.getPath()));
        tree.setShowsRootHandles(true);
        tree.repaint();
    }

    public static void buildAllMenuTreeForCust(KDTree tree, String IndustryType, String menutype) throws EASBizException, BOSException {
        DefaultKingdeeTreeNode root = new DefaultKingdeeTreeNode((Object)"EAS");
        ISysMenuFacade sysMenuFacade = SysMenuFacadeFactory.getRemoteInstance();
        IRowSet rowset = sysMenuFacade.getSubSys(IndustryType, menutype);
        try {
            while (rowset.next()) {
                String ln = rowset.getString("FLongNumber");
                DefaultKingdeeTreeNode treeNode = (DefaultKingdeeTreeNode)SysMenuBuilder.buildSubSysTreeForCustAndMenuType(ln, IndustryType, menutype);
                if (treeNode == null) continue;
                root.add((MutableTreeNode)treeNode);
            }
        }
        catch (SQLException exc) {
            throw new BOSException((Throwable)exc);
        }
        tree.setModel((TreeModel)new KingdeeTreeModel((TreeNode)root));
        tree.expandPath(new TreePath(root.getPath()));
        tree.setShowsRootHandles(true);
        tree.repaint();
    }

    public static void buildAllMenuTreeForCustAndMenuType(KDTree tree, String IndustryType, String menutype) throws EASBizException, BOSException {
        DefaultKingdeeTreeNode root = new DefaultKingdeeTreeNode((Object)"EAS");
        ISysMenuFacade sysMenuFacade = SysMenuFacadeFactory.getRemoteInstance();
        IRowSet rowset = sysMenuFacade.getSubSysForMenuType(menutype);
        try {
            while (rowset.next()) {
                String ln = rowset.getString("FLongNumber");
                DefaultKingdeeTreeNode treeNode = (DefaultKingdeeTreeNode)SysMenuBuilder.buildSubSysTreeForCustAndMenuType(ln, IndustryType, menutype);
                if (treeNode == null) continue;
                root.add((MutableTreeNode)treeNode);
            }
        }
        catch (SQLException exc) {
            throw new BOSException((Throwable)exc);
        }
        tree.setModel((TreeModel)new KingdeeTreeModel((TreeNode)root));
        tree.expandPath(new TreePath(root.getPath()));
        tree.setShowsRootHandles(true);
        tree.repaint();
    }

    private static TreeNode buildSubSysTreeForCust(String longNumber, String IndustryType) throws EASBizException, BOSException {
        DefaultKingdeeTreeNode root = null;
        try {
            ISysMenuFacade sysMenuFacade = SysMenuFacadeFactory.getRemoteInstance();
            IRowSet rowset = null;
            rowset = IndustryType.equals("") ? sysMenuFacade.getMenuByParentForCust(longNumber) : sysMenuFacade.getMenuByParentForCust(longNumber, IndustryType);
            Hashtable<String, MenuLeaf> menuht = new Hashtable<String, MenuLeaf>();
            SysMenuItemInfo menuItemInfo = null;
            DefaultKingdeeTreeNode menuComponent = null;
            IMenuComponent parent = null;
            SysMenuItemInfo parentItemInfo = null;
            PermItemInfo pemission = null;
            String sysMenuID = null;
            while (rowset.next()) {
                menuItemInfo = new SysMenuItemInfo();
                menuItemInfo.setId(BOSUuid.read((String)rowset.getString("FID")));
                SysMenuBuilder.setMultiLangValue(menuItemInfo, rowset);
                menuItemInfo.setNumber(rowset.getString("FNumber"));
                menuItemInfo.setIndustry(IndustryEnum.getEnum(rowset.getInt("FIndustry")));
                menuItemInfo.setNoSuit(rowset.getString("FNoSuit"));
                menuItemInfo.setLongNumber(rowset.getString("FLongNumber"));
                if (rowset.getString("FParent") != null) {
                    parentItemInfo = new SysMenuItemInfo();
                    parentItemInfo.setId(BOSUuid.read((String)rowset.getString("FParent")));
                    menuItemInfo.setParent(parentItemInfo);
                } else {
                    menuItemInfo.setParent(null);
                }
                menuItemInfo.setLevel(rowset.getInt("FLevel"));
                menuItemInfo.setIsLeaf(rowset.getInt("FIsLeaf") != 0);
                menuItemInfo.setOrder(rowset.getString("FOrder"));
                menuItemInfo.setImagePath(rowset.getString("FImagePath"));
                menuItemInfo.setEnabled(rowset.getInt("FEnabled") != 0);
                menuItemInfo.setVisible(rowset.getInt("FVisible") != 0);
                menuItemInfo.setIsReport(rowset.getInt("FIsReport") != 0);
                menuItemInfo.setUiClassName(rowset.getString("FUiClassName"));
                menuItemInfo.setUiClassParam(rowset.getString("FUiClassParam"));
                menuItemInfo.setUiOprt(rowset.getString("FUiOprt"));
                menuItemInfo.setOpenMethod(OpenMethod.getEnum(rowset.getInt("FOpenMethod")));
                menuItemInfo.setShortcutCode(rowset.getString("FShortcutCode"));
                sysMenuID = rowset.getString("FSysMenuID");
                if (rowset.getString("FFunction") != null && rowset.getString("FFunction").trim().length() > 0) {
                    pemission = new PermItemInfo();
                    pemission.setId(BOSUuid.read((String)rowset.getString("FFunction")));
                    menuItemInfo.setFunction(pemission);
                }
                if (rowset.getInt("FIsLeaf") == 1) {
                    menuComponent = new MenuLeaf(menuItemInfo);
                    if (StringUtils.isEmpty((String)rowset.getString("FUiClassName")) || sample.equals(rowset.getString("FUiClassName")) || rowset.getInt("FEnabled") == 0) {
                        ((DefaultKingdeeTreeNode)menuComponent).setTextColor(disableColor);
                    }
                    if (null != sysMenuID && sysMenuID.trim().length() > 0) {
                        ((DefaultKingdeeTreeNode)menuComponent).setCustomIcon(ICON_LEAF);
                    }
                } else {
                    menuComponent = new MenuComposite(menuItemInfo);
                    menuht.put(menuItemInfo.getId().toString(), (MenuLeaf)menuComponent);
                    if (null != sysMenuID && sysMenuID.trim().length() > 0) {
                        ((DefaultKingdeeTreeNode)menuComponent).setCustomOpenIcon(ICON_FOLDER_OPEN);
                        ((DefaultKingdeeTreeNode)menuComponent).setCustomClosedIcon(ICON_FOLDER_CLOSE);
                    }
                }
                if (rowset.getString("FParent") == null) {
                    root = menuComponent;
                    continue;
                }
                parent = (IMenuComponent)menuht.get(rowset.getString("FParent"));
                if (parent == null) continue;
                parent.addComponent((IMenuComponent)menuComponent);
            }
        }
        catch (SQLException exc) {
            throw new BOSException((Throwable)exc);
        }
        return root;
    }

    private static TreeNode buildSubSysTreeForCustAndMenuType(String longNumber, String IndustryType, String menutype) throws EASBizException, BOSException {
        DefaultKingdeeTreeNode root = null;
        try {
            ISysMenuFacade sysMenuFacade = SysMenuFacadeFactory.getRemoteInstance();
            IRowSet rowset = sysMenuFacade.getMenuByParentForCust(longNumber, IndustryType, menutype);
            Hashtable<String, MenuLeaf> menuht = new Hashtable<String, MenuLeaf>();
            SysMenuItemInfo menuItemInfo = null;
            DefaultKingdeeTreeNode menuComponent = null;
            IMenuComponent parent = null;
            SysMenuItemInfo parentItemInfo = null;
            PermItemInfo pemission = null;
            Object sysMenuID = null;
            while (rowset.next()) {
                menuItemInfo = new SysMenuItemInfo();
                menuItemInfo.setId(BOSUuid.read((String)rowset.getString("FID")));
                SysMenuBuilder.setMultiLangValue(menuItemInfo, rowset);
                if (null == rowset.getString("FMenutype") || "".equals(rowset.getString("FMenutype"))) {
                    menuItemInfo.setMenutype(BizTypeEnum.guimenu);
                } else {
                    menuItemInfo.setMenutype(BizTypeEnum.getEnum(rowset.getString("FMenutype")));
                }
                menuItemInfo.setNumber(rowset.getString("FNumber"));
                menuItemInfo.setIndustry(IndustryEnum.getEnum(rowset.getInt("FIndustry")));
                menuItemInfo.setNoSuit(rowset.getString("FNoSuit"));
                menuItemInfo.setLongNumber(rowset.getString("FLongNumber"));
                if (rowset.getString("FParent") != null) {
                    parentItemInfo = new SysMenuItemInfo();
                    parentItemInfo.setId(BOSUuid.read((String)rowset.getString("FParent")));
                    menuItemInfo.setParent(parentItemInfo);
                } else {
                    menuItemInfo.setParent(null);
                }
                menuItemInfo.setLevel(rowset.getInt("FLevel"));
                menuItemInfo.setIsLeaf(rowset.getInt("FIsLeaf") != 0);
                menuItemInfo.setOrder(rowset.getString("FOrder"));
                menuItemInfo.setImagePath(rowset.getString("FImagePath"));
                menuItemInfo.setEnabled(rowset.getInt("FEnabled") != 0);
                menuItemInfo.setVisible(rowset.getInt("FVisible") != 0);
                menuItemInfo.setIsReport(rowset.getInt("FIsReport") != 0);
                menuItemInfo.setUiClassName(rowset.getString("FUiClassName"));
                menuItemInfo.setUiClassParam(rowset.getString("FUiClassParam"));
                menuItemInfo.setUiOprt(rowset.getString("FUiOprt"));
                menuItemInfo.setOpenMethod(OpenMethod.getEnum(rowset.getInt("FOpenMethod")));
                menuItemInfo.setShortcutCode(rowset.getString("FShortcutCode"));
                sysMenuID = null;
                if (rowset.getString("FFunction") != null && rowset.getString("FFunction").trim().length() > 0) {
                    pemission = new PermItemInfo();
                    pemission.setId(BOSUuid.read((String)rowset.getString("FFunction")));
                    menuItemInfo.setFunction(pemission);
                }
                if (rowset.getInt("FIsLeaf") == 1) {
                    menuComponent = new MenuLeaf(menuItemInfo);
                    if (StringUtils.isEmpty((String)rowset.getString("FUiClassName")) || sample.equals(rowset.getString("FUiClassName")) || rowset.getInt("FEnabled") == 0) {
                        ((DefaultKingdeeTreeNode)menuComponent).setTextColor(disableColor);
                    }
                } else {
                    menuComponent = new MenuComposite(menuItemInfo);
                    menuht.put(menuItemInfo.getId().toString(), (MenuLeaf)menuComponent);
                }
                if (rowset.getString("FParent") == null) {
                    root = menuComponent;
                    continue;
                }
                parent = (IMenuComponent)menuht.get(rowset.getString("FParent"));
                if (parent == null) continue;
                parent.addComponent((IMenuComponent)menuComponent);
            }
        }
        catch (SQLException exc) {
            throw new BOSException((Throwable)exc);
        }
        return root;
    }

    private static void setMultiLangValue(SysMenuItemInfo menuItem, IRowSet rowset) throws SQLException {
        List langList = KDBizMultiLangBox.getLanguageList();
        for (LanguageInfo currentLang : langList) {
            Locale locale = currentLang.getLocale();
            String name = rowset.getString("FName_" + locale.toString());
            menuItem.setName(name, locale);
            String description = rowset.getString("FDescription_" + locale.toString());
            menuItem.setDescription(description, locale);
            if (!locale.equals(SysContext.getSysContext().getLocale())) continue;
            menuItem.setName(name);
            menuItem.setDescription(description);
        }
    }
}

