/*
 * Decompiled with CFR 0.152.
 */
package weibo4j;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import weibo4j.User;
import weibo4j.Weibo;
import weibo4j.WeiboException;
import weibo4j.WeiboResponse;
import weibo4j.http.Response;
import weibo4j.org.json.JSONArray;
import weibo4j.org.json.JSONException;
import weibo4j.org.json.JSONObject;

public class RetweetDetails
extends WeiboResponse
implements Serializable {
    private long retweetId;
    private Date retweetedAt;
    private User retweetingUser;
    static final long serialVersionUID = 1957982268696560598L;

    RetweetDetails(Response res, Weibo weibo) throws WeiboException {
        super(res);
        Element elem = res.asDocument().getDocumentElement();
        this.init(res, elem, weibo);
    }

    RetweetDetails(JSONObject json) throws WeiboException {
        this.init(json);
    }

    private void init(JSONObject json) throws WeiboException {
        try {
            this.retweetId = json.getInt("retweetId");
            this.retweetedAt = RetweetDetails.parseDate(json.getString("retweetedAt"), "EEE MMM dd HH:mm:ss z yyyy");
            this.retweetingUser = new User(json.getJSONObject("retweetingUser"));
        }
        catch (JSONException jsone) {
            throw new WeiboException(jsone.getMessage() + ":" + json.toString(), jsone);
        }
    }

    RetweetDetails(Response res, Element elem, Weibo weibo) throws WeiboException {
        super(res);
        this.init(res, elem, weibo);
    }

    private void init(Response res, Element elem, Weibo weibo) throws WeiboException {
        RetweetDetails.ensureRootNodeNameIs("retweet_details", elem);
        this.retweetId = RetweetDetails.getChildLong("retweet_id", elem);
        this.retweetedAt = RetweetDetails.getChildDate("retweeted_at", elem);
        this.retweetingUser = new User(res, (Element)elem.getElementsByTagName("retweeting_user").item(0), weibo);
    }

    public long getRetweetId() {
        return this.retweetId;
    }

    public Date getRetweetedAt() {
        return this.retweetedAt;
    }

    public User getRetweetingUser() {
        return this.retweetingUser;
    }

    static List<RetweetDetails> createRetweetDetails(Response res) throws WeiboException {
        try {
            JSONArray list = res.asJSONArray();
            int size = list.length();
            ArrayList<RetweetDetails> retweets = new ArrayList<RetweetDetails>(size);
            for (int i = 0; i < size; ++i) {
                retweets.add(new RetweetDetails(list.getJSONObject(i)));
            }
            return retweets;
        }
        catch (JSONException jsone) {
            throw new WeiboException(jsone);
        }
        catch (WeiboException te) {
            throw te;
        }
    }

    static List<RetweetDetails> createRetweetDetails(Response res, Weibo weibo) throws WeiboException {
        Document doc = res.asDocument();
        if (RetweetDetails.isRootNodeNilClasses(doc)) {
            return new ArrayList<RetweetDetails>(0);
        }
        try {
            RetweetDetails.ensureRootNodeNameIs("retweets", doc);
            NodeList list = doc.getDocumentElement().getElementsByTagName("retweet_details");
            int size = list.getLength();
            ArrayList<RetweetDetails> statuses = new ArrayList<RetweetDetails>(size);
            for (int i = 0; i < size; ++i) {
                Element status = (Element)list.item(i);
                statuses.add(new RetweetDetails(res, status, weibo));
            }
            return statuses;
        }
        catch (WeiboException te) {
            RetweetDetails.ensureRootNodeNameIs("nil-classes", doc);
            return new ArrayList<RetweetDetails>(0);
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof RetweetDetails)) {
            return false;
        }
        RetweetDetails that = (RetweetDetails)o;
        return this.retweetId == that.retweetId;
    }

    public int hashCode() {
        int result = (int)(this.retweetId ^ this.retweetId >>> 32);
        result = 31 * result + this.retweetedAt.hashCode();
        result = 31 * result + this.retweetingUser.hashCode();
        return result;
    }

    public String toString() {
        return "RetweetDetails{retweetId=" + this.retweetId + ", retweetedAt=" + this.retweetedAt + ", retweetingUser=" + this.retweetingUser + '}';
    }
}

