/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.wssc.openApi.handler;

import com.kingdee.bos.Context;
import com.kingdee.bos.json.JSONUtils;
import com.kingdee.bos.metadata.bo.MethodInfo;
import com.kingdee.bos.openapi.app.core.IOpenApiExtHandler;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.eas.base.wssc.openApi.annotation.ApiParam;
import com.kingdee.eas.base.wssc.openApi.utils.OpenApiUtils;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.HashMap;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;

public abstract class AbstractOpenApiHandler
implements IOpenApiExtHandler {
    private static Logger logger = Logger.getLogger(AbstractOpenApiHandler.class);

    public Object[] converToParamObjects(Context context, BOSObjectType bosObjectType, MethodInfo methodInfo, String s) {
        return null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void fireBeforeMethod(Context context, BOSObjectType bosObjectType, MethodInfo methodInfo, Object[] objects) {
        this.logger(methodInfo, objects, null);
        Method method = null;
        try {
            method = OpenApiUtils.getMethod(context, bosObjectType, methodInfo);
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        if (method == null) return;
        Object[] newObjects = new Object[objects.length + 1];
        newObjects[0] = context;
        for (int i = 0; i < objects.length; ++i) {
            newObjects[i + 1] = objects[i];
        }
        HashMap map = null;
        Annotation[][] parameterAnnotations = method.getParameterAnnotations();
        if (parameterAnnotations == null) return;
        if (parameterAnnotations.length == 0) return;
        for (int i = 0; i < parameterAnnotations.length; ++i) {
            for (Annotation annotation : parameterAnnotations[i]) {
                if (!(annotation instanceof ApiParam)) continue;
                ApiParam apiParam = (ApiParam)annotation;
                if (apiParam.required() && StringUtils.isBlank((CharSequence)(newObjects[i] == null ? "" : newObjects[i].toString()))) {
                    throw new IllegalArgumentException("\u65b9\u6cd5\uff1a" + methodInfo.getName() + "\u7b2c" + i + "\u4e2a\u53c2\u6570\u662f\u5fc5\u8981\u53c2\u6570\uff01");
                }
                if (!StringUtils.isNotBlank((CharSequence)apiParam.requiredColumn().replaceAll("\u6b64\u53c2\u6570\u5fc5\u987b\u5305\u542bXX\uff0c\u6709\u591a\u4e2a\u5fc5\u8981\u53c2\u6570\u7528\u9017\u53f7\u5206\u9694", ""))) continue;
                map = null;
                try {
                    map = JSONUtils.convertJsonToObject((Context)context, (String)newObjects[i].toString());
                }
                catch (Throwable e) {
                    logger.error((Object)("\u53c2\u6570\u8f6c\u6362\u5931\u8d25\uff1a" + newObjects[i]));
                }
                if (map == null) continue;
                String[] columns = apiParam.requiredColumn().split(",");
                for (int j = 0; j < columns.length; ++j) {
                    if (map.containsKey(columns[j])) continue;
                    throw new IllegalArgumentException("\u65b9\u6cd5\uff1a" + methodInfo.getName() + "\u7b2c" + i + "\u4e2a\u53c2\u6570\u4e2d" + columns[j] + "\u662f\u5fc5\u8981\u53c2\u6570\uff01");
                }
            }
        }
    }

    public void fireAfterMethod(Context context, BOSObjectType bosObjectType, MethodInfo methodInfo, Object[] objects, Object o) {
        this.logger(methodInfo, objects, o);
    }

    private void logger(MethodInfo methodInfo, Object[] objects, Object o) {
        StringBuilder param = new StringBuilder();
        for (Object op : objects) {
            param.append(op + "\uff1b");
        }
        if (o != null) {
            param.append("\uff1b\u8fd4\u56de\u503c\uff1a" + o.toString());
        }
        logger.info((Object)("\u8c03\u7528\u65b9\u6cd5\uff1a" + methodInfo.getName() + "\uff1b\u53c2\u6570\u503c\uff1a" + param.toString()));
    }
}

