/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.applet.framework;

import com.kingdee.eas.applet.framework.IAppletThreadService;
import com.kingdee.eas.applet.framework.NoIdleThreadException;
import com.kingdee.eas.applet.framework.ThreadService;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;

public class ThreadManager {
    private static Hashtable threadPool = new Hashtable();

    public static ThreadService getInstance(IAppletThreadService _threadService) throws NoIdleThreadException {
        ThreadService result = ThreadManager.get(_threadService);
        result.setBizService(_threadService);
        return result;
    }

    private static ThreadService get(IAppletThreadService _threadService) throws NoIdleThreadException {
        ThreadService result = null;
        String key = _threadService.getClass().getName();
        Hashtable<String, ThreadService> threadMgrs = (Hashtable<String, ThreadService>)threadPool.get(key);
        if (threadMgrs == null) {
            threadMgrs = new Hashtable<String, ThreadService>();
            String keyThread = key + ".0";
            result = new ThreadService();
            result.setCurrentThreadKey(keyThread);
            threadMgrs.put(keyThread, result);
            threadPool.put(key, threadMgrs);
        } else {
            Iterator ite = threadMgrs.entrySet().iterator();
            int threadCount = 0;
            Map.Entry entry = null;
            ThreadService threadMgr = null;
            while (ite.hasNext()) {
                entry = ite.next();
                threadMgr = (ThreadService)entry.getValue();
                ++threadCount;
                if (threadMgr.isStarted()) continue;
                result = threadMgr;
                break;
            }
            if (result == null) {
                if (threadCount >= _threadService.getMaxThreadCount()) {
                    throw new NoIdleThreadException("Thread pool has been to max capability. thread group : " + key);
                }
                String keyThread = key + "." + threadCount;
                result = new ThreadService();
                result.setCurrentThreadKey(keyThread);
                threadMgrs.put(keyThread, result);
                threadPool.put(key, threadMgrs);
            }
        }
        return result;
    }

    public static void reset(ThreadService newThread) {
        int idx;
        String keyThread = newThread.getCurrentThreadKey();
        String key = keyThread.substring(0, idx = keyThread.lastIndexOf(46));
        Hashtable<String, ThreadService> threadMgrs = (Hashtable<String, ThreadService>)threadPool.get(key);
        if (threadMgrs == null) {
            threadMgrs = new Hashtable<String, ThreadService>();
            threadMgrs.put(keyThread, newThread);
            threadPool.put(key, threadMgrs);
        } else {
            threadMgrs.put(keyThread, newThread);
            threadPool.put(key, threadMgrs);
        }
    }

    public static void setThreadStarted(ThreadService curThread) {
        int idx;
        String keyThread = curThread.getCurrentThreadKey();
        String key = keyThread.substring(0, idx = keyThread.lastIndexOf(46));
        Hashtable threadMgrs = (Hashtable)threadPool.get(key);
        if (threadMgrs == null) {
            return;
        }
        ThreadService newThread = (ThreadService)threadMgrs.get(keyThread);
        if (newThread == null) {
            return;
        }
        newThread.setStarted(true);
        threadMgrs.put(keyThread, newThread);
        threadPool.put(key, threadMgrs);
    }

    public static void destroy(IAppletThreadService _threadService) {
        String key = _threadService.getClass().getName();
        threadPool.remove(key);
        System.out.println("clear applet framework thread service: " + key);
    }

    public static void clear() {
        if (threadPool != null) {
            threadPool.clear();
            System.out.println("clear applet framework thread pool.");
        }
    }
}

