/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.apploader.framework;

import com.kingdee.eas.applet.IJSParameterProvider;
import com.kingdee.eas.apploader.framework.AppletRuningException;
import com.kingdee.eas.apploader.framework.AppletThreadServiceAdapter;
import com.kingdee.eas.apploader.framework.BizServiceProviderProxy;
import com.kingdee.eas.apploader.framework.NoIdleThreadException;
import com.kingdee.eas.apploader.framework.ThreadManager;
import com.kingdee.eas.apploader.framework.ThreadService;
import com.kingdee.eas.apploader.framework.WebUIContainer;
import java.lang.reflect.Method;

public class AppletThreadServiceImpl
extends AppletThreadServiceAdapter {
    private int maxThreadCount = 1;
    private ClassLoader cl = this.getClass().getClassLoader();
    private WebUIContainer container = null;
    private BizServiceProviderProxy proxy = null;
    private Class serviceProviderClass = null;
    private Object serviceProvider = null;
    private IJSParameterProvider paramProvider = null;
    private boolean repaint = false;
    private Thread serviceThread = null;

    public AppletThreadServiceImpl(WebUIContainer container) throws AppletRuningException {
        this(container, false, null);
    }

    public AppletThreadServiceImpl(WebUIContainer container, boolean repaint) throws AppletRuningException {
        this(container, repaint, null);
    }

    public AppletThreadServiceImpl(WebUIContainer container, boolean repaint, IJSParameterProvider paramProviderProxy) throws AppletRuningException {
        this(container, repaint, paramProviderProxy, null);
    }

    public AppletThreadServiceImpl(WebUIContainer container, boolean repaint, IJSParameterProvider paramProviderProxy, BizServiceProviderProxy proxy) throws AppletRuningException {
        this.container = container;
        this.proxy = proxy;
        this.paramProvider = paramProviderProxy;
        this.repaint = repaint;
        try {
            this.serviceThread = ThreadManager.getInstance(this);
        }
        catch (NoIdleThreadException e) {
            e.printStackTrace();
            throw new AppletRuningException(AppletRuningException.APPLET_INIT_FAILS, e);
        }
    }

    public void invokeService() {
        try {
            this.serviceThread = ThreadManager.getInstance(this);
            System.out.println("start biz service thread:" + ((ThreadService)this.serviceThread).getCurrentThreadKey());
            this.serviceThread.start();
        }
        catch (NoIdleThreadException e1) {
            System.out.println(e1.toString());
        }
        catch (IllegalThreadStateException e) {
            System.out.println("biz service thread[" + ((ThreadService)this.serviceThread).getCurrentThreadKey() + "] is started.");
            throw e;
        }
    }

    public void run() {
        long start = System.currentTimeMillis();
        try {
            this.loadServiceProvider();
            String invokeMethod = this.paramProvider.getInvokeMethod();
            if (invokeMethod != null && !"".equals(invokeMethod)) {
                Object result = this.invokeService(invokeMethod, this.paramProvider.getInvokeParameterTypes(), this.paramProvider.getInvokeParameterValues());
                this.paramProvider.setReturnValue(result);
                this.paramProvider.consume();
            }
            long cost = System.currentTimeMillis() - start;
            System.out.println(" finished invoking biz service [" + this.paramProvider.getInvokeClassName() + "." + invokeMethod + "],spent " + cost + " ms.");
        }
        catch (Throwable e) {
            this.serviceProviderClass = null;
            e.printStackTrace();
        }
    }

    private boolean isRepaint() {
        return this.repaint;
    }

    Object invokeService(String methodName, Class[] paramTypes, Object[] paramValues) throws Exception {
        long start = System.currentTimeMillis();
        Method method = this.serviceProviderClass.getMethod(methodName, paramTypes);
        Object result = method.invoke(this.serviceProvider, paramValues);
        long cost = System.currentTimeMillis() - start;
        System.out.println("Invoke service " + methodName + " : " + cost + "ms!");
        return result;
    }

    public int getMaxThreadCount() {
        return this.maxThreadCount;
    }

    public void destory() {
    }

    public void setParamProvider(IJSParameterProvider paramProvider) {
        this.paramProvider = paramProvider;
    }

    public IJSParameterProvider getParamProvider() {
        return this.paramProvider;
    }

    public void loadServiceProvider() throws ClassNotFoundException, InstantiationException, IllegalAccessException, NoSuchMethodException {
        System.out.println("Init service provider start ");
        long start = System.currentTimeMillis();
        String invokeClassName = this.paramProvider.getInvokeClassName();
        if (this.proxy != null && invokeClassName == null || "".equals(invokeClassName)) {
            this.serviceProviderClass = this.proxy.getServiceProxyClass();
            this.serviceProvider = this.proxy.getServiceProxy();
            return;
        }
        if (this.serviceProviderClass != null && this.serviceProviderClass.getName().equals(invokeClassName)) {
            return;
        }
        this.serviceProviderClass = this.container.getClassLoader().loadClass(invokeClassName);
        System.out.println("LoadClass serviceProvider " + invokeClassName + " :" + (System.currentTimeMillis() - start) + "ms");
        long start2 = System.currentTimeMillis();
        this.serviceProvider = this.serviceProviderClass.newInstance();
        System.out.println("NewInstance serviceProvider " + invokeClassName + " :" + (System.currentTimeMillis() - start2) + "ms");
        long cost = System.currentTimeMillis() - start;
        System.out.println("Init service provider end : " + cost + "ms!");
    }
}

