/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.analysis.bicomponent;

import com.kingdee.bos.ctrl.analysis.bicomponent.CellItem;
import com.kingdee.bos.ctrl.analysis.bicomponent.ComponentConfig;
import com.kingdee.bos.ctrl.analysis.bicomponent.DataCellItem;
import com.kingdee.bos.ctrl.analysis.bicomponent.DimensionPropertyCellItem;
import com.kingdee.bos.ctrl.analysis.bicomponent.DimensionPropertyValueCellItem;
import com.kingdee.bos.ctrl.analysis.bicomponent.ExpandHelper;
import com.kingdee.bos.ctrl.analysis.bicomponent.HierarchyCellItem;
import com.kingdee.bos.ctrl.analysis.bicomponent.Icons;
import com.kingdee.bos.ctrl.analysis.bicomponent.MemberCellItem;
import com.kingdee.bos.ctrl.analysis.bicomponent.TreeIcon;
import com.kingdee.bos.ctrl.analysis.resource.Resources;
import com.kingdee.bos.ctrl.kdf.util.render.IBasicRender;
import com.kingdee.bos.ctrl.kdf.util.render.SimpleTextRender;
import com.kingdee.bos.ctrl.kdf.util.style.Style;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.Shape;

public class CellRender
implements IBasicRender,
Cloneable {
    static Color bgColorDark = new Color(251, 251, 216);
    static Color bgColor = new Color(255, 254, 237);
    static SimpleTextRender textRender = new SimpleTextRender();
    static TreeIcon treeIcon = new TreeIcon();
    static Icons icons = new Icons();
    static Integer i0 = new Integer(0);
    static Integer i1 = new Integer(1);
    static Integer i2 = new Integer(2);
    Rectangle rect;
    ComponentConfig config;
    ExpandHelper expandHelper;

    public CellRender(ExpandHelper expandHelper, ComponentConfig config) {
        this.config = config;
        this.expandHelper = expandHelper;
    }

    private Image getStatusIcon(String status) {
        Image image = Resources.getImage("icon/status" + status + ".gif");
        return image;
    }

    private Image getTrendIcon(String trend) {
        return Resources.getImage("icon/tbtn_expand.gif");
    }

    public void draw(Graphics g, Shape clip, Object object, Style cellStyle) {
        Rectangle bound = clip.getBounds();
        if (object instanceof HierarchyCellItem) {
            HierarchyCellItem cellItem = (HierarchyCellItem)object;
            if (cellItem.inSlicer() || !this.config.showColumnHeaderInTableHeader) {
                Color oldColor = g.getColor();
                g.setColor(bgColorDark);
                g.fillRect(bound.x - 3, bound.y - 2 + 2, bound.width + 6, bound.height + 4 - 4);
                g.setColor(oldColor);
            }
            Rectangle clip2 = new Rectangle(bound.x, bound.y, bound.width - 12, bound.height);
            if (object != null && object.toString() != null) {
                textRender.draw(g, (Shape)clip2, object.toString(), cellStyle);
            }
            this.rect = new Rectangle(bound.x + bound.width - 12, bound.y + bound.height / 2 - 6, treeIcon.getWidth() + 8, treeIcon.getHeight() + 8);
        } else if (object instanceof MemberCellItem) {
            MemberCellItem mci = (MemberCellItem)object;
            if (!mci.inColumns() || !this.config.showColumnHeaderInTableHeader) {
                Color oldColor = g.getColor();
                g.setColor(bgColor);
                g.fillRect(bound.x - 3, bound.y - 2 + 2, bound.width + 6, bound.height + 4 - 4);
                g.setColor(oldColor);
            }
            int hIndent = 6;
            int wIndent = 2;
            int depth = mci.getMember().getDepth();
            if (depth > 0 && (!mci.inColumns() || this.config.showNestMemberForColumn) && mci.inRows() && !this.config.showNestMemberForRow) {
                wIndent += depth * treeIcon.getWidth();
            }
            if (wIndent > 3) {
                wIndent -= 3;
            }
            if (hIndent > 2) {
                hIndent -= 2;
            }
            Rectangle clip2 = null;
            Integer type = i0;
            type = mci.isLeaf() ? i0 : (this.expandHelper.canCollapse(mci) ? i2 : i1);
            Color oldColor = g.getColor();
            g.setColor(Color.BLACK);
            if (mci.inColumns() && !mci.isVirtual()) {
                if (this.config.showTreeIconForColumnHeader) {
                    treeIcon.paint(type, g, bound.x, bound.y + (bound.height - treeIcon.getHeight()) / 2);
                }
                g.setColor(oldColor);
                this.rect = new Rectangle(bound.x - 2, bound.y + (bound.height - treeIcon.getHeight()) / 2, treeIcon.getWidth() + 2, treeIcon.getHeight() + 2);
                int ind = type == i0 ? 0 : treeIcon.getWidth() + 2;
                clip2 = new Rectangle(bound.x + wIndent + ind, bound.y, bound.width - ind - wIndent, bound.height);
            } else if (mci.inRows() && !mci.isVirtual()) {
                if (this.config.showTreeIconForRowHeader) {
                    treeIcon.paint(type, g, bound.x + wIndent, bound.y + (bound.height - treeIcon.getHeight()) / 2);
                }
                g.setColor(oldColor);
                this.rect = new Rectangle(bound.x + wIndent - 2, bound.y + (bound.height - treeIcon.getHeight()) / 2 - 2, treeIcon.getWidth() + 2, treeIcon.getHeight() + 2);
                clip2 = this.config.showNestMemberForRow && type == i0 ? new Rectangle(bound.x, bound.y + hIndent, bound.width, bound.height - hIndent) : (type == i0 ? new Rectangle(bound.x + wIndent, bound.y + hIndent, bound.width - wIndent, bound.height - hIndent) : new Rectangle(bound.x + wIndent + treeIcon.getWidth() + 2, bound.y, bound.width - (wIndent + treeIcon.getWidth() + 2), bound.height));
            } else {
                clip2 = new Rectangle(bound.x + wIndent, bound.y + hIndent, bound.width - wIndent, bound.height - hIndent);
            }
            if (object != null && object.toString() != null) {
                textRender.draw(g, (Shape)clip2, object.toString(), cellStyle);
            }
        } else if (object instanceof DimensionPropertyValueCellItem) {
            DimensionPropertyValueCellItem dpvci = (DimensionPropertyValueCellItem)object;
            if (!dpvci.inColumns() || !this.config.showColumnHeaderInTableHeader) {
                Color oldColor = g.getColor();
                g.setColor(bgColor);
                g.fillRect(bound.x - 3, bound.y - 2 + 2, bound.width + 6, bound.height + 4 - 4);
                g.setColor(oldColor);
            }
            textRender.draw(g, clip, object.toString(), cellStyle);
        } else if (object instanceof DimensionPropertyCellItem) {
            textRender.draw(g, clip, object.toString(), cellStyle);
        } else if (object instanceof DataCellItem) {
            DataCellItem dci = (DataCellItem)object;
            String status = dci.getStatus();
            String trend = dci.getTrend();
            Rectangle rect = clip.getBounds();
            if (status != null && trend != null) {
                Image image1 = icons.getStatus(status);
                Image image2 = icons.getTrend(trend);
                g.drawImage(image1, rect.x + rect.width - 26, rect.y + (rect.height - image1.getHeight(null)) / 2, null);
                g.drawImage(image2, rect.x + rect.width - 12, rect.y + (rect.height - image2.getHeight(null)) / 2, null);
                Rectangle clip2 = new Rectangle(rect.x, rect.y, rect.width - 28, rect.height);
                textRender.draw(g, (Shape)clip2, object.toString(), cellStyle);
            } else if (status != null) {
                Image image = icons.getStatus(status);
                g.drawImage(image, rect.x + rect.width - 12, rect.y + (rect.height - image.getHeight(null)) / 2, null);
                Rectangle clip2 = new Rectangle(rect.x, rect.y, rect.width - 15, rect.height);
                textRender.draw(g, (Shape)clip2, object.toString(), cellStyle);
            } else if (trend != null) {
                Image image = icons.getTrend(trend);
                g.drawImage(image, rect.x + rect.width - 12, rect.y + (rect.height - image.getHeight(null)) / 2, null);
                Rectangle clip2 = new Rectangle(rect.x, rect.y, rect.width - 15, rect.height);
                textRender.draw(g, (Shape)clip2, object.toString(), cellStyle);
            } else {
                textRender.draw(g, clip, object.toString(), cellStyle);
            }
        } else if (object != null) {
            textRender.draw(g, clip, object.toString(), cellStyle);
        }
    }

    public boolean inClickRect(CellItem ci, int x, int y) {
        if (!ci.isHiden() && this.rect != null) {
            return this.rect.contains(x, y);
        }
        return false;
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (Exception e) {
            return null;
        }
    }
}

