/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.analysis.cubemodel.designer;

import com.kingdee.bos.ctrl.analysis.AnalysisException;
import com.kingdee.bos.ctrl.analysis.cubemodel.CubeModelResource;
import com.kingdee.bos.ctrl.analysis.cubemodel.designer.CubeModelEditor;
import com.kingdee.bos.ctrl.analysis.cubemodel.designer.NodeData;
import com.kingdee.bos.ctrl.analysis.cubemodel.schema.CubeModel;
import com.kingdee.bos.ctrl.analysis.cubemodel.schema.CubeModelUtil;
import com.kingdee.bos.ctrl.analysis.cubemodel.schema.CubeModel_Column;
import com.kingdee.bos.ctrl.analysis.cubemodel.schema.CubeModel_Cube;
import com.kingdee.bos.ctrl.analysis.cubemodel.schema.CubeModel_Dimension;
import com.kingdee.bos.ctrl.analysis.cubemodel.schema.CubeModel_Fact;
import com.kingdee.bos.ctrl.analysis.cubemodel.schema.CubeModel_FactJoinRef;
import com.kingdee.bos.ctrl.analysis.cubemodel.schema.CubeModel_Hierarchy;
import com.kingdee.bos.ctrl.analysis.cubemodel.schema.CubeModel_Join;
import com.kingdee.bos.ctrl.analysis.cubemodel.schema.CubeModel_JoinRef;
import com.kingdee.bos.ctrl.analysis.cubemodel.schema.CubeModel_Level;
import com.kingdee.bos.ctrl.analysis.cubemodel.schema.CubeModel_Measure;
import com.kingdee.bos.ctrl.analysis.cubemodel.schema.CubeModel_Table;
import com.kingdee.bos.ctrl.analysis.cubemodel.schema.CubeModel_TableRef;
import com.kingdee.bos.ctrl.common.ui.WindowUtil;
import com.kingdee.bos.ctrl.common.util.ExceptionUtil;
import com.kingdee.bos.ctrl.swing.MessageDialog;
import com.kingdee.bos.ctrl.swing.tree.DefaultKingdeeTreeNode;
import com.kingdee.bos.olap.def.DefUtil;
import com.kingdee.bos.olap.def.SchemaDef;
import java.awt.Component;
import java.io.File;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Locale;
import javax.swing.tree.MutableTreeNode;

public class ActionHelper {
    private final CubeModelEditor editor;
    private DefaultKingdeeTreeNode oldSelectedCubeNode = null;

    ActionHelper(CubeModelEditor editor) {
        this.editor = editor;
    }

    boolean doDeleteCube(boolean silence) {
        DefaultKingdeeTreeNode currentNode = this.editor.getSelectedNode();
        if (currentNode == null) {
            return false;
        }
        if (silence || MessageDialog.show((Component)this.editor.getWindow(), (Object)CubeModelResource.getString(CubeModelResource.class, (String)"ConfirmDelete"), (String)CubeModelResource.getString(CubeModelResource.class, (String)"Information"), (int)0) == 0) {
            CubeModel_Cube cube = (CubeModel_Cube)((NodeData)currentNode.getUserObject()).model;
            this.editor.diagramHelper.removeCube(cube);
            this.editor.tree.removeNodeFromParent((MutableTreeNode)currentNode);
            this.editor.mapCubeToMapRefCount.remove(cube);
            this.editor.wizardHelper.deleteCube();
            return true;
        }
        return false;
    }

    boolean doDeleteDimension(boolean silence) {
        DefaultKingdeeTreeNode currentNode = this.editor.getSelectedNode();
        if (currentNode == null) {
            return false;
        }
        if (silence || MessageDialog.show((Component)this.editor.getWindow(), (Object)CubeModelResource.getString(CubeModelResource.class, (String)"ConfirmDelete"), (String)CubeModelResource.getString(CubeModelResource.class, (String)"Information"), (int)0) == 0) {
            String key;
            Integer count;
            int i;
            DefaultKingdeeTreeNode cubeNode = this.editor.getSelectedCubeNode();
            NodeData data = (NodeData)cubeNode.getUserObject();
            CubeModel_Cube cube = (CubeModel_Cube)data.model;
            HashMap mapRefCount = (HashMap)this.editor.mapCubeToMapRefCount.get(cube);
            CubeModel_Dimension dimension = (CubeModel_Dimension)((NodeData)currentNode.getUserObject()).model;
            if (dimension.getFactJoinRef() != null) {
                this.editor.diagramHelper.removeDimensionForCube(cube, dimension);
            }
            CubeModel_Dimension[] dims = cube.getDimensions();
            CubeModel_Dimension[] dims2 = new CubeModel_Dimension[dims.length - 1];
            int j = 0;
            for (int i2 = 0; i2 < dims.length; ++i2) {
                if (dims[i2] == dimension) continue;
                dims2[j++] = dims[i2];
            }
            cube.setDimensions(dims2);
            CubeModel_TableRef[] tableRefs = dimension.getTableRefs();
            ArrayList<CubeModel_Table> tableList = new ArrayList<CubeModel_Table>();
            for (i = 0; i < cube.getTables().length; ++i) {
                tableList.add(cube.getTables()[i]);
            }
            for (i = 0; i < tableRefs.length; ++i) {
                String key2 = this.editor.tableKey(tableRefs[i].getName());
                Integer count2 = (Integer)mapRefCount.get(key2);
                if (count2 > 1) {
                    mapRefCount.put(key2, new Integer(count2 - 1));
                    continue;
                }
                tableList.remove(this.editor.findTable(cube, tableRefs[i].getName()));
                mapRefCount.remove(key2);
            }
            cube.setTables(tableList.toArray(new CubeModel_Table[0]));
            ArrayList<CubeModel_Join> joinList = new ArrayList<CubeModel_Join>();
            for (int i3 = 0; i3 < cube.getJoins().length; ++i3) {
                joinList.add(cube.getJoins()[i3]);
            }
            CubeModel_JoinRef[] joinRefs = dimension.getJoinRefs();
            if (joinRefs != null) {
                for (int i4 = 0; i4 < joinRefs.length; ++i4) {
                    String key3 = this.editor.joinKey(joinRefs[i4].getName());
                    Integer count3 = (Integer)mapRefCount.get(key3);
                    if (count3 > 1) {
                        mapRefCount.put(key3, new Integer(count3 - 1));
                        continue;
                    }
                    joinList.remove(this.editor.findJoin(cube, joinRefs[i4].getName()));
                    mapRefCount.remove(key3);
                }
            }
            if (dimension.getFactJoinRef() != null) {
                String key4 = this.editor.joinKey(dimension.getFactJoinRef().getName());
                count = (Integer)mapRefCount.get(key4);
                if (count > 1) {
                    mapRefCount.put(key4, new Integer(count - 1));
                } else {
                    joinList.remove(this.editor.findJoin(cube, dimension.getFactJoinRef().getName()));
                    mapRefCount.remove(key4);
                }
            }
            cube.setJoins(joinList.toArray(new CubeModel_Join[0]));
            if (dimension.getFactJoinRef() != null && ((count = (Integer)mapRefCount.get(key = this.editor.joinKey(dimension.getFactJoinRef().getName()))) == null || count == 0)) {
                DefaultKingdeeTreeNode joinFolderNode = this.editor.getSelectedJoinFolderNode();
                Enumeration children = joinFolderNode.children();
                String joinId = dimension.getFactJoinRef().getName();
                while (children.hasMoreElements()) {
                    DefaultKingdeeTreeNode child = (DefaultKingdeeTreeNode)children.nextElement();
                    NodeData childData = (NodeData)child.getUserObject();
                    if (!childData.id.equals(joinId)) continue;
                    this.editor.tree.removeNodeFromParent((MutableTreeNode)child);
                    break;
                }
            }
            this.editor.tree.removeNodeFromParent((MutableTreeNode)currentNode);
            this.editor.wizardHelper.deleteDimension(dimension);
            return true;
        }
        return false;
    }

    public void setCubeModel(CubeModel cubeModel) throws AnalysisException {
        this.editor.clearAll();
        DefaultKingdeeTreeNode root = this.editor.getRootNode();
        CubeModel_Cube[] cubes = cubeModel.getCubes();
        if (cubes == null || cubes.length == 0) {
            return;
        }
        int count = cubes.length;
        for (int i = 0; i < count; ++i) {
            this.buildRefCountInfo(cubes[i]);
            this.editor.wizardHelper.addCubeNode(root, cubes[i]);
            this.editor.diagramHelper.addJoinPanelForCube(cubes[i]);
            CubeModel_Dimension[] dims = cubes[i].getDimensions();
            if (dims == null) continue;
            int count2 = dims.length;
            for (int j = 0; j < count2; ++j) {
                this.editor.wizardHelper.addDimensionNode(cubes[i], dims[j]);
                if (dims[j].getFactJoinRef() == null) continue;
                this.editor.diagramHelper.addDimensionTableForCube(cubes[i], dims[j]);
            }
        }
        this.editor.tree.setSelectionNode((DefaultKingdeeTreeNode)root.getChildAt(0));
    }

    public void buildRefCountInfo(CubeModel_Cube cube) {
        int i;
        HashMap<String, Integer> mapRefCount = new HashMap<String, Integer>();
        this.editor.mapCubeToMapRefCount.put(cube, mapRefCount);
        CubeModel_Table[] tables = cube.getTables();
        int[] tableCounts = new int[tables.length];
        HashMap<String, Integer> tname2index = new HashMap<String, Integer>(tables.length);
        for (int i2 = 0; i2 < tables.length; ++i2) {
            tname2index.put(tables[i2].getName(), new Integer(i2));
        }
        CubeModel_Join[] joins = cube.getJoins();
        int[] joinCounts = null;
        HashMap<String, Integer> jname2index = null;
        if (joins != null) {
            joinCounts = new int[joins.length];
            jname2index = new HashMap<String, Integer>(joins.length);
            for (int i3 = 0; i3 < joins.length; ++i3) {
                jname2index.put(joins[i3].getName(), new Integer(i3));
            }
        }
        CubeModel_Fact fact = cube.getFact();
        String tname = fact.getTableRef().getName();
        int n = (Integer)tname2index.get(tname);
        tableCounts[n] = tableCounts[n] + 1;
        CubeModel_Dimension[] dims = cube.getDimensions();
        if (dims != null) {
            for (i = 0; i < dims.length; ++i) {
                CubeModel_FactJoinRef fref;
                CubeModel_TableRef[] refs = dims[i].getTableRefs();
                for (int j = 0; j < refs.length; ++j) {
                    int n2 = (Integer)tname2index.get(refs[j].getName());
                    tableCounts[n2] = tableCounts[n2] + 1;
                }
                if (joins == null || (fref = dims[i].getFactJoinRef()) == null || null == jname2index || null == joinCounts) continue;
                int n3 = (Integer)jname2index.get(fref.getName());
                joinCounts[n3] = joinCounts[n3] + 1;
            }
        }
        for (i = 0; i < tables.length; ++i) {
            mapRefCount.put(this.editor.tableKey(tables[i].getName()), new Integer(tableCounts[i]));
        }
        if (joins != null) {
            for (i = 0; i < joins.length; ++i) {
                mapRefCount.put(this.editor.joinKey(joins[i].getName()), new Integer(joinCounts[i]));
            }
        }
    }

    boolean doOpenModel() {
        try {
            CubeModel cubeModel = this.editor.getStorage().open();
            if (cubeModel == null) {
                return false;
            }
            this.setCubeModel(cubeModel);
            return true;
        }
        catch (AnalysisException e) {
            WindowUtil.alert((Component)this.editor.getWindow(), (String)e.getMessage());
            return false;
        }
    }

    boolean exportAsOLAPConfig() {
        String file;
        CubeModel model = this.parseCubeModel();
        if (model != null && (file = this.chooseSaveConfigFile()) != null) {
            try {
                DefUtil.saveToFile((SchemaDef)CubeModelUtil.convertCube(model.getCubes()[0], false), (String)file);
                return true;
            }
            catch (Exception e) {
                WindowUtil.alert((Component)this.editor.getWindow(), (String)e.getMessage());
            }
        }
        return false;
    }

    private String chooseSaveConfigFile() {
        File file = WindowUtil.chooseSaveFile((Component)((Object)this.editor), null, (String[])new String[]{".xml\tOLAP config file(*.xml)"});
        if (file == null) {
            return null;
        }
        String fileName = file.getAbsolutePath();
        if (!fileName.toLowerCase(Locale.ENGLISH).endsWith(".xml")) {
            fileName = fileName + ".xml";
        }
        return fileName;
    }

    boolean doSaveModel() {
        try {
            CubeModel model = this.parseCubeModel();
            if (model != null) {
                return this.editor.getStorage().save(model);
            }
        }
        catch (AnalysisException e) {
            WindowUtil.alert((Component)this.editor.getWindow(), (String)ExceptionUtil.findMessage((Throwable)e));
        }
        return false;
    }

    public CubeModel parseCubeModel() {
        CubeModel cubemodel = new CubeModel();
        DefaultKingdeeTreeNode rootNode = this.editor.getRootNode();
        int cubeCount = rootNode.getChildCount();
        if (cubeCount == 0) {
            WindowUtil.alert((Component)this.editor.getWindow(), (String)CubeModelResource.getString(CubeModelResource.class, (String)"CubeModelNotNull"));
            return null;
        }
        CubeModel_Cube[] cubes = new CubeModel_Cube[cubeCount];
        for (int i = 0; i < cubeCount; ++i) {
            DefaultKingdeeTreeNode node = (DefaultKingdeeTreeNode)rootNode.getChildAt(i);
            NodeData nodedata = (NodeData)node.getUserObject();
            cubes[i] = (CubeModel_Cube)nodedata.model;
        }
        cubemodel.setCubes(cubes);
        return cubemodel;
    }

    void doSelect(DefaultKingdeeTreeNode node) {
        DefaultKingdeeTreeNode cubeNode = this.editor.getSelectedCubeNode();
        if (cubeNode == null) {
            this.editor.diagramHelper.showEmpty();
            this.oldSelectedCubeNode = cubeNode;
        } else {
            CubeModel_Cube cube = (CubeModel_Cube)((NodeData)cubeNode.getUserObject()).model;
            if (!cubeNode.equals(this.oldSelectedCubeNode)) {
                this.oldSelectedCubeNode = cubeNode;
                this.editor.diagramHelper.showJoinPanelForCube(cube);
            }
            NodeData nd = (NodeData)node.getUserObject();
            if (nd.type == 70) {
                this.editor.diagramHelper.setSelectDimension(cube, (CubeModel_Dimension)nd.model);
            } else if (nd.type == 20) {
                this.editor.diagramHelper.setSelectTable(cube, null);
            } else if (nd.type == 35) {
                DefaultKingdeeTreeNode grandparent = (DefaultKingdeeTreeNode)node.getParent().getParent();
                NodeData gnd = (NodeData)grandparent.getUserObject();
                if (gnd.type == 20) {
                    this.editor.diagramHelper.setSelectTable(cube, null);
                } else {
                    CubeModel_Dimension dimension = (CubeModel_Dimension)gnd.model;
                    this.editor.diagramHelper.setSelectTable(cube, dimension);
                }
            } else if (nd.type == 110) {
                CubeModel_Join join = (CubeModel_Join)nd.model;
                CubeModel_Dimension[] dims = this.editor.findDimensionUsingJoin(cube, join.getName());
                if (dims.length > 0) {
                    this.editor.diagramHelper.setSelectLine(cube, dims[0]);
                }
            } else if (nd.type == 90) {
                DefaultKingdeeTreeNode grandparent = (DefaultKingdeeTreeNode)node.getParent().getParent();
                NodeData gnd = (NodeData)grandparent.getUserObject();
                CubeModel_Dimension dimension = (CubeModel_Dimension)gnd.model;
                CubeModel_Hierarchy hie = dimension.getHierarchys()[0];
                String fieldid = null;
                if (dimension.isParentChild()) {
                    CubeModel_Column column = hie.getMemberKey().getExp().getColumns()[0];
                    fieldid = column.getName();
                } else if (dimension.isTime()) {
                    CubeModel_Column column = dimension.getTimeColumn();
                    fieldid = column.getName();
                } else {
                    CubeModel_Level level = (CubeModel_Level)nd.model;
                    fieldid = level.getMemberKey().getExp().getColumns()[0].getName();
                }
                this.editor.diagramHelper.setSelectField(cube, dimension, fieldid);
            } else if (nd.type == 50) {
                CubeModel_Measure measure = (CubeModel_Measure)nd.model;
                String fieldid = measure.getExp().getColumns()[0].getName();
                this.editor.diagramHelper.setSelectField(cube, null, fieldid);
            } else {
                this.editor.diagramHelper.setSelectNull(cube);
            }
        }
    }
}

