/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.analysis.olap.base;

import com.kingdee.bos.ctrl.analysis.modelcore.ExtensionSupport;
import com.kingdee.bos.ctrl.analysis.modelcore.ModelSupport;
import com.kingdee.bos.ctrl.analysis.olap.Filter;
import com.kingdee.bos.ctrl.analysis.olap.OlapModel;
import com.kingdee.bos.ctrl.analysis.olap.querymanage.QueryAxisChangeListener;
import com.kingdee.bos.ctrl.analysis.olap.querymanage.QueryAxisManager;
import com.kingdee.bos.ctrl.common.util.CommonLogger;
import org.apache.log4j.Logger;

public abstract class FilterBase
extends ExtensionSupport
implements Filter,
QueryAxisChangeListener {
    protected boolean filtering = false;
    protected String condition = null;
    protected QueryAxisManager qamToFilter = null;
    static Logger logger = CommonLogger.getLogger(FilterBase.class);

    public FilterBase() {
        super.setId("filter");
    }

    @Override
    public void queryAxisChanged(QueryAxisManager qam, Object source, boolean changedByNavi) {
        if (qam != this.qamToFilter) {
            return;
        }
        if (!changedByNavi) {
            return;
        }
        if (!this.filtering) {
            return;
        }
        this.filtering = false;
        ModelSupport model = (ModelSupport)this.getModel();
        model.fireModelChanged();
    }

    public boolean isFiltering() {
        return this.filtering;
    }

    public void setFiltering(boolean filtering) {
        if (filtering == this.filtering) {
            return;
        }
        this.filtering = filtering;
        ((ModelSupport)this.getModel()).fireModelChanged();
    }

    public void reset() {
        this.filtering = false;
        this.condition = null;
        OlapModel model = (OlapModel)this.getModel();
        QueryAxisManager[] qams = model.getQueryManager().getQueryAxisManageres();
        for (int i = 0; i < qams.length; ++i) {
            qams[i].addChangeListener(this);
        }
    }

    public abstract void addFilterToQuery();

    @Override
    public void setAxisToFilter(int ordinal) {
        OlapModel model = (OlapModel)this.getModel();
        this.qamToFilter = model.getQueryManager().getQueryAxisManageres()[ordinal];
    }

    public boolean isFilterOnQuery() {
        return this.filtering && this.condition != null;
    }

    public String getCondition() {
        return this.condition;
    }

    @Override
    public void setCondition(String condition) {
        this.condition = condition;
    }
}

