/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.analysis.olapadapter.kingdeeolap;

import com.kingdee.bos.ctrl.analysis.modelcore.ExtensionSupport;
import com.kingdee.bos.ctrl.analysis.olap.Axis;
import com.kingdee.bos.ctrl.analysis.olap.Hierarchy;
import com.kingdee.bos.ctrl.analysis.olap.Member;
import com.kingdee.bos.ctrl.analysis.olap.MemberTree;
import com.kingdee.bos.ctrl.analysis.olap.OlapException;
import com.kingdee.bos.ctrl.analysis.olap.Position;
import com.kingdee.bos.ctrl.analysis.olap.querymanage.QueryAxisManager;
import com.kingdee.bos.ctrl.analysis.olapadapter.kingdeeolap.KDOLAP_Hierarchy;
import com.kingdee.bos.ctrl.analysis.olapadapter.kingdeeolap.KDOLAP_Member;
import com.kingdee.bos.ctrl.analysis.olapadapter.kingdeeolap.KDOLAP_Model;
import com.kingdee.bos.ctrl.analysis.olapadapter.kingdeeolap.KDOLAP_QueryManager;
import com.kingdee.bos.ctrl.analysis.olapadapter.kingdeeolap.KDOLAP_Result;
import com.kingdee.bos.ctrl.common.util.CommonLogger;
import com.kingdee.bos.olap.OLAPException;
import com.kingdee.bos.olap.collection.IMemberList;
import com.kingdee.bos.olap.mdx.Formula;
import com.kingdee.bos.olap.mdx.MdxQuery;
import com.kingdee.bos.olap.mdx.SchemaReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import org.apache.log4j.Logger;

public class KDOLAP_MemberTree
extends ExtensionSupport
implements MemberTree {
    static Logger logger = CommonLogger.getLogger(KDOLAP_MemberTree.class);

    public KDOLAP_MemberTree() {
        super.setId("memberTree");
    }

    @Override
    public Member[] getRootMembers(Hierarchy hier) {
        return this.internalGetRootMembers(hier);
    }

    private Member[] internalGetRootMembers(Hierarchy hier) {
        IMemberList kdMembers;
        KDOLAP_Model model = (KDOLAP_Model)this.getModel();
        com.kingdee.bos.olap.Hierarchy kdHier = ((KDOLAP_Hierarchy)hier).getKDHierarchy();
        MdxQuery q = ((KDOLAP_QueryManager)model.getQueryManager()).getKDQuery();
        SchemaReader scr = q.getSchemaReader();
        try {
            kdMembers = scr.getHierarchyRootMembers(kdHier);
        }
        catch (OLAPException e) {
            e.printStackTrace();
            return null;
        }
        ArrayList<KDOLAP_Member> aMem = new ArrayList<KDOLAP_Member>();
        for (com.kingdee.bos.olap.Member kdMember : kdMembers) {
            aMem.add(model.addMember(kdMember));
        }
        Formula[] formulas = q.getFormulas();
        for (int i = 0; i < formulas.length; ++i) {
            KDOLAP_Member m;
            Formula f = formulas[i];
            com.kingdee.bos.olap.Member kdMem = f.getMember();
            if (kdMem == null || !kdMem.getHierarchy().equals(kdHier) || aMem.contains(m = model.addMember(kdMem))) continue;
            aMem.add(m);
        }
        Member[] members = aMem.toArray(new Member[0]);
        KDOLAP_Result res = model.currentResult();
        if (res == null) {
            return members;
        }
        KDOLAP_QueryManager adapter = (KDOLAP_QueryManager)model.getQueryManager();
        QueryAxisManager qam = adapter.findQueryAxisManager(hier.getDimension());
        if (qam == null) {
            return members;
        }
        int iDim = qam.dimIdx(hier.getDimension());
        int iAx = qam.getOrdinal();
        if (adapter.isSwapAxes()) {
            iAx = (iAx + 1) % 2;
        }
        Axis axis = res.getOriginAxes()[iAx];
        List positions = axis.getPositions();
        final ArrayList<KDOLAP_Member> visibleRootMembers = new ArrayList<KDOLAP_Member>();
        for (Position pos : positions) {
            Member[] posMembers = pos.getMembers();
            KDOLAP_Member mem = (KDOLAP_Member)posMembers[iDim];
            if (mem.getKDMember().getParentMember() != null || visibleRootMembers.contains(mem)) continue;
            visibleRootMembers.add(mem);
        }
        Arrays.sort(members, new Comparator(){

            public int compare(Object arg0, Object arg1) {
                Member m1 = (Member)arg0;
                Member m2 = (Member)arg1;
                int index1 = visibleRootMembers.indexOf(m1);
                int index2 = visibleRootMembers.indexOf(m2);
                if (index2 == -1) {
                    return -1;
                }
                if (index1 == -1) {
                    return 1;
                }
                return index1 - index2;
            }
        });
        return members;
    }

    @Override
    public boolean hasChildren(Member member) {
        com.kingdee.bos.olap.Member kdMember = ((KDOLAP_Member)member).getKDMember();
        if (kdMember.isCalculated()) {
            return false;
        }
        KDOLAP_Model model = (KDOLAP_Model)this.getModel();
        SchemaReader scr = model.getConnection().getSchemaReader();
        return scr.isDrillable(kdMember);
    }

    @Override
    public Member[] getChildren(Member member) {
        return this.internalGetChildren(member);
    }

    private Member[] internalGetChildren(Member member) {
        IMemberList kdChildren;
        com.kingdee.bos.olap.Member kdMember = ((KDOLAP_Member)member).getKDMember();
        KDOLAP_Model model = (KDOLAP_Model)this.getModel();
        SchemaReader scr = model.getConnection().getSchemaReader();
        try {
            kdChildren = scr.getMemberChildren(kdMember);
        }
        catch (OLAPException e) {
            return null;
        }
        if (kdChildren == null) {
            return null;
        }
        Member[] children = new Member[kdChildren.size()];
        int i = 0;
        Iterator iter = kdChildren.iterator();
        while (iter.hasNext()) {
            children[i++] = model.addMember((com.kingdee.bos.olap.Member)iter.next());
        }
        return children;
    }

    @Override
    public Member getParent(Member member) {
        try {
            return member.getParent();
        }
        catch (OlapException e) {
            e.printStackTrace();
            return null;
        }
    }

    @Override
    public Member[] getDescendant(Member member) throws MemberTree.TooManyMembersException {
        ArrayList list = new ArrayList();
        this.innerGetDescendant(member, list);
        return list.toArray(new Member[0]);
    }

    private void innerGetDescendant(Member member, List list) throws MemberTree.TooManyMembersException {
        Member[] children = this.getChildren(member);
        if (children == null) {
            return;
        }
        for (int i = 0; i < children.length; ++i) {
            list.add(children[i]);
            this.innerGetDescendant(children[i], list);
        }
    }

    @Override
    public Member[] getDescendant(Hierarchy hier) throws MemberTree.TooManyMembersException {
        ArrayList<Member> list = new ArrayList<Member>();
        Member[] rootMembers = this.getRootMembers(hier);
        for (int i = 0; i < rootMembers.length; ++i) {
            list.add(rootMembers[i]);
            this.innerGetDescendant(rootMembers[i], list);
        }
        return list.toArray(new Member[0]);
    }
}

