/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.analysis.web.easkpi;

import com.kingdee.bos.ctrl.analysis.web.easkpi.BSCInfo;
import com.kingdee.bos.ctrl.analysis.web.easkpi.CSFInfo;
import com.kingdee.bos.ctrl.analysis.web.easkpi.EASKPI;
import com.kingdee.bos.ctrl.analysis.web.easkpi.KPIException;
import com.kingdee.bos.ctrl.analysis.web.easkpi.KPIInfo;
import com.kingdee.bos.ctrl.analysis.web.easkpi.KPIRange;
import com.kingdee.bos.ctrl.analysis.web.repository.Repository;
import com.kingdee.bos.ctrl.analysis.web.repository.RepositoryException;
import com.kingdee.bos.ctrl.analysis.web.solution.BISystem;
import com.kingdee.bos.ctrl.analysis.web.solution.exception.BIReportException;
import com.kingdee.bos.ctrl.analysis.web.solution.tree.KPITreeNode;
import com.kingdee.bos.ctrl.analysis.web.solution.util.MathUtil;
import com.kingdee.eas.util.ResourceBase;
import java.math.BigDecimal;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.StringTokenizer;
import javax.servlet.http.HttpServletRequest;

public class KPIUtil {
    private static String sql_query_kpi_value = "select KPIValue.FBizdate as bizDate,KPI.fname_l2 as KPIName, KPIValue.FDisplayName_l2 as KPIValueTime, KPI.FDisplayPrecision as displayPrecision,KPIValue.FKpivalue as KPIValue,EdgeType.FNumber as edgeType, EdgeParam.FNumber as edgeParam, WarmType.FNumber as warmType,WarmValue.fcurrentvalue as KPIWarmValue,WarmType.fcolor as warmColor,  KPI.FIsPercent as isPercent, KPI.FNumberUnit_l2 as KPIUnit, KPI.Ftimetype as timeType  from t_mp_kpiwarnParam WarmValue, t_mp_warngroup WarmType , t_mp_edgeParam EdgeParam , t_mp_kpivalue KPIValue, t_mp_kpi KPI , t_mp_edgegroup EdgeType  where WarmValue.FWarnGroupID = WarmType.FID and EdgeParam.FID = WarmValue.FEdgeParamID and KPIValue.FID = WarmValue.Fkpivalue and KPI.FID = KPIValue.fkpiid and KPI.fcurrentwarnstatus = EdgeType.FID and KPIValue.FBizdate = ? and KPIValue.fLastComputeTime = ? and KPI.FID = ?";
    private static String sql_query_colorSetting = "select FNumber,FColor from t_mp_warngroup";
    private static String sql_query_kpi_byou = "select * from t_mp_kpi where fid = ? and  FPartFI = ? ";
    private static String sql_query_kpi_byou2 = "select fid from t_mp_kpi where fnumber in (select fnumber from t_mp_kpi where fid = ? ) and FPartFI = ? ";
    private static String sql_query_kpi_etl_date = "select max(fLastComputeTime) as calTime,fBizDate from t_mp_kpivalue where fkpiid = ? group by fBizDate order by FBizDate DESC";
    private static String sql_can_use_easkpi = "select * from KSQL_USERCOLUMNS where KSQL_COL_NAME = 'FPartFI' and KSQL_COL_TABNAME = 't_mp_kpi'";
    private static String sql_query_kpi = "select  BSC.fname_l2 as BSCName, BSC.FNumber as BSCNumber, CSF.fname_l2 as CSFName, CSF.FNumber as CSFNumber, KPI.FNumber as KPINumber,KPI.FName_l2 as KPIName, KPI.fid as KPIId from t_mp_bsc BSC,t_mp_csf CSF,t_mp_kpi KPI, t_org_company Orgunit where Orgunit.FID = KPI.FPartFI and KPI.FCSFID = CSF.FID and CSF.FBSCID = BSC.FID  and KPI.fiswarnable = 1 and Orgunit.FID = ? ";
    private static String sql_query_kpi_design = "select  BSC.fname_l2 as BSCName, BSC.FNumber as BSCNumber, CSF.fname_l2 as CSFName, CSF.FNumber as CSFNumber, KPI.FNumber as KPINumber,KPI.FName_l2 as KPIName, KPI.fid as KPIId from t_mp_bsc BSC,t_mp_csf CSF,t_mp_kpi KPI where KPI.FCSFID = CSF.FID and CSF.FBSCID = BSC.FID  and KPI.fiswarnable = 1 ";

    public static KPIRange calcKPIRange(int type, double[] dblValue, double actualValue, int displayPrecision) throws BIReportException {
        KPIRange kpiRange = new KPIRange();
        if (type == EASKPI.EDGE_TYPE_UP) {
            double high = dblValue[1] + (dblValue[1] - dblValue[0]);
            double low = dblValue[0] - (dblValue[1] - dblValue[0]);
            if (actualValue > high) {
                high = actualValue;
            } else if (actualValue < low) {
                low = actualValue;
            }
            kpiRange.min = low;
            kpiRange.alert = dblValue[0];
            kpiRange.danger = dblValue[1];
            kpiRange.max = high;
            kpiRange.color1 = 1;
            kpiRange.color2 = 2;
            kpiRange.color3 = 0;
        } else if (type == EASKPI.EDGE_TYPE_DOWN) {
            double high = dblValue[1] + (dblValue[1] - dblValue[0]);
            double low = dblValue[0] - (dblValue[1] - dblValue[0]);
            if (actualValue < low) {
                low = actualValue;
            } else if (actualValue > high) {
                high = actualValue;
            }
            kpiRange.min = low;
            kpiRange.alert = dblValue[1];
            kpiRange.danger = dblValue[0];
            kpiRange.max = high;
            kpiRange.color1 = 0;
            kpiRange.color2 = 2;
            kpiRange.color3 = 1;
        } else if (type == EASKPI.EDGE_TYPE_DOUBLE) {
            double middle = (dblValue[1] + dblValue[2]) / 2.0;
            double lack = middle - dblValue[1];
            if (actualValue < middle) {
                double minimum = dblValue[0] - lack;
                if (minimum > actualValue) {
                    minimum = actualValue;
                }
                kpiRange.min = minimum;
                kpiRange.alert = dblValue[1];
                kpiRange.danger = dblValue[0];
                kpiRange.max = middle;
                kpiRange.color1 = 0;
                kpiRange.color2 = 2;
                kpiRange.color3 = 1;
            } else {
                double maxmum = dblValue[3] + lack;
                if (actualValue > maxmum) {
                    maxmum = actualValue;
                }
                kpiRange.min = middle;
                kpiRange.alert = dblValue[2];
                kpiRange.danger = dblValue[3];
                kpiRange.max = maxmum;
                kpiRange.color1 = 1;
                kpiRange.color2 = 2;
                kpiRange.color3 = 0;
            }
        }
        kpiRange.min = MathUtil.round(kpiRange.min, displayPrecision);
        kpiRange.alert = MathUtil.round(kpiRange.alert, displayPrecision);
        kpiRange.danger = MathUtil.round(kpiRange.danger, displayPrecision);
        kpiRange.max = MathUtil.round(kpiRange.max, displayPrecision);
        return kpiRange;
    }

    public static String getKPIUnitPrefix(HttpServletRequest request) throws BIReportException {
        String unitPrefix = "\u5355\u4f4d:";
        if (BISystem.isEAS()) {
            Locale local = BISystem.getContext(request).getLocale();
            unitPrefix = ResourceBase.getString((String)"com.kingdee.eas.portal.portalPublic", (String)"unit", (Locale)local);
        }
        return unitPrefix;
    }

    public static String[] getColorSetting(Repository rep) throws BIReportException {
        String[] colorSetting = new String[]{"", "", ""};
        List lstColor = rep.executeQuery(sql_query_colorSetting);
        if (lstColor.size() != 3) {
            throw new BIReportException("\u4e0d\u6b63\u786e\u7684\u9884\u8b66\u989c\u8272\u8bbe\u7f6e!");
        }
        for (int i = 0; i < 3; ++i) {
            String number = ((Map)lstColor.get(i)).get("FNumber".toLowerCase()).toString();
            String color = KPIUtil.transColorDataToHex(((Map)lstColor.get(i)).get("FColor".toLowerCase()).toString());
            if ("001".equals(number)) {
                colorSetting[0] = color;
                continue;
            }
            if ("002".equals(number)) {
                colorSetting[1] = color;
                continue;
            }
            if (!"003".equals(number)) continue;
            colorSetting[2] = color;
        }
        return colorSetting;
    }

    public static String handleOrgUnit(Repository rep, String ou, String cu, String kpi) throws KPIException, BIReportException {
        if (ou == null && cu == null) {
            throw new KPIException("\u65e0\u6cd5\u627e\u5230\u5f53\u524d\u7ec4\u7ec7!");
        }
        Object[] params = new Object[]{kpi, null};
        params[1] = ou == null ? cu : ou;
        List lstRet = rep.execQueryStmt(sql_query_kpi_byou2, params);
        if (lstRet.size() == 0) {
            throw new KPIException("\u6307\u5b9aKPI\u5728\u5f53\u524d\u7ec4\u7ec7\u65e0\u5b9a\u4e49!");
        }
        if (lstRet.size() == 1) {
            Map map = (Map)lstRet.get(0);
            return (String)map.get("fid");
        }
        throw new KPIException("\u7cfb\u7edf\u51fa\u73b0\u95ee\u9898\uff0c\u540c\u4e00\u7ec4\u7ec7\uff0c\u540c\u4e00KPI\u51fa\u73b0\u591a\u79cd\u8bb0\u5f55!");
    }

    public static List getKPIETLData(Repository rep, String kpi_id) throws BIReportException, KPIException {
        List lstBizData = rep.execQueryStmt(sql_query_kpi_etl_date, new Object[]{kpi_id});
        if (lstBizData.size() == 0) {
            throw new KPIException("\u6ca1\u6709\u53ef\u663e\u793a\u7684KPI\u6570\u636e!");
        }
        return lstBizData;
    }

    private static String transColorDataToHex(String c) {
        StringBuffer buf = new StringBuffer();
        buf.append("0x");
        StringTokenizer tk = new StringTokenizer(c, ",");
        while (tk.hasMoreTokens()) {
            int lastIndex;
            String temp = tk.nextToken().trim();
            String colorV = temp.substring((lastIndex = temp.lastIndexOf(32)) + 1);
            String htemp = Integer.toHexString(Integer.parseInt(colorV)).trim();
            if (htemp.length() == 1) {
                buf.append("0");
            }
            buf.append(htemp);
        }
        return buf.toString().trim().toUpperCase();
    }

    public static List getKPIData(Repository rep, Timestamp bizDate, Timestamp calTime, String kpiid) throws RepositoryException {
        Object[] params = new Object[]{bizDate, calTime, kpiid};
        return rep.execQueryStmt(sql_query_kpi_value, params);
    }

    public static KPIRange getKPIItemData(String strEdgeType, List lstKPIValue, int displayPrecision, List lstNumMax2, List lstNumMin2, BigDecimal kpiValue) throws BIReportException {
        KPIRange range = null;
        int type = -1;
        if ("EG003".equals(strEdgeType)) {
            type = EASKPI.EDGE_TYPE_DOUBLE;
            if (lstKPIValue.size() != 4) {
                throw new BIReportException("\u53cc\u8fb9\u4e0a\u4e0b\u9650\u7684\u6570\u636e\u6761\u76ee\u4e0d\u6b63\u786e\uff01");
            }
            double[] dblValue = new double[]{-1.0, -1.0, -1.0, -1.0};
            for (int i = 0; i < 4; ++i) {
                Map mapRow = (Map)lstKPIValue.get(i);
                String paramType = mapRow.get("edgeParam".toLowerCase()).toString();
                String warmType = mapRow.get("warmType".toLowerCase()).toString();
                BigDecimal KPIWarmValue = (BigDecimal)mapRow.get("KPIWarmValue".toLowerCase());
                if ("002".equals(paramType)) {
                    if ("001".equals(warmType)) {
                        dblValue[3] = KPIWarmValue.doubleValue();
                        continue;
                    }
                    if ("003".equals(warmType)) {
                        dblValue[2] = KPIWarmValue.doubleValue();
                        continue;
                    }
                    throw new BIReportException("\u672a\u77e5\u7684\u9884\u8b66\u7c7b\u578b" + paramType);
                }
                if ("003".equals(paramType)) {
                    if ("001".equals(warmType)) {
                        dblValue[0] = KPIWarmValue.doubleValue();
                        continue;
                    }
                    if ("003".equals(warmType)) {
                        dblValue[1] = KPIWarmValue.doubleValue();
                        continue;
                    }
                    throw new BIReportException("\u672a\u77e5\u7684\u9884\u8b66\u7c7b\u578b" + paramType);
                }
                throw new BIReportException("\u672a\u77e5\u7684\u8fb9\u754c\u53c2\u6570" + paramType);
            }
            range = KPIUtil.calcKPIRange(type, dblValue, kpiValue.doubleValue(), displayPrecision);
            if (kpiValue.doubleValue() < (dblValue[1] + dblValue[2]) / 2.0) {
                lstNumMax2.add(new Double(range.alert));
                lstNumMin2.add(new Double(range.danger));
            } else {
                lstNumMax2.add(new Double(range.danger));
                lstNumMin2.add(new Double(range.alert));
            }
        } else if ("EG001".equals(strEdgeType)) {
            type = EASKPI.EDGE_TYPE_UP;
            if (lstKPIValue.size() != 2) {
                throw new BIReportException("\u5355\u8fb9\u4e0a\u9650\u7684\u6570\u636e\u6761\u76ee\u4e0d\u6b63\u786e\uff01");
            }
            double[] dblValue = new double[]{-1.0, -1.0};
            for (int i = 0; i < 2; ++i) {
                Map mapRow = (Map)lstKPIValue.get(i);
                String paramType = mapRow.get("edgeParam".toLowerCase()).toString();
                String warmType = mapRow.get("warmType".toLowerCase()).toString();
                BigDecimal KPIWarmValue = (BigDecimal)mapRow.get("KPIWarmValue".toLowerCase());
                if ("002".equals(paramType)) {
                    if ("001".equals(warmType)) {
                        dblValue[1] = KPIWarmValue.doubleValue();
                        continue;
                    }
                    if ("003".equals(warmType)) {
                        dblValue[0] = KPIWarmValue.doubleValue();
                        continue;
                    }
                    throw new BIReportException("\u672a\u77e5\u7684\u9884\u8b66\u7c7b\u578b" + paramType);
                }
                throw new BIReportException("\u4e0d\u6b63\u786e\u7684\u8fb9\u754c\u53c2\u6570" + paramType);
            }
            range = KPIUtil.calcKPIRange(type, dblValue, kpiValue.doubleValue(), displayPrecision);
            lstNumMax2.add(new Double(range.danger));
            lstNumMin2.add(new Double(range.alert));
        } else if ("EG002".equals(strEdgeType)) {
            type = EASKPI.EDGE_TYPE_DOWN;
            if (lstKPIValue.size() != 2) {
                throw new BIReportException("\u5355\u8fb9\u4e0b\u9650\u7684\u6570\u636e\u6761\u76ee\u4e0d\u6b63\u786e\uff01");
            }
            double[] dblValue = new double[]{-1.0, -1.0};
            for (int i = 0; i < 2; ++i) {
                Map mapRow = (Map)lstKPIValue.get(i);
                String paramType = mapRow.get("edgeParam".toLowerCase()).toString();
                String warmType = mapRow.get("warmType".toLowerCase()).toString();
                BigDecimal KPIWarmValue = (BigDecimal)mapRow.get("KPIWarmValue".toLowerCase());
                if ("003".equals(paramType)) {
                    if ("001".equals(warmType)) {
                        dblValue[0] = KPIWarmValue.doubleValue();
                        continue;
                    }
                    if ("003".equals(warmType)) {
                        dblValue[1] = KPIWarmValue.doubleValue();
                        continue;
                    }
                    throw new BIReportException("\u672a\u77e5\u7684\u9884\u8b66\u7c7b\u578b" + paramType);
                }
                throw new BIReportException("\u4e0d\u6b63\u786e\u7684\u8fb9\u754c\u53c2\u6570" + paramType);
            }
            range = KPIUtil.calcKPIRange(type, dblValue, kpiValue.doubleValue(), displayPrecision);
            lstNumMax2.add(new Double(range.alert));
            lstNumMin2.add(new Double(range.danger));
        } else {
            throw new BIReportException("\u672a\u77e5\u7684\u8fb9\u754c\u7c7b\u578b" + strEdgeType);
        }
        return range;
    }

    public static void judgeCanUseKPI(Repository rep) throws RepositoryException {
        if (!BISystem.isEAS()) {
            return;
        }
        List lstRet = rep.executeQuery(sql_can_use_easkpi);
        if (lstRet.size() == 0) {
            throw new RepositoryException("\u65e0\u6cd5\u4f7f\u7528EAS KPI!(\u5f53\u524d\u4e0d\u662f\u6b63\u5e38\u7684EAS\u73af\u5883)");
        }
    }

    public static List calculateAllKPI(Repository rep, String ou, String cu) throws RepositoryException {
        String sql = "";
        Object[] params = null;
        if (ou != null) {
            sql = "select  BSC.fname_l2 as BSCName, BSC.FNumber as BSCNumber, CSF.fname_l2 as CSFName, CSF.FNumber as CSFNumber, KPI.FNumber as KPINumber,KPI.FName_l2 as KPIName, KPI.fid as KPIId from t_mp_bsc BSC,t_mp_csf CSF,t_mp_kpi KPI, t_org_company Orgunit where Orgunit.FID = KPI.FPartFI and KPI.FCSFID = CSF.FID and CSF.FBSCID = BSC.FID  and KPI.fiswarnable = 1 and Orgunit.FID='" + ou + "'";
            sql = sql_query_kpi;
            params = new Object[]{ou};
        } else if (cu != null) {
            sql = "select  BSC.fname_l2 as BSCName, BSC.FNumber as BSCNumber, CSF.fname_l2 as CSFName, CSF.FNumber as CSFNumber, KPI.FNumber as KPINumber,KPI.FName_l2 as KPIName, KPI.fid as KPIId from t_mp_bsc BSC,t_mp_csf CSF,t_mp_kpi KPI, t_org_company Orgunit where Orgunit.FID = KPI.FPartFI and KPI.FCSFID = CSF.FID and CSF.FBSCID = BSC.FID  and KPI.fiswarnable = 1 and Orgunit.FID='" + cu + "'";
            sql = sql_query_kpi;
            params = new Object[]{cu};
        } else {
            sql = sql_query_kpi_design;
        }
        return rep.execQueryStmt(sql, params);
    }

    public static void createKPITree(KPITreeNode parent, List lstBSCData) {
        List lstBSC = KPIUtil.getAllBSC(lstBSCData);
        if (lstBSC.size() > 0) {
            ArrayList<KPITreeNode> childrenBSC = new ArrayList<KPITreeNode>();
            for (BSCInfo bsc : lstBSC) {
                KPITreeNode bscNode = new KPITreeNode(parent);
                childrenBSC.add(bscNode);
                bscNode.setCaption(bsc.getCaption());
                List lstCSF = KPIUtil.getAllCSF(bsc.getNumber(), lstBSCData);
                if (lstCSF.size() <= 0) continue;
                ArrayList<KPITreeNode> childrenCSF = new ArrayList<KPITreeNode>();
                for (CSFInfo csf : lstCSF) {
                    KPITreeNode csfNode = new KPITreeNode(bscNode);
                    childrenCSF.add(csfNode);
                    csfNode.setCaption(csf.getCaption());
                    List lstKPI = KPIUtil.getAllKPI(bsc.getNumber(), csf.getNumber(), lstBSCData);
                    if (lstKPI.size() > 0) {
                        ArrayList<KPITreeNode> childrenKPI = new ArrayList<KPITreeNode>();
                        for (KPIInfo kpi : lstKPI) {
                            KPITreeNode kpiNode = new KPITreeNode(csfNode);
                            childrenKPI.add(kpiNode);
                            kpiNode.setCaption(kpi.getCaption());
                            kpiNode.setKPI(kpi.getId());
                            kpiNode.setNumber(kpi.getNumber());
                        }
                        csfNode.setChildren(childrenKPI);
                    }
                    bscNode.setChildren(childrenCSF);
                }
            }
            parent.setChildren(childrenBSC);
        }
    }

    private static List getAllBSC(List lstBSCData) {
        Iterator it = lstBSCData.iterator();
        ArrayList<BSCInfo> lstBSC = new ArrayList<BSCInfo>();
        while (it.hasNext()) {
            Map bscData = (Map)it.next();
            BSCInfo o = new BSCInfo(bscData.get("BSCNumber".toLowerCase()).toString(), bscData.get("BSCName".toLowerCase()).toString());
            if (lstBSC.contains(o)) continue;
            lstBSC.add(o);
        }
        return lstBSC;
    }

    private static List getAllCSF(String bscNumber, List lstBSCData) {
        Iterator it = lstBSCData.iterator();
        ArrayList<CSFInfo> lstCSF = new ArrayList<CSFInfo>();
        while (it.hasNext()) {
            CSFInfo o;
            Map bscData = (Map)it.next();
            if (!bscData.get("BSCNumber".toLowerCase()).toString().equals(bscNumber) || lstCSF.contains(o = new CSFInfo(bscNumber, bscData.get("CSFNumber".toLowerCase()).toString(), bscData.get("CSFName".toLowerCase()).toString()))) continue;
            lstCSF.add(o);
        }
        return lstCSF;
    }

    private static List getAllKPI(String bscNumber, String csfNumber, List lstBSCData) {
        Iterator it = lstBSCData.iterator();
        ArrayList<KPIInfo> lstCSF = new ArrayList<KPIInfo>();
        while (it.hasNext()) {
            KPIInfo o;
            Map bscData = (Map)it.next();
            if (!bscData.get("BSCNumber".toLowerCase()).toString().equals(bscNumber) || !bscData.get("CSFNumber".toLowerCase()).toString().equals(csfNumber) || lstCSF.contains(o = new KPIInfo(bscNumber, csfNumber, bscData.get("KPINumber".toLowerCase()).toString(), bscData.get("KPIName".toLowerCase()).toString(), bscData.get("KPIID".toLowerCase()).toString()))) continue;
            lstCSF.add(o);
        }
        return lstCSF;
    }
}

