/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.analysis.web.solution.impl;

import com.kingdee.bos.ctrl.analysis.web.link.Linkage;
import com.kingdee.bos.ctrl.analysis.web.repository.Repository;
import com.kingdee.bos.ctrl.analysis.web.solution.BILayout;
import com.kingdee.bos.ctrl.analysis.web.solution.BIReport;
import com.kingdee.bos.ctrl.analysis.web.solution.BIReportComponent;
import com.kingdee.bos.ctrl.analysis.web.solution.BISubject;
import com.kingdee.bos.ctrl.analysis.web.solution.exception.BIReportException;
import com.kingdee.bos.ctrl.analysis.web.solution.filter.BIReportFilter;
import com.kingdee.bos.ctrl.analysis.web.solution.filter.FilterScheme;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import javax.servlet.http.HttpServletRequest;

public class BIReportImpl
implements BIReport {
    private List lstComponents = null;
    private BIReportFilter filter = null;
    private String name;
    private String caption;
    private String path;
    private String cubeRefPath;
    private String dataSourceRefPath;
    private BILayout layout;
    private List lstScheme;
    private String subjectPath;
    private BISubject subject;
    private List lstLinks;
    private List lstWorklist;
    private boolean molap;
    private InputStream isCube;
    private InputStream isDataSourece;
    private boolean isDefaultOpenDataDrill;
    private String repositoryPath = "";
    private String datacenter;

    public BIReportImpl(String name, String caption, String path, List lstComponents, String cubeRefPath, String dataSourceRefPath, BIReportFilter filter, BILayout layout, List lstScheme, String subjectPath, BISubject subject, List lstLinks, List lstWorklist, boolean molap, boolean isDefaultOpenDataDrill) {
        this.name = name;
        this.caption = caption;
        this.path = path;
        this.cubeRefPath = cubeRefPath;
        this.dataSourceRefPath = dataSourceRefPath;
        this.lstComponents = lstComponents;
        this.layout = layout;
        this.filter = filter;
        this.lstScheme = lstScheme;
        this.subjectPath = subjectPath;
        this.subject = subject;
        this.lstLinks = lstLinks;
        this.lstWorklist = lstWorklist;
        this.molap = molap;
        this.isDefaultOpenDataDrill = isDefaultOpenDataDrill;
    }

    @Override
    public String getPath() {
        return this.path;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getCaption() {
        return this.caption;
    }

    private String getDataSourcePath() {
        return this.dataSourceRefPath;
    }

    private String getCubePath() {
        return this.cubeRefPath;
    }

    @Override
    public List getComponents() {
        return this.lstComponents;
    }

    @Override
    public BIReportFilter getFilter(HttpServletRequest request) {
        return this.filter;
    }

    @Override
    public BILayout getLayout() {
        return this.layout;
    }

    @Override
    public List getComponents(String schemeName) {
        ArrayList<BIReportComponent> coms = null;
        if (this.lstComponents != null) {
            coms = new ArrayList<BIReportComponent>();
            for (BIReportComponent com : this.lstComponents) {
                if (com == null || !com.getMdxQuery().equals(schemeName)) continue;
                coms.add(com);
            }
        }
        return coms;
    }

    @Override
    public List getSchemeList() {
        return this.lstScheme;
    }

    @Override
    public String getSubjectPath() {
        return this.subjectPath;
    }

    @Override
    public FilterScheme[] getFilterSchemes(Repository rep) throws BIReportException {
        return FilterScheme.getFilterSchemesSharedByUserAndOrgUnit(this.getRepositoryPath(), this.getFilter(null), rep);
    }

    @Override
    public BISubject getSubject() {
        return this.subject;
    }

    @Override
    public void setRepositoryPath(String repositoryPath) {
        this.repositoryPath = repositoryPath;
    }

    @Override
    public String getRepositoryPath() {
        return this.repositoryPath;
    }

    @Override
    public List getLinks(String schemeName) {
        ArrayList<Linkage> links = null;
        if (this.lstLinks != null) {
            links = new ArrayList<Linkage>();
            for (Linkage link : this.lstLinks) {
                if (link == null || !link.getMdxQuery().equals(schemeName)) continue;
                links.add(link);
            }
        }
        return links;
    }

    @Override
    public List getWorklists() {
        return this.lstWorklist;
    }

    @Override
    public boolean hasFilter(HttpServletRequest request) throws BIReportException {
        return this.getFilter(request) != null;
    }

    @Override
    public boolean isMolap() {
        return this.molap;
    }

    @Override
    public void close() {
    }

    @Override
    public String getDatacenter() {
        return this.datacenter;
    }

    @Override
    public void setDatacenter(String datacenter) {
        this.datacenter = datacenter;
    }

    private InputStream getFileInputStream(String filepathname) throws BIReportException {
        InputStream is = null;
        URL url = null;
        File file = new File(filepathname);
        if (file.exists()) {
            try {
                url = file.toURL();
            }
            catch (MalformedURLException e1) {
                throw new BIReportException(e1);
            }
        }
        try {
            url = new URL(filepathname);
        }
        catch (Exception e) {
            throw new BIReportException(e);
        }
        if (url == null) {
            throw new BIReportException("could not find file \"" + filepathname + "\"");
        }
        try {
            is = url.openStream();
        }
        catch (IOException e) {
            throw new BIReportException(e);
        }
        return is;
    }

    @Override
    public InputStream getCubeStream() throws BIReportException {
        if (this.isCube != null) {
            try {
                this.isCube.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.isCube = null;
        }
        this.isCube = this.getFileInputStream(this.getCubePath());
        return this.isCube;
    }

    @Override
    public InputStream getDataSourceStream() throws BIReportException {
        if (this.isDataSourece != null) {
            try {
                this.isDataSourece.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.isDataSourece = null;
        }
        this.isDataSourece = this.getFileInputStream(this.getDataSourcePath());
        return this.isDataSourece;
    }

    @Override
    public boolean isDefaultOpenDataDrill() {
        return this.isDefaultOpenDataDrill;
    }
}

