/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.bibench.platform.ui.content.dsprovider;

import com.kingdee.bos.ctrl.bibench.platform.model.nodes.RDBaseNode;
import com.kingdee.bos.ctrl.bibench.platform.ui.util.IconUtil;
import com.kingdee.bos.ctrl.swing.tree.DefaultKingdeeTreeNode;
import com.kingdee.bos.ctrl.swing.tree.KingdeeTreeModel;
import java.util.Iterator;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;

class RDSProviderHelper {
    static final int TABLE_PROVIDER = 1;
    static final int CUBEMODEL_PROVIDER = 2;
    private RDBaseNode item;

    public RDSProviderHelper(RDBaseNode item) {
        this.item = item;
    }

    public TreeModel buildTreeModel_table() {
        return this.buildTreeModel(1);
    }

    public TreeModel buildTreeModel_cubemodel() {
        return this.buildTreeModel(2);
    }

    private TreeModel buildTreeModel(int type) {
        DefaultKingdeeTreeNode root = new DefaultKingdeeTreeNode((Object)"ROOT");
        DefaultKingdeeTreeNode pnode = (DefaultKingdeeTreeNode)this.item.getProperty("node");
        if (pnode != null) {
            DefaultKingdeeTreeNode pTitleRoot = pnode;
            DefaultKingdeeTreeNode proot = (DefaultKingdeeTreeNode)pnode.getParent();
            while (proot.getParent() != null) {
                pTitleRoot = proot;
                proot = (DefaultKingdeeTreeNode)proot.getParent();
            }
            int n = proot.getChildCount();
            for (int i = 0; i < n; ++i) {
                DefaultKingdeeTreeNode sub = (DefaultKingdeeTreeNode)proot.getChildAt(i);
                RDBaseNode obj = (RDBaseNode)sub.getUserObject();
                if (sub != pTitleRoot && obj.getType() != 1) continue;
                DefaultKingdeeTreeNode node = this.newNode(obj);
                switch (type) {
                    case 1: {
                        this.addItemAndChildren_selectTable(obj, node);
                        break;
                    }
                    case 2: {
                        this.addItemAndChildren_selectCubeModel(obj, node);
                    }
                }
                root.add((MutableTreeNode)node);
            }
            this.removeEmptyNode(root);
        }
        return new KingdeeTreeModel((TreeNode)root);
    }

    private boolean removeEmptyNode(DefaultKingdeeTreeNode root) {
        for (int i = 0; i < root.getChildCount(); ++i) {
            if (!this.removeEmptyNode((DefaultKingdeeTreeNode)root.getChildAt(i))) continue;
            --i;
        }
        if (root.getChildCount() == 0) {
            Object obj = root.getUserObject();
            if (obj instanceof RDBaseNode) {
                int type = ((RDBaseNode)obj).getType();
                if (type != 11 && type != 12 && type != 13 && type != 14 && type != 20 && type != 21 && type != 22) {
                    root.removeFromParent();
                    return true;
                }
            } else {
                root.removeFromParent();
                return true;
            }
        }
        return false;
    }

    private void addItemAndChildren_selectTable(RDBaseNode item, DefaultKingdeeTreeNode root) {
        Iterator iter = item.childIterator();
        while (iter.hasNext()) {
            RDBaseNode sub = (RDBaseNode)iter.next();
            int type = sub.getType();
            if (type != 4 && type != 1 && type != 11 && type != 12 && type != 13 && type != 14) continue;
            DefaultKingdeeTreeNode node = this.newNode(sub);
            root.add((MutableTreeNode)node);
            if (type != 4 && type != 1) continue;
            this.addItemAndChildren_selectTable(sub, node);
        }
    }

    private void addItemAndChildren_selectCubeModel(RDBaseNode item, DefaultKingdeeTreeNode root) {
        Iterator iter = item.childIterator();
        while (iter.hasNext()) {
            RDBaseNode sub = (RDBaseNode)iter.next();
            int type = sub.getType();
            if (type != 4 && type != 1 && type != 20) continue;
            DefaultKingdeeTreeNode node = this.newNode(sub);
            root.add((MutableTreeNode)node);
            if (type != 4 && type != 1) continue;
            this.addItemAndChildren_selectCubeModel(sub, node);
        }
    }

    private DefaultKingdeeTreeNode newNode(RDBaseNode item) {
        DefaultKingdeeTreeNode node = new DefaultKingdeeTreeNode((Object)item);
        IconUtil.setTreeNodeIcon(node, item);
        return node;
    }
}

