/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.bibench.platform.ui.content.filter;

import com.kingdee.bos.ctrl.bibench.platform.ui.PaltformWorkBenchContext;
import com.kingdee.bos.ctrl.bibench.platform.ui.content.filter.FilterItemCollection;
import com.kingdee.bos.ctrl.bibench.platform.ui.content.filter.type.AbstractFilterType;
import com.kingdee.bos.ctrl.bibench.platform.ui.content.filter.visitor.CheckParseVisitor;
import com.kingdee.bos.ctrl.bibench.platform.ui.content.filter.visitor.ComponentVisitor;
import com.kingdee.bos.ctrl.bibench.platform.ui.util.MsgBox;
import com.kingdee.bos.ctrl.common.layout.table.Style;
import com.kingdee.bos.ctrl.common.layout.table.TableLayout;
import com.kingdee.bos.ctrl.swing.KDButton;
import com.kingdee.bos.ctrl.swing.KDDialog;
import com.kingdee.bos.ctrl.swing.KDLabel;
import com.kingdee.bos.ctrl.swing.KDPanel;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JToggleButton;

public class FilterUI
extends KDPanel {
    private List cList = new ArrayList();
    private boolean isOK = false;
    private KDButton btnOK = new KDButton("\u786e\u5b9a");
    private KDButton btnCanel = new KDButton("\u53d6\u6d88");
    private KDDialog dialog;

    public FilterUI(FilterItemCollection filters, PaltformWorkBenchContext ctx) {
        int rows = filters.size();
        TableLayout layout = TableLayout.split((int)(rows + 1), (int)3);
        this.setLayout((LayoutManager)layout);
        for (int i = 0; i < rows; ++i) {
            AbstractFilterType item = filters.get(i);
            Component c = (Component)item.accept(new ComponentVisitor(ctx), (Object)this);
            if (c == null) continue;
            if (!(c instanceof JToggleButton)) {
                layout.cell(i, 0).style().setMargin(10, 3, 10, 3);
                this.add((Component)new KDLabel(item.getLabel()), layout.cell(i, 0));
            }
            layout.cell(i, 1).style().setMargin(10, 3, 0, 3);
            layout.cell(i, 1).style().setPriX(1);
            this.add(c, layout.cell(i, 1));
            if (item.isRequired()) {
                layout.cell(i, 2).style().setMargin(3, 3, 10, 3);
                this.add((Component)new KDLabel("<HTML><font color='red'>*</font></HTML>"), layout.cell(i, 2));
            }
            this.cList.add(new ComponentFilter(c, item));
        }
        KDPanel btnPanel = new KDPanel((LayoutManager)new FlowLayout(2, 5, 5));
        Style s = layout.cell(rows, 0).style();
        s.setPriY(1);
        s.setAlignmentY((short)2);
        s = layout.cell(rows, 1).style();
        s.setAlignmentY((short)2);
        this.add((Component)btnPanel, layout.cell(rows, 1));
        btnPanel.add((Component)this.btnOK);
        btnPanel.add((Component)this.btnCanel);
        this.btnOK.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FilterUI.this.ok();
            }
        });
        this.btnCanel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FilterUI.this.cancel();
            }
        });
    }

    private void ok() {
        if (this.checkParse()) {
            this.isOK = true;
            if (this.dialog != null) {
                this.dialog.dispose();
            }
        }
    }

    private boolean checkParse() {
        ComponentFilter ic = null;
        try {
            CheckParseVisitor cv = new CheckParseVisitor();
            for (int i = 0; i < this.cList.size(); ++i) {
                ic = (ComponentFilter)this.cList.get(i);
                Object obj = ic.filter.accept(cv, ic.c);
                if (obj != null && obj instanceof Exception) {
                    throw (Exception)obj;
                }
                ic.filter.setValue(obj);
            }
            return true;
        }
        catch (Exception e) {
            ic.c.requestFocus();
            MsgBox.warn("\u6761\u4ef6\u68c0\u6d4b", e.getMessage(), (Component)((Object)this));
            return false;
        }
    }

    private void cancel() {
        this.isOK = false;
        if (this.dialog != null) {
            this.dialog.dispose();
        }
    }

    public FilterItemCollection getFilters() {
        if (this.isOK) {
            FilterItemCollection fi = new FilterItemCollection();
            for (int i = 0; i < this.cList.size(); ++i) {
                fi.addFilterItem(((ComponentFilter)this.cList.get((int)i)).filter);
            }
            return fi;
        }
        return null;
    }

    public KDDialog getDialog() {
        return this.dialog;
    }

    public void setDialog(KDDialog dialog) {
        this.dialog = dialog;
    }

    class ComponentFilter {
        Component c;
        AbstractFilterType filter;

        ComponentFilter(Component c, AbstractFilterType filter) {
            this.c = c;
            this.filter = filter;
        }
    }
}

