/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.bibench.platform.ui.widget;

import com.kingdee.bos.ctrl.bibench.platform.ui.widget.CloseableTabbedPaneUI;
import com.kingdee.bos.ctrl.common.CtrlUIEnv;
import com.kingdee.bos.ctrl.swing.KDTabbedPane;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Icon;
import javax.swing.JFrame;
import javax.swing.JTextArea;
import javax.swing.event.EventListenerList;
import javax.swing.plaf.TabbedPaneUI;

public class CloseableTabbedPane
extends KDTabbedPane {
    protected EventListenerList closeListenerList = new EventListenerList();
    private CloseHandler closeHandler = new CloseHandler(){

        @Override
        public boolean close(Component tabbedComponent, int tabIndex) {
            CloseableTabbedPane.this.remove(tabIndex);
            return true;
        }
    };

    public void setTitle(Component c, String title) {
        int n = this.getComponentCount();
        for (int i = 0; i < n; ++i) {
            if (this.getComponentAt(i) != c) continue;
            this.setTitleAt(i, title);
            break;
        }
    }

    public void updateUI() {
        this.setUI((TabbedPaneUI)((Object)new CloseableTabbedPaneUI()));
    }

    public void addCloseListener(ActionListener l) {
        this.closeListenerList.add(ActionListener.class, l);
    }

    public void removeCloseListener(ActionListener l) {
        this.closeListenerList.remove(ActionListener.class, l);
    }

    public Icon getIconAt(int index) {
        Icon icon = super.getIconAt(index);
        if (icon == null || !(icon instanceof CloseableTabbedPaneUI.CloseIcon)) {
            super.setIconAt(index, (Icon)CloseableTabbedPaneUI.createCloseIcon());
        }
        return super.getIconAt(index);
    }

    protected void fireClosed(ActionEvent e) {
        Object[] listeners = this.closeListenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != ActionListener.class) continue;
            ((ActionListener)listeners[i + 1]).actionPerformed(e);
        }
    }

    public CloseHandler getCloseHandler() {
        return this.closeHandler;
    }

    public void setCloseHandler(CloseHandler closeHandler) {
        this.closeHandler = closeHandler;
    }

    public static void main(String[] args) {
        CtrlUIEnv.setKingdeeLAF();
        JFrame frame = new JFrame("KDCloseableTabbedPane Demo");
        frame.setSize(400, 320);
        Dimension d = Toolkit.getDefaultToolkit().getScreenSize();
        frame.setLocation((d.width - frame.getSize().width) / 2, (d.height - frame.getSize().height) / 2);
        frame.setDefaultCloseOperation(3);
        CloseableTabbedPane bar = new CloseableTabbedPane();
        bar.addTab("\u6d4b\u8bd51", new JTextArea());
        bar.addTab("\u6d4b\u8bd52", new JTextArea());
        bar.addTab("\u6d4b\u8bd53", new JTextArea());
        bar.addCloseListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                System.out.println("\u5173\u95ed\uff1a" + e.getSource());
            }
        });
        frame.getContentPane().add((Component)((Object)bar), "Center");
        frame.setVisible(true);
    }

    public static interface CloseHandler {
        public boolean close(Component var1, int var2);
    }
}

