/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.swing.chart.data;

import com.kingdee.bos.ctrl.swing.chart.data.IChartData;
import java.text.DecimalFormat;

public class CommonChartData
implements IChartData {
    public static final String name = "CommonChartData";
    private Comparable[] seriesKeys;
    private Comparable[] groupKeys;
    private double[][] values;

    public CommonChartData(Comparable[] seriesKeys, Comparable[] groupKeys, double[][] values) {
        int i;
        if (seriesKeys == null) {
            seriesKeys = new String[]{};
        }
        if (groupKeys == null) {
            groupKeys = new String[]{};
        }
        if (values == null) {
            values = new double[0][0];
        }
        int seriesCount = 0;
        int groupsCount = 0;
        seriesCount = values.length;
        if (seriesCount > 0) {
            for (i = 0; i < seriesCount; ++i) {
                if (values[i] == null || values[i].length <= groupsCount) continue;
                groupsCount = values[i].length;
            }
        }
        if (seriesKeys.length > seriesCount) {
            seriesCount = seriesKeys.length;
        }
        if (groupKeys.length > groupsCount) {
            groupsCount = groupKeys.length;
        }
        this.seriesKeys = new Comparable[seriesCount];
        this.groupKeys = new Comparable[groupsCount];
        this.values = new double[seriesCount][groupsCount];
        for (i = 0; i < seriesCount; ++i) {
            this.seriesKeys[i] = i < seriesKeys.length && seriesKeys[i] != null ? seriesKeys[i] : "S" + i;
        }
        for (i = 0; i < groupsCount; ++i) {
            this.groupKeys[i] = i < groupKeys.length && groupKeys[i] != null ? groupKeys[i] : "G" + i;
        }
        for (i = 0; i < seriesCount; ++i) {
            if (i >= values.length || values[i] == null) continue;
            for (int j = 0; j < groupsCount; ++j) {
                if (j >= values[i].length) continue;
                this.values[i][j] = values[i][j];
            }
        }
    }

    @Override
    public String getName() {
        return name;
    }

    public Comparable[] getSeriesKeys() {
        return this.seriesKeys;
    }

    public Comparable[] getGroupKeys() {
        return this.groupKeys;
    }

    public double[][] getValues() {
        return this.values;
    }

    public String toString() {
        int i;
        int rows = this.seriesKeys.length;
        int cols = this.groupKeys.length;
        DecimalFormat df = new DecimalFormat("0.00");
        StringBuffer sb = new StringBuffer();
        sb.append("ChartData Type: CommonChartData");
        sb.append('\n');
        sb.append('\t');
        for (i = 0; i < cols; ++i) {
            sb.append('\t');
            sb.append(this.groupKeys[i]);
        }
        for (i = 0; i < rows; ++i) {
            sb.append('\n');
            sb.append(this.seriesKeys[i]);
            for (int j = 0; j < cols; ++j) {
                sb.append('\t');
                sb.append(df.format(this.values[i][j]));
            }
        }
        return sb.toString();
    }
}

